## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ADRV9001 Embedded System Peripherals
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property config.num_slaves 2 [get_bd_cells axi_mspi]
set_property left 1 [get_bd_ports spi_csn]

set_property config.gpio_out_width 8 [get_bd_cells axi_sysid]
set_property left 7 [get_bd_ports gpio_out]

set_property config.status_width 4 [get_bd_cells axi_sysid]
set_property config.num_ports 4 [get_bd_cells sys_status]
make_bd_pins_external -name d1_vadj_err [get_bd_pins sys_status/in3]

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_intc && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_intr
set_property config.c_irq_connection 1 [get_bd_cells axi_intr]
connect_bd_net -net axilite_clk [get_bd_pins axi_intr/s_axi_aclk]  
connect_bd_net -net axilite_resetn [get_bd_pins axi_intr/s_axi_aresetn]
add_axilite_peripheral 0x44a10000 axi_intr/s_axi
add_interrupt axi_intr/irq

set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs_1
connect_bd_net [get_bd_pins sys_intrs_1/dout] [get_bd_pins axi_intr/intr]

## ##################################################################################
## ##################################################################################
## AXI-ADRV9001

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_adrv9001 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adrv9001_1
set_property config.axi_adrv9001_instance_id 1 [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_rx0_iodelay_group AXI_ADRV9001_1_IODELAY [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_rx1_iodelay_group AXI_ADRV9001_1_IODELAY [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_tx0_iodelay_group AXI_ADRV9001_1_IODELAY [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_tx1_iodelay_group AXI_ADRV9001_1_IODELAY [get_bd_cells axi_adrv9001_1]
create_bd_intf_port -mode slave -vlnv analog.com:interface:device_io_rtl:1.0 dio_1
connect_bd_intf_net [get_bd_intf_ports dio_1] [get_bd_intf_pins axi_adrv9001_1/dio]
create_bd_intf_port -mode slave -vlnv analog.com:interface:system_io_rtl:1.0 sys_1
connect_bd_intf_net [get_bd_intf_ports sys_1] [get_bd_intf_pins axi_adrv9001_1/sys]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_adrv9001_1/gpio_clk]
connect_bd_net [get_bd_pins axi_adrv9001/dev_out_clk] [get_bd_pins axi_adrv9001_1/dev_clk]
connect_bd_net [get_bd_pins axi_adrv9001/mcs_out_int] [get_bd_pins axi_adrv9001_1/mcs_int]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk] [get_bd_pins axi_adrv9001_1/tdd_clk]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_resetn] [get_bd_pins axi_adrv9001_1/tdd_resetn]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_state] [get_bd_pins axi_adrv9001_1/tdd_state]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_frm_toggle] [get_bd_pins axi_adrv9001_1/tdd_frm_toggle]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk_cnt] [get_bd_pins axi_adrv9001_1/tdd_clk_cnt]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_frm_cnt] [get_bd_pins axi_adrv9001_1/tdd_frm_cnt]
connect_bd_net -net sys_200m_clk [get_bd_pins axi_adrv9001_1/sys_200m_clk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adrv9001_1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_adrv9001_1/axilite_resetn]
add_axilite_peripheral 0x43110000 axi_adrv9001_1/axilite
set_property config.num_ports 1 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_adrv9001_1/interrupt] [get_bd_pins sys_intrs_1/in0]

## ##################################################################################
## ##################################################################################
## TX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_tx0
set_property config.instance_id 0 [get_bd_cells axi_dma_1_tx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_tx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx0_clk] [get_bd_pins axi_dma_1_tx0/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx0_resetn] [get_bd_pins axi_dma_1_tx0/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_dma_1_tx0/tx] [get_bd_intf_pins axi_adrv9001_1/tx0]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_tx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_tx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_tx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_tx0/aximm_resetn]
add_axilite_peripheral 0x43120000 axi_dma_1_tx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_tx0/aximm
set_property config.num_ports 2 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_tx0/interrupt] [get_bd_pins sys_intrs_1/in1]

## ##################################################################################
## ##################################################################################
## TX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_tx1
set_property config.instance_id 1 [get_bd_cells axi_dma_1_tx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_tx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx1_clk] [get_bd_pins axi_dma_1_tx1/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx1_resetn] [get_bd_pins axi_dma_1_tx1/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_dma_1_tx1/tx] [get_bd_intf_pins axi_adrv9001_1/tx1]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_tx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_tx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_tx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_tx1/aximm_resetn]
add_axilite_peripheral 0x43130000 axi_dma_1_tx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_tx1/aximm
set_property config.num_ports 3 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_tx1/interrupt] [get_bd_pins sys_intrs_1/in2]

## ##################################################################################
## ##################################################################################
## RX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_rx0
set_property config.instance_id 2 [get_bd_cells axi_dma_1_rx0]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_1_rx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_rx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_clk] [get_bd_pins axi_dma_1_rx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_resetn] [get_bd_pins axi_dma_1_rx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/rx0] [get_bd_intf_pins axi_dma_1_rx0/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_rx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_rx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_rx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_rx0/aximm_resetn]
add_axilite_peripheral 0x43140000 axi_dma_1_rx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_rx0/aximm
set_property config.num_ports 4 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_rx0/interrupt] [get_bd_pins sys_intrs_1/in3]

## ##################################################################################
## ##################################################################################
## RX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_rx1
set_property config.instance_id 3 [get_bd_cells axi_dma_1_rx1]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_1_rx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_rx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_clk] [get_bd_pins axi_dma_1_rx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_resetn] [get_bd_pins axi_dma_1_rx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/rx1] [get_bd_intf_pins axi_dma_1_rx1/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_rx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_rx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_rx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_rx1/aximm_resetn]
add_axilite_peripheral 0x43150000 axi_dma_1_rx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_rx1/aximm
set_property config.num_ports 5 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_rx1/interrupt] [get_bd_pins sys_intrs_1/in4]

## ##################################################################################
## ##################################################################################
## ORX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_orx0
set_property config.instance_id 4 [get_bd_cells axi_dma_1_orx0]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_1_orx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_orx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_clk] [get_bd_pins axi_dma_1_orx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_resetn] [get_bd_pins axi_dma_1_orx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/orx0] [get_bd_intf_pins axi_dma_1_orx0/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_orx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_orx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_orx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_orx0/aximm_resetn]
add_axilite_peripheral 0x43160000 axi_dma_1_orx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_orx0/aximm
set_property config.num_ports 6 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_orx0/interrupt] [get_bd_pins sys_intrs_1/in5]

## ##################################################################################
## ##################################################################################
## ORX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_orx1
set_property config.instance_id 5 [get_bd_cells axi_dma_1_orx1]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_1_orx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_orx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_clk] [get_bd_pins axi_dma_1_orx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_resetn] [get_bd_pins axi_dma_1_orx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/orx1] [get_bd_intf_pins axi_dma_1_orx1/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_orx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_orx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_orx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_orx1/aximm_resetn]
add_axilite_peripheral 0x43170000 axi_dma_1_orx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_orx1/aximm
set_property config.num_ports 7 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_orx1/interrupt] [get_bd_pins sys_intrs_1/in6]

## ##################################################################################
## ##################################################################################
## GAIN-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_gain
set_property config.instance_id 6 [get_bd_cells axi_dma_1_gain]
set_property config.axis_data_width 8 [get_bd_cells axi_dma_1_gain]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_gain/trig]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_dma_1_gain/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/gpio_resetn] [get_bd_pins axi_dma_1_gain/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/gpio_gain] [get_bd_intf_pins axi_dma_1_gain/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_gain/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_gain/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_gain/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_gain/aximm_resetn]
add_axilite_peripheral 0x43180000 axi_dma_1_gain/axilite
add_aximm_peripheral 0x80000000 axi_dma_1_gain/aximm
set_property config.num_ports 8 [get_bd_cells sys_intrs_1]
connect_bd_net [get_bd_pins axi_dma_1_gain/interrupt] [get_bd_pins sys_intrs_1/in7]

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

