## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ADRV9001 Rev.A ZC706
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set m_mode [lindex $argv 0]
set m_app [lindex $argv 1]
set m_linux adrv9001_zc706_linux_${m_mode}
set m_bare_metal adrv9001_zc706_bare_metal_${m_mode}
set m_define [string toupper $m_mode]

sdk setws $m_mode

if {$m_app eq "bsp"} {
  sdk createhw -name hw -hwspec [lindex $argv 2]
  sdk createapp -name fsbl -hwproject hw -proc ps7_cortexa9_0 -app {Zynq FSBL}
  sdk createapp -name $m_linux -hwproject hw -proc ps7_cortexa9 \
    -app {Linux Empty Application} -os linux
  sdk configapp -app $m_linux define-compiler-symbols ADI_ADRV9001_PLATFORM_LINUX
  sdk createapp -name $m_bare_metal -hwproject hw -bsp fsbl_bsp -proc ps7_cortexa9_0 \
    -app {Empty Application} -os standalone
  sdk configapp -app $m_bare_metal define-compiler-symbols ADI_ADRV9001_PLATFORM_BARE_METAL
  sdk configapp -app $m_bare_metal define-compiler-symbols $m_define
  sdk projects -build -type bsp -name fsbl_bsp
  exit
}

sdk projects -build -type app -name $m_app
exit

## ##################################################################################
## ##################################################################################

