## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 Interface Core
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

M_XSCT := xsct xsct.tcl
ifeq ($(OS), Windows_NT)
	M_XSCT := xsct.bat xsct.tcl
endif

M_PWD := $(shell pwd)

VPATH := ../../../library/common/sw
VPATH += ../../../library/axi_adrv9001/sw
VPATH += ../../../library/axi_rxdma/sw
VPATH += ../../../library/axi_txdma/sw
VPATH += ../../../library/axi_sysid/sw
VPATH += ../../../library/axi_mspi/sw
VPATH += ../../common/sw

M_INC_DIRS := $(addprefix -I, $(VPATH))
M_SOURCES := $(foreach dir, $(VPATH), $(wildcard $(dir)/*.c))

M_OBJS := $(notdir $(M_SOURCES))
M_OBJS := $(patsubst %.c, %.o, $(M_OBJS))
M_OBJS := $(addprefix $(M_TARGET)/objs/, $(M_OBJS))

M_BARE_METAL := adrv9001_zc706_bare_metal_$(M_TARGET)
M_BARE_METAL_ELF_FILE := $(M_TARGET)/$(M_BARE_METAL).elf

## ##################################################################################
## ##################################################################################

M_CC_FLAGS := -DADI_ADRV9001_PLATFORM_BARE_METAL -D$(M_TARGET)
M_CC_FLAGS += -I$(M_TARGET)/fsbl_bsp/ps7_cortexa9_0/include $(M_INC_DIRS)
M_CC_FLAGS += -Wall -O0 -g3 -c -fmessage-length=0
M_CC_FLAGS += -mcpu=cortex-a9 -mfpu=vfpv3 -mfloat-abi=hard -MMD -MP 

M_LINKER_FLAGS := -mcpu=cortex-a9 -mfpu=vfpv3 -mfloat-abi=hard -Wl,-build-id=none
M_LINKER_FLAGS += -specs=$(M_TARGET)/$(M_BARE_METAL)/src/Xilinx.spec
M_LINKER_FLAGS += -Wl,-T -Wl,$(M_TARGET)/$(M_BARE_METAL)/src/lscript.ld
M_LINKER_FLAGS += -L$(M_TARGET)/fsbl_bsp/ps7_cortexa9_0/lib

M_LIBRARY_FLAGS += -Wl,--start-group,-lxil,-lgcc,-lc,--end-group
M_LIBRARY_FLAGS += -Wl,--start-group,-lxilffs,-lxil,-lgcc,-lc,--end-group
M_LIBRARY_FLAGS += -Wl,--start-group,-lrsa,-lxil,-lgcc,-lc,--end-group

## ##################################################################################
## ##################################################################################

M_HDF_FILE := ../hdl/$(M_TARGET)/adrv9001_zc706_$(M_TARGET).hdf
M_BIT_FILE := $(M_TARGET)/adrv9001_zc706_$(M_TARGET).bit
M_FSBL_FILE := $(M_TARGET)/fsbl/Debug/fsbl.elf

## ##################################################################################
## ##################################################################################

.PHONY: all
all: $(M_BARE_METAL_ELF_FILE) $(M_TARGET)/BOOT.bin

.PHONY: clean
clean:
	rm -rf $(M_TARGET)/objs $(M_BARE_METAL_ELF_FILE)

## ##################################################################################
## ##################################################################################

$(M_BARE_METAL_ELF_FILE): $(M_FSBL_FILE) $(M_BIT_FILE) $(M_OBJS)
	arm-none-eabi-gcc $(M_LINKER_FLAGS) -o $@ $(M_OBJS) $(M_LIBRARY_FLAGS)

$(M_TARGET)/objs/%.o: %.c | $(M_TARGET)/objs
	arm-none-eabi-gcc $(M_CC_FLAGS) -MF"$(@:%.o=%.d)" -MT"$(@)" -o $@ $<

$(M_TARGET)/objs:
	mkdir -p $@

## ##################################################################################
## ##################################################################################

$(M_BIT_FILE): ../hdl/$(M_TARGET)/adrv9001_zc706_$(M_TARGET).bit
	cp ../hdl/$(M_TARGET)/adrv9001_zc706_$(M_TARGET).bit $(M_BIT_FILE)

## ##################################################################################
## ##################################################################################

$(M_FSBL_FILE): fsbl_hooks.pl ../../common/hdl/zc706_bd.tcl
	rm -fr $(M_TARGET)
	$(M_XSCT) $(M_TARGET) bsp $(M_HDF_FILE)
	cp $(M_TARGET)/fsbl/src/fsbl_hooks.c $(M_TARGET)/fsbl/src/fsbl_hooks.c.original
	$(M_PWD)/fsbl_hooks.pl $(M_TARGET)/fsbl/src/fsbl_hooks.c
	cp $(M_TARGET)/$(M_BARE_METAL)/src/lscript.ld $(M_TARGET)/$(M_BARE_METAL)/src/lscript.ld.original
	sed -i 's/> sys_ddr_memaddr/> ps7_ddr_0/g' $(M_TARGET)/$(M_BARE_METAL)/src/lscript.ld
	$(M_XSCT) $(M_TARGET) fsbl

## ##################################################################################
## ##################################################################################

$(M_TARGET)/BOOT.bin: $(M_FSBL_FILE) $(M_BIT_FILE) $(M_BARE_METAL_ELF_FILE)
	rm -fr $(M_TARGET)/BOOT.bin
	@echo "image:" > $(M_TARGET)/boot.bif
	@echo "{" >> $(M_TARGET)/boot.bif
	@echo "  [bootloader]$(M_FSBL_FILE)" >> $(M_TARGET)/boot.bif
	@echo "  $(M_BIT_FILE)" >> $(M_TARGET)/boot.bif
	@echo "  $(M_BARE_METAL_ELF_FILE)" >> $(M_TARGET)/boot.bif
	@echo "}" >> $(M_TARGET)/boot.bif
	bootgen -image $(M_TARGET)/boot.bif -arch zynq -o $(M_TARGET)/BOOT.bin

## ##################################################################################
## ##################################################################################

