#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 Interface Core
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;

$n_lines = 0;
$status = -1;
$mask = 0;
$fnum = 0;

open(IFILE, $ARGV[0]);
while ($fline = <IFILE>) {
  chomp($fline);
  $fnum = $fnum + 1;
  if ($fline eq "u32 FsblHookBeforeBitstreamDload(void)") {
    $status = 0;
    if ($mask == 1) {
      $status = -1;
      print "$ARGV[0]:$fnum: duplicate declaration?\n";
    }
    $mask = 1;
    $lines[$n_lines++] = "INSERT_fsbl_hook_before_bitstream_download";
  } elsif (($mask == 1) && ($fline eq "}")) {
    $mask = 0;
  } elsif ($mask == 0) {
    $lines[$n_lines++] = $fline;
  }
  if ($fline eq "#include \"fsbl.h\"") {
    $lines[$n_lines++] = "#include \"xiicps.h\"";
  }
}
close(IFILE);

if ($status != 0) {
  print "$ARGV[0]:none found or too many!\n";
  exit(-1);
}

open(OFILE, ">$ARGV[0]");
for ($n = 0; $n < $n_lines; $n++) {
  if ($lines[$n] eq "INSERT_fsbl_hook_before_bitstream_download") {
    print OFILE <<INSERT_FUNCTION;
u32 FsblHookBeforeBitstreamDload(void)
{
  u32 status;
  u32 voltage;
  unsigned char data[3];

  status = XST_SUCCESS;
	fsbl_printf(DEBUG_INFO,"In FsblHookBeforeBitstreamDload function \\r\\n");

  XIicPs ps7_iic;
  XIicPs_Config *ps7_iic_config;

  ps7_iic_config = XIicPs_LookupConfig(XPAR_PS7_I2C_0_DEVICE_ID);
  if (ps7_iic_config == NULL) {
    xil_printf("FSBL-ADI: XIicPs_LookupConfig() FAILED!\\n");
    return(XST_FAILURE);
  }

  status = XIicPs_CfgInitialize(&ps7_iic, ps7_iic_config, ps7_iic_config->BaseAddress);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XIicPs_CfgInitialize() FAILED!\\n");
    return(XST_FAILURE);
  }

  XIicPs_SetSClk(&ps7_iic, 400000);

  data[0] = 0x80;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 1, 0x74);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(IIC_MUX) FAILED!\\n");
    return(XST_FAILURE);
  }

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterRecvPolled(&ps7_iic, &data[1], 1, 0x74);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Read(IIC_MUX) FAILED!\\n");
    return(XST_FAILURE);
  }

  if (data[0] != data[1]) {
    xil_printf("FSBL-ADI: IIC_MUX_MISMATCH(%02x, %02x) FAILED!\\n", data[0], data[1]);
    return(XST_FAILURE);
  }

  data[0] = 0x00;
  data[1] = 0x03;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 2, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_00) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0x44;
  data[1] = 0xf6;
  data[2] = 0x30;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 3, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_44) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0xfa;
  data[1] = 0x0f;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 2, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_FA) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0xfb;
  data[1] = 0x07;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 2, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_FB) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0x40;
  data[1] = 0x3e;
  data[2] = 0x42;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 3, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_40) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0x5e;
  data[1] = 0xd7;
  data[2] = 0x33;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 3, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_5E) FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0x5f;
  data[1] = 0xf6;
  data[2] = 0x30;

  while (XIicPs_BusIsBusy(&ps7_iic) != 0);
  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 3, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(PMBUS_5F) FAILED!\\n");
    return(XST_FAILURE);
  }

  status = XIicPs_SetOptions(&ps7_iic, XIICPS_REP_START_OPTION);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XIicPs_SetOptions() FAILED!\\n");
    return(XST_FAILURE);
  }

  data[0] = 0x8b;

  status = XIicPs_MasterSendPolled(&ps7_iic, &data[0], 1, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Write(CMD_READ_VOLTAGE) FAILED!\\n");
    return(XST_FAILURE);
  }

  status = XIicPs_MasterRecvPolled(&ps7_iic, &data[0], 2, 0x65);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XicPs_Read(CMD_READ_VOLTAGE) FAILED!\\n");
    return(XST_FAILURE);
  }

  status = XIicPs_ClearOptions(&ps7_iic, XIICPS_REP_START_OPTION);
  if (status != XST_SUCCESS) {
    xil_printf("FSBL-ADI: XIicPs_ClearOptions() FAILED!\\n");
    return(XST_FAILURE);
  }

  voltage = ((data[1] << 8) | data[0]) * 122;

  xil_printf("FSBL: PM Bus VADJ Read Voltage: [%d uV]\\n", voltage);
  return(XST_SUCCESS);
}
INSERT_FUNCTION
  } else {
    print OFILE "$lines[$n]\n";
  }
}
close(OFILE);


exit(0);

## ##################################################################################
## ##################################################################################
