// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       TDD DMA enable
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module tdd_dma_enable (

  // source

  input   wire            resetn,
  input   wire            clk,
  output  reg             enable = 'd0,

  // tdd

  input   wire            tdd_resetn,
  input   wire            tdd_clk,
  input   wire            tdd_state,
  input   wire  [ 31:0]   tdd_clk_cnt,
  input   wire  [ 31:0]   tdd_frm_cnt,
  input   wire            tdd_frm_toggle,

  // axilite

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  output  wire  [  7:0]   axilite_clk_ratio,
  input   wire  [ 31:0]   axilite_num_of_frames,
  input   wire  [ 31:0]   axilite_pri_assert,
  input   wire  [ 31:0]   axilite_pri_deassert,
  input   wire  [ 31:0]   axilite_sec_assert,
  input   wire  [ 31:0]   axilite_sec_deassert,
  input   wire  [ 31:0]   axilite_pri_frame_assert,
  input   wire  [ 31:0]   axilite_pri_frame_deassert,
  input   wire  [ 31:0]   axilite_sec_frame_assert,
  input   wire  [ 31:0]   axilite_sec_frame_deassert,
  input   wire  [  1:0]   axilite_mode,
  input   wire            axilite_sync);

  // internal registers

  reg                     enable_sync = 'd0;
  reg                     pri_enable_sync = 'd0;
  reg                     sec_enable_sync = 'd0;
  reg                     frm_toggle_d = 'd0;
  reg           [ 31:0]   clk_cnt = 'd0;
  reg           [ 31:0]   clk_cnt_nxt = 'd0;
  reg           [ 31:0]   frm_cnt = 'd0;
  reg           [  3:0]   clk_ratio_count = 'd0;
  reg                     clk_ratio_toggle = 'd0;
  reg                     tdd_clk_ratio_toggle_d = 'd0;
  reg           [  7:0]   tdd_clk_ratio = 'd0;
  reg           [ 11:0]   tdd_clk_ratio_count = 'd0;

  // internal signals

  wire                    frm_toggle;
  wire                    state;
  wire                    enable_async;
  wire          [  7:0]   clk_ratio;
  wire          [ 31:0]   num_of_frames;
  wire          [ 31:0]   pri_assert;
  wire          [ 31:0]   pri_deassert;
  wire          [ 31:0]   sec_assert;
  wire          [ 31:0]   sec_deassert;
  wire          [ 31:0]   pri_frame_assert;
  wire          [ 31:0]   pri_frame_deassert;
  wire          [ 31:0]   sec_frame_assert;
  wire          [ 31:0]   sec_frame_deassert;
  wire          [  1:0]   mode;
  wire                    sync;
  wire                    tdd_clk_ratio_toggle;
  wire                    tdd_enable_async;

  // tdd enable

  always @(negedge resetn or posedge clk) begin
    if (resetn == 1'b0) begin
      enable <= 1'd0;
    end else begin
      if (sync == 1'b1) begin
        enable <= enable_sync;
      end else begin
        enable <= enable_async;
      end
    end
  end

  always @(negedge resetn or posedge clk) begin
    if (resetn == 1'b0) begin
      enable_sync <= 1'd0;
      pri_enable_sync <= 1'd0;
      sec_enable_sync <= 1'd0;
    end else begin
      if (mode[1] == 1'd0) begin
        enable_sync <= mode[0];
      end else begin
        enable_sync <= pri_enable_sync | sec_enable_sync;
      end
      if ((clk_cnt <= pri_deassert) && (clk_cnt_nxt >= pri_deassert) &&
        (frm_cnt == pri_frame_deassert)) begin
        pri_enable_sync <= 1'd0;
      end else if ((clk_cnt <= pri_assert) && (clk_cnt_nxt >= pri_assert) &&
        (frm_cnt == pri_frame_assert)) begin
        pri_enable_sync <= state;
      end
      if ((clk_cnt <= sec_deassert) && (clk_cnt_nxt >= sec_deassert) &&
        (frm_cnt == sec_frame_deassert)) begin
        sec_enable_sync <= 1'd0;
      end else if ((clk_cnt <= sec_assert) && (clk_cnt_nxt >= sec_assert) &&
        (frm_cnt == sec_frame_assert)) begin
        sec_enable_sync <= state;
      end
    end
  end

  // tdd frame
 
  always @(negedge resetn or posedge clk) begin
    if (resetn == 1'b0) begin
      frm_toggle_d <= 1'd0;
      clk_cnt <= 32'd0;
      clk_cnt_nxt <= 32'd0;
      frm_cnt <= 32'd0;
    end else begin
      frm_toggle_d <= frm_toggle;
      if ((state == 1'd0) || ((frm_toggle_d ^ frm_toggle) == 1'd1)) begin
        clk_cnt <= 32'd0;
        if (clk_ratio > 1) begin
          clk_cnt_nxt <= clk_ratio - 1'd1;
        end else begin
          clk_cnt_nxt <= 32'd0;
        end
      end else begin
        clk_cnt <= clk_cnt + clk_ratio;
        clk_cnt_nxt <= clk_cnt_nxt + clk_ratio;
      end
      if (state == 1'd0) begin
        frm_cnt <= 32'd0;
      end else if ((frm_toggle_d ^ frm_toggle) == 1'd1) begin
        if (frm_cnt >= num_of_frames) begin
          frm_cnt <= 32'd0;
        end else begin
          frm_cnt <= frm_cnt + 1'd1;
        end
      end
    end
  end

  // tdd clock ratio

  always @(negedge resetn or posedge clk) begin
    if (resetn == 1'b0) begin
      clk_ratio_count <= 4'd0;
      clk_ratio_toggle <= 1'd0;
    end else begin
      clk_ratio_count <= clk_ratio_count + 1'd1;
      if (clk_ratio_count == 4'hf) begin
        clk_ratio_toggle <= ~clk_ratio_toggle;
      end
    end
  end

  always @(negedge tdd_resetn or posedge tdd_clk) begin
    if (tdd_resetn == 1'b0) begin
      tdd_clk_ratio_toggle_d <= 1'b0;
      tdd_clk_ratio <= 8'd0;
      tdd_clk_ratio_count <= 12'd0;
    end else begin
      tdd_clk_ratio_toggle_d <= tdd_clk_ratio_toggle;
      if ((tdd_clk_ratio_toggle_d ^ tdd_clk_ratio_toggle) == 1'b1) begin
        tdd_clk_ratio <= tdd_clk_ratio_count[11:4];
      end
      if ((tdd_clk_ratio_toggle_d ^ tdd_clk_ratio_toggle) == 1'b1) begin
        tdd_clk_ratio_count <= 12'd1;
      end else begin
        tdd_clk_ratio_count <= tdd_clk_ratio_count + 1'd1;
      end
    end
  end

  // instantiations

  cdc_cntrl #(.DATA_WIDTH(8)) i_axilite_cdc_cntrl (
    .src_resetn                   (tdd_resetn),
    .src_clk                      (tdd_clk),
    .src_data                     (tdd_clk_ratio),
    .dest_resetn                  (axilite_resetn),
    .dest_clk                     (axilite_clk),
    .dest_data                    (axilite_clk_ratio));

  cdc #(.DATA_WIDTH(1)) i_tdd_cdc (
    .src_data                     (clk_ratio_toggle),
    .dest_resetn                  (tdd_resetn),
    .dest_clk                     (tdd_clk),
    .dest_data                    (tdd_clk_ratio_toggle));

  cdc #(.DATA_WIDTH(3)) i_cdc (
    .src_data                     ({tdd_frm_toggle,
                                    tdd_state,
                                    tdd_enable_async}),
    .dest_resetn                  (resetn),
    .dest_clk                     (clk),
    .dest_data                    ({frm_toggle,
                                    state,
                                    enable_async}));

  cdc_cntrl #(.DATA_WIDTH(8)) i_cdc_cntrl_0 (
    .src_resetn                   (tdd_resetn),
    .src_clk                      (tdd_clk),
    .src_data                     (tdd_clk_ratio),
    .dest_resetn                  (resetn),
    .dest_clk                     (clk),
    .dest_data                    (clk_ratio));

  cdc_cntrl #(.DATA_WIDTH(291)) i_cdc_cntrl_1 (
    .src_resetn                   (axilite_resetn),
    .src_clk                      (axilite_clk),
    .src_data                     ({axilite_num_of_frames,
                                    axilite_pri_assert,
                                    axilite_pri_deassert,
                                    axilite_sec_assert,
                                    axilite_sec_deassert,
                                    axilite_pri_frame_assert,
                                    axilite_pri_frame_deassert,
                                    axilite_sec_frame_assert,
                                    axilite_sec_frame_deassert,
                                    axilite_mode,
                                    axilite_sync}),
    .dest_resetn                  (resetn),
    .dest_clk                     (clk),
    .dest_data                    ({num_of_frames,
                                    pri_assert,
                                    pri_deassert,
                                    sec_assert,
                                    sec_deassert,
                                    pri_frame_assert,
                                    pri_frame_deassert,
                                    sec_frame_assert,
                                    sec_frame_deassert,
                                    mode,
                                    sync}));

  tdd_enable i_tdd_enable (
    .tdd_resetn                   (tdd_resetn),
    .tdd_clk                      (tdd_clk),
    .tdd_state                    (tdd_state),
    .tdd_clk_cnt                  (tdd_clk_cnt),
    .tdd_frm_cnt                  (tdd_frm_cnt),
    .tdd_enable                   (tdd_enable_async),
    .axilite_clk                  (axilite_clk),
    .axilite_resetn               (axilite_resetn),
    .axilite_pri_assert           (axilite_pri_assert),
    .axilite_pri_deassert         (axilite_pri_deassert),
    .axilite_sec_assert           (axilite_sec_assert),
    .axilite_sec_deassert         (axilite_sec_deassert),
    .axilite_pri_frame_assert     (axilite_pri_frame_assert),
    .axilite_pri_frame_deassert   (axilite_pri_frame_deassert),
    .axilite_sec_frame_assert     (axilite_sec_frame_assert),
    .axilite_sec_frame_deassert   (axilite_sec_frame_deassert),
    .axilite_mode                 (axilite_mode));

endmodule

// **********************************************************************************
// **********************************************************************************
