// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Memory, simple dual port
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module mem_sdp #(

  parameter   DATA_WIDTH = 16,
  parameter   ADDRESS_WIDTH = 5) (

  input                               wr_clk,
  input                               wr_enable,
  input       [(ADDRESS_WIDTH-1):0]   wr_addr,
  input       [(DATA_WIDTH-1):0]      wr_data,

  input                               rd_clk,
  input                               rd_enable,
  input       [(ADDRESS_WIDTH-1):0]   rd_addr,
  output  reg [(DATA_WIDTH-1):0]      rd_data = 'd0);

  (* ram_style = "block" *)

  reg         [(DATA_WIDTH-1):0]      mem[0:((2**ADDRESS_WIDTH)-1)];

  always @(posedge wr_clk) begin
    if (wr_enable == 1'b1) begin
      mem[wr_addr] <= wr_data;
    end
  end

  always @(posedge rd_clk) begin
    if (rd_enable == 1'b1) begin
      rd_data <= mem[rd_addr];
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
