// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Clock Monitor
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module clk_mon (

  input   wire            clk,
  input   wire            axilite_resetn,
  input   wire            axilite_clk,
  output  reg   [ 31:0]   axilite_clk_mon_count = 'd0);

  // internal registers

  reg           [ 15:0]   axilite_run_count = 'd0;
  reg                     axilite_req_toggle = 'd0;
  reg                     axilite_req_toggle_d = 'd0;
  reg                     axilite_req = 'd0;
  reg                     axilite_ack_toggle_d = 'd0;
  reg                     axilite_ack = 'd0;
  reg           [ 31:0]   axilite_count_m = 'd0;
  reg           [ 31:0]   axilite_count = 'd0;
  reg                     req_toggle_d = 'd0;
  reg           [ 31:0]   run_count = 'd0;
  reg                     ack_toggle = 'd0;
  reg           [ 31:0]   count = 'd0;

  // internal signals

  wire                    axilite_ack_toggle_p;
  wire                    axilite_ack_toggle;
  wire                    req_toggle_p;
  wire                    req_toggle;

  // axilite clock as the reference
 
  assign axilite_ack_toggle_p = axilite_ack_toggle_d ^ axilite_ack_toggle;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_run_count <= 16'd0;
      axilite_req_toggle <= 1'd0;
      axilite_req_toggle_d <= 1'd0;
      axilite_req <= 1'd0;
      axilite_ack_toggle_d <= 1'd0;
      axilite_ack <= 1'd0;
      axilite_count_m <= 32'd0;
      axilite_count <= 32'd0;
      axilite_clk_mon_count <= 32'd0;
    end else begin
      axilite_run_count <= axilite_run_count + 1'd1;
      if (axilite_run_count == 16'hffff) begin
        axilite_req_toggle <= ~axilite_req_toggle;
      end
      axilite_req_toggle_d <= axilite_req_toggle;
      axilite_req <= ~axilite_req_toggle_d & axilite_req_toggle;
      axilite_ack_toggle_d <= axilite_ack_toggle;
      axilite_ack <= axilite_ack_toggle_p;
      if (axilite_ack_toggle_p == 1'd1) begin
        axilite_count_m <= count;
      end
      if (axilite_req == 1'd1) begin
        axilite_count <= 32'd0;
      end else if (axilite_ack == 1'd1) begin
        axilite_count <= axilite_count_m;
      end
      if (axilite_req == 1'd1) begin
        axilite_clk_mon_count <= axilite_count;
      end
    end
  end

  assign req_toggle_p = req_toggle_d ^ req_toggle;

  always @(posedge clk) begin
    req_toggle_d <= req_toggle;
    if (req_toggle_p == 1'b1) begin
      run_count <= 32'd1;
    end else begin
      run_count <= run_count + 1'd1;
    end
    if ((req_toggle_p == 1'b1) && (req_toggle == 1'b0)) begin
      ack_toggle <= ~ack_toggle;
      count <= run_count;
    end
  end

  cdc #(.DATA_WIDTH(1)) i_req_toggle (
    .src_data             (axilite_req_toggle),
    .dest_resetn          (1'd1),
    .dest_clk             (clk),
    .dest_data            (req_toggle));

  cdc #(.DATA_WIDTH(1)) i_ack_toggle (
    .src_data             (ack_toggle),
    .dest_resetn          (axilite_resetn),
    .dest_clk             (axilite_clk),
    .dest_data            (axilite_ack_toggle));

endmodule

// **********************************************************************************
// **********************************************************************************
