// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       CDC event (no guarantee on number of events)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module cdc_event #(parameter DATA_WIDTH = 8) (

  // source

  input   wire                              src_resetn,
  input   wire                              src_clk,
  input   wire  [(DATA_WIDTH-1):0]          src_data,

  // destination

  input   wire                              dest_resetn,
  input   wire                              dest_clk,
  output  reg   [(DATA_WIDTH-1):0]          dest_data = 'd0);

  // internal registers

  reg           [(DATA_WIDTH-1):0]          src_ack_toggle_m1 = 'd0;
  reg           [(DATA_WIDTH-1):0]          src_ack_toggle_m2 = 'd0;
  reg           [(DATA_WIDTH-1):0]          src_ack_toggle = 'd0;
  reg           [(DATA_WIDTH-1):0]          src_req_toggle = 'd0;
  reg           [(DATA_WIDTH-1):0]          src_state = 'd0;
  reg           [(DATA_WIDTH-1):0]          dest_req_toggle_m1 = 'd0;
  reg           [(DATA_WIDTH-1):0]          dest_req_toggle_m2 = 'd0;
  reg           [(DATA_WIDTH-1):0]          dest_ack_toggle = 'd0;

  // device events transfer

  genvar n;
  generate
  for (n = 0; n < DATA_WIDTH; n = n + 1) begin: g_cdc

  always @(negedge src_resetn or posedge src_clk) begin
    if (src_resetn == 1'b0) begin
      src_ack_toggle_m1[n] <= 'd0;
      src_ack_toggle_m2[n] <= 'd0;
      src_ack_toggle[n] <= 'd0;
      src_req_toggle[n] <= 'd0;
      src_state[n] <= 'd0;
    end else begin
      src_ack_toggle_m1[n] <= dest_ack_toggle[n];
      src_ack_toggle_m2[n] <= src_ack_toggle_m1[n];
      src_ack_toggle[n] <= src_ack_toggle_m2[n];
      if (src_state[n] == 1'b1) begin
        src_req_toggle[n] <= src_req_toggle[n];
        if ((src_ack_toggle[n] ^ src_ack_toggle_m2[n]) == 1'b1) begin
          src_state[n] <= 1'b0;
        end
      end else if (src_data[n] == 1'b1) begin
        src_req_toggle[n] <= ~src_req_toggle[n];
        src_state[n] <= 1'b1;
      end
    end
  end

  always @(negedge dest_resetn or posedge dest_clk) begin
    if (dest_resetn == 1'b0) begin
      dest_req_toggle_m1[n] <= 'd0;
      dest_req_toggle_m2[n] <= 'd0;
      dest_ack_toggle[n] <= 'd0;
      dest_data[n] <= 'd0;
    end else begin
      dest_req_toggle_m1[n] <= src_req_toggle[n];
      dest_req_toggle_m2[n] <= dest_req_toggle_m1[n];
      dest_ack_toggle[n] <= dest_req_toggle_m2[n];
      if ((dest_ack_toggle[n] ^ dest_req_toggle_m2[n]) == 1'b1) begin
        dest_data[n] <= 1'b1;
      end else begin
        dest_data[n] <= 1'b0;
      end
    end
  end

  end
  endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
