// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Simple CDC
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module cdc_cntrl #(parameter DATA_WIDTH = 8) (

  // source

  input   wire                              src_resetn,
  input   wire                              src_clk,
  input   wire  [(DATA_WIDTH-1):0]          src_data,

  // destination

  input   wire                              dest_resetn,
  input   wire                              dest_clk,
  output  reg   [(DATA_WIDTH-1):0]          dest_data = 'd0);

  // internal registers

  reg                                       src_xfer_state_m1 = 'd0;
  reg                                       src_xfer_state_m2 = 'd0;
  reg                                       src_xfer_state = 'd0;
  reg                                       src_xfer_toggle = 'd0;
  reg           [(DATA_WIDTH-1):0]          src_xfer_data = 'd0;
  reg                                       dest_xfer_toggle_m1 = 'd0;
  reg                                       dest_xfer_toggle_m2 = 'd0;
  reg                                       dest_xfer_toggle_m3 = 'd0;
  reg                                       dest_xfer_toggle = 'd0;

  // internal signals

  wire                                      src_xfer_enable_s;
  wire                                      dest_xfer_toggle_s;

  // device control transfer

  assign src_xfer_enable_s = src_xfer_state ^ src_xfer_toggle;

  always @(negedge src_resetn or posedge src_clk) begin
    if (src_resetn == 1'b0) begin
      src_xfer_state_m1 <= 'd0;
      src_xfer_state_m2 <= 'd0;
      src_xfer_state <= 'd0;
      src_xfer_toggle <= 'd0;
      src_xfer_data <= 'd0;
    end else begin
      src_xfer_state_m1 <= dest_xfer_toggle;
      src_xfer_state_m2 <= src_xfer_state_m1;
      src_xfer_state <= src_xfer_state_m2;
      if (src_xfer_enable_s == 1'b0) begin
        src_xfer_toggle <= ~src_xfer_toggle;
        src_xfer_data <= src_data;
      end
    end
  end

  assign dest_xfer_toggle_s = dest_xfer_toggle_m3 ^ dest_xfer_toggle_m2;

  always @(negedge dest_resetn or posedge dest_clk) begin
    if (dest_resetn == 1'b0) begin
      dest_xfer_toggle_m1 <= 'd0;
      dest_xfer_toggle_m2 <= 'd0;
      dest_xfer_toggle_m3 <= 'd0;
      dest_xfer_toggle <= 'd0;
      dest_data <= 'd0;
    end else begin
      dest_xfer_toggle_m1 <= src_xfer_toggle;
      dest_xfer_toggle_m2 <= dest_xfer_toggle_m1;
      dest_xfer_toggle_m3 <= dest_xfer_toggle_m2;
      dest_xfer_toggle <= dest_xfer_toggle_m3;
      if (dest_xfer_toggle_s == 1'b1) begin
        dest_data <= src_xfer_data;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
