// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_txdma_regs (

  input   wire  [31:0]    axilite_version,
  input   wire  [31:0]    axilite_instance_id,
  output  reg   [31:0]    axilite_scratch = 'd0,
  output  reg   [31:0]    axilite_timer = 'd0,
  input   wire  [31:0]    axilite_data_width,
  output  reg             axilite_swreset = 'd0,
  input   wire            axilite_swreset_clr,
  output  reg             axilite_start = 'd0,
  input   wire            axilite_start_clr,
  output  reg             axilite_stop = 'd0,
  input   wire            axilite_stop_clr,
  output  reg             axilite_cyclic = 'd0,
  output  reg   [ 3:0]    axilite_qthreshold = 'd0,
  input   wire            axilite_busy,
  input   wire            axilite_status,
  input   wire            axilite_underflow,
  input   wire            axilite_length_error,
  input   wire            axilite_tlast_error,
  input   wire            axilite_addrdec_error,
  input   wire            axilite_slave_error,
  output  reg   [31:0]    axilite_start_addr_low = 'd0,
  output  reg   [ 7:0]    axilite_start_addr_high = 'd0,
  output  reg   [22:0]    axilite_length = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_0 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_1 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_2 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_3 = 'd0,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [11:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [11:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);

  reg                     axilite_swreset_clr_d = 'd0;
  reg                     axilite_start_clr_d = 'd0;
  reg                     axilite_stop_clr_d = 'd0;
  reg                     axilite_underflow_w1c = 'd0;
  reg                     axilite_length_error_w1c = 'd0;
  reg                     axilite_tlast_error_w1c = 'd0;
  reg                     axilite_addrdec_error_w1c = 'd0;
  reg                     axilite_slave_error_w1c = 'd0;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      axilite_wrack <= axilite_wrreq;
      axilite_rdack <= axilite_rdreq;
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_scratch <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h8)) begin
        axilite_scratch <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_timer <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc)) begin
        axilite_timer <= axilite_wrdata;
      end else if (axilite_timer > 0) begin
        axilite_timer <= axilite_timer - 1'b1;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_swreset_clr_d <= 'd0;
      axilite_swreset <= 'h0;
    end else begin
      axilite_swreset_clr_d <= axilite_swreset_clr;
      if ((axilite_swreset_clr_d == 1'b0) && (axilite_swreset_clr == 1'b1)) begin
        axilite_swreset <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_swreset <= axilite_swreset | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_start_clr_d <= 'd0;
      axilite_start <= 'h0;
    end else begin
      axilite_start_clr_d <= axilite_start_clr;
      if ((axilite_start_clr_d == 1'b0) && (axilite_start_clr == 1'b1)) begin
        axilite_start <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h24)) begin
        axilite_start <= axilite_start | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_stop_clr_d <= 'd0;
      axilite_stop <= 'h0;
    end else begin
      axilite_stop_clr_d <= axilite_stop_clr;
      if ((axilite_stop_clr_d == 1'b0) && (axilite_stop_clr == 1'b1)) begin
        axilite_stop <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h24)) begin
        axilite_stop <= axilite_stop | axilite_wrdata[1];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_cyclic <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h24)) begin
        axilite_cyclic <= axilite_wrdata[2];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_qthreshold <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h24)) begin
        axilite_qthreshold <= axilite_wrdata[7:4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_underflow_w1c <= 'h0;
    end else begin
      if (axilite_underflow == 1'b1) begin
        axilite_underflow_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h2c)) begin
        axilite_underflow_w1c <= axilite_underflow_w1c & ~axilite_wrdata[1];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_length_error_w1c <= 'h0;
    end else begin
      if (axilite_length_error == 1'b1) begin
        axilite_length_error_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h2c)) begin
        axilite_length_error_w1c <= axilite_length_error_w1c & ~axilite_wrdata[2];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tlast_error_w1c <= 'h0;
    end else begin
      if (axilite_tlast_error == 1'b1) begin
        axilite_tlast_error_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h2c)) begin
        axilite_tlast_error_w1c <= axilite_tlast_error_w1c & ~axilite_wrdata[3];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_addrdec_error_w1c <= 'h0;
    end else begin
      if (axilite_addrdec_error == 1'b1) begin
        axilite_addrdec_error_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h2c)) begin
        axilite_addrdec_error_w1c <= axilite_addrdec_error_w1c & ~axilite_wrdata[4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_slave_error_w1c <= 'h0;
    end else begin
      if (axilite_slave_error == 1'b1) begin
        axilite_slave_error_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h2c)) begin
        axilite_slave_error_w1c <= axilite_slave_error_w1c & ~axilite_wrdata[5];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_start_addr_low <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h30)) begin
        axilite_start_addr_low <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_start_addr_high <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h34)) begin
        axilite_start_addr_high <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_length <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h40)) begin
        axilite_length <= axilite_wrdata[22:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h50)) begin
        axilite_trigger_mode_0 <= axilite_wrdata[2:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_1 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h50)) begin
        axilite_trigger_mode_1 <= axilite_wrdata[6:4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_2 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h50)) begin
        axilite_trigger_mode_2 <= axilite_wrdata[10:8];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_3 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h50)) begin
        axilite_trigger_mode_3 <= axilite_wrdata[14:12];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if (axilite_rdreq == 1'b1) begin
        case (axilite_rdaddr[11:0])
          'h0: begin
            axilite_rddata <= axilite_version;
          end
          'h4: begin
            axilite_rddata <= axilite_instance_id;
          end
          'h8: begin
            axilite_rddata <= axilite_scratch;
          end
          'hc: begin
            axilite_rddata <= axilite_timer;
          end
          'h10: begin
            axilite_rddata <= axilite_data_width;
          end
          'h20: begin
            axilite_rddata[0] <= axilite_swreset;
            axilite_rddata[31:1] <= 'd0;
          end
          'h24: begin
            axilite_rddata[0] <= axilite_start;
            axilite_rddata[1] <= axilite_stop;
            axilite_rddata[2] <= axilite_cyclic;
            axilite_rddata[3] <= 'd0;
            axilite_rddata[7:4] <= axilite_qthreshold;
            axilite_rddata[31:8] <= 'd0;
          end
          'h28: begin
            axilite_rddata[0] <= axilite_busy;
            axilite_rddata[31:1] <= 'd0;
          end
          'h2c: begin
            axilite_rddata[0] <= axilite_status;
            axilite_rddata[1] <= axilite_underflow_w1c;
            axilite_rddata[2] <= axilite_length_error_w1c;
            axilite_rddata[3] <= axilite_tlast_error_w1c;
            axilite_rddata[4] <= axilite_addrdec_error_w1c;
            axilite_rddata[5] <= axilite_slave_error_w1c;
            axilite_rddata[31:6] <= 'd0;
          end
          'h30: begin
            axilite_rddata <= axilite_start_addr_low;
          end
          'h34: begin
            axilite_rddata[7:0] <= axilite_start_addr_high;
            axilite_rddata[31:8] <= 'd0;
          end
          'h40: begin
            axilite_rddata[22:0] <= axilite_length;
            axilite_rddata[31:23] <= 'd0;
          end
          'h50: begin
            axilite_rddata[2:0] <= axilite_trigger_mode_0;
            axilite_rddata[3] <= 'd0;
            axilite_rddata[6:4] <= axilite_trigger_mode_1;
            axilite_rddata[7] <= 'd0;
            axilite_rddata[10:8] <= axilite_trigger_mode_2;
            axilite_rddata[11] <= 'd0;
            axilite_rddata[14:12] <= axilite_trigger_mode_3;
            axilite_rddata[31:15] <= 'd0;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
