# AXI Transmit DMA

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI transmit DMA transfers samples from the AXI memory slave (usually DDR).

## <a name="functional-description"></a>Functional Description

The DMA may optionally be synchronized with any one of the trigger sources. A simple block diagram is shown below.

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| tx\_clk               | Input                    | Transmit clock. |
| tx\_resetn            | Input                    | Transmit reset (active low). |
| tx\_tready            | Input                    | Transmit data read (ready for data). |
| tx\_tvalid            | Output                   | Transmit data valid. |
| tx\_tdata             | Output[32]               | Transmit data. |
| trig\_0               | Input                    | Trigger input 0, for data transfer. |
| trig\_1               | Input                    | Trigger input 1, for data transfer. |
| trig\_2               | Input                    | Trigger input 2, for data transfer. |
| trig\_3               | Input                    | Trigger input 3, for data transfer. |
| aximm\_clk            | Input                    | MM interface clock. |
| aximm\_resetn         | Input                    | MM interface reset (active low). |
| aximm\_araddr         | Output[40]               | MM read address channel, address. |
| aximm\_arlen          | Output[8]                | MM read address channel, length. |
| aximm\_arsize         | Output[3]                | MM read address channel, size. |
| aximm\_arburst        | Output[2]                | MM read address channel, burst. |
| aximm\_arprot         | Output[3]                | MM read address channel, protect. |
| aximm\_arcache        | Output[4]                | MM read address channel, cache. |
| aximm\_aruser         | Output[4]                | MM read address channel, user. |
| aximm\_arvalid        | Output                   | MM read address channel, valid. |
| aximm\_arready        | Input                    | MM read address channel, ready. |
| aximm\_rdata          | Input[512]               | MM read channel, data. |
| aximm\_rresp          | Input[2]                 | MM read channel, response. |
| aximm\_rlast          | Input                    | MM read channel, last. |
| aximm\_rvalid         | Input                    | MM read channel, valid. |
| aximm\_rready         | Output                   | MM read channel, ready. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_txdma_regs.md)
