// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_sysid_regs (

  input   wire  [31:0]    axilite_version,
  input   wire  [31:0]    axilite_instance_id,
  output  reg   [31:0]    axilite_scratch = 'd0,
  output  reg   [31:0]    axilite_timer = 'd0,
  input   wire  [ 7:0]    axilite_gpio_in,
  output  reg   [ 7:0]    axilite_gpio_out = 'd0,
  output  reg   [ 7:0]    axilite_gpio_in_mask = 'd0,
  input   wire  [ 7:0]    axilite_status_state,
  input   wire  [ 7:0]    axilite_status_event,
  output  reg   [ 7:0]    axilite_status_event_mask = 'd0,
  input   wire  [31:0]    axilite_sys_version,
  input   wire  [31:0]    axilite_sys_params_0,
  input   wire  [31:0]    axilite_sys_params_1,
  input   wire  [31:0]    axilite_sys_build_0,
  input   wire  [31:0]    axilite_sys_build_1,
  input   wire  [31:0]    axilite_sys_info_0_0,
  input   wire  [31:0]    axilite_sys_info_0_1,
  input   wire  [31:0]    axilite_sys_info_0_2,
  input   wire  [31:0]    axilite_sys_info_0_3,
  input   wire  [31:0]    axilite_sys_info_0_4,
  input   wire  [31:0]    axilite_sys_info_0_5,
  input   wire  [31:0]    axilite_sys_info_0_6,
  input   wire  [31:0]    axilite_sys_info_0_7,
  input   wire  [31:0]    axilite_sys_info_1_0,
  input   wire  [31:0]    axilite_sys_info_1_1,
  input   wire  [31:0]    axilite_sys_info_1_2,
  input   wire  [31:0]    axilite_sys_info_1_3,
  input   wire  [31:0]    axilite_sys_info_1_4,
  input   wire  [31:0]    axilite_sys_info_1_5,
  input   wire  [31:0]    axilite_sys_info_1_6,
  input   wire  [31:0]    axilite_sys_info_1_7,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [11:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [11:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);

  reg           [ 7:0]    axilite_status_event_w1c = 'd0;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      axilite_wrack <= axilite_wrreq;
      axilite_rdack <= axilite_rdreq;
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_scratch <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h8)) begin
        axilite_scratch <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_timer <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'hc)) begin
        axilite_timer <= axilite_wrdata;
      end else if (axilite_timer > 0) begin
        axilite_timer <= axilite_timer - 1'b1;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gpio_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h44)) begin
        axilite_gpio_out <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gpio_in_mask <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h48)) begin
        axilite_gpio_in_mask <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_status_event_w1c <= 'h0;
    end else begin
      if (axilite_status_event[0] == 1'b1) begin
        axilite_status_event_w1c[0] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[0] <= axilite_status_event_w1c[0] & ~axilite_wrdata[0];
      end
      if (axilite_status_event[1] == 1'b1) begin
        axilite_status_event_w1c[1] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[1] <= axilite_status_event_w1c[1] & ~axilite_wrdata[1];
      end
      if (axilite_status_event[2] == 1'b1) begin
        axilite_status_event_w1c[2] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[2] <= axilite_status_event_w1c[2] & ~axilite_wrdata[2];
      end
      if (axilite_status_event[3] == 1'b1) begin
        axilite_status_event_w1c[3] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[3] <= axilite_status_event_w1c[3] & ~axilite_wrdata[3];
      end
      if (axilite_status_event[4] == 1'b1) begin
        axilite_status_event_w1c[4] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[4] <= axilite_status_event_w1c[4] & ~axilite_wrdata[4];
      end
      if (axilite_status_event[5] == 1'b1) begin
        axilite_status_event_w1c[5] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[5] <= axilite_status_event_w1c[5] & ~axilite_wrdata[5];
      end
      if (axilite_status_event[6] == 1'b1) begin
        axilite_status_event_w1c[6] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[6] <= axilite_status_event_w1c[6] & ~axilite_wrdata[6];
      end
      if (axilite_status_event[7] == 1'b1) begin
        axilite_status_event_w1c[7] <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_status_event_w1c[7] <= axilite_status_event_w1c[7] & ~axilite_wrdata[7];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_status_event_mask <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[11:0] == 'h88)) begin
        axilite_status_event_mask <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if (axilite_rdreq == 1'b1) begin
        case (axilite_rdaddr[11:0])
          'h0: begin
            axilite_rddata <= axilite_version;
          end
          'h4: begin
            axilite_rddata <= axilite_instance_id;
          end
          'h8: begin
            axilite_rddata <= axilite_scratch;
          end
          'hc: begin
            axilite_rddata <= axilite_timer;
          end
          'h40: begin
            axilite_rddata[7:0] <= axilite_gpio_in;
            axilite_rddata[31:8] <= 'd0;
          end
          'h44: begin
            axilite_rddata[7:0] <= axilite_gpio_out;
            axilite_rddata[31:8] <= 'd0;
          end
          'h48: begin
            axilite_rddata[7:0] <= axilite_gpio_in_mask;
            axilite_rddata[31:8] <= 'd0;
          end
          'h80: begin
            axilite_rddata[7:0] <= axilite_status_state;
            axilite_rddata[31:8] <= 'd0;
          end
          'h84: begin
            axilite_rddata[7:0] <= axilite_status_event_w1c;
            axilite_rddata[31:8] <= 'd0;
          end
          'h88: begin
            axilite_rddata[7:0] <= axilite_status_event_mask;
            axilite_rddata[31:8] <= 'd0;
          end
          'h100: begin
            axilite_rddata <= axilite_sys_version;
          end
          'h104: begin
            axilite_rddata <= axilite_sys_params_0;
          end
          'h108: begin
            axilite_rddata <= axilite_sys_params_1;
          end
          'h140: begin
            axilite_rddata <= axilite_sys_build_0;
          end
          'h144: begin
            axilite_rddata <= axilite_sys_build_1;
          end
          'h200: begin
            axilite_rddata <= axilite_sys_info_0_0;
          end
          'h204: begin
            axilite_rddata <= axilite_sys_info_0_1;
          end
          'h208: begin
            axilite_rddata <= axilite_sys_info_0_2;
          end
          'h20c: begin
            axilite_rddata <= axilite_sys_info_0_3;
          end
          'h210: begin
            axilite_rddata <= axilite_sys_info_0_4;
          end
          'h214: begin
            axilite_rddata <= axilite_sys_info_0_5;
          end
          'h218: begin
            axilite_rddata <= axilite_sys_info_0_6;
          end
          'h21c: begin
            axilite_rddata <= axilite_sys_info_0_7;
          end
          'h300: begin
            axilite_rddata <= axilite_sys_info_1_0;
          end
          'h304: begin
            axilite_rddata <= axilite_sys_info_1_1;
          end
          'h308: begin
            axilite_rddata <= axilite_sys_info_1_2;
          end
          'h30c: begin
            axilite_rddata <= axilite_sys_info_1_3;
          end
          'h310: begin
            axilite_rddata <= axilite_sys_info_1_4;
          end
          'h314: begin
            axilite_rddata <= axilite_sys_info_1_5;
          end
          'h318: begin
            axilite_rddata <= axilite_sys_info_1_6;
          end
          'h31c: begin
            axilite_rddata <= axilite_sys_info_1_7;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
