#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       System Id
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 12;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_sysid');

register(0x000, 'REG_VERSION');
field(0, 32, RO, 0x00060000, 'VERSION', 'This is read as the current version of this IP core.');

register(0x004, 'REG_INSTANCE_ID');
field(0, 32, RO, 0x0, 'INSTANCE_ID', 'These bits Indicate the instance ID, in any multiple
  instances system, instance id 0x0 is the master core.');

register(0x008, 'REG_SCRATCH');
field(0, 32, RW, 0x0, 'SCRATCH', 'The general purpose scratch register');

register(0x00c, 'TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'The general purpose timer register');

## ##################################################################################
## ##################################################################################
## System GPIO

register(0x040, 'REG_GPIO_IN');
field(0, 8, RO, 0x0, 'GPIO_IN', 'GPIO inputs.');

register(0x044, 'REG_GPIO_OUT');
field(0, 8, RW, 0x0, 'GPIO_OUT', 'GPIO outputs.');

register(0x048, 'REG_GPIO_IN_MASK');
field(0, 8, RW, 0x0, 'GPIO_IN_MASK', 'If set, the corresponding gpio input is
  masked from generating an interrupt to the system.');

## ##################################################################################
## ##################################################################################
## System status & information (raw & persistent)

register(0x080, 'REG_STATUS_STATE');
field(0, 8, RO, 0x0, 'STATUS_STATE', 'Platform status states');

register(0x084, 'REG_STATUS_EVENT');
field(0, 8, RW1C, 0x0, 'STATUS_EVENT', 'Platform status events');

register(0x088, 'REG_STATUS_EVENT_MASK');
field(0, 8, RW, 0x0, 'STATUS_EVENT_MASK', 'If set, the corresponding event is
  masked from generating an interrupt to the system.');

## ##################################################################################
## ##################################################################################
## Platform Version (not the IP core version)

register(0x100, 'REG_SYS_VERSION');
field(0, 32, RO, 0x00060000, 'SYS_VERSION', 'This is read as the current version
  of the system and is independent of the IP core version.');

register(0x104, 'REG_SYS_PARAMS_0');
field(0, 32, RO, 0x0, 'SYS_PARAMS_0', 'This is read as system parameters
  set by the project (dependent on the platform)');

register(0x108, 'REG_SYS_PARAMS_1');
field(0, 32, RO, 0x0, 'SYS_PARAMS_1', 'This is read as system parameters
  set by the project (dependent on the platform)');

register(0x140, 'REG_SYS_BUILD_0');
field(0, 32, RO, 0x0, 'SYS_BUILD_0', 'This is read as the build version
  of the system as MMDDYYYY.');

register(0x144, 'REG_SYS_BUILD_1');
field(0, 32, RO, 0x0, 'SYS_BUILD_1', 'This is read as the build version
  of the system as 00HHMMSS.');

## ##################################################################################
## ##################################################################################
## The 32 character system identifier.

$SID = "ADRV9001 Rev.A ZC706";
for ($n = 0; $n < 8; $n++) {
  register((0x200 + ($n*4)), "REG_SYS_INFO_0_${n}");
  field(0, 32, RO, s2h_32($SID, $n), "SYS_INFO_0_${n}", "System Id string $n");
}

## ##################################################################################
## ##################################################################################
## The 32 character system build identifier.

$BID = "201909191621";
for ($n = 0; $n < 8; $n++) {
  register((0x300 + ($n*4)), "REG_SYS_INFO_1_${n}");
  field(0, 32, RO, s2h_32($BID, $n), "SYS_INFO_1_${n}", "Build Id string $n");
}

## ##################################################################################
## ##################################################################################

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
