# axi\_sysid
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This is read as the current version of this IP core. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | These bits Indicate the instance ID, in any multiple instances system, instance id 0x0 is the master core. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | The general purpose scratch register |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | The general purpose timer register |
| | | | | | |
| 0x40 | [7:0] | gpio\_in[7:0] | RO | 0x0 | GPIO inputs. |
| | | | | | |
| 0x44 | [7:0] | gpio\_out[7:0] | RW | 0x0 | GPIO outputs. |
| | | | | | |
| 0x48 | [7:0] | gpio\_in\_mask[7:0] | RW | 0x0 | If set, the corresponding gpio input is masked from generating an interrupt to the system. |
| | | | | | |
| 0x80 | [7:0] | status\_state[7:0] | RO | 0x0 | Platform status states |
| | | | | | |
| 0x84 | [7:0] | status\_event[7:0] | RW1C | 0x0 | Platform status events |
| | | | | | |
| 0x88 | [7:0] | status\_event\_mask[7:0] | RW | 0x0 | If set, the corresponding event is masked from generating an interrupt to the system. |
| | | | | | |
| 0x100 | [31:0] | sys\_version[31:0] | RO | 0x60000 | This is read as the current version of the system and is independent of the IP core version. |
| | | | | | |
| 0x104 | [31:0] | sys\_params\_0[31:0] | RO | 0x0 | This is read as system parameters set by the project (dependent on the platform) |
| | | | | | |
| 0x108 | [31:0] | sys\_params\_1[31:0] | RO | 0x0 | This is read as system parameters set by the project (dependent on the platform) |
| | | | | | |
| 0x140 | [31:0] | sys\_build\_0[31:0] | RO | 0x0 | This is read as the build version of the system as MMDDYYYY. |
| | | | | | |
| 0x144 | [31:0] | sys\_build\_1[31:0] | RO | 0x0 | This is read as the build version of the system as 00HHMMSS. |
| | | | | | |
| 0x200 | [31:0] | sys\_info\_0\_0[31:0] | RO | 0x41445256 | System Id string 0 |
| | | | | | |
| 0x204 | [31:0] | sys\_info\_0\_1[31:0] | RO | 0x39303031 | System Id string 1 |
| | | | | | |
| 0x208 | [31:0] | sys\_info\_0\_2[31:0] | RO | 0x20526576 | System Id string 2 |
| | | | | | |
| 0x20c | [31:0] | sys\_info\_0\_3[31:0] | RO | 0x2e41205a | System Id string 3 |
| | | | | | |
| 0x210 | [31:0] | sys\_info\_0\_4[31:0] | RO | 0x43373036 | System Id string 4 |
| | | | | | |
| 0x214 | [31:0] | sys\_info\_0\_5[31:0] | RO | 0x20202020 | System Id string 5 |
| | | | | | |
| 0x218 | [31:0] | sys\_info\_0\_6[31:0] | RO | 0x20202020 | System Id string 6 |
| | | | | | |
| 0x21c | [31:0] | sys\_info\_0\_7[31:0] | RO | 0x20202020 | System Id string 7 |
| | | | | | |
| 0x300 | [31:0] | sys\_info\_1\_0[31:0] | RO | 0x32303139 | Build Id string 0 |
| | | | | | |
| 0x304 | [31:0] | sys\_info\_1\_1[31:0] | RO | 0x30393139 | Build Id string 1 |
| | | | | | |
| 0x308 | [31:0] | sys\_info\_1\_2[31:0] | RO | 0x31363231 | Build Id string 2 |
| | | | | | |
| 0x30c | [31:0] | sys\_info\_1\_3[31:0] | RO | 0x20202020 | Build Id string 3 |
| | | | | | |
| 0x310 | [31:0] | sys\_info\_1\_4[31:0] | RO | 0x20202020 | Build Id string 4 |
| | | | | | |
| 0x314 | [31:0] | sys\_info\_1\_5[31:0] | RO | 0x20202020 | Build Id string 5 |
| | | | | | |
| 0x318 | [31:0] | sys\_info\_1\_6[31:0] | RO | 0x20202020 | Build Id string 6 |
| | | | | | |
| 0x31c | [31:0] | sys\_info\_1\_7[31:0] | RO | 0x20202020 | Build Id string 7 |
| | | | | | |
---
