# AXI System Identifier

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI system identifier core is a parameterized informational core about the platform. It allows software to identify the platform, monitor the platforms functionalities.

## <a name="functional-description"></a>Functional Description

The system identifier provides the following information:

### System Version

This identifies the platform version (not the IP core version). Software must identify the platform using this register and **NOT** the individual IP core versions. Integer, 32bits.

### System Parameters

This contains the platform parameters as set by the user. Integer, 64bits.

### System Info

This contains the platform information as set by the user. This is interpreted as two separate strings 32 characters long.

### System Build

This contains the platform build information. This is the build date and time.

### Platform Status

These bits indicate the platform status (such as processor reset, memory controller status (DDR), clock generator status (PLL) and such.

### Platform GPIO

These bits reflects any platform inputs (push buttons, switches and such) and platform outputs (leds, voltage enables and such).

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
| STATUS\_WIDTH     | Integer | 8       | The width of status bits on the platform. |
| GPIO\_IN\_WIDTH   | Integer | 8       | The width of platform GPIO inputs. |
| GPIO\_OUT\_WIDTH  | Integer | 8       | The width of platform GPIO outputs. |
| SYS\_VERSION      | [31:0]  | 0       | The platform/system version. |
| SYS\_PARAMS       | [63:0]  | 0       | The platform/system parameters. |
| SYS\_INFO\_0      | [255:0] | 0       | The 32 character system information string 1. |
| SYS\_INFO\_1      | [255:0] | 0       | The 32 character system information string 2. |
| SYS\_BUILD        | [63:0]  | 0       | The build identifier MM-DD-YYYY, SS-MM-HH. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| status                | Input[STATUS\_WIDTH]     | Platform status inputs. |
| gpio\_in              | Input[GPIO\_IN\_WIDTH]   | Platform GPIO inputs. |
| gpio\_out             | Output[GPIO\_OUT\_WIDTH] | Platform GPIO outputs. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_sysid_regs.md)
