## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       DMA Xilinx Cores
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

source ../../../bin/vivado_include.tcl

create_project axi_rxdma . -part xc7z045ffg900-2 -force
msg_settings none

set ip_source_list {}
lappend ip_source_list ../../common/hdl/cdc.v
lappend ip_source_list ../../common/hdl/cdc_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_cntrl.v
lappend ip_source_list ../../common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_event.v
lappend ip_source_list ../../common/hdl/cdc_event_constr.xdc
lappend ip_source_list ../../common/hdl/axilite_slave_if.v
lappend ip_source_list axi_rxdma_regs.v
lappend ip_source_list axi_rxdma.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_rxdma [get_filesets sources_1]
set_property top axi_rxdma [get_filesets sim_1]

pkg_ip_core axi_rxdma
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {name =~ *synthesis*}]
set_property SCOPED_TO_REF cdc_event [ipx::get_files *cdc_event_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc [ipx::get_files *cdc_constr.xdc -of_objects $ip_file_set]
ipx::save_core

set_property driver_value 0 [ipx::get_ports *trig* -of_objects [ipx::current_core]]
ipx::save_core

## ##################################################################################
## ##################################################################################

set ip_file_list {}
set ip_param_list {}
create_ip -vlnv xilinx.com:ip:axi_datamover:5.1 -module_name axi_rxdma_mm
lappend ip_param_list config.c_enable_mm2s 0
lappend ip_param_list config.c_include_s2mm full
lappend ip_param_list config.c_m_axi_s2mm_data_width 512
lappend ip_param_list config.c_s_axis_s2mm_tdata_width 64
lappend ip_param_list config.c_s2mm_burst_size 16
lappend ip_param_list config.c_s2mm_btt_used 23
lappend ip_param_list config.c_enable_s2mm_adv_sig 0
lappend ip_param_list config.c_addr_width 40
lappend ip_param_list config.c_s2mm_stscmd_is_async false
lappend ip_param_list config.c_s2mm_include_sf true
lappend ip_param_list config.c_m_axi_s2mm_id_width 0
set_property -dict $ip_param_list [get_ips axi_rxdma_mm]
lappend ip_file_list [get_files axi_rxdma_mm.xci]
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_list {}
set ip_param_list {}
create_ip -vlnv xilinx.com:ip:axis_data_fifo:1.1 -module_name axi_rxdma_es
lappend ip_param_list config.tdata_num_bytes 8
lappend ip_param_list config.is_aclk_async 1
set_property -dict $ip_param_list [get_ips axi_rxdma_es]
lappend ip_file_list [get_files axi_rxdma_es.xci]
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_list {}
set ip_param_list {}
create_ip -vlnv xilinx.com:ip:axis_dwidth_converter:1.1 -module_name axi_rxdma_dw
lappend ip_param_list config.s_tdata_num_bytes 1
lappend ip_param_list config.m_tdata_num_bytes 8
set_property -dict $ip_param_list [get_ips axi_rxdma_dw]
lappend ip_file_list [get_files axi_rxdma_dw.xci]
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

## ##################################################################################
## ##################################################################################

