#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       Receive DMA registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 12;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_rxdma');

register(0x000, 'REG_VERSION');
field(0, 32, RO, 0x00060000, 'VERSION', 'This is read as the current version of this IP core.');

register(0x004, 'REG_INSTANCE_ID');
field(0, 32, RO, 0x0, 'INSTANCE_ID', 'These bits Indicate the instance ID, in any multiple
  instances system, instance id 0x0 is the master core.');

register(0x008, 'REG_SCRATCH');
field(0, 32, RW, 0x0, 'SCRATCH', 'The general purpose scratch register');

register(0x00c, 'TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'The general purpose timer register');

register(0x010, 'REG_DATA_WIDTH');
field(0, 32, RO, 0x200, 'DATA_WIDTH', 'These bits Indicate AXIMM data width, ideally
  it is best to set the length to an integer multiple of this width in bytes. This allows
  minimal realignment and byte enables.');

register(0x020, 'REG_SWRESET');
field(0, 1, RW1HC, 0x0, 'SWRESET', 'If set, the core is reset at the AXIMM interface.
  In all hardware error cases, a software reset is required to resume normal
  operation. Hardware clears this bit once the internal reset is completed.');

register(0x024, 'REG_CONTROL');
field(0, 1, RW1HC, 0x0, 'START', 'If set interpreted as a request to start the data transfer.
  All DMA related registers must be set properly before asserting this bit.');
field(1, 1, RW1HC, 0x0, 'STOP', 'If set, while the DMA BUSY bit is set, interpreted as a
  request to stop the data transfer. This may take a while depending on the queue threshold
  programmed and cyclic mode. All pending bursts is cleared.');
field(2, 1, RW,    0x0, 'CYCLIC', 'This bit may be asserted to indicate a cyclic data
  transfer, software may split up contigous memory as segments to provide a seamless
  capture, however it must be capable of finishing read before data transfer repeats.');
field(4, 4, RW,    0x0, 'QTHRESHOLD', 'The transaction queue threshold, this limits the
  maximum number of posted transactions within the current data transfer.');

register(0x028, 'REG_BUSY');
field(0, 1, RO,   0x0, 'BUSY', 'If asserted indicates that dma is running or has stopped
  because of an error as indicated by the STATUS fields below. This bit is asserted
  low to indicate a successful completion of DMA, provided there are no overflow.');

register(0x02c, 'REG_STATUS');
field(0, 1, RO,   0x0, 'STATUS', 'If asserted indicates that the AXI bus transaction
  has completed successfully, this is not an indication of the entire transfer.
  This bit is accumulative');
field(1, 1, RW1C, 0x0, 'OVERFLOW', 'If asserted indicates an overflow, data transfer
  may complete, but most likely data is corrupted.');
field(2, 1, RW1C, 0x0, 'LENGTH_ERROR', 'If asserted indicates an invalid transfer
  length, recovery requires a soft-reset.');
field(3, 1, RW1C, 0x0, 'TLAST_ERROR', 'If asserted indicates an internal LAST flag
  error, recovery requires a soft-reset.');
field(4, 1, RW1C, 0x0, 'ADDRDEC_ERROR', 'If asserted indicates an address decode error,
  likely that the slave is not addressable, recovery requires a soft-reset.');
field(5, 1, RW1C, 0x0, 'SLAVE_ERROR', 'If asserted indicates a slave error, this is
  the AXI-RESPONSE received from the slave, recovery requires a soft-reset.');

register(0x030, 'REG_START_ADDR_LOW');
field(0, 32, RW, 0x0, 'START_ADDR_LOW', 'start address low order bits');

register(0x034, 'REG_START_ADDR_HIGH');
field(0, 8, RW, 0x0, 'START_ADDR_HIGH', 'start address high order bits');

register(0x040, 'REG_LENGTH');
field(0, 23, RW, 0x0, 'LENGTH', 'indicates length in bytes');

register(0x050, 'REG_TRIGGER_MODE');
field( 0, 3, RW, 0x0, 'TRIGGER_MODE_0', 'The DMA may optionally be controlled through
  the cores trigger inputs. There are four programmable trigger inputs, these bits
  control each one of the triggers independently. The data transfer is controlled
  as an AND function of all the trigger modes. In all modes, the duration of data
  transfer is controlled by the length.
  0x0: This trigger source is disabled.
  0x1: The data transfer is enabled if the trigger input is asserted high.
  0x4: The data transfer is enabled after a rising edge on the trigger input.
  0x5: The data transfer is enabled after a falling edge on the trigger input.
  0x6: The data transfer is enabled after any edge on the trigger input.');
field( 4, 3, RW, 0x0, 'TRIGGER_MODE_1', 'The same as above for trigger input 1');
field( 8, 3, RW, 0x0, 'TRIGGER_MODE_2', 'The same as above for trigger input 2');
field(12, 3, RW, 0x0, 'TRIGGER_MODE_3', 'The same as above for trigger input 3');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
