# axi\_rxdma
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This is read as the current version of this IP core. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | These bits Indicate the instance ID, in any multiple instances system, instance id 0x0 is the master core. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | The general purpose scratch register |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | The general purpose timer register |
| | | | | | |
| 0x10 | [31:0] | data\_width[31:0] | RO | 0x200 | These bits Indicate AXIMM data width, ideally it is best to set the length to an integer multiple of this width in bytes. This allows minimal realignment and byte enables. |
| | | | | | |
| 0x20 | [0:0] | swreset | RW1HC | 0x0 | If set, the core is reset at the AXIMM interface. In all hardware error cases, a software reset is required to resume normal operation. Hardware clears this bit once the internal reset is completed. |
| | | | | | |
| 0x24 | [0:0] | start | RW1HC | 0x0 | If set interpreted as a request to start the data transfer. All DMA related registers must be set properly before asserting this bit. |
| 0x24 | [1:1] | stop | RW1HC | 0x0 | If set, while the DMA BUSY bit is set, interpreted as a request to stop the data transfer. This may take a while depending on the queue threshold programmed and cyclic mode. All pending bursts is cleared. |
| 0x24 | [2:2] | cyclic | RW | 0x0 | This bit may be asserted to indicate a cyclic data transfer, software may split up contigous memory as segments to provide a seamless capture, however it must be capable of finishing read before data transfer repeats. |
| 0x24 | [7:4] | qthreshold[3:0] | RW | 0x0 | The transaction queue threshold, this limits the maximum number of posted transactions within the current data transfer. |
| | | | | | |
| 0x28 | [0:0] | busy | RO | 0x0 | If asserted indicates that dma is running or has stopped because of an error as indicated by the STATUS fields below. This bit is asserted low to indicate a successful completion of DMA, provided there are no overflow. |
| | | | | | |
| 0x2c | [0:0] | status | RO | 0x0 | If asserted indicates that the AXI bus transaction has completed successfully, this is not an indication of the entire transfer. This bit is accumulative |
| 0x2c | [1:1] | overflow | RW1C | 0x0 | If asserted indicates an overflow, data transfer may complete, but most likely data is corrupted. |
| 0x2c | [2:2] | length\_error | RW1C | 0x0 | If asserted indicates an invalid transfer length, recovery requires a soft-reset. |
| 0x2c | [3:3] | tlast\_error | RW1C | 0x0 | If asserted indicates an internal LAST flag error, recovery requires a soft-reset. |
| 0x2c | [4:4] | addrdec\_error | RW1C | 0x0 | If asserted indicates an address decode error, likely that the slave is not addressable, recovery requires a soft-reset. |
| 0x2c | [5:5] | slave\_error | RW1C | 0x0 | If asserted indicates a slave error, this is the AXI-RESPONSE received from the slave, recovery requires a soft-reset. |
| | | | | | |
| 0x30 | [31:0] | start\_addr\_low[31:0] | RW | 0x0 | start address low order bits |
| | | | | | |
| 0x34 | [7:0] | start\_addr\_high[7:0] | RW | 0x0 | start address high order bits |
| | | | | | |
| 0x40 | [22:0] | length[22:0] | RW | 0x0 | indicates length in bytes |
| | | | | | |
| 0x50 | [2:0] | trigger\_mode\_0[2:0] | RW | 0x0 | The DMA may optionally be controlled through the cores trigger inputs. There are four programmable trigger inputs, these bits control each one of the triggers independently. The data transfer is controlled as an AND function of all the trigger modes. In all modes, the duration of data transfer is controlled by the length. 0x0: This trigger source is disabled. 0x1: The data transfer is enabled if the trigger input is asserted high. 0x4: The data transfer is enabled after a rising edge on the trigger input. 0x5: The data transfer is enabled after a falling edge on the trigger input. 0x6: The data transfer is enabled after any edge on the trigger input. |
| 0x50 | [6:4] | trigger\_mode\_1[2:0] | RW | 0x0 | The same as above for trigger input 1 |
| 0x50 | [10:8] | trigger\_mode\_2[2:0] | RW | 0x0 | The same as above for trigger input 2 |
| 0x50 | [14:12] | trigger\_mode\_3[2:0] | RW | 0x0 | The same as above for trigger input 3 |
| | | | | | |
---
