# AXI Receive DMA

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
* [Parameters](#parameters)
* [Ports](#ports)
* [Register Map](#register-map)

## <a name="introduction"></a>Introduction

The AXI receive DMA transfers samples to the AXI memory slave (usually DDR).

## <a name="functional-description"></a>Functional Description

The DMA may optionally be synchronized with any one of the trigger sources. A simple block diagram is shown below.

## <a name="parameters"></a>Parameters

---
| Parameter         | Type    | Default | Description |
| ----------------- | ------- | ------- | ----------- |
| INSTANCE\_ID      | Integer | 0       | The instance ID of this core. |
| AXIS\_DATA\_WIDTH | Integer | 32      | The AXIS data width 32 or 8 only. |
|||||
---

## <a name="ports"></a>Ports

---
| Port                  | Direction/Size           | Description |
| --------------------- | ------------------------ | ----------- |
| rx\_clk               | Input                    | Receive clock. |
| rx\_resetn            | Input                    | Receive reset (active low). |
| rx\_tvalid            | Input                    | Receive data valid. |
| rx\_tdata             | Input[AXIS\_DATA\_WIDTH] | Receive data. |
| trig\_0               | Input                    | Trigger input 0, for data transfer. |
| trig\_1               | Input                    | Trigger input 1, for data transfer. |
| trig\_2               | Input                    | Trigger input 2, for data transfer. |
| trig\_3               | Input                    | Trigger input 3, for data transfer. |
| aximm\_clk            | Input                    | MM interface clock. |
| aximm\_resetn         | Input                    | MM interface reset (active low). |
| aximm\_awaddr         | Output[40]               | MM write address channel, address. |
| aximm\_awlen          | Output[8]                | MM write address channel, length. |
| aximm\_awsize         | Output[3]                | MM write address channel, size. |
| aximm\_awburst        | Output[2]                | MM write address channel, burst. |
| aximm\_awprot         | Output[3]                | MM write address channel, protect. |
| aximm\_awcache        | Output[4]                | MM write address channel, cache. |
| aximm\_awvalid        | Output                   | MM write address channel, valid. |
| aximm\_awready        | Input                    | MM write address channel, ready. |
| aximm\_wdata          | Output[512]              | MM write channel, data. |
| aximm\_wstrb          | Output[64]               | MM write channel, strobe. |
| aximm\_wlast          | Output                   | MM write channel, last. |
| aximm\_wvalid         | Output                   | MM write channel, valid. |
| aximm\_wready         | Input                    | MM write channel, ready. |
| aximm\_bresp          | Input[2]                 | MM write response channel, data (response). |
| aximm\_bvalid         | Input                    | MM write response channel, valid. |
| aximm\_bready         | Output                   | MM write response channel, ready. |
| axilite\_clk          | Input                    | Processor clock. |
| axilite\_resetn       | Input                    | Processor reset (active low). |
| axilite\_awvalid      | Input                    | Write address channel, valid. |
| axilite\_awaddr       | Input[16]                | Write address channel, address. |
| axilite\_awready      | Output                   | Write address channel, ready. |
| axilite\_wvalid       | Input                    | Write channel, valid. |
| axilite\_wdata        | Input[32]                | Write channel, data. | 
| axilite\_wready       | Output                   | Write channel, ready. |
| axilite\_bvalid       | Output                   | Write response channel, valid. |
| axilite\_bresp        | Output[2]                | Write response channel, data (response). |
| axilite\_bready       | Input                    | Write response channel, ready. |
| axilite\_arvalid      | Input                    | Read address channel, valid. |
| axilite\_araddr       | Input[16]                | Read address channel, address. |
| axilite\_arready      | Output                   | Read address channel, ready. |
| axilite\_rvalid       | Output                   | Read data channel, valid. |
| axilite\_rresp        | Output[2]                | Read data channel, response. |
| axilite\_rdata        | Output[32]               | Read data channel, data. |
| axilite\_rready       | Input                    | Read data channel, ready. |
| interrupt             | Output                   | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

### [Register Map](hdl/axi_rxdma_regs.md)
