## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       Master SPI
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

source ../../../bin/vivado_include.tcl

create_project axi_mspi . -part xc7z045ffg900-2 -force
msg_settings none

set ip_source_list {}
lappend ip_source_list axi_mspi_defs.sv
lappend ip_source_list axi_mspi_regs.sv
lappend ip_source_list axi_mspi_engine.v
lappend ip_source_list axi_mspi.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_mspi [get_filesets sources_1]
set_property top axi_mspi [get_filesets sim_1]

pkg_ip_core axi_mspi
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

## ##################################################################################
## ##################################################################################

set ip_param_list {}
create_ip -vlnv xilinx.com:ip:fifo_generator:13.2 -module_name fifo_8w_256d
lappend ip_param_list config.fifo_implementation {common_clock_block_ram}
lappend ip_param_list config.performance_options {first_word_fall_through}
lappend ip_param_list config.input_data_width {8}
lappend ip_param_list config.input_depth {256}
lappend ip_param_list config.output_data_width {8}
lappend ip_param_list config.output_depth {256}
lappend ip_param_list config.reset_pin {true}
lappend ip_param_list config.reset_type {synchronous_reset}
lappend ip_param_list config.data_count {true}
set_property -dict $ip_param_list [get_ips fifo_8w_256d]
lappend ip_file_list [get_files fifo_8w_256d.xci]
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

## ##################################################################################
## ##################################################################################

