`timescale 1ns / 1ps
//-----------------------------------------------------------------------------------
// ################  Company:        Analog Devices, Inc.
// ##   ###########  Engineer:       JCE
// ##      ########
// ##         #####  Create Date:    
// ##            ##  Design Name:    
// ##         #####  Module Name:    
// ##      ########  Project Name:   
// ##   ###########  Target Devices: 
// ################  Tool versions:  
//-----------------------------------------------------------------------------------
// Description:
//
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
//
// Additional Comments: 
//
//-----------------------------------------------------------------------------------
// The following code is provided as-is and is intended to be used as a reference 
// only.  ADI is not responsible for supporting or providing updates.  The code may 
// contain manufacturer specific primitive elements.  You are solely responsible for 
// obtaining the proper license to use the manufacturer's design tools.
//
// All rights reserved.  
//-----------------------------------------------------------------------------------


module axi_mspi_regs
  #(parameter NUM_SLAVES = 1)
   (
    // axi interface
    input 			 s_axi_aclk,
    input 			 s_axi_aresetn,
    input 			 s_axi_awvalid,
    input [31:0] 		 s_axi_awaddr,
    output reg 			 s_axi_awready,
    input 			 s_axi_wvalid,
    input [31:0] 		 s_axi_wdata,
    input [ 3:0] 		 s_axi_wstrb,
    output reg 			 s_axi_wready,
    output reg 			 s_axi_bvalid,
    output wire [ 1:0] 		 s_axi_bresp,
    input 			 s_axi_bready,
    input 			 s_axi_arvalid,
    input [31:0] 		 s_axi_araddr,
    output reg 			 s_axi_arready,
    output reg 			 s_axi_rvalid,
    output reg [31:0] 		 s_axi_rdata,
    output wire [ 1:0] 		 s_axi_rresp,
    input 			 s_axi_rready,

    // interrupt signals
    output reg 			 interrupt,
   
    // reset signal
    output wire 		 soft_reset,

    // control signals
    output wire 		 loop,
    output wire 		 spe,
    output wire 		 master,
    output reg 			 cpol,
    output reg 			 cpha,
    output wire 		 tx_fifo_reset,
    output wire 		 rx_fifo_reset,
    output wire 		 man_ss_en,
    output wire 		 mstr_inhibit,
    output reg 			 lsb_first,

    output reg 			 four_wire,
    output reg 			 miso_slip,
    output reg [7:0] 		 tri_point,
    output reg [15:0] 		 clock_div,

    // status signals
    input 			 rx_empty,
    input 			 rx_full,
    input 			 tx_empty,
    input 			 tx_full,

    // data signals
    input 			 rx_data_wr,
    output wire 		 rx_data_rd,
    input [7:0] 		 rx_data,
    output wire 		 tx_data_wr,
    output wire [7:0] 		 tx_data,

    // slave select signals
    input [NUM_SLAVES-1:0] 	 slave_select_i,
    output wire [NUM_SLAVES-1:0] slave_select_o,

    // fifo occupancy signals
    input [8:0] 		 tx_fifo_occupancy,
    input [8:0] 		 rx_fifo_occupancy
    
    );
   
   import axi_mspi_pkg::*;
   
   parameter                     ADDRESS_WIDTH = 6;
   localparam                    AW = ADDRESS_WIDTH-1;
   
   parameter	                 DEFAULT_3WIRE_TRI_POINT = 8'h10;
   parameter 	                 DEFAULT_CLOCK_DIV = 16'h0001;
   
   // internal registers
   reg [AW:0] 			 wr_addr;
   reg [AW:0] 			 rd_addr;
   
   reg 				 write_address_valid;
   reg 				 write_valid;
   reg 				 read_address_valid;
   
   reg [31:0] 			 dgier = 32'b0;
   reg [31:0] 			 ipisr_rd = 32'b0;
   reg [31:0] 			 ipisr_wr = 32'b0;
   reg [31:0] 			 ipier = 32'b0;
   reg [31:0] 			 srr = 32'b0;
   reg [31:0] 			 spicr = 32'b0;
   reg [31:0] 			 spisr = 32'b0;
   reg [31:0] 			 spidtr = 32'b0;
   reg [31:0] 			 spidrr = 32'b0;
   reg [31:0] 			 spissr = 32'b0;
   reg [31:0] 			 tx_fifo_ocy = 32'b0;
   reg [31:0] 			 rx_fifo_ocy = 32'b0;
   reg [31:0][31:0] 		 adv_feat_config_ss_reg;
   
   // interrupt signals
   wire 			 gie;
   
   reg 				 modf;
   reg 				 dtr_empty;
   reg 				 drr_full;
   reg 				 drr_overrun;
   reg 				 tx_fifo_half_empty;
   
   reg 				 tx_empty_d;
   reg 				 rx_full_d;
   reg [8:0] 			 tx_fifo_ocy_d;
   
   wire 			 modf_itog;
   wire 			 dtr_empty_itog;
   wire 			 drr_full_itog;
   wire 			 drr_overrun_itog;
   wire 			 tx_fifo_half_empty_itog;
   
   wire 			 modf_ien;
   wire 			 dtr_empty_ien;
   wire 			 drr_full_ien;
   wire 			 drr_overrun_ien;
   wire 			 tx_fifo_half_empty_ien;
   
   // advanced signals
   wire [31:0] 			 adv_feat_enable;
   wire [31:0] 			 adv_feat_cpol;
   wire [31:0] 			 adv_feat_cpha;
   wire [31:0] 			 adv_feat_lsb_first;
   wire [31:0] 			 adv_feat_four_wire;
   wire [31:0] 			 adv_feat_miso_slip;
   wire [31:0][7:0] 		 adv_feat_3wire_tri_point;
   wire [31:0][15:0] 		 adv_feat_clock_div;

   genvar  			 i;
   integer 			 byte_index;
   

   // ------------------------------------------------------------------------
   // Output Signals
   // ------------------------------------------------------------------------
   assign s_axi_bresp                  = 2'd0;
   assign s_axi_rresp                  = 2'd0;

   assign soft_reset                   = srr == 32'h0000000A ? 1'b1 : 1'b0;

   assign loop                         = spicr[BF_LOOP_ROFFSET];
   assign spe                          = spicr[BF_SPE_ROFFSET];
   assign master                       = spicr[BF_MASTER_ROFFSET];
   assign tx_fifo_reset                = spicr[BF_TX_FIFO_RESET_ROFFSET];
   assign rx_fifo_reset                = spicr[BF_RX_FIFO_RESET_ROFFSET];
   assign man_ss_en                    = spicr[BF_MAN_SS_EN_ROFFSET];
   assign mstr_inhibit                 = spicr[BF_MSTR_INHIBIT_ROFFSET];

   assign rx_data_rd                   = (s_axi_rvalid && s_axi_rready && rd_addr == RG_SPIDRR_ADDR[AW+2:2]) ? 1'b1 : 1'b0;
   assign tx_data_wr                   = (s_axi_wvalid && s_axi_wready && wr_addr == RG_SPIDTR_ADDR[AW+2:2]) ? 1'b1 : 1'b0;
   assign tx_data                      = spidtr[BF_TX_DATA_RMSB:BF_TX_DATA_ROFFSET];

   assign slave_select_o               = spissr[NUM_SLAVES-1:0];


   // ------------------------------------------------------------------------
   // Internal Signals
   // ------------------------------------------------------------------------
   assign gie                          = dgier[BF_GIE_ROFFSET];
   
   assign modf_ien                     = ipier[BF_MODF_IEN_ROFFSET];
   assign dtr_empty_ien                = ipier[BF_DTR_EMPTY_IEN_ROFFSET];
   assign drr_full_ien                 = ipier[BF_DRR_FULL_IEN_ROFFSET];
   assign drr_overrun_ien              = ipier[BF_DRR_OVERRUN_IEN_ROFFSET];
   assign tx_fifo_half_empty_ien       = ipier[BF_TX_FIFO_HALF_EMPTY_IEN_ROFFSET];

   assign modf_itog                    = ipisr_wr[BF_MODF_ROFFSET];
   assign dtr_empty_itog               = ipisr_wr[BF_DTR_EMPTY_ROFFSET];
   assign drr_full_itog                = ipisr_wr[BF_DRR_FULL_ROFFSET];
   assign drr_overrun_itog             = ipisr_wr[BF_DRR_OVERRUN_ROFFSET];
   assign tx_fifo_half_empty_itog      = ipisr_wr[BF_TX_FIFO_HALF_EMPTY_ROFFSET];

   generate for ( i=0; i<32; i=i+1 )
     begin
	assign adv_feat_clock_div[i]        = adv_feat_config_ss_reg[i][BF_ADV_FEAT_CLOCK_DIV_RMSB:BF_ADV_FEAT_CLOCK_DIV_ROFFSET];
	assign adv_feat_3wire_tri_point[i]  = adv_feat_config_ss_reg[i][BF_ADV_FEAT_3WIRE_TRI_POINT_RMSB:BF_ADV_FEAT_3WIRE_TRI_POINT_ROFFSET];
	assign adv_feat_miso_slip[i]        = adv_feat_config_ss_reg[i][BF_ADV_FEAT_MISO_SAMPLE_SLIP_ROFFSET];
	assign adv_feat_four_wire[i]        = adv_feat_config_ss_reg[i][BF_ADV_FEAT_FOUR_WIRE_ROFFSET];
	assign adv_feat_lsb_first[i]        = adv_feat_config_ss_reg[i][BF_ADV_FEAT_LSB_FIRST_ROFFSET];
	assign adv_feat_cpha[i]             = adv_feat_config_ss_reg[i][BF_ADV_FEAT_CPHA_ROFFSET];
	assign adv_feat_cpol[i]             = adv_feat_config_ss_reg[i][BF_ADV_FEAT_CPOL_ROFFSET];
	assign adv_feat_enable[i]           = adv_feat_config_ss_reg[i][BF_ADV_FEAT_ENABLE_ROFFSET];
     end
   endgenerate

   // ------------------------------------------------------------------------
   // Internal Read Only Registers
   // ------------------------------------------------------------------------
   always @(*)
     begin
	spisr[BF_MODF_FLAG_ROFFSET]                = modf;
	spisr[BF_TX_FULL_ROFFSET]                  = tx_full;
	spisr[BF_TX_EMPTY_ROFFSET]                 = tx_empty;
	spisr[BF_RX_FULL_ROFFSET]                  = rx_full;
	spisr[BF_RX_EMPTY_ROFFSET]                 = rx_empty;

	spidrr[BF_RX_DATA_RMSB:BF_RX_DATA_ROFFSET] = rx_data;
	
	tx_fifo_ocy[BF_TX_FIFO_OCCUPANCY_RMSB:BF_TX_FIFO_OCCUPANCY_ROFFSET] = tx_fifo_occupancy;
	rx_fifo_ocy[BF_RX_FIFO_OCCUPANCY_RMSB:BF_RX_FIFO_OCCUPANCY_ROFFSET] = rx_fifo_occupancy;

	
     end



   // ------------------------------------------------------------------------
   // SPI Configuration Per Advanced Settings
   // ------------------------------------------------------------------------
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       begin
	  cpol          <= 1'b0;
	  cpha          <= 1'b0;
	  lsb_first     <= 1'b0;
	  four_wire     <= 1'b1;
	  miso_slip     <= 1'b0;
	  tri_point     <= 8'hF;
	  clock_div     <= 16'h3;
       end
     else
       begin
	  if ( spissr[0] == 1'b0 )
	    begin
	       if ( adv_feat_enable[0] )
		 begin
		    cpol      <= adv_feat_cpol[0];
		    cpha      <= adv_feat_cpha[0];
		    lsb_first <= adv_feat_lsb_first[0];
		    miso_slip <= adv_feat_miso_slip[0];
		    four_wire <= adv_feat_four_wire[0];
		    tri_point <= adv_feat_3wire_tri_point[0];
		    clock_div <= adv_feat_clock_div[0];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 1 && spissr[1] == 1'b0 )
	    begin
	       if ( adv_feat_enable[1] )
		 begin
		    cpol      <= adv_feat_cpol[1];
		    cpha      <= adv_feat_cpha[1];
		    lsb_first <= adv_feat_lsb_first[1];
		    miso_slip <= adv_feat_miso_slip[1];
		    four_wire <= adv_feat_four_wire[1];
		    tri_point <= adv_feat_3wire_tri_point[1];
		    clock_div <= adv_feat_clock_div[1];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 2 && spissr[2] == 1'b0 )
	    begin
	       if ( adv_feat_enable[2] )
		 begin
		    cpol      <= adv_feat_cpol[2];
		    cpha      <= adv_feat_cpha[2];
		    lsb_first <= adv_feat_lsb_first[2];
		    miso_slip <= adv_feat_miso_slip[2];
		    four_wire <= adv_feat_four_wire[2];
		    tri_point <= adv_feat_3wire_tri_point[2];
		    clock_div <= adv_feat_clock_div[2];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 3 && spissr[3] == 1'b0 )
	    begin
	       if ( adv_feat_enable[3] )
		 begin
		    cpol      <= adv_feat_cpol[3];
		    cpha      <= adv_feat_cpha[3];
		    lsb_first <= adv_feat_lsb_first[3];
		    miso_slip <= adv_feat_miso_slip[3];
		    four_wire <= adv_feat_four_wire[3];
		    tri_point <= adv_feat_3wire_tri_point[3];
		    clock_div <= adv_feat_clock_div[3];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 4 && spissr[4] == 1'b0 )
	    begin
	       if ( adv_feat_enable[4] )
		 begin
		    cpol      <= adv_feat_cpol[4];
		    cpha      <= adv_feat_cpha[4];
		    lsb_first <= adv_feat_lsb_first[4];
		    miso_slip <= adv_feat_miso_slip[4];
		    four_wire <= adv_feat_four_wire[4];
		    tri_point <= adv_feat_3wire_tri_point[4];
		    clock_div <= adv_feat_clock_div[4];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 5 && spissr[5] == 1'b0 )
	    begin
	       if ( adv_feat_enable[5] )
		 begin
		    cpol      <= adv_feat_cpol[5];
		    cpha      <= adv_feat_cpha[5];
		    lsb_first <= adv_feat_lsb_first[5];
		    miso_slip <= adv_feat_miso_slip[5];
		    four_wire <= adv_feat_four_wire[5];
		    tri_point <= adv_feat_3wire_tri_point[5];
		    clock_div <= adv_feat_clock_div[5];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 6 && spissr[6] == 1'b0 )
	    begin
	       if ( adv_feat_enable[6] )
		 begin
		    cpol      <= adv_feat_cpol[6];
		    cpha      <= adv_feat_cpha[6];
		    lsb_first <= adv_feat_lsb_first[6];
		    miso_slip <= adv_feat_miso_slip[6];
		    four_wire <= adv_feat_four_wire[6];
		    tri_point <= adv_feat_3wire_tri_point[6];
		    clock_div <= adv_feat_clock_div[6];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 7 && spissr[7] == 1'b0 )
	    begin
	       if ( adv_feat_enable[7] )
		 begin
		    cpol      <= adv_feat_cpol[7];
		    cpha      <= adv_feat_cpha[7];
		    lsb_first <= adv_feat_lsb_first[7];
		    miso_slip <= adv_feat_miso_slip[7];
		    four_wire <= adv_feat_four_wire[7];
		    tri_point <= adv_feat_3wire_tri_point[7];
		    clock_div <= adv_feat_clock_div[7];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 8 && spissr[8] == 1'b0 )
	    begin
	       if ( adv_feat_enable[8] )
		 begin
		    cpol      <= adv_feat_cpol[8];
		    cpha      <= adv_feat_cpha[8];
		    lsb_first <= adv_feat_lsb_first[8];
		    miso_slip <= adv_feat_miso_slip[8];
		    four_wire <= adv_feat_four_wire[8];
		    tri_point <= adv_feat_3wire_tri_point[8];
		    clock_div <= adv_feat_clock_div[8];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 9 && spissr[9] == 1'b0 )
	    begin
	       if ( adv_feat_enable[9] )
		 begin
		    cpol      <= adv_feat_cpol[9];
		    cpha      <= adv_feat_cpha[9];
		    lsb_first <= adv_feat_lsb_first[9];
		    miso_slip <= adv_feat_miso_slip[9];
		    four_wire <= adv_feat_four_wire[9];
		    tri_point <= adv_feat_3wire_tri_point[9];
		    clock_div <= adv_feat_clock_div[9];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 10 && spissr[10] == 1'b0 )
	    begin
	       if ( adv_feat_enable[10] )
		 begin
		    cpol      <= adv_feat_cpol[10];
		    cpha      <= adv_feat_cpha[10];
		    lsb_first <= adv_feat_lsb_first[10];
		    miso_slip <= adv_feat_miso_slip[10];
		    four_wire <= adv_feat_four_wire[10];
		    tri_point <= adv_feat_3wire_tri_point[10];
		    clock_div <= adv_feat_clock_div[10];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 11 && spissr[11] == 1'b0 )
	    begin
	       if ( adv_feat_enable[11] )
		 begin
		    cpol      <= adv_feat_cpol[11];
		    cpha      <= adv_feat_cpha[11];
		    lsb_first <= adv_feat_lsb_first[11];
		    miso_slip <= adv_feat_miso_slip[11];
		    four_wire <= adv_feat_four_wire[11];
		    tri_point <= adv_feat_3wire_tri_point[11];
		    clock_div <= adv_feat_clock_div[11];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 12 && spissr[12] == 1'b0 )
	    begin
	       if ( adv_feat_enable[12] )
		 begin
		    cpol      <= adv_feat_cpol[12];
		    cpha      <= adv_feat_cpha[12];
		    lsb_first <= adv_feat_lsb_first[12];
		    miso_slip <= adv_feat_miso_slip[12];
		    four_wire <= adv_feat_four_wire[12];
		    tri_point <= adv_feat_3wire_tri_point[12];
		    clock_div <= adv_feat_clock_div[12];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 13 && spissr[13] == 1'b0 )
	    begin
	       if ( adv_feat_enable[13] )
		 begin
		    cpol      <= adv_feat_cpol[13];
		    cpha      <= adv_feat_cpha[13];
		    lsb_first <= adv_feat_lsb_first[13];
		    miso_slip <= adv_feat_miso_slip[13];
		    four_wire <= adv_feat_four_wire[13];
		    tri_point <= adv_feat_3wire_tri_point[13];
		    clock_div <= adv_feat_clock_div[13];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 14 && spissr[14] == 1'b0 )
	    begin
	       if ( adv_feat_enable[14] )
		 begin
		    cpol      <= adv_feat_cpol[14];
		    cpha      <= adv_feat_cpha[14];
		    lsb_first <= adv_feat_lsb_first[14];
		    miso_slip <= adv_feat_miso_slip[14];
		    four_wire <= adv_feat_four_wire[14];
		    tri_point <= adv_feat_3wire_tri_point[14];
		    clock_div <= adv_feat_clock_div[14];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 15 && spissr[15] == 1'b0 )
	    begin
	       if ( adv_feat_enable[15] )
		 begin
		    cpol      <= adv_feat_cpol[15];
		    cpha      <= adv_feat_cpha[15];
		    lsb_first <= adv_feat_lsb_first[15];
		    miso_slip <= adv_feat_miso_slip[15];
		    four_wire <= adv_feat_four_wire[15];
		    tri_point <= adv_feat_3wire_tri_point[15];
		    clock_div <= adv_feat_clock_div[15];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 16 && spissr[16] == 1'b0 )
	    begin
	       if ( adv_feat_enable[16] )
		 begin
		    cpol      <= adv_feat_cpol[16];
		    cpha      <= adv_feat_cpha[16];
		    lsb_first <= adv_feat_lsb_first[16];
		    miso_slip <= adv_feat_miso_slip[16];
		    four_wire <= adv_feat_four_wire[16];
		    tri_point <= adv_feat_3wire_tri_point[16];
		    clock_div <= adv_feat_clock_div[16];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 17 && spissr[17] == 1'b0 )
	    begin
	       if ( adv_feat_enable[17] )
		 begin
		    cpol      <= adv_feat_cpol[17];
		    cpha      <= adv_feat_cpha[17];
		    lsb_first <= adv_feat_lsb_first[17];
		    miso_slip <= adv_feat_miso_slip[17];
		    four_wire <= adv_feat_four_wire[17];
		    tri_point <= adv_feat_3wire_tri_point[17];
		    clock_div <= adv_feat_clock_div[17];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 18 && spissr[18] == 1'b0 )
	    begin
	       if ( adv_feat_enable[18] )
		 begin
		    cpol      <= adv_feat_cpol[18];
		    cpha      <= adv_feat_cpha[18];
		    lsb_first <= adv_feat_lsb_first[18];
		    miso_slip <= adv_feat_miso_slip[18];
		    four_wire <= adv_feat_four_wire[18];
		    tri_point <= adv_feat_3wire_tri_point[18];
		    clock_div <= adv_feat_clock_div[18];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 19 && spissr[19] == 1'b0 )
	    begin
	       if ( adv_feat_enable[19] )
		 begin
		    cpol      <= adv_feat_cpol[19];
		    cpha      <= adv_feat_cpha[19];
		    lsb_first <= adv_feat_lsb_first[19];
		    miso_slip <= adv_feat_miso_slip[19];
		    four_wire <= adv_feat_four_wire[19];
		    tri_point <= adv_feat_3wire_tri_point[19];
		    clock_div <= adv_feat_clock_div[19];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 20 && spissr[20] == 1'b0 )
	    begin
	       if ( adv_feat_enable[20] )
		 begin
		    cpol      <= adv_feat_cpol[20];
		    cpha      <= adv_feat_cpha[20];
		    lsb_first <= adv_feat_lsb_first[20];
		    miso_slip <= adv_feat_miso_slip[20];
		    four_wire <= adv_feat_four_wire[20];
		    tri_point <= adv_feat_3wire_tri_point[20];
		    clock_div <= adv_feat_clock_div[20];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 21 && spissr[21] == 1'b0 )
	    begin
	       if ( adv_feat_enable[21] )
		 begin
		    cpol      <= adv_feat_cpol[21];
		    cpha      <= adv_feat_cpha[21];
		    lsb_first <= adv_feat_lsb_first[21];
		    miso_slip <= adv_feat_miso_slip[21];
		    four_wire <= adv_feat_four_wire[21];
		    tri_point <= adv_feat_3wire_tri_point[21];
		    clock_div <= adv_feat_clock_div[21];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 22 && spissr[22] == 1'b0 )
	    begin
	       if ( adv_feat_enable[22] )
		 begin
		    cpol      <= adv_feat_cpol[22];
		    cpha      <= adv_feat_cpha[22];
		    lsb_first <= adv_feat_lsb_first[22];
		    miso_slip <= adv_feat_miso_slip[22];
		    four_wire <= adv_feat_four_wire[22];
		    tri_point <= adv_feat_3wire_tri_point[22];
		    clock_div <= adv_feat_clock_div[22];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 23 && spissr[23] == 1'b0 )
	    begin
	       if ( adv_feat_enable[23] )
		 begin
		    cpol      <= adv_feat_cpol[23];
		    cpha      <= adv_feat_cpha[23];
		    lsb_first <= adv_feat_lsb_first[23];
		    miso_slip <= adv_feat_miso_slip[23];
		    four_wire <= adv_feat_four_wire[23];
		    tri_point <= adv_feat_3wire_tri_point[23];
		    clock_div <= adv_feat_clock_div[23];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 24 && spissr[24] == 1'b0 )
	    begin
	       if ( adv_feat_enable[24] )
		 begin
		    cpol      <= adv_feat_cpol[24];
		    cpha      <= adv_feat_cpha[24];
		    lsb_first <= adv_feat_lsb_first[24];
		    miso_slip <= adv_feat_miso_slip[24];
		    four_wire <= adv_feat_four_wire[24];
		    tri_point <= adv_feat_3wire_tri_point[24];
		    clock_div <= adv_feat_clock_div[24];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 25 && spissr[25] == 1'b0 )
	    begin
	       if ( adv_feat_enable[25] )
		 begin
		    cpol      <= adv_feat_cpol[25];
		    cpha      <= adv_feat_cpha[25];
		    lsb_first <= adv_feat_lsb_first[25];
		    miso_slip <= adv_feat_miso_slip[25];
		    four_wire <= adv_feat_four_wire[25];
		    tri_point <= adv_feat_3wire_tri_point[25];
		    clock_div <= adv_feat_clock_div[25];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 26 && spissr[26] == 1'b0 )
	    begin
	       if ( adv_feat_enable[26] )
		 begin
		    cpol      <= adv_feat_cpol[26];
		    cpha      <= adv_feat_cpha[26];
		    lsb_first <= adv_feat_lsb_first[26];
		    miso_slip <= adv_feat_miso_slip[26];
		    four_wire <= adv_feat_four_wire[26];
		    tri_point <= adv_feat_3wire_tri_point[26];
		    clock_div <= adv_feat_clock_div[26];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 27 && spissr[27] == 1'b0 )
	    begin
	       if ( adv_feat_enable[27] )
		 begin
		    cpol      <= adv_feat_cpol[27];
		    cpha      <= adv_feat_cpha[27];
		    lsb_first <= adv_feat_lsb_first[27];
		    miso_slip <= adv_feat_miso_slip[27];
		    four_wire <= adv_feat_four_wire[27];
		    tri_point <= adv_feat_3wire_tri_point[27];
		    clock_div <= adv_feat_clock_div[27];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 28 && spissr[28] == 1'b0 )
	    begin
	       if ( adv_feat_enable[28] )
		 begin
		    cpol      <= adv_feat_cpol[28];
		    cpha      <= adv_feat_cpha[28];
		    lsb_first <= adv_feat_lsb_first[28];
		    miso_slip <= adv_feat_miso_slip[28];
		    four_wire <= adv_feat_four_wire[28];
		    tri_point <= adv_feat_3wire_tri_point[28];
		    clock_div <= adv_feat_clock_div[28];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 29 && spissr[29] == 1'b0 )
	    begin
	       if ( adv_feat_enable[29] )
		 begin
		    cpol      <= adv_feat_cpol[29];
		    cpha      <= adv_feat_cpha[29];
		    lsb_first <= adv_feat_lsb_first[29];
		    miso_slip <= adv_feat_miso_slip[29];
		    four_wire <= adv_feat_four_wire[29];
		    tri_point <= adv_feat_3wire_tri_point[29];
		    clock_div <= adv_feat_clock_div[29];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 30 && spissr[30] == 1'b0 )
	    begin
	       if ( adv_feat_enable[30] )
		 begin
		    cpol      <= adv_feat_cpol[30];
		    cpha      <= adv_feat_cpha[30];
		    lsb_first <= adv_feat_lsb_first[30];
		    miso_slip <= adv_feat_miso_slip[30];
		    four_wire <= adv_feat_four_wire[30];
		    tri_point <= adv_feat_3wire_tri_point[30];
		    clock_div <= adv_feat_clock_div[30];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
	  else if ( NUM_SLAVES > 31 && spissr[31] == 1'b0 )
	    begin
	       if ( adv_feat_enable[31] )
		 begin
		    cpol      <= adv_feat_cpol[31];
		    cpha      <= adv_feat_cpha[31];
		    lsb_first <= adv_feat_lsb_first[31];
		    miso_slip <= adv_feat_miso_slip[31];
		    four_wire <= adv_feat_four_wire[31];
		    tri_point <= adv_feat_3wire_tri_point[31];
		    clock_div <= adv_feat_clock_div[31];
		 end
	       else
		 begin
		    cpol      <= spicr[BF_CPOL_ROFFSET];
		    cpha      <= spicr[BF_CPHA_ROFFSET];
		    lsb_first <= spicr[BF_LSB_FIRST_ROFFSET];
		    miso_slip <= 1'b0;
		    four_wire <= 1'b1;
		    tri_point <= DEFAULT_3WIRE_TRI_POINT;
		    clock_div <= DEFAULT_CLOCK_DIV;
		 end
	    end
       	  else
	    begin
	       cpol           <= spicr[BF_CPOL_ROFFSET];
	       cpha           <= spicr[BF_CPHA_ROFFSET];
	       lsb_first      <= spicr[BF_LSB_FIRST_ROFFSET];
	       miso_slip      <= 1'b0;
	       four_wire      <= 1'b1;
	       tri_point      <= DEFAULT_3WIRE_TRI_POINT;
	       clock_div      <= DEFAULT_CLOCK_DIV;
	    end
       end



   

   // ------------------------------------------------------------------------
   // AXI Bus Logic
   // ------------------------------------------------------------------------


   // Write address handshake
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       s_axi_awready <= 1'b0;
     else if ( !s_axi_awready && s_axi_awvalid )
       s_axi_awready <= 1'b1;
     else 
       s_axi_awready <= 1'b0;

   
   // latch write address
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       wr_addr       <= {ADDRESS_WIDTH{1'b0}};
     else if ( !s_axi_awready && s_axi_awvalid )
       wr_addr       <= s_axi_awaddr[AW+2:2];
       
   // latch write address valid
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       write_address_valid <= 1'b0;
     else if ( s_axi_awready && s_axi_awvalid )
       write_address_valid <= 1'b1;
     else if ( write_address_valid && write_valid )
       write_address_valid <= 1'b0;

   // latch write valid
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       write_valid <= 1'b0;
     else if ( s_axi_wready && s_axi_wvalid )
       write_valid <= 1'b1;
     else if ( write_address_valid && write_valid )
       write_valid <= 1'b0;


   // write registers
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       begin
	  dgier                     <= RG_DGIER_RESET;
	  ipier                     <= RG_IPIER_RESET;
	  ipisr_wr                  <= RG_IPISR_RESET;
	  srr                       <= RG_SRR_RESET;
	  spicr                     <= RG_SPICR_RESET;
	  spidtr                    <= RG_SPIDTR_RESET;
	  spissr                    <= RG_SPISSR_RESET;

	  s_axi_wready              <= 1'b0;
       end
     else 
       begin
	  if ( write_address_valid && s_axi_wvalid && !s_axi_wready )
	    begin
	       s_axi_wready         <= 1'b1;
	       
	       case ( wr_addr )
		 RG_DGIER_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  dgier[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_IPISR_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  ipisr_wr[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_IPIER_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  ipier[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_SRR_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  srr[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_SPICR_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  spicr[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_SPIDTR_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  spidtr[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end
		 
		 RG_SPISSR_ADDR[AW+2:2]:
	           for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
	             if ( s_axi_wstrb[byte_index] == 1 ) 
		       begin
			  spissr[(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
	               end

		 default:            ;
	       endcase
	    end
	  else
	    begin
	       s_axi_wready <= 1'b0;
	       spicr[BF_TX_FIFO_RESET_ROFFSET] <= 1'b0;        
	       spicr[BF_RX_FIFO_RESET_ROFFSET] <= 1'b0;        
	       ipisr_wr     <= RG_IPISR_RESET;
	       srr          <= RG_SRR_RESET;
	    end
       end
   
     // write registers
     generate for (i=0; i<32; i=i+1 )
       always @( posedge s_axi_aclk or negedge s_axi_aresetn )
	 if ( !s_axi_aresetn )
	   begin
    	      adv_feat_config_ss_reg[i] <= RG_ADV_FEAT_CONFIG_SS_N_RESET;
	   end
	 else 
	   begin
	      if ( write_address_valid && s_axi_wvalid && !s_axi_wready )
		begin
		   case ( wr_addr )
		     RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+i:
	               for ( byte_index = 0; byte_index <= 3; byte_index = byte_index+1 )
			 if ( s_axi_wstrb[byte_index] == 1 ) 
			   begin
			      adv_feat_config_ss_reg[i][(byte_index*8) +: 8] <= s_axi_wdata[(byte_index*8) +: 8];
			   end
		     
		     default:            ;
		   endcase
		end
	   end
     endgenerate
     
   // write access response
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       s_axi_bvalid <= 1'b0;
     else if ( write_address_valid && write_valid )
       s_axi_bvalid <= 1'b1;
     else if ( s_axi_bready )
       s_axi_bvalid <= 1'b0;


   // read handshake
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       s_axi_arready <= 1'b0;
     else if ( !s_axi_arready && s_axi_arvalid )
       s_axi_arready <= 1'b1;
     else
       s_axi_arready <= 1'b0;


   // latch read address
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       rd_addr            <= {ADDRESS_WIDTH{1'b0}};
     else if ( !s_axi_arready && s_axi_arvalid )
       rd_addr            <= s_axi_araddr[AW+2:2];
       

   // latch read address valid
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       read_address_valid <= 1'b0;
     else if ( !s_axi_arready && s_axi_arvalid )
       read_address_valid <= 1'b1;
     else if ( s_axi_rvalid )
       read_address_valid <= 1'b0;
       

     
   // read registers
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       begin
	  s_axi_rdata <= 32'b0;
       end
     else if ( read_address_valid )
       begin
	  case ( rd_addr )
	    RG_VERSION_ADDR[AW+2:2]                 : s_axi_rdata <= RG_VERSION_RESET;
	    RG_DGIER_ADDR[AW+2:2]                   : s_axi_rdata <= dgier;
	    RG_IPISR_ADDR[AW+2:2]                   : s_axi_rdata <= ipisr_rd;
	    RG_IPIER_ADDR[AW+2:2]                   : s_axi_rdata <= ipier;
	    RG_SPICR_ADDR[AW+2:2]                   : s_axi_rdata <= spicr;
	    RG_SPISR_ADDR[AW+2:2]                   : s_axi_rdata <= spisr;
	    RG_SPIDRR_ADDR[AW+2:2]                  : s_axi_rdata <= spidrr;
	    RG_SPISSR_ADDR[AW+2:2]                  : s_axi_rdata <= spissr;
	    RG_TX_FIFO_OCY_ADDR[AW+2:2]             : s_axi_rdata <= tx_fifo_ocy;
	    RG_RX_FIFO_OCY_ADDR[AW+2:2]             : s_axi_rdata <= rx_fifo_ocy;
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+00 : s_axi_rdata <= adv_feat_config_ss_reg[00];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+01 : s_axi_rdata <= adv_feat_config_ss_reg[01];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+02 : s_axi_rdata <= adv_feat_config_ss_reg[02];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+03 : s_axi_rdata <= adv_feat_config_ss_reg[03];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+04 : s_axi_rdata <= adv_feat_config_ss_reg[04];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+05 : s_axi_rdata <= adv_feat_config_ss_reg[05];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+06 : s_axi_rdata <= adv_feat_config_ss_reg[06];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+07 : s_axi_rdata <= adv_feat_config_ss_reg[07];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+08 : s_axi_rdata <= adv_feat_config_ss_reg[08];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+09 : s_axi_rdata <= adv_feat_config_ss_reg[09];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+10 : s_axi_rdata <= adv_feat_config_ss_reg[10];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+11 : s_axi_rdata <= adv_feat_config_ss_reg[11];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+12 : s_axi_rdata <= adv_feat_config_ss_reg[12];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+13 : s_axi_rdata <= adv_feat_config_ss_reg[13];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+14 : s_axi_rdata <= adv_feat_config_ss_reg[14];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+15 : s_axi_rdata <= adv_feat_config_ss_reg[15];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+16 : s_axi_rdata <= adv_feat_config_ss_reg[16];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+17 : s_axi_rdata <= adv_feat_config_ss_reg[17];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+18 : s_axi_rdata <= adv_feat_config_ss_reg[18];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+19 : s_axi_rdata <= adv_feat_config_ss_reg[19];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+20 : s_axi_rdata <= adv_feat_config_ss_reg[20];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+21 : s_axi_rdata <= adv_feat_config_ss_reg[21];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+22 : s_axi_rdata <= adv_feat_config_ss_reg[22];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+23 : s_axi_rdata <= adv_feat_config_ss_reg[23];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+24 : s_axi_rdata <= adv_feat_config_ss_reg[24];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+25 : s_axi_rdata <= adv_feat_config_ss_reg[25];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+26 : s_axi_rdata <= adv_feat_config_ss_reg[26];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+27 : s_axi_rdata <= adv_feat_config_ss_reg[27];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+28 : s_axi_rdata <= adv_feat_config_ss_reg[28];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+29 : s_axi_rdata <= adv_feat_config_ss_reg[29];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+30 : s_axi_rdata <= adv_feat_config_ss_reg[30];
            RG_ADV_FEAT_CONFIG_SS_N_ADDR[AW+2:2]+31 : s_axi_rdata <= adv_feat_config_ss_reg[31];
	    default:                                  s_axi_rdata <= 32'b0;
	  endcase
       end



   // read valid handshake
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       s_axi_rvalid <= 1'b0;
     else if ( read_address_valid && !s_axi_rvalid )
       s_axi_rvalid <= 1'b1;
     else if ( s_axi_rready )
       s_axi_rvalid <= 1'b0;




   // ------------------------------------------------------------------------
   // Interrupt Registers
   // ------------------------------------------------------------------------

   // global interrupt
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       interrupt <= 1'b0;
     else if ( |ipisr_wr )
       interrupt <= 1'b0;
     else if ( gie )
       interrupt <= |ipisr_rd;

   
   // interrupt status
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       begin
	  ipisr_rd <= RG_IPISR_RESET;
       end
     else
       begin
	  if ( modf_itog )
	    ipisr_rd[BF_MODF_ROFFSET]                  <= ~ipisr_rd[BF_MODF_ROFFSET];
	  else if ( modf_ien )
   	    ipisr_rd[BF_MODF_ROFFSET]                  <= modf;
	  
	  if ( dtr_empty_itog )
	    ipisr_rd[BF_DTR_EMPTY_ROFFSET]             <= ~ipisr_rd[BF_DTR_EMPTY_ROFFSET];
	  else if ( dtr_empty_ien )
	    ipisr_rd[BF_DTR_EMPTY_ROFFSET]             <= dtr_empty;
	  
	  if ( drr_full_itog )
	    ipisr_rd[BF_DRR_FULL_ROFFSET]              <= ~ipisr_rd[BF_DRR_FULL_ROFFSET];
	  else if ( drr_full_ien )
	    ipisr_rd[BF_DRR_FULL_ROFFSET]              <= drr_full;
	  
	  if ( drr_overrun_itog )
	    ipisr_rd[BF_DRR_OVERRUN_ROFFSET]           <= ~ipisr_rd[BF_DRR_OVERRUN_ROFFSET];
	  else if (  drr_overrun_ien)
	    ipisr_rd[BF_DRR_OVERRUN_ROFFSET]           <= drr_overrun;
	  
	  if ( tx_fifo_half_empty_itog )
	    ipisr_rd[BF_TX_FIFO_HALF_EMPTY_ROFFSET]    <= ~ipisr_rd[BF_TX_FIFO_HALF_EMPTY_ROFFSET];
	  else if ( tx_fifo_half_empty_ien )
	    ipisr_rd[BF_TX_FIFO_HALF_EMPTY_ROFFSET]    <= tx_fifo_half_empty;
       end
 

   // interrupt sources
   always @( posedge s_axi_aclk or negedge s_axi_aresetn )
     if ( !s_axi_aresetn )
       begin
	  modf                 <= 1'b0;
	  dtr_empty            <= 1'b0;
	  drr_full             <= 1'b0;
	  drr_overrun          <= 1'b0;
	  tx_fifo_half_empty   <= 1'b0;

	  tx_empty_d           <= 1'b1;
	  rx_full_d            <= 1'b0;
	  tx_fifo_ocy_d        <= 9'b0;
       end
     else
       begin
	  tx_empty_d           <= tx_empty;
	  rx_full_d            <= rx_full;
	  tx_fifo_ocy_d        <= tx_fifo_occupancy;

	  // Mode Fault
	  if ( modf_itog )
	    modf               <= 1'b0;
	  else if ( ~&slave_select_i && !spe )
	    modf               <= 1'b1;

	  // Data Transmit FIFO Empty
	  if ( dtr_empty_itog )
	    dtr_empty          <= 1'b0;
	  else if ( tx_empty && !tx_empty_d )
	    dtr_empty          <= 1'b1;

	  // Data Receive FIFO Full
	  if ( drr_full_itog )
	    drr_full           <= 1'b0;
	  else if ( rx_full && !rx_full_d )
	    drr_full           <= 1'b1;

	  // Data Receive FIFO Overrun
	  if ( drr_overrun_itog )
	    drr_overrun        <= 1'b0;
	  else if ( rx_full && rx_data_wr )
	    drr_overrun        <= 1'b1;

	  // Transmit FIFO Half Full
	  if ( tx_fifo_half_empty_itog )
	    tx_fifo_half_empty <= 1'b0;
	  else if ( tx_fifo_ocy_d == 9'h100 && tx_fifo_occupancy == 'h0FF )
	    tx_fifo_half_empty <= 1'b1;
       end

   
   
endmodule

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
