`ifndef _DEFINE_AXI_MSPI
`define _DEFINE_AXI_MSPI

//
// ---- Constant Definitions ----
//
//    Register Constants
//        RG_XXXX_ADDR        Address of the register
//        RG_XXXX_RESET       Reset value for the register
//
//    BitField defines
//        BF_XXXX_RESET       Reset value for the bitfield
//        BF_XXXX_WIDTH       Width of the bitfield
//
//    BitField register reference defines
//        BF_XXXX_LSB         LSB of the bitfield slice
//        BF_XXXX_MSB         MSB of the bitfield slice
//        BF_XXXX_ROFFSET     Offset of the slice in the register
//        BF_XXXX_RMSB        MSB of the slice in the register
//        BF_XXXX_RMASK       Mask of the slice in the register
//        BF_XXXX_RWIDTH      Width of the slice
//        BF_XXXX_RESET       Reset value of the slice
//

package axi_mspi_pkg;
  
  // ==========  Register constants  ==========
  parameter RG_VERSION_ADDR                      = 32'h00000000;            //  Module Version Number
  parameter RG_VERSION_RESET                     = 32'h00000000;
  parameter RG_DGIER_ADDR                        = 32'h0000001C;            //  Device Global Interrupt Enable Register
  parameter RG_DGIER_RESET                       = 32'h00000000;
  parameter RG_IPISR_ADDR                        = 32'h00000020;            //  IP Interrupt Status Register
  parameter RG_IPISR_RESET                       = 32'h00000000;
  parameter RG_IPIER_ADDR                        = 32'h00000028;            //  IP Interrupt Enable Register
  parameter RG_IPIER_RESET                       = 32'h00000000;
  parameter RG_SRR_ADDR                          = 32'h00000040;            //  Software Reset Register
  parameter RG_SRR_RESET                         = 32'h00000000;
  parameter RG_SPICR_ADDR                        = 32'h00000060;            //  SPI Control Register
  parameter RG_SPICR_RESET                       = 32'h00000184;
  parameter RG_SPISR_ADDR                        = 32'h00000064;            //  SPI Status Register
  parameter RG_SPISR_RESET                       = 32'h00000000;
  parameter RG_SPIDTR_ADDR                       = 32'h00000068;            //  SPI Transmit Data Register
  parameter RG_SPIDTR_RESET                      = 32'h00000000;
  parameter RG_SPIDRR_ADDR                       = 32'h0000006C;            //  SPI Receive Data Register
  parameter RG_SPIDRR_RESET                      = 32'h00000000;
  parameter RG_SPISSR_ADDR                       = 32'h00000070;            //  SPI Slave Select Register
  parameter RG_SPISSR_RESET                      = 32'hFFFFFFFF;
  parameter RG_TX_FIFO_OCY_ADDR                  = 32'h00000074;            //  Transmit FIFO Occupancy
  parameter RG_TX_FIFO_OCY_RESET                 = 32'h00000000;
  parameter RG_RX_FIFO_OCY_ADDR                  = 32'h00000078;            //  Receive FIFO Occupancy
  parameter RG_RX_FIFO_OCY_RESET                 = 32'h00000000;
  parameter RG_ADV_FEAT_CONFIG_SS_N_ADDR         = 32'h00000080;            //  Advanced Feature Configuration Register for Slave Select [n]
  parameter RG_ADV_FEAT_CONFIG_SS_N_RESET        = 32'h00031010;

  // ==========  BitFields  ==========
  
  // BitField: module_version_minor (r) 
  //        bitfield defines
  parameter BF_MODULE_VERSION_MINOR_RESET         = 16'h0;
  parameter BF_MODULE_VERSION_MINOR_WIDTH         = 32'd16;
  //        register reference defines
  parameter BF_MODULE_VERSION_MINOR_LSB           = 32'd0;
  parameter BF_MODULE_VERSION_MINOR_MSB           = 32'd15;
  parameter BF_MODULE_VERSION_MINOR_ROFFSET       = 32'd0;
  parameter BF_MODULE_VERSION_MINOR_RMSB          = 32'd15;
  parameter BF_MODULE_VERSION_MINOR_RMASK         = 16'hffff;
  parameter BF_MODULE_VERSION_MINOR_RWIDTH        = 32'd16;
  typedef logic [15:0] module_version_minor_data_t;
  //        bitfield structures
  typedef struct packed {
    module_version_minor_data_t data;
  } module_version_minor_reg_t;
  
  // BitField: module_version_major (r) 
  //        bitfield defines
  parameter BF_MODULE_VERSION_MAJOR_RESET         = 8'h0;
  parameter BF_MODULE_VERSION_MAJOR_WIDTH         = 32'd8;
  //        register reference defines
  parameter BF_MODULE_VERSION_MAJOR_LSB           = 32'd0;
  parameter BF_MODULE_VERSION_MAJOR_MSB           = 32'd7;
  parameter BF_MODULE_VERSION_MAJOR_ROFFSET       = 32'd16;
  parameter BF_MODULE_VERSION_MAJOR_RMSB          = 32'd23;
  parameter BF_MODULE_VERSION_MAJOR_RMASK         = 24'hff0000;
  parameter BF_MODULE_VERSION_MAJOR_RWIDTH        = 32'd8;
  typedef logic [7:0] module_version_major_data_t;
  //        bitfield structures
  typedef struct packed {
    module_version_major_data_t data;
  } module_version_major_reg_t;
  
  // BitField: gie (r/w) 
  //        bitfield defines
  parameter BF_GIE_RESET                          = 1'h0;
  parameter BF_GIE_WIDTH                          = 32'd1;
  //        register reference defines
  parameter BF_GIE_LSB                            = 32'd0;
  parameter BF_GIE_MSB                            = 32'd0;
  parameter BF_GIE_ROFFSET                        = 32'd31;
  parameter BF_GIE_RMSB                           = 32'd31;
  parameter BF_GIE_RMASK                          = 32'h80000000;
  parameter BF_GIE_RWIDTH                         = 32'd1;
  typedef logic  gie_data_t;
  //        bitfield structures
  typedef struct packed {
    gie_data_t data;
  } gie_reg_t;
  
  // BitField: modf (r) 
  //        bitfield defines
  parameter BF_MODF_RESET                         = 1'h0;
  parameter BF_MODF_WIDTH                         = 32'd1;
  //        register reference defines
  parameter BF_MODF_LSB                           = 32'd0;
  parameter BF_MODF_MSB                           = 32'd0;
  parameter BF_MODF_ROFFSET                       = 32'd0;
  parameter BF_MODF_RMSB                          = 32'd0;
  parameter BF_MODF_RMASK                         = 1'h1;
  parameter BF_MODF_RWIDTH                        = 32'd1;
  typedef logic  modf_data_t;
  //        bitfield structures
  typedef struct packed {
    modf_data_t data;
  } modf_reg_t;
  
  // BitField: dtr_empty (r/w) 
  //        bitfield defines
  parameter BF_DTR_EMPTY_RESET                    = 1'h0;
  parameter BF_DTR_EMPTY_WIDTH                    = 32'd1;
  //        register reference defines
  parameter BF_DTR_EMPTY_LSB                      = 32'd0;
  parameter BF_DTR_EMPTY_MSB                      = 32'd0;
  parameter BF_DTR_EMPTY_ROFFSET                  = 32'd2;
  parameter BF_DTR_EMPTY_RMSB                     = 32'd2;
  parameter BF_DTR_EMPTY_RMASK                    = 3'h4;
  parameter BF_DTR_EMPTY_RWIDTH                   = 32'd1;
  typedef logic  dtr_empty_data_t;
  //        bitfield structures
  typedef struct packed {
    dtr_empty_data_t data;
  } dtr_empty_reg_t;
  
  // BitField: drr_full (r/w) 
  //        bitfield defines
  parameter BF_DRR_FULL_RESET                     = 1'h0;
  parameter BF_DRR_FULL_WIDTH                     = 32'd1;
  //        register reference defines
  parameter BF_DRR_FULL_LSB                       = 32'd0;
  parameter BF_DRR_FULL_MSB                       = 32'd0;
  parameter BF_DRR_FULL_ROFFSET                   = 32'd4;
  parameter BF_DRR_FULL_RMSB                      = 32'd4;
  parameter BF_DRR_FULL_RMASK                     = 5'h10;
  parameter BF_DRR_FULL_RWIDTH                    = 32'd1;
  typedef logic  drr_full_data_t;
  //        bitfield structures
  typedef struct packed {
    drr_full_data_t data;
  } drr_full_reg_t;
  
  // BitField: drr_overrun (r/w) 
  //        bitfield defines
  parameter BF_DRR_OVERRUN_RESET                  = 1'h0;
  parameter BF_DRR_OVERRUN_WIDTH                  = 32'd1;
  //        register reference defines
  parameter BF_DRR_OVERRUN_LSB                    = 32'd0;
  parameter BF_DRR_OVERRUN_MSB                    = 32'd0;
  parameter BF_DRR_OVERRUN_ROFFSET                = 32'd5;
  parameter BF_DRR_OVERRUN_RMSB                   = 32'd5;
  parameter BF_DRR_OVERRUN_RMASK                  = 6'h20;
  parameter BF_DRR_OVERRUN_RWIDTH                 = 32'd1;
  typedef logic  drr_overrun_data_t;
  //        bitfield structures
  typedef struct packed {
    drr_overrun_data_t data;
  } drr_overrun_reg_t;
  
  // BitField: tx_fifo_half_empty (r/w) 
  //        bitfield defines
  parameter BF_TX_FIFO_HALF_EMPTY_RESET           = 1'h0;
  parameter BF_TX_FIFO_HALF_EMPTY_WIDTH           = 32'd1;
  //        register reference defines
  parameter BF_TX_FIFO_HALF_EMPTY_LSB             = 32'd0;
  parameter BF_TX_FIFO_HALF_EMPTY_MSB             = 32'd0;
  parameter BF_TX_FIFO_HALF_EMPTY_ROFFSET         = 32'd6;
  parameter BF_TX_FIFO_HALF_EMPTY_RMSB            = 32'd6;
  parameter BF_TX_FIFO_HALF_EMPTY_RMASK           = 7'h40;
  parameter BF_TX_FIFO_HALF_EMPTY_RWIDTH          = 32'd1;
  typedef logic  tx_fifo_half_empty_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_fifo_half_empty_data_t data;
  } tx_fifo_half_empty_reg_t;
  
  // BitField: modf_ien (r/w) 
  //        bitfield defines
  parameter BF_MODF_IEN_RESET                     = 1'h0;
  parameter BF_MODF_IEN_WIDTH                     = 32'd1;
  //        register reference defines
  parameter BF_MODF_IEN_LSB                       = 32'd0;
  parameter BF_MODF_IEN_MSB                       = 32'd0;
  parameter BF_MODF_IEN_ROFFSET                   = 32'd0;
  parameter BF_MODF_IEN_RMSB                      = 32'd0;
  parameter BF_MODF_IEN_RMASK                     = 1'h1;
  parameter BF_MODF_IEN_RWIDTH                    = 32'd1;
  typedef logic  modf_ien_data_t;
  //        bitfield structures
  typedef struct packed {
    modf_ien_data_t data;
  } modf_ien_reg_t;
  
  // BitField: dtr_empty_ien (r/w) 
  //        bitfield defines
  parameter BF_DTR_EMPTY_IEN_RESET                = 1'h0;
  parameter BF_DTR_EMPTY_IEN_WIDTH                = 32'd1;
  //        register reference defines
  parameter BF_DTR_EMPTY_IEN_LSB                  = 32'd0;
  parameter BF_DTR_EMPTY_IEN_MSB                  = 32'd0;
  parameter BF_DTR_EMPTY_IEN_ROFFSET              = 32'd2;
  parameter BF_DTR_EMPTY_IEN_RMSB                 = 32'd2;
  parameter BF_DTR_EMPTY_IEN_RMASK                = 3'h4;
  parameter BF_DTR_EMPTY_IEN_RWIDTH               = 32'd1;
  typedef logic  dtr_empty_ien_data_t;
  //        bitfield structures
  typedef struct packed {
    dtr_empty_ien_data_t data;
  } dtr_empty_ien_reg_t;
  
  // BitField: drr_full_ien (r/w) 
  //        bitfield defines
  parameter BF_DRR_FULL_IEN_RESET                 = 1'h0;
  parameter BF_DRR_FULL_IEN_WIDTH                 = 32'd1;
  //        register reference defines
  parameter BF_DRR_FULL_IEN_LSB                   = 32'd0;
  parameter BF_DRR_FULL_IEN_MSB                   = 32'd0;
  parameter BF_DRR_FULL_IEN_ROFFSET               = 32'd4;
  parameter BF_DRR_FULL_IEN_RMSB                  = 32'd4;
  parameter BF_DRR_FULL_IEN_RMASK                 = 5'h10;
  parameter BF_DRR_FULL_IEN_RWIDTH                = 32'd1;
  typedef logic  drr_full_ien_data_t;
  //        bitfield structures
  typedef struct packed {
    drr_full_ien_data_t data;
  } drr_full_ien_reg_t;
  
  // BitField: drr_overrun_ien (r/w) 
  //        bitfield defines
  parameter BF_DRR_OVERRUN_IEN_RESET              = 1'h0;
  parameter BF_DRR_OVERRUN_IEN_WIDTH              = 32'd1;
  //        register reference defines
  parameter BF_DRR_OVERRUN_IEN_LSB                = 32'd0;
  parameter BF_DRR_OVERRUN_IEN_MSB                = 32'd0;
  parameter BF_DRR_OVERRUN_IEN_ROFFSET            = 32'd5;
  parameter BF_DRR_OVERRUN_IEN_RMSB               = 32'd5;
  parameter BF_DRR_OVERRUN_IEN_RMASK              = 6'h20;
  parameter BF_DRR_OVERRUN_IEN_RWIDTH             = 32'd1;
  typedef logic  drr_overrun_ien_data_t;
  //        bitfield structures
  typedef struct packed {
    drr_overrun_ien_data_t data;
  } drr_overrun_ien_reg_t;
  
  // BitField: tx_fifo_half_empty_ien (r/w) 
  //        bitfield defines
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_RESET       = 1'h0;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_WIDTH       = 32'd1;
  //        register reference defines
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_LSB         = 32'd0;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_MSB         = 32'd0;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_ROFFSET     = 32'd6;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_RMSB        = 32'd6;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_RMASK       = 7'h40;
  parameter BF_TX_FIFO_HALF_EMPTY_IEN_RWIDTH      = 32'd1;
  typedef logic  tx_fifo_half_empty_ien_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_fifo_half_empty_ien_data_t data;
  } tx_fifo_half_empty_ien_reg_t;
  
  // BitField: reset (w) 
  //        bitfield defines
  parameter BF_RESET_RESET                        = 32'h0;
  parameter BF_RESET_WIDTH                        = 32'd32;
  //        register reference defines
  parameter BF_RESET_LSB                          = 32'd0;
  parameter BF_RESET_MSB                          = 32'd31;
  parameter BF_RESET_ROFFSET                      = 32'd0;
  parameter BF_RESET_RMSB                         = 32'd31;
  parameter BF_RESET_RMASK                        = 32'hffffffff;
  parameter BF_RESET_RWIDTH                       = 32'd32;
  typedef logic [31:0] reset_data_t;
  //        bitfield structures
  typedef struct packed {
    reset_data_t data;
  } reset_reg_t;
  
  // BitField: loop (r/w) 
  //        bitfield defines
  parameter BF_LOOP_RESET                         = 1'h0;
  parameter BF_LOOP_WIDTH                         = 32'd1;
  //        register reference defines
  parameter BF_LOOP_LSB                           = 32'd0;
  parameter BF_LOOP_MSB                           = 32'd0;
  parameter BF_LOOP_ROFFSET                       = 32'd0;
  parameter BF_LOOP_RMSB                          = 32'd0;
  parameter BF_LOOP_RMASK                         = 1'h1;
  parameter BF_LOOP_RWIDTH                        = 32'd1;
  typedef logic  loop_data_t;
  //        bitfield structures
  typedef struct packed {
    loop_data_t data;
  } loop_reg_t;
  
  // BitField: spe (r/w) 
  //        bitfield defines
  parameter BF_SPE_RESET                          = 1'h0;
  parameter BF_SPE_WIDTH                          = 32'd1;
  //        register reference defines
  parameter BF_SPE_LSB                            = 32'd0;
  parameter BF_SPE_MSB                            = 32'd0;
  parameter BF_SPE_ROFFSET                        = 32'd1;
  parameter BF_SPE_RMSB                           = 32'd1;
  parameter BF_SPE_RMASK                          = 2'h2;
  parameter BF_SPE_RWIDTH                         = 32'd1;
  typedef logic  spe_data_t;
  //        bitfield structures
  typedef struct packed {
    spe_data_t data;
  } spe_reg_t;
  
  // BitField: master (r/w) 
  //        bitfield defines
  parameter BF_MASTER_RESET                       = 1'h1;
  parameter BF_MASTER_WIDTH                       = 32'd1;
  //        register reference defines
  parameter BF_MASTER_LSB                         = 32'd0;
  parameter BF_MASTER_MSB                         = 32'd0;
  parameter BF_MASTER_ROFFSET                     = 32'd2;
  parameter BF_MASTER_RMSB                        = 32'd2;
  parameter BF_MASTER_RMASK                       = 3'h4;
  parameter BF_MASTER_RWIDTH                      = 32'd1;
  typedef logic  master_data_t;
  //        bitfield structures
  typedef struct packed {
    master_data_t data;
  } master_reg_t;
  
  // BitField: cpol (r/w) 
  //        bitfield defines
  parameter BF_CPOL_RESET                         = 1'h0;
  parameter BF_CPOL_WIDTH                         = 32'd1;
  //        register reference defines
  parameter BF_CPOL_LSB                           = 32'd0;
  parameter BF_CPOL_MSB                           = 32'd0;
  parameter BF_CPOL_ROFFSET                       = 32'd3;
  parameter BF_CPOL_RMSB                          = 32'd3;
  parameter BF_CPOL_RMASK                         = 4'h8;
  parameter BF_CPOL_RWIDTH                        = 32'd1;
  typedef logic  cpol_data_t;
  //        bitfield structures
  typedef struct packed {
    cpol_data_t data;
  } cpol_reg_t;
  
  // BitField: cpha (r/w) 
  //        bitfield defines
  parameter BF_CPHA_RESET                         = 1'h0;
  parameter BF_CPHA_WIDTH                         = 32'd1;
  //        register reference defines
  parameter BF_CPHA_LSB                           = 32'd0;
  parameter BF_CPHA_MSB                           = 32'd0;
  parameter BF_CPHA_ROFFSET                       = 32'd4;
  parameter BF_CPHA_RMSB                          = 32'd4;
  parameter BF_CPHA_RMASK                         = 5'h10;
  parameter BF_CPHA_RWIDTH                        = 32'd1;
  typedef logic  cpha_data_t;
  //        bitfield structures
  typedef struct packed {
    cpha_data_t data;
  } cpha_reg_t;
  
  // BitField: tx_fifo_reset (w) 
  //        bitfield defines
  parameter BF_TX_FIFO_RESET_RESET                = 1'h0;
  parameter BF_TX_FIFO_RESET_WIDTH                = 32'd1;
  //        register reference defines
  parameter BF_TX_FIFO_RESET_LSB                  = 32'd0;
  parameter BF_TX_FIFO_RESET_MSB                  = 32'd0;
  parameter BF_TX_FIFO_RESET_ROFFSET              = 32'd5;
  parameter BF_TX_FIFO_RESET_RMSB                 = 32'd5;
  parameter BF_TX_FIFO_RESET_RMASK                = 6'h20;
  parameter BF_TX_FIFO_RESET_RWIDTH               = 32'd1;
  typedef logic  tx_fifo_reset_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_fifo_reset_data_t data;
  } tx_fifo_reset_reg_t;
  
  // BitField: rx_fifo_reset (w) 
  //        bitfield defines
  parameter BF_RX_FIFO_RESET_RESET                = 1'h0;
  parameter BF_RX_FIFO_RESET_WIDTH                = 32'd1;
  //        register reference defines
  parameter BF_RX_FIFO_RESET_LSB                  = 32'd0;
  parameter BF_RX_FIFO_RESET_MSB                  = 32'd0;
  parameter BF_RX_FIFO_RESET_ROFFSET              = 32'd6;
  parameter BF_RX_FIFO_RESET_RMSB                 = 32'd6;
  parameter BF_RX_FIFO_RESET_RMASK                = 7'h40;
  parameter BF_RX_FIFO_RESET_RWIDTH               = 32'd1;
  typedef logic  rx_fifo_reset_data_t;
  //        bitfield structures
  typedef struct packed {
    rx_fifo_reset_data_t data;
  } rx_fifo_reset_reg_t;
  
  // BitField: man_ss_en (r/w) 
  //        bitfield defines
  parameter BF_MAN_SS_EN_RESET                    = 1'h1;
  parameter BF_MAN_SS_EN_WIDTH                    = 32'd1;
  //        register reference defines
  parameter BF_MAN_SS_EN_LSB                      = 32'd0;
  parameter BF_MAN_SS_EN_MSB                      = 32'd0;
  parameter BF_MAN_SS_EN_ROFFSET                  = 32'd7;
  parameter BF_MAN_SS_EN_RMSB                     = 32'd7;
  parameter BF_MAN_SS_EN_RMASK                    = 8'h80;
  parameter BF_MAN_SS_EN_RWIDTH                   = 32'd1;
  typedef logic  man_ss_en_data_t;
  //        bitfield structures
  typedef struct packed {
    man_ss_en_data_t data;
  } man_ss_en_reg_t;
  
  // BitField: mstr_inhibit (r/w) 
  //        bitfield defines
  parameter BF_MSTR_INHIBIT_RESET                 = 1'h1;
  parameter BF_MSTR_INHIBIT_WIDTH                 = 32'd1;
  //        register reference defines
  parameter BF_MSTR_INHIBIT_LSB                   = 32'd0;
  parameter BF_MSTR_INHIBIT_MSB                   = 32'd0;
  parameter BF_MSTR_INHIBIT_ROFFSET               = 32'd8;
  parameter BF_MSTR_INHIBIT_RMSB                  = 32'd8;
  parameter BF_MSTR_INHIBIT_RMASK                 = 9'h100;
  parameter BF_MSTR_INHIBIT_RWIDTH                = 32'd1;
  typedef logic  mstr_inhibit_data_t;
  //        bitfield structures
  typedef struct packed {
    mstr_inhibit_data_t data;
  } mstr_inhibit_reg_t;
  
  // BitField: lsb_first (r/w) 
  //        bitfield defines
  parameter BF_LSB_FIRST_RESET                    = 1'h0;
  parameter BF_LSB_FIRST_WIDTH                    = 32'd1;
  //        register reference defines
  parameter BF_LSB_FIRST_LSB                      = 32'd0;
  parameter BF_LSB_FIRST_MSB                      = 32'd0;
  parameter BF_LSB_FIRST_ROFFSET                  = 32'd9;
  parameter BF_LSB_FIRST_RMSB                     = 32'd9;
  parameter BF_LSB_FIRST_RMASK                    = 10'h200;
  parameter BF_LSB_FIRST_RWIDTH                   = 32'd1;
  typedef logic  lsb_first_data_t;
  //        bitfield structures
  typedef struct packed {
    lsb_first_data_t data;
  } lsb_first_reg_t;
  
  // BitField: rx_empty (r) 
  //        bitfield defines
  parameter BF_RX_EMPTY_RESET                     = 1'h0;
  parameter BF_RX_EMPTY_WIDTH                     = 32'd1;
  //        register reference defines
  parameter BF_RX_EMPTY_LSB                       = 32'd0;
  parameter BF_RX_EMPTY_MSB                       = 32'd0;
  parameter BF_RX_EMPTY_ROFFSET                   = 32'd0;
  parameter BF_RX_EMPTY_RMSB                      = 32'd0;
  parameter BF_RX_EMPTY_RMASK                     = 1'h1;
  parameter BF_RX_EMPTY_RWIDTH                    = 32'd1;
  typedef logic  rx_empty_data_t;
  //        bitfield structures
  typedef struct packed {
    rx_empty_data_t data;
  } rx_empty_reg_t;
  
  // BitField: rx_full (r) 
  //        bitfield defines
  parameter BF_RX_FULL_RESET                      = 1'h0;
  parameter BF_RX_FULL_WIDTH                      = 32'd1;
  //        register reference defines
  parameter BF_RX_FULL_LSB                        = 32'd0;
  parameter BF_RX_FULL_MSB                        = 32'd0;
  parameter BF_RX_FULL_ROFFSET                    = 32'd1;
  parameter BF_RX_FULL_RMSB                       = 32'd1;
  parameter BF_RX_FULL_RMASK                      = 2'h2;
  parameter BF_RX_FULL_RWIDTH                     = 32'd1;
  typedef logic  rx_full_data_t;
  //        bitfield structures
  typedef struct packed {
    rx_full_data_t data;
  } rx_full_reg_t;
  
  // BitField: tx_empty (r) 
  //        bitfield defines
  parameter BF_TX_EMPTY_RESET                     = 1'h0;
  parameter BF_TX_EMPTY_WIDTH                     = 32'd1;
  //        register reference defines
  parameter BF_TX_EMPTY_LSB                       = 32'd0;
  parameter BF_TX_EMPTY_MSB                       = 32'd0;
  parameter BF_TX_EMPTY_ROFFSET                   = 32'd2;
  parameter BF_TX_EMPTY_RMSB                      = 32'd2;
  parameter BF_TX_EMPTY_RMASK                     = 3'h4;
  parameter BF_TX_EMPTY_RWIDTH                    = 32'd1;
  typedef logic  tx_empty_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_empty_data_t data;
  } tx_empty_reg_t;
  
  // BitField: tx_full (r) 
  //        bitfield defines
  parameter BF_TX_FULL_RESET                      = 1'h0;
  parameter BF_TX_FULL_WIDTH                      = 32'd1;
  //        register reference defines
  parameter BF_TX_FULL_LSB                        = 32'd0;
  parameter BF_TX_FULL_MSB                        = 32'd0;
  parameter BF_TX_FULL_ROFFSET                    = 32'd3;
  parameter BF_TX_FULL_RMSB                       = 32'd3;
  parameter BF_TX_FULL_RMASK                      = 4'h8;
  parameter BF_TX_FULL_RWIDTH                     = 32'd1;
  typedef logic  tx_full_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_full_data_t data;
  } tx_full_reg_t;
  
  // BitField: modf_flag (r) 
  //        bitfield defines
  parameter BF_MODF_FLAG_RESET                    = 1'h0;
  parameter BF_MODF_FLAG_WIDTH                    = 32'd1;
  //        register reference defines
  parameter BF_MODF_FLAG_LSB                      = 32'd0;
  parameter BF_MODF_FLAG_MSB                      = 32'd0;
  parameter BF_MODF_FLAG_ROFFSET                  = 32'd4;
  parameter BF_MODF_FLAG_RMSB                     = 32'd4;
  parameter BF_MODF_FLAG_RMASK                    = 5'h10;
  parameter BF_MODF_FLAG_RWIDTH                   = 32'd1;
  typedef logic  modf_flag_data_t;
  //        bitfield structures
  typedef struct packed {
    modf_flag_data_t data;
  } modf_flag_reg_t;
  
  // BitField: tx_data (w) 
  //        bitfield defines
  parameter BF_TX_DATA_RESET                      = 8'h0;
  parameter BF_TX_DATA_WIDTH                      = 32'd8;
  //        register reference defines
  parameter BF_TX_DATA_LSB                        = 32'd0;
  parameter BF_TX_DATA_MSB                        = 32'd7;
  parameter BF_TX_DATA_ROFFSET                    = 32'd0;
  parameter BF_TX_DATA_RMSB                       = 32'd7;
  parameter BF_TX_DATA_RMASK                      = 8'hff;
  parameter BF_TX_DATA_RWIDTH                     = 32'd8;
  typedef logic [7:0] tx_data_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_data_data_t data;
  } tx_data_reg_t;
  
  // BitField: rx_data (r) 
  //        bitfield defines
  parameter BF_RX_DATA_RESET                      = 8'h0;
  parameter BF_RX_DATA_WIDTH                      = 32'd8;
  //        register reference defines
  parameter BF_RX_DATA_LSB                        = 32'd0;
  parameter BF_RX_DATA_MSB                        = 32'd7;
  parameter BF_RX_DATA_ROFFSET                    = 32'd0;
  parameter BF_RX_DATA_RMSB                       = 32'd7;
  parameter BF_RX_DATA_RMASK                      = 8'hff;
  parameter BF_RX_DATA_RWIDTH                     = 32'd8;
  typedef logic [7:0] rx_data_data_t;
  //        bitfield structures
  typedef struct packed {
    rx_data_data_t data;
  } rx_data_reg_t;
  
  // BitField: slave_select (r/w) 
  //        bitfield defines
  parameter BF_SLAVE_SELECT_RESET                 = 32'hFFFFFFFF;
  parameter BF_SLAVE_SELECT_WIDTH                 = 32'd32;
  //        register reference defines
  parameter BF_SLAVE_SELECT_LSB                   = 32'd0;
  parameter BF_SLAVE_SELECT_MSB                   = 32'd31;
  parameter BF_SLAVE_SELECT_ROFFSET               = 32'd0;
  parameter BF_SLAVE_SELECT_RMSB                  = 32'd31;
  parameter BF_SLAVE_SELECT_RMASK                 = 32'hffffffff;
  parameter BF_SLAVE_SELECT_RWIDTH                = 32'd32;
  typedef logic [31:0] slave_select_data_t;
  //        bitfield structures
  typedef struct packed {
    slave_select_data_t data;
  } slave_select_reg_t;
  
  // BitField: tx_fifo_occupancy (r) 
  //        bitfield defines
  parameter BF_TX_FIFO_OCCUPANCY_RESET            = 9'h0;
  parameter BF_TX_FIFO_OCCUPANCY_WIDTH            = 32'd9;
  //        register reference defines
  parameter BF_TX_FIFO_OCCUPANCY_LSB              = 32'd0;
  parameter BF_TX_FIFO_OCCUPANCY_MSB              = 32'd8;
  parameter BF_TX_FIFO_OCCUPANCY_ROFFSET          = 32'd0;
  parameter BF_TX_FIFO_OCCUPANCY_RMSB             = 32'd8;
  parameter BF_TX_FIFO_OCCUPANCY_RMASK            = 9'h1ff;
  parameter BF_TX_FIFO_OCCUPANCY_RWIDTH           = 32'd9;
  typedef logic [8:0] tx_fifo_occupancy_data_t;
  //        bitfield structures
  typedef struct packed {
    tx_fifo_occupancy_data_t data;
  } tx_fifo_occupancy_reg_t;
  
  // BitField: rx_fifo_occupancy (r) 
  //        bitfield defines
  parameter BF_RX_FIFO_OCCUPANCY_RESET            = 9'h0;
  parameter BF_RX_FIFO_OCCUPANCY_WIDTH            = 32'd9;
  //        register reference defines
  parameter BF_RX_FIFO_OCCUPANCY_LSB              = 32'd0;
  parameter BF_RX_FIFO_OCCUPANCY_MSB              = 32'd8;
  parameter BF_RX_FIFO_OCCUPANCY_ROFFSET          = 32'd0;
  parameter BF_RX_FIFO_OCCUPANCY_RMSB             = 32'd8;
  parameter BF_RX_FIFO_OCCUPANCY_RMASK            = 9'h1ff;
  parameter BF_RX_FIFO_OCCUPANCY_RWIDTH           = 32'd9;
  typedef logic [8:0] rx_fifo_occupancy_data_t;
  //        bitfield structures
  typedef struct packed {
    rx_fifo_occupancy_data_t data;
  } rx_fifo_occupancy_reg_t;
  
  // BitField: adv_feat_enable (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_ENABLE_COUNT              = 32'd32;
  parameter BF_ADV_FEAT_ENABLE_RESET              = 1'h0;
  parameter BF_ADV_FEAT_ENABLE_WIDTH              = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_ENABLE_LSB                = 32'd0;
  parameter BF_ADV_FEAT_ENABLE_MSB                = 32'd0;
  parameter BF_ADV_FEAT_ENABLE_ROFFSET            = 32'd0;
  parameter BF_ADV_FEAT_ENABLE_RMSB               = 32'd0;
  parameter BF_ADV_FEAT_ENABLE_RMASK              = 1'h1;
  parameter BF_ADV_FEAT_ENABLE_RWIDTH             = 32'd1;
  typedef logic  adv_feat_enable_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_enable_data_t [31:0] data;
  } adv_feat_enable_reg_t;
  
  // BitField: adv_feat_cpol (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_CPOL_COUNT                = 32'd32;
  parameter BF_ADV_FEAT_CPOL_RESET                = 1'h0;
  parameter BF_ADV_FEAT_CPOL_WIDTH                = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_CPOL_LSB                  = 32'd0;
  parameter BF_ADV_FEAT_CPOL_MSB                  = 32'd0;
  parameter BF_ADV_FEAT_CPOL_ROFFSET              = 32'd1;
  parameter BF_ADV_FEAT_CPOL_RMSB                 = 32'd1;
  parameter BF_ADV_FEAT_CPOL_RMASK                = 2'h2;
  parameter BF_ADV_FEAT_CPOL_RWIDTH               = 32'd1;
  typedef logic  adv_feat_cpol_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_cpol_data_t [31:0] data;
  } adv_feat_cpol_reg_t;
  
  // BitField: adv_feat_cpha (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_CPHA_COUNT                = 32'd32;
  parameter BF_ADV_FEAT_CPHA_RESET                = 1'h0;
  parameter BF_ADV_FEAT_CPHA_WIDTH                = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_CPHA_LSB                  = 32'd0;
  parameter BF_ADV_FEAT_CPHA_MSB                  = 32'd0;
  parameter BF_ADV_FEAT_CPHA_ROFFSET              = 32'd2;
  parameter BF_ADV_FEAT_CPHA_RMSB                 = 32'd2;
  parameter BF_ADV_FEAT_CPHA_RMASK                = 3'h4;
  parameter BF_ADV_FEAT_CPHA_RWIDTH               = 32'd1;
  typedef logic  adv_feat_cpha_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_cpha_data_t [31:0] data;
  } adv_feat_cpha_reg_t;
  
  // BitField: adv_feat_lsb_first (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_LSB_FIRST_COUNT           = 32'd32;
  parameter BF_ADV_FEAT_LSB_FIRST_RESET           = 1'h0;
  parameter BF_ADV_FEAT_LSB_FIRST_WIDTH           = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_LSB_FIRST_LSB             = 32'd0;
  parameter BF_ADV_FEAT_LSB_FIRST_MSB             = 32'd0;
  parameter BF_ADV_FEAT_LSB_FIRST_ROFFSET         = 32'd3;
  parameter BF_ADV_FEAT_LSB_FIRST_RMSB            = 32'd3;
  parameter BF_ADV_FEAT_LSB_FIRST_RMASK           = 4'h8;
  parameter BF_ADV_FEAT_LSB_FIRST_RWIDTH          = 32'd1;
  typedef logic  adv_feat_lsb_first_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_lsb_first_data_t [31:0] data;
  } adv_feat_lsb_first_reg_t;
  
  // BitField: adv_feat_four_wire (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_FOUR_WIRE_COUNT           = 32'd32;
  parameter BF_ADV_FEAT_FOUR_WIRE_RESET           = 1'h1;
  parameter BF_ADV_FEAT_FOUR_WIRE_WIDTH           = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_FOUR_WIRE_LSB             = 32'd0;
  parameter BF_ADV_FEAT_FOUR_WIRE_MSB             = 32'd0;
  parameter BF_ADV_FEAT_FOUR_WIRE_ROFFSET         = 32'd4;
  parameter BF_ADV_FEAT_FOUR_WIRE_RMSB            = 32'd4;
  parameter BF_ADV_FEAT_FOUR_WIRE_RMASK           = 5'h10;
  parameter BF_ADV_FEAT_FOUR_WIRE_RWIDTH          = 32'd1;
  typedef logic  adv_feat_four_wire_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_four_wire_data_t [31:0] data;
  } adv_feat_four_wire_reg_t;
  
  // BitField: adv_feat_miso_sample_slip (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_COUNT    = 32'd32;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_RESET    = 1'h0;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_WIDTH    = 32'd1;
  //        register reference defines
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_LSB      = 32'd0;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_MSB      = 32'd0;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_ROFFSET  = 32'd5;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_RMSB     = 32'd5;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_RMASK    = 6'h20;
  parameter BF_ADV_FEAT_MISO_SAMPLE_SLIP_RWIDTH   = 32'd1;
  typedef logic  adv_feat_miso_sample_slip_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_miso_sample_slip_data_t [31:0] data;
  } adv_feat_miso_sample_slip_reg_t;
  
  // BitField: adv_feat_3wire_tri_point (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_COUNT     = 32'd32;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_RESET     = 8'h10;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_WIDTH     = 32'd8;
  //        register reference defines
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_LSB       = 32'd0;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_MSB       = 32'd7;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_ROFFSET   = 32'd8;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_RMSB      = 32'd15;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_RMASK     = 16'hff00;
  parameter BF_ADV_FEAT_3WIRE_TRI_POINT_RWIDTH    = 32'd8;
  typedef logic [7:0] adv_feat_3wire_tri_point_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_3wire_tri_point_data_t [31:0] data;
  } adv_feat_3wire_tri_point_reg_t;
  
  // BitField: adv_feat_clock_div (r/w)   Array of 32 
  //        bitfield defines
  parameter BF_ADV_FEAT_CLOCK_DIV_COUNT           = 32'd32;
  parameter BF_ADV_FEAT_CLOCK_DIV_RESET           = 16'h0003;
  parameter BF_ADV_FEAT_CLOCK_DIV_WIDTH           = 32'd16;
  //        register reference defines
  parameter BF_ADV_FEAT_CLOCK_DIV_LSB             = 32'd0;
  parameter BF_ADV_FEAT_CLOCK_DIV_MSB             = 32'd15;
  parameter BF_ADV_FEAT_CLOCK_DIV_ROFFSET         = 32'd16;
  parameter BF_ADV_FEAT_CLOCK_DIV_RMSB            = 32'd31;
  parameter BF_ADV_FEAT_CLOCK_DIV_RMASK           = 32'hffff0000;
  parameter BF_ADV_FEAT_CLOCK_DIV_RWIDTH          = 32'd16;
  typedef logic [15:0] adv_feat_clock_div_data_t;
  //        bitfield structures
  typedef struct packed {
    adv_feat_clock_div_data_t [31:0] data;
  } adv_feat_clock_div_reg_t;
  
  // ==========  Register Input and Output Structures  ==========
  typedef struct packed {
    module_version_minor_reg_t module_version_minor;
    module_version_major_reg_t module_version_major;
    gie_reg_t gie;
    modf_reg_t modf;
    dtr_empty_reg_t dtr_empty;
    drr_full_reg_t drr_full;
    drr_overrun_reg_t drr_overrun;
    tx_fifo_half_empty_reg_t tx_fifo_half_empty;
    modf_ien_reg_t modf_ien;
    dtr_empty_ien_reg_t dtr_empty_ien;
    drr_full_ien_reg_t drr_full_ien;
    drr_overrun_ien_reg_t drr_overrun_ien;
    tx_fifo_half_empty_ien_reg_t tx_fifo_half_empty_ien;
    reset_reg_t reset;
    loop_reg_t loop;
    spe_reg_t spe;
    master_reg_t master;
    cpol_reg_t cpol;
    cpha_reg_t cpha;
    tx_fifo_reset_reg_t tx_fifo_reset;
    rx_fifo_reset_reg_t rx_fifo_reset;
    man_ss_en_reg_t man_ss_en;
    mstr_inhibit_reg_t mstr_inhibit;
    lsb_first_reg_t lsb_first;
    rx_empty_reg_t rx_empty;
    rx_full_reg_t rx_full;
    tx_empty_reg_t tx_empty;
    tx_full_reg_t tx_full;
    modf_flag_reg_t modf_flag;
    tx_data_reg_t tx_data;
    rx_data_reg_t rx_data;
    slave_select_reg_t slave_select;
    tx_fifo_occupancy_reg_t tx_fifo_occupancy;
    rx_fifo_occupancy_reg_t rx_fifo_occupancy;
    adv_feat_enable_reg_t adv_feat_enable;
    adv_feat_cpol_reg_t adv_feat_cpol;
    adv_feat_cpha_reg_t adv_feat_cpha;
    adv_feat_lsb_first_reg_t adv_feat_lsb_first;
    adv_feat_four_wire_reg_t adv_feat_four_wire;
    adv_feat_miso_sample_slip_reg_t adv_feat_miso_sample_slip;
    adv_feat_3wire_tri_point_reg_t adv_feat_3wire_tri_point;
    adv_feat_clock_div_reg_t adv_feat_clock_div;
  } axi_mspi_regs_t;





/*----------------------------------------*/ 
/*  Function for MMR WR Access Validation */ 
/*----------------------------------------*/ 
 
function  automatic MMR_Rd_Valid_AXI_MSPI( input  [31:0] adr ); 
  logic valid; 
  begin 
    case( adr ) 
      32'h00000000 : valid = 1'b1; 
      32'h0000001c : valid = 1'b1; 
      32'h00000020 : valid = 1'b1; 
      32'h00000028 : valid = 1'b1; 
      32'h00000060 : valid = 1'b1; 
      32'h00000064 : valid = 1'b1; 
      32'h0000006c : valid = 1'b1; 
      32'h00000070 : valid = 1'b1; 
      32'h00000074 : valid = 1'b1; 
      32'h00000078 : valid = 1'b1; 
      32'h00000080 : valid = 1'b1; 
      32'h00000084 : valid = 1'b1; 
      32'h00000088 : valid = 1'b1; 
      32'h0000008c : valid = 1'b1; 
      32'h00000090 : valid = 1'b1; 
      32'h00000094 : valid = 1'b1; 
      32'h00000098 : valid = 1'b1; 
      32'h0000009c : valid = 1'b1; 
      32'h000000a0 : valid = 1'b1; 
      32'h000000a4 : valid = 1'b1; 
      32'h000000a8 : valid = 1'b1; 
      32'h000000ac : valid = 1'b1; 
      32'h000000b0 : valid = 1'b1; 
      32'h000000b4 : valid = 1'b1; 
      32'h000000b8 : valid = 1'b1; 
      32'h000000bc : valid = 1'b1; 
      32'h000000c0 : valid = 1'b1; 
      32'h000000c4 : valid = 1'b1; 
      32'h000000c8 : valid = 1'b1; 
      32'h000000cc : valid = 1'b1; 
      32'h000000d0 : valid = 1'b1; 
      32'h000000d4 : valid = 1'b1; 
      32'h000000d8 : valid = 1'b1; 
      32'h000000dc : valid = 1'b1; 
      32'h000000e0 : valid = 1'b1; 
      32'h000000e4 : valid = 1'b1; 
      32'h000000e8 : valid = 1'b1; 
      32'h000000ec : valid = 1'b1; 
      32'h000000f0 : valid = 1'b1; 
      32'h000000f4 : valid = 1'b1; 
      32'h000000f8 : valid = 1'b1; 
      32'h000000fc : valid = 1'b1; 
      default    : valid = 1'b0; 
    endcase 
    MMR_Rd_Valid_AXI_MSPI = valid; 
  end 
endfunction /* MMR_Rd_Valid_AXI_MSPI */

/*----------------------------------------*/ 
/*  Function for MMR WR Access Validation */ 
/*----------------------------------------*/ 
 
function automatic MMR_Wr_Valid_AXI_MSPI( input  [31:0] adr ); 
  logic valid; 
  begin 
    case( adr ) 
      32'h0000001c : valid = 1'b1; 
      32'h00000020 : valid = 1'b1; 
      32'h00000028 : valid = 1'b1; 
      32'h00000040 : valid = 1'b1; 
      32'h00000060 : valid = 1'b1; 
      32'h00000068 : valid = 1'b1; 
      32'h00000070 : valid = 1'b1; 
      32'h00000080 : valid = 1'b1; 
      32'h00000084 : valid = 1'b1; 
      32'h00000088 : valid = 1'b1; 
      32'h0000008c : valid = 1'b1; 
      32'h00000090 : valid = 1'b1; 
      32'h00000094 : valid = 1'b1; 
      32'h00000098 : valid = 1'b1; 
      32'h0000009c : valid = 1'b1; 
      32'h000000a0 : valid = 1'b1; 
      32'h000000a4 : valid = 1'b1; 
      32'h000000a8 : valid = 1'b1; 
      32'h000000ac : valid = 1'b1; 
      32'h000000b0 : valid = 1'b1; 
      32'h000000b4 : valid = 1'b1; 
      32'h000000b8 : valid = 1'b1; 
      32'h000000bc : valid = 1'b1; 
      32'h000000c0 : valid = 1'b1; 
      32'h000000c4 : valid = 1'b1; 
      32'h000000c8 : valid = 1'b1; 
      32'h000000cc : valid = 1'b1; 
      32'h000000d0 : valid = 1'b1; 
      32'h000000d4 : valid = 1'b1; 
      32'h000000d8 : valid = 1'b1; 
      32'h000000dc : valid = 1'b1; 
      32'h000000e0 : valid = 1'b1; 
      32'h000000e4 : valid = 1'b1; 
      32'h000000e8 : valid = 1'b1; 
      32'h000000ec : valid = 1'b1; 
      32'h000000f0 : valid = 1'b1; 
      32'h000000f4 : valid = 1'b1; 
      32'h000000f8 : valid = 1'b1; 
      32'h000000fc : valid = 1'b1; 
      default    : valid = 1'b0; 
    endcase 
    MMR_Wr_Valid_AXI_MSPI = valid; 
  end 
endfunction /* MMR_Wr_Valid_AXI_MSPI */

endpackage

`endif        // end ifndef _DEFINE_AXI_MSPI

