`timescale 1ns / 1ps
//-----------------------------------------------------------------------------------
// ################  Company:        Analog Devices, Inc.
// ##   ###########  Engineer:       JCE
// ##      ########
// ##         #####  Create Date:    
// ##            ##  Design Name:    
// ##         #####  Module Name:    
// ##      ########  Project Name:   
// ##   ###########  Target Devices: 
// ################  Tool versions:  
//-----------------------------------------------------------------------------------
// Description:
//
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
//
// Additional Comments: 
//
//-----------------------------------------------------------------------------------
// The following code is provided as-is and is intended to be used as a reference 
// only.  ADI is not responsible for supporting or providing updates.  The code may 
// contain manufacturer specific primitive elements.  You are solely responsible for 
// obtaining the proper license to use the manufacturer's design tools.
//
// All rights reserved.  
//-----------------------------------------------------------------------------------


module axi_mspi 
 #(parameter NUM_SLAVES = 1)
  (
   // axi interface
   input 			s_axi_aclk,
   input 			s_axi_aresetn,
   input 			s_axi_awvalid,
   input [11:0] 		s_axi_awaddr,
   output wire 			s_axi_awready,
   input 			s_axi_wvalid,
   input [31:0] 		s_axi_wdata,
   input [ 3:0] 		s_axi_wstrb,
   output wire 			s_axi_wready,
   output wire 			s_axi_bvalid,
   output wire [ 1:0] 		s_axi_bresp,
   input 			s_axi_bready,
   input 			s_axi_arvalid,
   input [11:0] 		s_axi_araddr,
   output wire 			s_axi_arready,
   output wire 			s_axi_rvalid,
   output wire [31:0] 		s_axi_rdata,
   output wire [ 1:0] 		s_axi_rresp,
   input 			s_axi_rready,

   // SPI Interface
   output wire 			spi_clk,
   output wire [NUM_SLAVES-1:0] spi_csn,
   output			spi_mosi_t,
   output			spi_mosi_o,
   input 			spi_mosi_i,
   input 			spi_miso,

   // interrupt
   output wire 			interrupt
   );


   
   // internal signals
   

   // reset signals
   wire 			soft_reset;
   wire 			tx_fifo_reset;
   wire 			rx_fifo_reset;
   wire 			engine_reset;
   
   // control signals
   wire 			loop;
   wire 			spe;
   wire 			master;
   wire 			cpol;
   wire 			cpha;
   wire 			tx_fifo_soft_reset;
   wire 			rx_fifo_soft_reset;
   wire 			man_ss_en;
   wire 			mstr_inhibit;
   wire 			lsb_first;
   wire 			miso_slip;
   wire 			four_wire;
   wire [7:0] 			tri_point;
   wire [15:0] 			clock_div;
   wire [NUM_SLAVES-1:0] 	slave_select;
   
   
   // rx fifo signals
   wire 			rx_fifo_wr;
   wire [7:0] 			rx_fifo_wr_data;
   wire 			rx_fifo_rd;
   wire [7:0] 			rx_fifo_rd_data;
   wire 			rx_fifo_empty;
   wire 			rx_fifo_full;
   wire [8:0] 			rx_fifo_occupancy;
   
   // tx fifo signals
   wire 			tx_fifo_wr;
   wire [7:0] 			tx_fifo_wr_data;
   wire 			tx_fifo_rd;
   wire [7:0] 			tx_fifo_rd_data;
   wire 			tx_fifo_empty;
   wire 			tx_fifo_full;
   wire [8:0] 			tx_fifo_occupancy;
   
   

   
   
   // assign internal signals
   assign tx_fifo_reset = tx_fifo_soft_reset | soft_reset | ~s_axi_aresetn;
   assign rx_fifo_reset = rx_fifo_soft_reset | soft_reset | ~s_axi_aresetn;
   assign engine_reset  = soft_reset | ~s_axi_aresetn;

   // Cmd_mailbox general registers
   axi_mspi_regs #(.NUM_SLAVES(NUM_SLAVES))
   i_registers
     (
      // axi interface
      .s_axi_aresetn          (s_axi_aresetn),
      .s_axi_aclk             (s_axi_aclk),
      .s_axi_awvalid          (s_axi_awvalid),
      .s_axi_awaddr           ({20'd0, s_axi_awaddr}),
      .s_axi_awready          (s_axi_awready),
      .s_axi_wvalid           (s_axi_wvalid),
      .s_axi_wdata            (s_axi_wdata),
      .s_axi_wstrb            (s_axi_wstrb),
      .s_axi_wready           (s_axi_wready),
      .s_axi_bvalid           (s_axi_bvalid),
      .s_axi_bresp            (s_axi_bresp),
      .s_axi_bready           (s_axi_bready),
      .s_axi_arvalid          (s_axi_arvalid),
      .s_axi_araddr           ({20'd0, s_axi_araddr}),
      .s_axi_arready          (s_axi_arready),
      .s_axi_rvalid           (s_axi_rvalid),
      .s_axi_rresp            (s_axi_rresp),
      .s_axi_rdata            (s_axi_rdata),
      .s_axi_rready           (s_axi_rready),

      // interrupt signals
      .interrupt              (interrupt),
      
      // reset signal
      .soft_reset             (soft_reset),
      
      // control signals
      .loop                   (loop),
      .spe                    (spe),
      .master                 (master),
      .cpol                   (cpol),
      .cpha                   (cpha),
      .tx_fifo_reset          (tx_fifo_soft_reset),
      .rx_fifo_reset          (rx_fifo_soft_reset),
      .man_ss_en              (man_ss_en),
      .mstr_inhibit           (mstr_inhibit),
      .lsb_first              (lsb_first),

      .miso_slip              (miso_slip),
      .four_wire              (four_wire),
      .tri_point              (tri_point),
      .clock_div              (clock_div),
      
      // status signals
      .rx_empty               (rx_fifo_empty),
      .rx_full                (rx_fifo_full),
      .tx_empty               (tx_fifo_empty),
      .tx_full                (tx_fifo_full),
      
      // data signals
      .rx_data_wr             (rx_fifo_wr),
      .rx_data_rd             (rx_fifo_rd),
      .rx_data                (rx_fifo_rd_data),
      .tx_data_wr             (tx_fifo_wr),
      .tx_data                (tx_fifo_wr_data),
      
      // slave select signals
      .slave_select_i         ({NUM_SLAVES{1'b1}}),
      .slave_select_o         (slave_select),
      
      // fifo occupancy signals
      .tx_fifo_occupancy      (tx_fifo_occupancy),
      .rx_fifo_occupancy      (rx_fifo_occupancy)
      );


   fifo_8w_256d i_tx_fifo
     (.clk                    (s_axi_aclk),
      .srst                   (tx_fifo_reset),

      .wr_en                  (tx_fifo_wr),
      .din                    (tx_fifo_wr_data),

      .rd_en                  (tx_fifo_rd),
      .dout                   (tx_fifo_rd_data),

      .full                   (tx_fifo_full),
      .empty                  (tx_fifo_empty),
    
      .data_count             (tx_fifo_occupancy)
      );
   

   fifo_8w_256d i_rx_fifo
     (.clk                    (s_axi_aclk),
      .srst                   (rx_fifo_reset),

      .wr_en                  (rx_fifo_wr),
      .din                    (rx_fifo_wr_data),

      .rd_en                  (rx_fifo_rd),
      .dout                   (rx_fifo_rd_data),

      .full                   (rx_fifo_full),
      .empty                  (rx_fifo_empty),

      .data_count             (rx_fifo_occupancy)
      );
   
   axi_mspi_engine #(.NUM_SLAVES(NUM_SLAVES))
   u_spi_engine
     (
      .clk                    (s_axi_aclk),
      .reset                  (engine_reset),

      // Control 
      .enable                 (spe),
      .loop                   (loop),
      .cpol                   (cpol),
      .cpha                   (cpha),
      .man_ss_en              (man_ss_en),
      .mstr_inhibit	      (mstr_inhibit),
      .lsb_first	      (lsb_first),

      .miso_slip	      (miso_slip),
      .four_wire	      (four_wire),
      .tri_point	      (tri_point),
      .clock_div	      (clock_div),

      .slave_select	      (slave_select),

      // TX FIFO
      .tx_fifo_rd	      (tx_fifo_rd),
      .tx_fifo_rd_data	      (tx_fifo_rd_data),
      .tx_fifo_empty	      (tx_fifo_empty),

      // RX FIFO
      .rx_fifo_wr	      (rx_fifo_wr),
      .rx_fifo_wr_data	      (rx_fifo_wr_data),

      // SPI Interface
      .spi_clk_i	      (spi_clk),
      .spi_clk_o	      (spi_clk),
      .spi_clk_t	      (),
      .spi_csb_o	      (spi_csn),
      .spi_csb_t	      (),
      .spi_mosi_o	      (spi_mosi_o),
      .spi_mosi_t	      (spi_mosi_t),
      .spi_mosi_i	      (spi_mosi_i),
      .spi_miso_i             (spi_miso)
      );

endmodule

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
