## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 Interface Core
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Interface

source ../../../bin/vivado_include.tcl

pkg_interface system_io
add_interface_ports ref_clk_p out 1
add_interface_ports ref_clk_n out 1
add_interface_ports mcs_in_p out 1
add_interface_ports mcs_in_n out 1
add_interface_ports mcs_out_p in 1
add_interface_ports mcs_out_n in 1
ipx::save_abstraction_definition [ipx::current_busabs]
ipx::save_bus_definition [ipx::current_busdef]

pkg_interface device_io
add_interface_ports rx0_cssi_clk_lssi_clk_p out 1
add_interface_ports rx0_cssi_nc_lssi_clk_n out 1
add_interface_ports rx0_cssi_strobe_lssi_strobe_p out 1
add_interface_ports rx0_cssi_nc_lssi_strobe_n out 1
add_interface_ports rx0_cssi_data1_lssi_data0_p out 1
add_interface_ports rx0_cssi_data0_lssi_data0_n out 1
add_interface_ports rx0_cssi_data3_lssi_data1_p out 1
add_interface_ports rx0_cssi_data2_lssi_data1_n out 1
add_interface_ports rx0_cssi_gpio_in out 8
add_interface_ports rx0_cssi_gpio_out in 8
add_interface_ports rx0_cssi_gpio_enb in 8
add_interface_ports rx1_cssi_clk_lssi_clk_p out 1
add_interface_ports rx1_cssi_nc_lssi_clk_n out 1
add_interface_ports rx1_cssi_strobe_lssi_strobe_p out 1
add_interface_ports rx1_cssi_nc_lssi_strobe_n out 1
add_interface_ports rx1_cssi_data1_lssi_data0_p out 1
add_interface_ports rx1_cssi_data0_lssi_data0_n out 1
add_interface_ports rx1_cssi_data3_lssi_data1_p out 1
add_interface_ports rx1_cssi_data2_lssi_data1_n out 1
add_interface_ports rx1_cssi_gpio_in out 8
add_interface_ports rx1_cssi_gpio_out in 8
add_interface_ports rx1_cssi_gpio_enb in 8
add_interface_ports tx0_cssi_refclk_lssi_refclk_p out 1
add_interface_ports tx0_cssi_nc_lssi_refclk_n out 1
add_interface_ports tx0_cssi_clk_lssi_clk_p in 1
add_interface_ports tx0_cssi_nc_lssi_clk_n in 1
add_interface_ports tx0_cssi_strobe_lssi_strobe_p in 1
add_interface_ports tx0_cssi_nc_lssi_strobe_n in 1
add_interface_ports tx0_cssi_data1_lssi_data0_p in 1
add_interface_ports tx0_cssi_data0_lssi_data0_n in 1
add_interface_ports tx0_cssi_data3_lssi_data1_p in 1
add_interface_ports tx0_cssi_data2_lssi_data1_n in 1
add_interface_ports tx0_cssi_gpio_in out 10
add_interface_ports tx0_cssi_gpio_out in 10
add_interface_ports tx0_cssi_gpio_enb in 10
add_interface_ports tx1_cssi_refclk_lssi_refclk_p out 1
add_interface_ports tx1_cssi_nc_lssi_refclk_n out 1
add_interface_ports tx1_cssi_clk_lssi_clk_p in 1
add_interface_ports tx1_cssi_nc_lssi_clk_n in 1
add_interface_ports tx1_cssi_strobe_lssi_strobe_p in 1
add_interface_ports tx1_cssi_nc_lssi_strobe_n in 1
add_interface_ports tx1_cssi_data1_lssi_data0_p in 1
add_interface_ports tx1_cssi_data0_lssi_data0_n in 1
add_interface_ports tx1_cssi_data3_lssi_data1_p in 1
add_interface_ports tx1_cssi_data2_lssi_data1_n in 1
add_interface_ports tx1_cssi_gpio_in out 10
add_interface_ports tx1_cssi_gpio_out in 10
add_interface_ports tx1_cssi_gpio_enb in 10
add_interface_ports rx0_enable in 1
add_interface_ports rx1_enable in 1
add_interface_ports tx0_enable in 1
add_interface_ports tx1_enable in 1
add_interface_ports dgpio inout   12
add_interface_ports mode in 1
add_interface_ports resetb in 1
add_interface_ports gp_int out 1
add_interface_ports dev_clk out 1
ipx::save_abstraction_definition [ipx::current_busabs]
ipx::save_bus_definition [ipx::current_busdef]

## ##################################################################################
## ##################################################################################
## IP Core

create_project axi_adrv9001 . -part xc7z045ffg900-2 -force
msg_settings none
set_property ip_repo_paths . [current_fileset]
update_ip_catalog

set ip_source_list {}
lappend ip_source_list ../../common/hdl/cdc.v
lappend ip_source_list ../../common/hdl/cdc_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_cntrl.v
lappend ip_source_list ../../common/hdl/cdc_cntrl_constr.xdc
lappend ip_source_list ../../common/hdl/cdc_event.v
lappend ip_source_list ../../common/hdl/cdc_event_constr.xdc
lappend ip_source_list ../../common/hdl/clk_mon.v
lappend ip_source_list ../../common/hdl/clk_mon_constr.xdc
lappend ip_source_list ../../common/hdl/mem_sdp.v
lappend ip_source_list ../../common/hdl/mem_fifo.v
lappend ip_source_list ../../common/hdl/tdd_frame.v
lappend ip_source_list ../../common/hdl/tdd_enable.v
lappend ip_source_list ../../common/hdl/tdd_dma_enable.v
lappend ip_source_list ../../common/hdl/axilite_slave_if.v
lappend ip_source_list ../../common/hdl/axilite_block_if.v
lappend ip_source_list axi_adrv9001_constr.xdc
lappend ip_source_list axi_adrv9001_rx_if.v
lappend ip_source_list axi_adrv9001_rx_dmon.v
lappend ip_source_list axi_adrv9001_rx_dec.v
lappend ip_source_list axi_adrv9001_rx_regs.v
lappend ip_source_list axi_adrv9001_rx.v
lappend ip_source_list axi_adrv9001_tx_if.v
lappend ip_source_list axi_adrv9001_tx_clk.v
lappend ip_source_list axi_adrv9001_tx_dgen.v
lappend ip_source_list axi_adrv9001_tx_fifo.v
lappend ip_source_list axi_adrv9001_tx_regs.v
lappend ip_source_list axi_adrv9001_tx.v
lappend ip_source_list axi_adrv9001_tdd_dma_regs.v
lappend ip_source_list axi_adrv9001_tdd_regs.v
lappend ip_source_list axi_adrv9001_tdd.v
lappend ip_source_list axi_adrv9001_regs.v
lappend ip_source_list axi_adrv9001_mcs.v
lappend ip_source_list axi_adrv9001_clkgen.v
lappend ip_source_list axi_adrv9001_gpio.v
lappend ip_source_list axi_adrv9001_gpio_regs.v
lappend ip_source_list axi_adrv9001.v
set ip_file_list $ip_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property source_set sources_1 [get_filesets sim_1]
set_property top axi_adrv9001 [get_filesets sources_1]
set_property top axi_adrv9001 [get_filesets sim_1]

pkg_ip_core axi_adrv9001
add_ip_files $ip_file_list synthesis
add_ip_files $ip_file_list simulation
ipx::save_core

set ip_file_set [ipx::get_file_groups -filter {NAME =~ *synthesis*}]
set_property SCOPED_TO_REF axi_adrv9001 [ipx::get_files *axi_adrv9001_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_event [ipx::get_files *cdc_event_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc_cntrl [ipx::get_files *cdc_cntrl_constr.xdc -of_objects $ip_file_set]
set_property SCOPED_TO_REF cdc [ipx::get_files *cdc_constr.xdc -of_objects $ip_file_set]
ipx::save_core

ipx::associate_bus_interfaces -busif rx0 -clock rx0_clk [ipx::current_core]
ipx::associate_bus_interfaces -busif orx0 -clock rx0_clk [ipx::current_core]
ipx::associate_bus_interfaces -busif rx1 -clock rx1_clk [ipx::current_core]
ipx::associate_bus_interfaces -busif orx1 -clock rx1_clk [ipx::current_core]
ipx::associate_bus_interfaces -busif gpio_gain -clock gpio_clk [ipx::current_core]
ipx::save_core

set_property driver_value 0 [ipx::get_ports *trig* -of_objects [ipx::current_core]]
set_property driver_value 0 [ipx::get_ports *usr_gpio_in* -of_objects [ipx::current_core]]
ipx::save_core

## ##################################################################################
## ##################################################################################
