#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 transmit registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_tx');

register(0x000, 'REG_TX_CMOS_LVDS_ID');
field(0, 32, RO, 0x0, 'TX_CMOS_LVDS_ID', 'An unambigous identifier indicates the
  current configuration of SSI interface. If configured as CMOS, this register
  reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53.');

register(0x004, 'REG_TX_CONTROL');
field( 4, 3, RW, 0x0, 'TX_NUM_OF_BITS', 'This field must be set to the desired number of
  bits in a sample. It supports the following sample widths.
    3b101: 64bits, (IQ) interface.
    3b100: 32bits, (IQ) interface.
    3b011: 24bits, (IQ) interface.
    3b010: 16bits, (I) interface.
    3b001:  8bits, (I) interface.
    3b000:  2bits, (I) interface.');
field( 8, 1, RW, 0x0, 'TX_LSTRB1_PSTRB0', 'This field must be set to the desired strobe
  type, It supports the following two modes. If set to 1 and is a two channel interface,
  a level strobe is asserted for the entire first channel. If this bit is set to 0, strobe
  is generated as a pulse, asserted only during the first clock cycle of the data frame.');
field( 9, 1, RW, 0x0, 'TX_MLANE1_SLANE0', 'This field must be set to the desired number of
  lanes (or lines) at the interface. If this bit is set to 0x1, the interface is a multiple lane
  (or line) interface. In CMOS mode this is 4 lines, in LVDS it is 2 lanes. If this bit is
  set to 0x0, it is a single lane (or line) interface.');
field(10, 1, RW, 0x0, 'TX_SDR1_DDR0', 'This field must be set to the desired clock type.
  If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be
  set carefully to match the device. The FPGA core supports SDR or DDR in all modes.');
field(11, 1, RW, 0x0, 'TX_LSB1_MSB0', 'This field must be set to the desired bit order within
  the data frame. If set to 0x1, the samples are transmitted lsb first, otherwise msb first.');
field(12, 1, RW, 0x0, 'TX_Q1_I0', 'This field must be set to the desired channel order within
  the data frame. If set to 0x1, the Q data is sent as the first sample, otherwise I data.');
field(14, 1, RO, 0x0, 'TX_CMOS1_LVDS0', 'This is a read-only bit indicating the current
  configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is
  in LVDS mode. The software is expected to qualify the remaining fields in this register
  based on the value read in this bit.');

register(0x008, 'REG_TX_IO_CONTROL');
field(0, 1, RW, 0x0, 'TX_BUF_ENABLE', 'The core, by default, tri-states all the IO unless
  explicitly enabled by software. After a profile is loaded, this bit must be set to 0x1
  to enable all the output buffers in both LVDS and CMOS mode');
field(1, 1, RW, 0x0, 'TX_CLK_SEL', 'If this field is set, the transmit interface internal
  clock is sourced from the receive interface clock, otherwise, the transmit reference clock
  input sources the transmit interface internal clock.');
field(2, 1, RW, 0x0, 'TX_CLK_MSB', 'The transmit interface clock output may be inverted
  by setting this field to 0x1, as it controls the MSB bit in the clock output.');

register(0x00c, 'REG_TX_INIT');
field(0, 1, RW1HC, 0x0, 'TX_INIT', 'A 0 to 1 transition on this bit initiates a reset request
  at the interface. This is self-cleared, it is recommended that software set this bit after
  a profile is loaded to ensure a clean start.');

register(0x020, 'REG_TX_DATA_SEL');
field(0, 4, RW, 0x0, 'TX_DATA_SEL', 'This field selects the transmit data source.
  The following are supported:
    4b0000: DMA.
    4b0001: Receive loop back.
    4b0010: Zeros
    4b0011: Pattern (see TX_DATA_PAT below).
    4b0100: Nibble ramp
    4b0101: Word ramp
    4b0110: PRBS15
    4b0111: PRBS7
    4b1000: FS/8 tone @ -12 dBfs.');

register(0x030, 'REG_TX_DATA_PAT');
field(0, 32, RW, 0x0, 'TX_DATA_PAT', 'The data pattern transmitted at the interface. In non 32
  bit modes, only the lower bits are used as per the NUM_OF_BITS field above.');

register(0x038, 'REG_TX_DATA_PAT_CTL');
field(0, 1, RW, 0x0, 'TX_DATA_PAT_PULSE', 'If set, sends pattern as a pulse, pattern is
  inserted relative to MCS or software and may optionally be delayed.');
field(8, 8, RW, 0x0, 'TX_DATA_PAT_DELAY', 'The number in SSI clock cycles to delay the
  insertion of pattern if TX_DATA_PAT_PULSE is set.');

register(0x03c, 'REG_TX_DATA_PAT_INS');
field(0, 1, RW1HC, 0x0, 'TX_DATA_PAT_INS', 'If set, pattern is inserted and hardware
  clears the bit after insertion of pattern. Note that pattern is inserted relative
  to MCS always.');

register(0x060, 'REG_TX_STATUS');
field(8, 1, RW1C, 0x0, 'TX_LBOVF', 'This bit indicates an overflow in loop back.');
field(9, 1, RW1C, 0x0, 'TX_LBUNF', 'This bit indicates an underflow in loop back.');

register(0x070, 'REG_TX_DELAY_UNLOCKED');
field(0, 1, RO, 0x0, 'TX_DELAY_UNLOCKED', 'If clear, this bit indicates the delay controller
  is locked and calibrated. A delay setting is not guaranteed if this bit is set.');

register(0x080, 'REG_TX_DELAY_CONTROL_0');
field(0, 5, RW, 0x0, 'TX_WRDELAY_0', 'This field sets the IO delay value at the
  interface for data lane 1. The resolution is ~78ps. The range is 0 to 31.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_0', 'This field indicates the current delay setting
  at the interface for data lane 1. If done correctly, the value read is the same as
  the TX_WRDELAY.');

register(0x084, 'REG_TX_DELAY_CONTROL_1');
field(0, 5, RW, 0x0, 'TX_WRDELAY_1', 'This field is the same as TX_WRDELAY_0 above,
  but for the data lane 2.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_1', 'This field is the same as TX_RDDELAY_0 above,
  but for the data lane 2.');

register(0x088, 'REG_TX_DELAY_CONTROL_2');
field(0, 5, RW, 0x0, 'TX_WRDELAY_2', 'This field is the same as TX_WRDELAY_0 above,
  but for the data lane 3. It is unused in LVDS mode.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_2', 'This field is the same as TX_RDDELAY_0 above,
  but for the data lane 3. It is unused in LVDS mode.');

register(0x08c, 'REG_TX_DELAY_CONTROL_3');
field(0, 5, RW, 0x0, 'TX_WRDELAY_3', 'This field is the same as TX_WRDELAY_0 above,
  but for the data lane 4. It is unused in LVDS mode.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_3', 'This field is the same as TX_RDDELAY_0 above,
  but for the data lane 4. It is unused in LVDS mode.');

register(0x090, 'REG_TX_DELAY_CONTROL_S');
field(0, 5, RW, 0x0, 'TX_WRDELAY_S', 'This field is the same as TX_WRDELAY_0 above,
  but for the strobe lane.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_S', 'This field is the same as TX_RDDELAY_0 above,
  but for the strobe lane.');

register(0x094, 'REG_TX_DELAY_CONTROL_C');
field(0, 5, RW, 0x0, 'TX_WRDELAY_C', 'This field is the same as TX_WRDELAY_0 above,
  but for the clock lane.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_C', 'This field is the same as TX_RDDELAY_0 above,
  but for the clock lane.');

register(0x0a0, 'REG_TX_DELAY_CONTROL_INT_C');
field(0, 5, RW, 0x0, 'TX_WRDELAY_INT_C', 'This field is the same as TX_WRDELAY_0 above,
  but for the internal input clock lane.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_INT_C', 'This field is the same as TX_RDDELAY_0 above,
  but for the internal input clock lane.');

register(0x0a4, 'REG_TX_DELAY_CONTROL_EXT_C');
field(0, 5, RW, 0x0, 'TX_WRDELAY_EXT_C', 'This field is the same as TX_WRDELAY_0 above,
  but for the external input clock lane.');
field(8, 5, RO, 0x0, 'TX_RDDELAY_EXT_C', 'This field is the same as TX_RDDELAY_0 above,
  but for the external input clock lane.');

register(0x100, 'REG_TX_TIMER');
field(0, 32, RW, 0x0, 'TX_TIMER', 'General purpose timer register, this is a count
  down timer, software may write desired interval and wait for it to reach zero.
  The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

register(0x104, 'REG_TX_CLK_MON');
field(0, 32, RO, 0x0, 'TX_CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
  indicates a loss of clock. The format is 16.16 x 100MHz');

register(0x108, 'REG_TX_MCS_LATENCY');
field(0, 16, RO, 0x0, 'TX_MCS_LATENCY_COUNT', 'MCS to first strobe latency count in
  half the interface clock period.');

register(0x10c, 'REG_TX_MCS_SYNC');
field(0, 1, RW, 0x0, 'TX_MCS_SYNC', 'If set, enable MCS synchronization of
  transmit ssi interface, also note that self reset is disabled.');

register(0x110, 'REG_TX_MCS_ACTIVE');
field(0, 4, RW, 0x0, 'TX_MCS_ACTIVE', 'If MCS_SYNC is set, the SSI signals are
  ignored until the active MCS pulse is received.');

register(0x200, 'REG_TX_SW_RESET');
field(0, 1, RW1HC, 0x0, 'TX_SW_RESET', 'This bit allows reset of the transmit interface
  logic from the processor clock domain, its use is left to the driver.');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
