# axi\_adrv9001\_tx
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | tx\_cmos\_lvds\_id[31:0] | RO | 0x0 | An unambigous identifier indicates the current configuration of SSI interface. If configured as CMOS, this register reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53. |
| | | | | | |
| 0x4 | [6:4] | tx\_num\_of\_bits[2:0] | RW | 0x0 | This field must be set to the desired number of bits in a sample. It supports the following sample widths. 3b101: 64bits, (IQ) interface. 3b100: 32bits, (IQ) interface. 3b011: 24bits, (IQ) interface. 3b010: 16bits, (I) interface. 3b001: 8bits, (I) interface. 3b000: 2bits, (I) interface. |
| 0x4 | [8:8] | tx\_lstrb1\_pstrb0 | RW | 0x0 | This field must be set to the desired strobe type, It supports the following two modes. If set to 1 and is a two channel interface, a level strobe is asserted for the entire first channel. If this bit is set to 0, strobe is generated as a pulse, asserted only during the first clock cycle of the data frame. |
| 0x4 | [9:9] | tx\_mlane1\_slane0 | RW | 0x0 | This field must be set to the desired number of lanes (or lines) at the interface. If this bit is set to 0x1, the interface is a multiple lane (or line) interface. In CMOS mode this is 4 lines, in LVDS it is 2 lanes. If this bit is set to 0x0, it is a single lane (or line) interface. |
| 0x4 | [10:10] | tx\_sdr1\_ddr0 | RW | 0x0 | This field must be set to the desired clock type. If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be set carefully to match the device. The FPGA core supports SDR or DDR in all modes. |
| 0x4 | [11:11] | tx\_lsb1\_msb0 | RW | 0x0 | This field must be set to the desired bit order within the data frame. If set to 0x1, the samples are transmitted lsb first, otherwise msb first. |
| 0x4 | [12:12] | tx\_q1\_i0 | RW | 0x0 | This field must be set to the desired channel order within the data frame. If set to 0x1, the Q data is sent as the first sample, otherwise I data. |
| 0x4 | [14:14] | tx\_cmos1\_lvds0 | RO | 0x0 | This is a read-only bit indicating the current configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is in LVDS mode. The software is expected to qualify the remaining fields in this register based on the value read in this bit. |
| | | | | | |
| 0x8 | [0:0] | tx\_buf\_enable | RW | 0x0 | The core, by default, tri-states all the IO unless explicitly enabled by software. After a profile is loaded, this bit must be set to 0x1 to enable all the output buffers in both LVDS and CMOS mode |
| 0x8 | [1:1] | tx\_clk\_sel | RW | 0x0 | If this field is set, the transmit interface internal clock is sourced from the receive interface clock, otherwise, the transmit reference clock input sources the transmit interface internal clock. |
| 0x8 | [2:2] | tx\_clk\_msb | RW | 0x0 | The transmit interface clock output may be inverted by setting this field to 0x1, as it controls the MSB bit in the clock output. |
| | | | | | |
| 0xc | [0:0] | tx\_init | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates a reset request at the interface. This is self-cleared, it is recommended that software set this bit after a profile is loaded to ensure a clean start. |
| | | | | | |
| 0x20 | [3:0] | tx\_data\_sel[3:0] | RW | 0x0 | This field selects the transmit data source. The following are supported: 4b0000: DMA. 4b0001: Receive loop back. 4b0010: Zeros 4b0011: Pattern (see TX\_DATA\_PAT below). 4b0100: Nibble ramp 4b0101: Word ramp 4b0110: PRBS15 4b0111: PRBS7 4b1000: FS/8 tone @ -12 dBfs. |
| | | | | | |
| 0x30 | [31:0] | tx\_data\_pat[31:0] | RW | 0x0 | The data pattern transmitted at the interface. In non 32 bit modes, only the lower bits are used as per the NUM\_OF\_BITS field above. |
| | | | | | |
| 0x38 | [0:0] | tx\_data\_pat\_pulse | RW | 0x0 | If set, sends pattern as a pulse, pattern is inserted relative to MCS or software and may optionally be delayed. |
| 0x38 | [15:8] | tx\_data\_pat\_delay[7:0] | RW | 0x0 | The number in SSI clock cycles to delay the insertion of pattern if TX\_DATA\_PAT\_PULSE is set. |
| | | | | | |
| 0x3c | [0:0] | tx\_data\_pat\_ins | RW1HC | 0x0 | If set, pattern is inserted and hardware clears the bit after insertion of pattern. Note that pattern is inserted relative to MCS always. |
| | | | | | |
| 0x60 | [8:8] | tx\_lbovf | RW1C | 0x0 | This bit indicates an overflow in loop back. |
| 0x60 | [9:9] | tx\_lbunf | RW1C | 0x0 | This bit indicates an underflow in loop back. |
| | | | | | |
| 0x70 | [0:0] | tx\_delay\_unlocked | RO | 0x0 | If clear, this bit indicates the delay controller is locked and calibrated. A delay setting is not guaranteed if this bit is set. |
| | | | | | |
| 0x80 | [4:0] | tx\_wrdelay\_0[4:0] | RW | 0x0 | This field sets the IO delay value at the interface for data lane 1. The resolution is ~78ps. The range is 0 to 31. |
| 0x80 | [12:8] | tx\_rddelay\_0[4:0] | RO | 0x0 | This field indicates the current delay setting at the interface for data lane 1. If done correctly, the value read is the same as the TX\_WRDELAY. |
| | | | | | |
| 0x84 | [4:0] | tx\_wrdelay\_1[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the data lane 2. |
| 0x84 | [12:8] | tx\_rddelay\_1[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the data lane 2. |
| | | | | | |
| 0x88 | [4:0] | tx\_wrdelay\_2[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the data lane 3. It is unused in LVDS mode. |
| 0x88 | [12:8] | tx\_rddelay\_2[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the data lane 3. It is unused in LVDS mode. |
| | | | | | |
| 0x8c | [4:0] | tx\_wrdelay\_3[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the data lane 4. It is unused in LVDS mode. |
| 0x8c | [12:8] | tx\_rddelay\_3[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the data lane 4. It is unused in LVDS mode. |
| | | | | | |
| 0x90 | [4:0] | tx\_wrdelay\_s[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the strobe lane. |
| 0x90 | [12:8] | tx\_rddelay\_s[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the strobe lane. |
| | | | | | |
| 0x94 | [4:0] | tx\_wrdelay\_c[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the clock lane. |
| 0x94 | [12:8] | tx\_rddelay\_c[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the clock lane. |
| | | | | | |
| 0xa0 | [4:0] | tx\_wrdelay\_int\_c[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the internal input clock lane. |
| 0xa0 | [12:8] | tx\_rddelay\_int\_c[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the internal input clock lane. |
| | | | | | |
| 0xa4 | [4:0] | tx\_wrdelay\_ext\_c[4:0] | RW | 0x0 | This field is the same as TX\_WRDELAY\_0 above, but for the external input clock lane. |
| 0xa4 | [12:8] | tx\_rddelay\_ext\_c[4:0] | RO | 0x0 | This field is the same as TX\_RDDELAY\_0 above, but for the external input clock lane. |
| | | | | | |
| 0x100 | [31:0] | tx\_timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x104 | [31:0] | tx\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x108 | [15:0] | tx\_mcs\_latency\_count[15:0] | RO | 0x0 | MCS to first strobe latency count in half the interface clock period. |
| | | | | | |
| 0x10c | [0:0] | tx\_mcs\_sync | RW | 0x0 | If set, enable MCS synchronization of transmit ssi interface, also note that self reset is disabled. |
| | | | | | |
| 0x110 | [3:0] | tx\_mcs\_active[3:0] | RW | 0x0 | If MCS\_SYNC is set, the SSI signals are ignored until the active MCS pulse is received. |
| | | | | | |
| 0x200 | [0:0] | tx\_sw\_reset | RW1HC | 0x0 | This bit allows reset of the transmit interface logic from the processor clock domain, its use is left to the driver. |
| | | | | | |
---
