// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001, transmit interface (single channel)
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tx_if #(

  parameter GPIO2_CMOS1_LVDS0 = 0,
  parameter IODELAY_DEVICE = "NONE",
  parameter IODELAY_GROUP = "IODELAY_GROUP") (

  // system interface

  input   wire            tx_resetn,
  input   wire            tx_hs_clk,
  input   wire            tx_clk,
  input   wire  [  7:0]   tx_pdata,
  output  wire            tx_data_p,
  output  wire            tx_data_n,
  input   wire            tx_buf_enable,

  // axilite interface

  input   wire            axilite_resetn,
  input   wire            axilite_clk,
  input   wire  [  4:0]   axilite_delay_wrdata,
  output  wire  [  4:0]   axilite_delay_rddata);

  // internal registers
 
  reg                     axilite_delay_rdwr = 'd0;
  reg           [  4:0]   axilite_delay_wrdata_d = 'd0;
  reg                     tx_buf_disable = 'd0;

  // internal signals
 
  wire                    tx_ddata;
  wire                    tx_sdata;
  wire                    tx_tdata;

  // load delay value

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_delay_wrdata_d <= 5'd0;
      axilite_delay_rdwr <= 1'b0;
    end else begin
      axilite_delay_wrdata_d <= axilite_delay_wrdata;
      if (axilite_delay_wrdata_d == axilite_delay_wrdata) begin
        axilite_delay_rdwr <= 1'b0;
      end else begin
        axilite_delay_rdwr <= 1'b1;
      end
    end
  end

  always @(posedge tx_clk) begin
    tx_buf_disable <= ~tx_buf_enable;
  end

  // instantiations

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign tx_ddata = 1'd0;
  assign tx_tdata = 1'd0;

  end else begin

  OSERDESE2 #(
    .DATA_RATE_OQ           ("DDR"),
    .DATA_RATE_TQ           ("SDR"),
    .DATA_WIDTH             (8),
    .TRISTATE_WIDTH         (1),
    .SERDES_MODE            ("MASTER"))
  i_serdes (
    .CLK                    (tx_hs_clk),
    .CLKDIV                 (tx_clk),
    .RST                    (~tx_resetn),
    .D1                     (tx_pdata[7]),
    .D2                     (tx_pdata[6]),
    .D3                     (tx_pdata[5]),
    .D4                     (tx_pdata[4]),
    .D5                     (tx_pdata[3]),
    .D6                     (tx_pdata[2]),
    .D7                     (tx_pdata[1]),
    .D8                     (tx_pdata[0]),
    .OQ                     (tx_ddata),
    .T1                     (tx_buf_disable),
    .T2                     (tx_buf_disable),
    .T3                     (tx_buf_disable),
    .T4                     (tx_buf_disable),
    .TQ                     (tx_tdata),
    .OCE                    (1'b1),
    .TCE                    (1'b1),
    .TBYTEIN                (1'b0),
    .SHIFTIN1               (1'b0),
    .SHIFTIN2               (1'b0),
    .SHIFTOUT1              (),
    .SHIFTOUT2              (),
    .OFB                    (),
    .TFB                    (),
    .TBYTEOUT               ());

  end
  endgenerate

  // io delay
 
  generate
  if ((IODELAY_DEVICE == "NONE") || (GPIO2_CMOS1_LVDS0 == 2)) begin

  assign tx_sdata = tx_ddata;
  assign axilite_delay_rddata = 5'd0;

  end else begin

  (* IODELAY_GROUP = IODELAY_GROUP *)
  ODELAYE2 #(
    .CINVCTRL_SEL           ("FALSE"),
    .DELAY_SRC              ("ODATAIN"),
    .HIGH_PERFORMANCE_MODE  ("FALSE"),
    .ODELAY_TYPE            ("VAR_LOAD"),
    .ODELAY_VALUE           (0),
    .REFCLK_FREQUENCY       (200.0),
    .PIPE_SEL               ("FALSE"),
    .SIGNAL_PATTERN         ("DATA"))
  i_delay (
    .CE                     (1'b0),
    .INC                    (1'b0),
    .CLKIN                  (1'b0),
    .LDPIPEEN               (1'b0),
    .CINVCTRL               (1'b0),
    .REGRST                 (1'b0),
    .C                      (axilite_clk),
    .ODATAIN                (tx_ddata),
    .DATAOUT                (tx_sdata),
    .LD                     (axilite_delay_rdwr),
    .CNTVALUEIN             (axilite_delay_wrdata),
    .CNTVALUEOUT            (axilite_delay_rddata));

  end
  endgenerate

  // io buffer
 
  generate
  if (GPIO2_CMOS1_LVDS0 == 1) begin

  OBUFT i_obuf (
    .T                      (tx_tdata),
    .I                      (tx_sdata),
    .O                      (tx_data_p));

  assign tx_data_n = 1'bz;

  end else if (GPIO2_CMOS1_LVDS0 == 0) begin

  OBUFTDS i_obuf (
    .T                      (tx_tdata),
    .I                      (tx_sdata),
    .O                      (tx_data_p),
    .OB                     (tx_data_n));

  end else begin

  assign tx_data_p = 1'd0;
  assign tx_data_n = 1'd0;

  end
  endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
