// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001, transmit interface
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tx_clk #(

  parameter GPIO2_CMOS1_LVDS0 = 0,
  parameter IODELAY_DEVICE = "NONE",
  parameter IODELAY_GROUP = "IODELAY_GROUP") (

  // internal interface

  input   wire            rx_buf_clk,

  input   wire            tx_ref_clk_p,
  input   wire            tx_ref_clk_n,
  output  wire            tx_hs_clk,
  output  wire            tx_clk,

  output  wire            tx_clock_p,
  output  wire            tx_clock_n,

  // axi interface

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_cpu_resetn,
  input   wire  [  4:0]   axilite_wrdelay_int_c,
  output  wire  [  4:0]   axilite_rddelay_int_c,
  input   wire  [  4:0]   axilite_wrdelay_ext_c,
  output  wire  [  4:0]   axilite_rddelay_ext_c,
  input   wire  [  4:0]   axilite_wrdelay_c,
  output  wire  [  4:0]   axilite_rddelay_c,
  input   wire            axilite_buf_enable,
  input   wire            axilite_clk_enable,
  input   wire            axilite_clk_reset,
  input   wire            axilite_clk_msb,
  input   wire            axilite_clk_sel);

  // internal registers
 
  reg           [  7:0]   tx_pclock = 'd0;
  reg           [  4:0]   axilite_wrdelay_d_int_c = 'd0;
  reg                     axilite_lddelay_int_c = 'd0;
  reg           [  4:0]   axilite_wrdelay_d_ext_c = 'd0;
  reg                     axilite_lddelay_ext_c = 'd0;
  reg                     axilite_clk0_sel = 1'b1;
  reg                     axilite_clk1_sel = 1'b0;

  // internal signals
 
  wire                    tx_hs_mr_int_clk;
  wire                    tx_hs_delay_int_clk;
  wire                    tx_ls_ext_resetn;
  wire                    tx_ls_ext_buf_enable;
  wire                    tx_ls_ext_clk_msb;
  wire                    tx_ls_ext_clk;
  wire                    tx_hs_ext_clk;
  wire                    tx_hs_mr_ext_clk;
  wire                    tx_hs_delay_ext_clk;
  wire                    tx_hs_mux_clk;
  wire                    tx_hs_ref_clk;

  // clock

  always @(negedge tx_ls_ext_resetn or posedge tx_ls_ext_clk) begin
    if (tx_ls_ext_resetn == 1'b0) begin
      tx_pclock <= 8'd0;
    end else begin
      if (tx_ls_ext_clk_msb == 1'b0) begin
        tx_pclock <= 8'h55;
      end else begin
        tx_pclock <= 8'haa;
      end
    end
  end

  // internal delay

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrdelay_d_int_c <= 5'd0;
      axilite_lddelay_int_c <= 1'b0;
    end else begin
      axilite_wrdelay_d_int_c <= axilite_wrdelay_int_c;
      if (axilite_wrdelay_d_int_c == axilite_wrdelay_int_c) begin
        axilite_lddelay_int_c <= 1'b0;
      end else begin
        axilite_lddelay_int_c <= 1'b1;
      end
    end
  end

  // external delay
 
  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrdelay_d_ext_c <= 5'd0;
      axilite_lddelay_ext_c <= 1'b0;
    end else begin
      axilite_wrdelay_d_ext_c <= axilite_wrdelay_ext_c;
      if (axilite_wrdelay_d_ext_c == axilite_wrdelay_ext_c) begin
        axilite_lddelay_ext_c <= 1'b0;
      end else begin
        axilite_lddelay_ext_c <= 1'b1;
      end
    end
  end

  // clock mux control
 
  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_clk0_sel <= 1'b1;
      axilite_clk1_sel <= 1'b0;
    end else begin
      axilite_clk0_sel <= ~axilite_clk_sel;
      axilite_clk1_sel <= axilite_clk_sel;
    end
  end

  // instantiations

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign tx_clk = 1'd0;
  assign tx_hs_clk = 1'd0;
  assign tx_hs_mr_int_clk = 1'd0;
  assign tx_hs_delay_int_clk = 1'd0;
  assign axilite_rddelay_int_c = 5'd0;

  end else begin

  BUFR #(.BUFR_DIVIDE("4")) i_ls_int_clk (
    .CE                                     (1'b1),
    .CLR                                    (axilite_clk_reset),
    .I                                      (tx_hs_mr_int_clk),
    .O                                      (tx_clk));

  BUFIO i_int_clk (
    .I                                      (tx_hs_mr_int_clk),
    .O                                      (tx_hs_clk));

  BUFMRCE i_mr_int_clk (
    .CE                                     (axilite_clk_enable),
    .I                                      (tx_hs_delay_int_clk),
    .O                                      (tx_hs_mr_int_clk));

  (* IODELAY_GROUP = IODELAY_GROUP *)
  IDELAYE2 #(
    .CINVCTRL_SEL                           ("FALSE"),
    .DELAY_SRC                              ("DATAIN"),
    .HIGH_PERFORMANCE_MODE                  ("FALSE"),
    .IDELAY_TYPE                            ("VAR_LOAD"),
    .IDELAY_VALUE                           (0),
    .REFCLK_FREQUENCY                       (200.0),
    .PIPE_SEL                               ("FALSE"),
    .SIGNAL_PATTERN                         ("CLOCK"))
  i_delay_int_clk (
    .CE                                     (1'b0),
    .INC                                    (1'b0),
    .IDATAIN                                (1'b0),
    .LDPIPEEN                               (1'b0),
    .CINVCTRL                               (1'b0),
    .REGRST                                 (1'b0),
    .C                                      (axilite_clk),
    .DATAIN                                 (tx_hs_mux_clk),
    .DATAOUT                                (tx_hs_delay_int_clk),
    .LD                                     (axilite_lddelay_int_c),
    .CNTVALUEIN                             (axilite_wrdelay_int_c),
    .CNTVALUEOUT                            (axilite_rddelay_int_c));

  end
  endgenerate

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign tx_clock_p = 1'd0;
  assign tx_clock_n = 1'd0;
  assign axilite_rddelay_c = 5'd0;

  end else begin

  axi_adrv9001_tx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
    .IODELAY_DEVICE                         (IODELAY_DEVICE),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_pclock (
    .tx_resetn                              (tx_ls_ext_resetn),
    .tx_hs_clk                              (tx_hs_ext_clk),
    .tx_clk                                 (tx_ls_ext_clk),
    .tx_pdata                               (tx_pclock),
    .tx_data_p                              (tx_clock_p),
    .tx_data_n                              (tx_clock_n),
    .tx_buf_enable                          (tx_ls_ext_buf_enable),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_c),
    .axilite_delay_rddata                   (axilite_rddelay_c));

  end
  endgenerate

  cdc #(.DATA_WIDTH(3)) i_cdc (
    .src_data                               ({axilite_cpu_resetn,
                                              axilite_buf_enable,
                                              axilite_clk_msb}),
    .dest_resetn                            (1'b1),
    .dest_clk                               (tx_ls_ext_clk),
    .dest_data                              ({tx_ls_ext_resetn,
                                              tx_ls_ext_buf_enable,
                                              tx_ls_ext_clk_msb}));

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign tx_ls_ext_clk = 1'd0;
  assign tx_hs_ext_clk = 1'd0;
  assign tx_hs_mr_ext_clk = 1'd0;
  assign tx_hs_delay_ext_clk = 1'd0;
  assign axilite_rddelay_ext_c = 5'd0;

  end else begin

  BUFR #(.BUFR_DIVIDE("4")) i_ls_ext_clk (
    .CE                                     (1'b1),
    .CLR                                    (axilite_clk_reset),
    .I                                      (tx_hs_mr_ext_clk),
    .O                                      (tx_ls_ext_clk));

  BUFIO i_ext_clk (
    .I                                      (tx_hs_mr_ext_clk),
    .O                                      (tx_hs_ext_clk));

  BUFMRCE i_mr_ext_clk (
    .CE                                     (axilite_clk_enable),
    .I                                      (tx_hs_delay_ext_clk),
    .O                                      (tx_hs_mr_ext_clk));

  (* IODELAY_GROUP = IODELAY_GROUP *)
  IDELAYE2 #(
    .CINVCTRL_SEL                           ("FALSE"),
    .DELAY_SRC                              ("DATAIN"),
    .HIGH_PERFORMANCE_MODE                  ("FALSE"),
    .IDELAY_TYPE                            ("VAR_LOAD"),
    .IDELAY_VALUE                           (0),
    .REFCLK_FREQUENCY                       (200.0),
    .PIPE_SEL                               ("FALSE"),
    .SIGNAL_PATTERN                         ("CLOCK"))
  i_delay_ext_clk (
    .CE                                     (1'b0),
    .INC                                    (1'b0),
    .IDATAIN                                (1'b0),
    .LDPIPEEN                               (1'b0),
    .CINVCTRL                               (1'b0),
    .REGRST                                 (1'b0),
    .C                                      (axilite_clk),
    .DATAIN                                 (tx_hs_mux_clk),
    .DATAOUT                                (tx_hs_delay_ext_clk),
    .LD                                     (axilite_lddelay_ext_c),
    .CNTVALUEIN                             (axilite_wrdelay_ext_c),
    .CNTVALUEOUT                            (axilite_rddelay_ext_c));

  end
  endgenerate

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign tx_hs_mux_clk = 1'd0;

  end else begin

  BUFGCTRL i_mux_clk (
    .IGNORE0                                (1'b0),
    .IGNORE1                                (1'b0),
    .CE0                                    (1'b1),
    .CE1                                    (1'b1),
    .S0                                     (axilite_clk0_sel),
    .S1                                     (axilite_clk1_sel),
    .I0                                     (tx_hs_ref_clk),
    .I1                                     (rx_buf_clk),
    .O                                      (tx_hs_mux_clk));

  end
  endgenerate

  generate
  if (GPIO2_CMOS1_LVDS0 == 0) begin

  IBUFGDS i_ibuf (
    .I                                      (tx_ref_clk_p),
    .IB                                     (tx_ref_clk_n),
    .O                                      (tx_hs_ref_clk));

  end else if (GPIO2_CMOS1_LVDS0 == 1) begin

  IBUFG i_ibuf (
    .I                                      (tx_ref_clk_p),
    .O                                      (tx_hs_ref_clk));

  end else begin

  assign tx_hs_ref_clk = 1'd0;

  end
  endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
