// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tdd_regs #(parameter [3:0] ID = 0) (

  output  reg   [31:0]    axilite_frame_period = 'd0,
  output  reg   [31:0]    axilite_num_of_frames = 'd0,
  output  reg   [31:0]    axilite_frame_switch_period = 'd0,
  output  reg   [31:0]    axilite_frame_switch_number = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_0 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_1 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_2 = 'd0,
  output  reg   [ 2:0]    axilite_trigger_mode_3 = 'd0,
  output  reg             axilite_start = 'd0,
  input   wire            axilite_start_clr,
  output  reg             axilite_stop = 'd0,
  input   wire            axilite_stop_clr,
  output  reg             axilite_sequence_repeat = 'd0,
  output  reg             axilite_frame_switch_enable = 'd0,
  output  reg             axilite_swreset = 'd0,
  input   wire            axilite_swreset_clr,
  output  reg   [31:0]    axilite_timer = 'd0,
  input   wire  [31:0]    axilite_clk_mon_count,
  output  reg   [31:0]    axilite_rx0_device_primary_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_device_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_rx0_device_mode = 'd0,
  output  reg   [31:0]    axilite_tx0_device_primary_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_device_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_tx0_device_mode = 'd0,
  output  reg   [31:0]    axilite_rx1_device_primary_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_device_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_rx1_device_mode = 'd0,
  output  reg   [31:0]    axilite_tx1_device_primary_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_device_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_tx1_device_mode = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_orx0_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_orx1_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_aux0_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_aux0_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_aux1_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_aux1_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl0_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_ctl0_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl1_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_ctl1_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl2_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_ctl2_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_primary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_ctl3_gpio_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_ctl3_gpio_mode = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_primary_assert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_trig0_ext_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_trig0_ext_mode = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_primary_assert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_trig1_ext_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_trig1_ext_mode = 'd0,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [15:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [15:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);

  reg                     axilite_start_clr_d = 'd0;
  reg                     axilite_stop_clr_d = 'd0;
  reg                     axilite_swreset_clr_d = 'd0;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      if (axilite_wraddr[15:12] == ID) begin
        axilite_wrack <= axilite_wrreq;
      end else begin
        axilite_wrack <= 1'd0;
      end
      if (axilite_rdaddr[15:12] == ID) begin
        axilite_rdack <= axilite_rdreq;
      end else begin
        axilite_rdack <= 1'd0;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_frame_period <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h0)) begin
        axilite_frame_period <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_num_of_frames <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_num_of_frames <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_frame_switch_period <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8)) begin
        axilite_frame_switch_period <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_frame_switch_number <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc)) begin
        axilite_frame_switch_number <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_trigger_mode_0 <= axilite_wrdata[2:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_1 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_trigger_mode_1 <= axilite_wrdata[6:4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_2 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_trigger_mode_2 <= axilite_wrdata[10:8];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trigger_mode_3 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_trigger_mode_3 <= axilite_wrdata[14:12];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_start_clr_d <= 'd0;
      axilite_start <= 'h0;
    end else begin
      axilite_start_clr_d <= axilite_start_clr;
      if ((axilite_start_clr_d == 1'b0) && (axilite_start_clr == 1'b1)) begin
        axilite_start <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_start <= axilite_start | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_stop_clr_d <= 'd0;
      axilite_stop <= 'h0;
    end else begin
      axilite_stop_clr_d <= axilite_stop_clr;
      if ((axilite_stop_clr_d == 1'b0) && (axilite_stop_clr == 1'b1)) begin
        axilite_stop <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_stop <= axilite_stop | axilite_wrdata[1];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_sequence_repeat <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_sequence_repeat <= axilite_wrdata[2];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_frame_switch_enable <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_frame_switch_enable <= axilite_wrdata[3];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_swreset_clr_d <= 'd0;
      axilite_swreset <= 'h0;
    end else begin
      axilite_swreset_clr_d <= axilite_swreset_clr;
      if ((axilite_swreset_clr_d == 1'b0) && (axilite_swreset_clr == 1'b1)) begin
        axilite_swreset <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h24)) begin
        axilite_swreset <= axilite_swreset | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_timer <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h28)) begin
        axilite_timer <= axilite_wrdata;
      end else if (axilite_timer > 0) begin
        axilite_timer <= axilite_timer - 1'b1;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h100)) begin
        axilite_rx0_device_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h104)) begin
        axilite_rx0_device_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h108)) begin
        axilite_rx0_device_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
        axilite_rx0_device_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h110)) begin
        axilite_rx0_device_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h114)) begin
        axilite_rx0_device_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h118)) begin
        axilite_rx0_device_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h11c)) begin
        axilite_rx0_device_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_device_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h120)) begin
        axilite_rx0_device_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h200)) begin
        axilite_tx0_device_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
        axilite_tx0_device_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h208)) begin
        axilite_tx0_device_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20c)) begin
        axilite_tx0_device_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h210)) begin
        axilite_tx0_device_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h214)) begin
        axilite_tx0_device_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h218)) begin
        axilite_tx0_device_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h21c)) begin
        axilite_tx0_device_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_device_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h220)) begin
        axilite_tx0_device_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h300)) begin
        axilite_rx1_device_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h304)) begin
        axilite_rx1_device_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h308)) begin
        axilite_rx1_device_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h30c)) begin
        axilite_rx1_device_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h310)) begin
        axilite_rx1_device_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h314)) begin
        axilite_rx1_device_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h318)) begin
        axilite_rx1_device_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h31c)) begin
        axilite_rx1_device_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_device_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h320)) begin
        axilite_rx1_device_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h400)) begin
        axilite_tx1_device_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h404)) begin
        axilite_tx1_device_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h408)) begin
        axilite_tx1_device_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h40c)) begin
        axilite_tx1_device_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h410)) begin
        axilite_tx1_device_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h414)) begin
        axilite_tx1_device_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h418)) begin
        axilite_tx1_device_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h41c)) begin
        axilite_tx1_device_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_device_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h420)) begin
        axilite_tx1_device_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h500)) begin
        axilite_orx0_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h504)) begin
        axilite_orx0_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h508)) begin
        axilite_orx0_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h50c)) begin
        axilite_orx0_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h510)) begin
        axilite_orx0_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h514)) begin
        axilite_orx0_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h518)) begin
        axilite_orx0_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h51c)) begin
        axilite_orx0_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h520)) begin
        axilite_orx0_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h600)) begin
        axilite_orx1_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h604)) begin
        axilite_orx1_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h608)) begin
        axilite_orx1_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60c)) begin
        axilite_orx1_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h610)) begin
        axilite_orx1_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h614)) begin
        axilite_orx1_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h618)) begin
        axilite_orx1_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h61c)) begin
        axilite_orx1_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h620)) begin
        axilite_orx1_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h700)) begin
        axilite_aux0_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h704)) begin
        axilite_aux0_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h708)) begin
        axilite_aux0_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h70c)) begin
        axilite_aux0_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h710)) begin
        axilite_aux0_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h714)) begin
        axilite_aux0_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h718)) begin
        axilite_aux0_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h71c)) begin
        axilite_aux0_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux0_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h720)) begin
        axilite_aux0_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h800)) begin
        axilite_aux1_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h804)) begin
        axilite_aux1_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h808)) begin
        axilite_aux1_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h80c)) begin
        axilite_aux1_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h810)) begin
        axilite_aux1_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h814)) begin
        axilite_aux1_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h818)) begin
        axilite_aux1_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h81c)) begin
        axilite_aux1_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_aux1_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h820)) begin
        axilite_aux1_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h900)) begin
        axilite_ctl0_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h904)) begin
        axilite_ctl0_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h908)) begin
        axilite_ctl0_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90c)) begin
        axilite_ctl0_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h910)) begin
        axilite_ctl0_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h914)) begin
        axilite_ctl0_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h918)) begin
        axilite_ctl0_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h91c)) begin
        axilite_ctl0_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl0_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h920)) begin
        axilite_ctl0_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha00)) begin
        axilite_ctl1_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha04)) begin
        axilite_ctl1_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha08)) begin
        axilite_ctl1_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha0c)) begin
        axilite_ctl1_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha10)) begin
        axilite_ctl1_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha14)) begin
        axilite_ctl1_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha18)) begin
        axilite_ctl1_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha1c)) begin
        axilite_ctl1_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl1_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'ha20)) begin
        axilite_ctl1_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb00)) begin
        axilite_ctl2_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb04)) begin
        axilite_ctl2_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb08)) begin
        axilite_ctl2_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb0c)) begin
        axilite_ctl2_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb10)) begin
        axilite_ctl2_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb14)) begin
        axilite_ctl2_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb18)) begin
        axilite_ctl2_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb1c)) begin
        axilite_ctl2_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl2_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hb20)) begin
        axilite_ctl2_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc00)) begin
        axilite_ctl3_gpio_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc04)) begin
        axilite_ctl3_gpio_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc08)) begin
        axilite_ctl3_gpio_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc0c)) begin
        axilite_ctl3_gpio_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc10)) begin
        axilite_ctl3_gpio_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc14)) begin
        axilite_ctl3_gpio_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc18)) begin
        axilite_ctl3_gpio_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc1c)) begin
        axilite_ctl3_gpio_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_ctl3_gpio_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc20)) begin
        axilite_ctl3_gpio_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd00)) begin
        axilite_trig0_ext_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd04)) begin
        axilite_trig0_ext_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd08)) begin
        axilite_trig0_ext_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd0c)) begin
        axilite_trig0_ext_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd10)) begin
        axilite_trig0_ext_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd14)) begin
        axilite_trig0_ext_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd18)) begin
        axilite_trig0_ext_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd1c)) begin
        axilite_trig0_ext_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig0_ext_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hd20)) begin
        axilite_trig0_ext_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he00)) begin
        axilite_trig1_ext_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he04)) begin
        axilite_trig1_ext_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he08)) begin
        axilite_trig1_ext_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he0c)) begin
        axilite_trig1_ext_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he10)) begin
        axilite_trig1_ext_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he14)) begin
        axilite_trig1_ext_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he18)) begin
        axilite_trig1_ext_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he1c)) begin
        axilite_trig1_ext_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig1_ext_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'he20)) begin
        axilite_trig1_ext_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
        case (axilite_rdaddr[11:0])
          'h0: begin
            axilite_rddata <= axilite_frame_period;
          end
          'h4: begin
            axilite_rddata <= axilite_num_of_frames;
          end
          'h8: begin
            axilite_rddata <= axilite_frame_switch_period;
          end
          'hc: begin
            axilite_rddata <= axilite_frame_switch_number;
          end
          'h10: begin
            axilite_rddata[2:0] <= axilite_trigger_mode_0;
            axilite_rddata[3] <= 'd0;
            axilite_rddata[6:4] <= axilite_trigger_mode_1;
            axilite_rddata[7] <= 'd0;
            axilite_rddata[10:8] <= axilite_trigger_mode_2;
            axilite_rddata[11] <= 'd0;
            axilite_rddata[14:12] <= axilite_trigger_mode_3;
            axilite_rddata[31:15] <= 'd0;
          end
          'h20: begin
            axilite_rddata[0] <= axilite_start;
            axilite_rddata[1] <= axilite_stop;
            axilite_rddata[2] <= axilite_sequence_repeat;
            axilite_rddata[3] <= axilite_frame_switch_enable;
            axilite_rddata[31:4] <= 'd0;
          end
          'h24: begin
            axilite_rddata[0] <= axilite_swreset;
            axilite_rddata[31:1] <= 'd0;
          end
          'h28: begin
            axilite_rddata <= axilite_timer;
          end
          'h30: begin
            axilite_rddata <= axilite_clk_mon_count;
          end
          'h100: begin
            axilite_rddata <= axilite_rx0_device_primary_assert;
          end
          'h104: begin
            axilite_rddata <= axilite_rx0_device_primary_deassert;
          end
          'h108: begin
            axilite_rddata <= axilite_rx0_device_secondary_assert;
          end
          'h10c: begin
            axilite_rddata <= axilite_rx0_device_secondary_deassert;
          end
          'h110: begin
            axilite_rddata <= axilite_rx0_device_primary_frame_assert;
          end
          'h114: begin
            axilite_rddata <= axilite_rx0_device_primary_frame_deassert;
          end
          'h118: begin
            axilite_rddata <= axilite_rx0_device_secondary_frame_assert;
          end
          'h11c: begin
            axilite_rddata <= axilite_rx0_device_secondary_frame_deassert;
          end
          'h120: begin
            axilite_rddata[1:0] <= axilite_rx0_device_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h200: begin
            axilite_rddata <= axilite_tx0_device_primary_assert;
          end
          'h204: begin
            axilite_rddata <= axilite_tx0_device_primary_deassert;
          end
          'h208: begin
            axilite_rddata <= axilite_tx0_device_secondary_assert;
          end
          'h20c: begin
            axilite_rddata <= axilite_tx0_device_secondary_deassert;
          end
          'h210: begin
            axilite_rddata <= axilite_tx0_device_primary_frame_assert;
          end
          'h214: begin
            axilite_rddata <= axilite_tx0_device_primary_frame_deassert;
          end
          'h218: begin
            axilite_rddata <= axilite_tx0_device_secondary_frame_assert;
          end
          'h21c: begin
            axilite_rddata <= axilite_tx0_device_secondary_frame_deassert;
          end
          'h220: begin
            axilite_rddata[1:0] <= axilite_tx0_device_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h300: begin
            axilite_rddata <= axilite_rx1_device_primary_assert;
          end
          'h304: begin
            axilite_rddata <= axilite_rx1_device_primary_deassert;
          end
          'h308: begin
            axilite_rddata <= axilite_rx1_device_secondary_assert;
          end
          'h30c: begin
            axilite_rddata <= axilite_rx1_device_secondary_deassert;
          end
          'h310: begin
            axilite_rddata <= axilite_rx1_device_primary_frame_assert;
          end
          'h314: begin
            axilite_rddata <= axilite_rx1_device_primary_frame_deassert;
          end
          'h318: begin
            axilite_rddata <= axilite_rx1_device_secondary_frame_assert;
          end
          'h31c: begin
            axilite_rddata <= axilite_rx1_device_secondary_frame_deassert;
          end
          'h320: begin
            axilite_rddata[1:0] <= axilite_rx1_device_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h400: begin
            axilite_rddata <= axilite_tx1_device_primary_assert;
          end
          'h404: begin
            axilite_rddata <= axilite_tx1_device_primary_deassert;
          end
          'h408: begin
            axilite_rddata <= axilite_tx1_device_secondary_assert;
          end
          'h40c: begin
            axilite_rddata <= axilite_tx1_device_secondary_deassert;
          end
          'h410: begin
            axilite_rddata <= axilite_tx1_device_primary_frame_assert;
          end
          'h414: begin
            axilite_rddata <= axilite_tx1_device_primary_frame_deassert;
          end
          'h418: begin
            axilite_rddata <= axilite_tx1_device_secondary_frame_assert;
          end
          'h41c: begin
            axilite_rddata <= axilite_tx1_device_secondary_frame_deassert;
          end
          'h420: begin
            axilite_rddata[1:0] <= axilite_tx1_device_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h500: begin
            axilite_rddata <= axilite_orx0_gpio_primary_assert;
          end
          'h504: begin
            axilite_rddata <= axilite_orx0_gpio_primary_deassert;
          end
          'h508: begin
            axilite_rddata <= axilite_orx0_gpio_secondary_assert;
          end
          'h50c: begin
            axilite_rddata <= axilite_orx0_gpio_secondary_deassert;
          end
          'h510: begin
            axilite_rddata <= axilite_orx0_gpio_primary_frame_assert;
          end
          'h514: begin
            axilite_rddata <= axilite_orx0_gpio_primary_frame_deassert;
          end
          'h518: begin
            axilite_rddata <= axilite_orx0_gpio_secondary_frame_assert;
          end
          'h51c: begin
            axilite_rddata <= axilite_orx0_gpio_secondary_frame_deassert;
          end
          'h520: begin
            axilite_rddata[1:0] <= axilite_orx0_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h600: begin
            axilite_rddata <= axilite_orx1_gpio_primary_assert;
          end
          'h604: begin
            axilite_rddata <= axilite_orx1_gpio_primary_deassert;
          end
          'h608: begin
            axilite_rddata <= axilite_orx1_gpio_secondary_assert;
          end
          'h60c: begin
            axilite_rddata <= axilite_orx1_gpio_secondary_deassert;
          end
          'h610: begin
            axilite_rddata <= axilite_orx1_gpio_primary_frame_assert;
          end
          'h614: begin
            axilite_rddata <= axilite_orx1_gpio_primary_frame_deassert;
          end
          'h618: begin
            axilite_rddata <= axilite_orx1_gpio_secondary_frame_assert;
          end
          'h61c: begin
            axilite_rddata <= axilite_orx1_gpio_secondary_frame_deassert;
          end
          'h620: begin
            axilite_rddata[1:0] <= axilite_orx1_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h700: begin
            axilite_rddata <= axilite_aux0_gpio_primary_assert;
          end
          'h704: begin
            axilite_rddata <= axilite_aux0_gpio_primary_deassert;
          end
          'h708: begin
            axilite_rddata <= axilite_aux0_gpio_secondary_assert;
          end
          'h70c: begin
            axilite_rddata <= axilite_aux0_gpio_secondary_deassert;
          end
          'h710: begin
            axilite_rddata <= axilite_aux0_gpio_primary_frame_assert;
          end
          'h714: begin
            axilite_rddata <= axilite_aux0_gpio_primary_frame_deassert;
          end
          'h718: begin
            axilite_rddata <= axilite_aux0_gpio_secondary_frame_assert;
          end
          'h71c: begin
            axilite_rddata <= axilite_aux0_gpio_secondary_frame_deassert;
          end
          'h720: begin
            axilite_rddata[1:0] <= axilite_aux0_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h800: begin
            axilite_rddata <= axilite_aux1_gpio_primary_assert;
          end
          'h804: begin
            axilite_rddata <= axilite_aux1_gpio_primary_deassert;
          end
          'h808: begin
            axilite_rddata <= axilite_aux1_gpio_secondary_assert;
          end
          'h80c: begin
            axilite_rddata <= axilite_aux1_gpio_secondary_deassert;
          end
          'h810: begin
            axilite_rddata <= axilite_aux1_gpio_primary_frame_assert;
          end
          'h814: begin
            axilite_rddata <= axilite_aux1_gpio_primary_frame_deassert;
          end
          'h818: begin
            axilite_rddata <= axilite_aux1_gpio_secondary_frame_assert;
          end
          'h81c: begin
            axilite_rddata <= axilite_aux1_gpio_secondary_frame_deassert;
          end
          'h820: begin
            axilite_rddata[1:0] <= axilite_aux1_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h900: begin
            axilite_rddata <= axilite_ctl0_gpio_primary_assert;
          end
          'h904: begin
            axilite_rddata <= axilite_ctl0_gpio_primary_deassert;
          end
          'h908: begin
            axilite_rddata <= axilite_ctl0_gpio_secondary_assert;
          end
          'h90c: begin
            axilite_rddata <= axilite_ctl0_gpio_secondary_deassert;
          end
          'h910: begin
            axilite_rddata <= axilite_ctl0_gpio_primary_frame_assert;
          end
          'h914: begin
            axilite_rddata <= axilite_ctl0_gpio_primary_frame_deassert;
          end
          'h918: begin
            axilite_rddata <= axilite_ctl0_gpio_secondary_frame_assert;
          end
          'h91c: begin
            axilite_rddata <= axilite_ctl0_gpio_secondary_frame_deassert;
          end
          'h920: begin
            axilite_rddata[1:0] <= axilite_ctl0_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'ha00: begin
            axilite_rddata <= axilite_ctl1_gpio_primary_assert;
          end
          'ha04: begin
            axilite_rddata <= axilite_ctl1_gpio_primary_deassert;
          end
          'ha08: begin
            axilite_rddata <= axilite_ctl1_gpio_secondary_assert;
          end
          'ha0c: begin
            axilite_rddata <= axilite_ctl1_gpio_secondary_deassert;
          end
          'ha10: begin
            axilite_rddata <= axilite_ctl1_gpio_primary_frame_assert;
          end
          'ha14: begin
            axilite_rddata <= axilite_ctl1_gpio_primary_frame_deassert;
          end
          'ha18: begin
            axilite_rddata <= axilite_ctl1_gpio_secondary_frame_assert;
          end
          'ha1c: begin
            axilite_rddata <= axilite_ctl1_gpio_secondary_frame_deassert;
          end
          'ha20: begin
            axilite_rddata[1:0] <= axilite_ctl1_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'hb00: begin
            axilite_rddata <= axilite_ctl2_gpio_primary_assert;
          end
          'hb04: begin
            axilite_rddata <= axilite_ctl2_gpio_primary_deassert;
          end
          'hb08: begin
            axilite_rddata <= axilite_ctl2_gpio_secondary_assert;
          end
          'hb0c: begin
            axilite_rddata <= axilite_ctl2_gpio_secondary_deassert;
          end
          'hb10: begin
            axilite_rddata <= axilite_ctl2_gpio_primary_frame_assert;
          end
          'hb14: begin
            axilite_rddata <= axilite_ctl2_gpio_primary_frame_deassert;
          end
          'hb18: begin
            axilite_rddata <= axilite_ctl2_gpio_secondary_frame_assert;
          end
          'hb1c: begin
            axilite_rddata <= axilite_ctl2_gpio_secondary_frame_deassert;
          end
          'hb20: begin
            axilite_rddata[1:0] <= axilite_ctl2_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'hc00: begin
            axilite_rddata <= axilite_ctl3_gpio_primary_assert;
          end
          'hc04: begin
            axilite_rddata <= axilite_ctl3_gpio_primary_deassert;
          end
          'hc08: begin
            axilite_rddata <= axilite_ctl3_gpio_secondary_assert;
          end
          'hc0c: begin
            axilite_rddata <= axilite_ctl3_gpio_secondary_deassert;
          end
          'hc10: begin
            axilite_rddata <= axilite_ctl3_gpio_primary_frame_assert;
          end
          'hc14: begin
            axilite_rddata <= axilite_ctl3_gpio_primary_frame_deassert;
          end
          'hc18: begin
            axilite_rddata <= axilite_ctl3_gpio_secondary_frame_assert;
          end
          'hc1c: begin
            axilite_rddata <= axilite_ctl3_gpio_secondary_frame_deassert;
          end
          'hc20: begin
            axilite_rddata[1:0] <= axilite_ctl3_gpio_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'hd00: begin
            axilite_rddata <= axilite_trig0_ext_primary_assert;
          end
          'hd04: begin
            axilite_rddata <= axilite_trig0_ext_primary_deassert;
          end
          'hd08: begin
            axilite_rddata <= axilite_trig0_ext_secondary_assert;
          end
          'hd0c: begin
            axilite_rddata <= axilite_trig0_ext_secondary_deassert;
          end
          'hd10: begin
            axilite_rddata <= axilite_trig0_ext_primary_frame_assert;
          end
          'hd14: begin
            axilite_rddata <= axilite_trig0_ext_primary_frame_deassert;
          end
          'hd18: begin
            axilite_rddata <= axilite_trig0_ext_secondary_frame_assert;
          end
          'hd1c: begin
            axilite_rddata <= axilite_trig0_ext_secondary_frame_deassert;
          end
          'hd20: begin
            axilite_rddata[1:0] <= axilite_trig0_ext_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'he00: begin
            axilite_rddata <= axilite_trig1_ext_primary_assert;
          end
          'he04: begin
            axilite_rddata <= axilite_trig1_ext_primary_deassert;
          end
          'he08: begin
            axilite_rddata <= axilite_trig1_ext_secondary_assert;
          end
          'he0c: begin
            axilite_rddata <= axilite_trig1_ext_secondary_deassert;
          end
          'he10: begin
            axilite_rddata <= axilite_trig1_ext_primary_frame_assert;
          end
          'he14: begin
            axilite_rddata <= axilite_trig1_ext_primary_frame_deassert;
          end
          'he18: begin
            axilite_rddata <= axilite_trig1_ext_secondary_frame_assert;
          end
          'he1c: begin
            axilite_rddata <= axilite_trig1_ext_secondary_frame_deassert;
          end
          'he20: begin
            axilite_rddata[1:0] <= axilite_trig1_ext_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
