# axi\_adrv9001\_tdd
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | frame\_period[31:0] | RW | 0x0 | The number of clock cycles in the TDD frame |
| | | | | | |
| 0x4 | [31:0] | num\_of\_frames[31:0] | RW | 0x0 | The number of frames in the TDD sequence |
| | | | | | |
| 0x8 | [31:0] | frame\_switch\_period[31:0] | RW | 0x0 | The clock cycles value for premature termination of the current frame. |
| | | | | | |
| 0xc | [31:0] | frame\_switch\_number[31:0] | RW | 0x0 | The frame number for premature termination of the current clock count. This will be a shortened sequence. |
| | | | | | |
| 0x10 | [2:0] | trigger\_mode\_0[2:0] | RW | 0x0 | The start of a TDD sequence may optionally be synchronized to the hardware events. There are four trigger inputs, these bits controls each of the trigger inputs independently. 0x0: This trigger source is disabled or ignored. 0x4: TDD is started at the rising edge of this trigger input. 0x5: TDD is started at the falling edge of this trigger input. 0x6: TDD is started at any edge of this trigger input. |
| 0x10 | [6:4] | trigger\_mode\_1[2:0] | RW | 0x0 | The same as above for trigger input 1 |
| 0x10 | [10:8] | trigger\_mode\_2[2:0] | RW | 0x0 | The same as above for trigger input 2 |
| 0x10 | [14:12] | trigger\_mode\_3[2:0] | RW | 0x0 | The same as above for trigger input 3 |
| | | | | | |
| 0x20 | [0:0] | start | RW1HC | 0x0 | If set, indicates a request to start the TDD sequence, all sequence parameters above must be programmed first before setting this bit. Hardware clears this bit once the sequence is completed OR a stop request is initiated. |
| 0x20 | [1:1] | stop | RW1HC | 0x0 | If set, indicates a request to stop the current sequence, Hardware clears this bit once the sequence is stopped. |
| 0x20 | [2:2] | sequence\_repeat | RW | 0x0 | If set, the current sequence is repeated until a STOP request is received. |
| 0x20 | [3:3] | frame\_switch\_enable | RW | 0x0 | If set, a sequence is shortened and the set frame is prematurely terminated. |
| | | | | | |
| 0x24 | [0:0] | swreset | RW1HC | 0x0 | If set, the counters are reset. Hardware clears this bit once the internal reset is completed. |
| | | | | | |
| 0x28 | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x30 | [31:0] | clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x100 | [31:0] | rx0\_device\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the RX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x104 | [31:0] | rx0\_device\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the RX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x108 | [31:0] | rx0\_device\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the RX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x10c | [31:0] | rx0\_device\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the RX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x110 | [31:0] | rx0\_device\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the RX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x114 | [31:0] | rx0\_device\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the RX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x118 | [31:0] | rx0\_device\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the RX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x11c | [31:0] | rx0\_device\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the RX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x120 | [1:0] | rx0\_device\_mode[1:0] | RW | 0x0 | The software control of RX0\_DEVICE\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x200 | [31:0] | tx0\_device\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the TX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x204 | [31:0] | tx0\_device\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the TX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x208 | [31:0] | tx0\_device\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the TX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x20c | [31:0] | tx0\_device\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the TX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x210 | [31:0] | tx0\_device\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x214 | [31:0] | tx0\_device\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x218 | [31:0] | tx0\_device\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TX0\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x21c | [31:0] | tx0\_device\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TX0\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x220 | [1:0] | tx0\_device\_mode[1:0] | RW | 0x0 | The software control of TX0\_DEVICE\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x300 | [31:0] | rx1\_device\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the RX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x304 | [31:0] | rx1\_device\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the RX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x308 | [31:0] | rx1\_device\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the RX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x30c | [31:0] | rx1\_device\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the RX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x310 | [31:0] | rx1\_device\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the RX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x314 | [31:0] | rx1\_device\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the RX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x318 | [31:0] | rx1\_device\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the RX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x31c | [31:0] | rx1\_device\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the RX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x320 | [1:0] | rx1\_device\_mode[1:0] | RW | 0x0 | The software control of RX1\_DEVICE\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x400 | [31:0] | tx1\_device\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the TX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x404 | [31:0] | tx1\_device\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the TX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x408 | [31:0] | tx1\_device\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the TX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x40c | [31:0] | tx1\_device\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the TX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x410 | [31:0] | tx1\_device\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x414 | [31:0] | tx1\_device\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x418 | [31:0] | tx1\_device\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TX1\_DEVICE\_ENABLE signal is asserted high. |
| | | | | | |
| 0x41c | [31:0] | tx1\_device\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TX1\_DEVICE\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x420 | [1:0] | tx1\_device\_mode[1:0] | RW | 0x0 | The software control of TX1\_DEVICE\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x500 | [31:0] | orx0\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the ORX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x504 | [31:0] | orx0\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the ORX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x508 | [31:0] | orx0\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the ORX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x50c | [31:0] | orx0\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the ORX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x510 | [31:0] | orx0\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the ORX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x514 | [31:0] | orx0\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the ORX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x518 | [31:0] | orx0\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the ORX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x51c | [31:0] | orx0\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the ORX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x520 | [1:0] | orx0\_gpio\_mode[1:0] | RW | 0x0 | The software control of ORX0\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x600 | [31:0] | orx1\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the ORX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x604 | [31:0] | orx1\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the ORX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x608 | [31:0] | orx1\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the ORX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x60c | [31:0] | orx1\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the ORX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x610 | [31:0] | orx1\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the ORX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x614 | [31:0] | orx1\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the ORX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x618 | [31:0] | orx1\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the ORX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x61c | [31:0] | orx1\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the ORX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x620 | [1:0] | orx1\_gpio\_mode[1:0] | RW | 0x0 | The software control of ORX1\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x700 | [31:0] | aux0\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the AUX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x704 | [31:0] | aux0\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the AUX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x708 | [31:0] | aux0\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the AUX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x70c | [31:0] | aux0\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the AUX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x710 | [31:0] | aux0\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the AUX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x714 | [31:0] | aux0\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the AUX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x718 | [31:0] | aux0\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the AUX0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x71c | [31:0] | aux0\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the AUX0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x720 | [1:0] | aux0\_gpio\_mode[1:0] | RW | 0x0 | The software control of AUX0\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x800 | [31:0] | aux1\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the AUX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x804 | [31:0] | aux1\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the AUX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x808 | [31:0] | aux1\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the AUX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x80c | [31:0] | aux1\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the AUX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x810 | [31:0] | aux1\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the AUX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x814 | [31:0] | aux1\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the AUX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x818 | [31:0] | aux1\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the AUX1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x81c | [31:0] | aux1\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the AUX1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x820 | [1:0] | aux1\_gpio\_mode[1:0] | RW | 0x0 | The software control of AUX1\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0x900 | [31:0] | ctl0\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x904 | [31:0] | ctl0\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x908 | [31:0] | ctl0\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x90c | [31:0] | ctl0\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x910 | [31:0] | ctl0\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x914 | [31:0] | ctl0\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x918 | [31:0] | ctl0\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL0\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0x91c | [31:0] | ctl0\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL0\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0x920 | [1:0] | ctl0\_gpio\_mode[1:0] | RW | 0x0 | The software control of CTL0\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0xa00 | [31:0] | ctl1\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xa04 | [31:0] | ctl1\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xa08 | [31:0] | ctl1\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xa0c | [31:0] | ctl1\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xa10 | [31:0] | ctl1\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xa14 | [31:0] | ctl1\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xa18 | [31:0] | ctl1\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL1\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xa1c | [31:0] | ctl1\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL1\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xa20 | [1:0] | ctl1\_gpio\_mode[1:0] | RW | 0x0 | The software control of CTL1\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0xb00 | [31:0] | ctl2\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL2\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xb04 | [31:0] | ctl2\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL2\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xb08 | [31:0] | ctl2\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL2\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xb0c | [31:0] | ctl2\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL2\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xb10 | [31:0] | ctl2\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL2\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xb14 | [31:0] | ctl2\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL2\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xb18 | [31:0] | ctl2\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL2\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xb1c | [31:0] | ctl2\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL2\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xb20 | [1:0] | ctl2\_gpio\_mode[1:0] | RW | 0x0 | The software control of CTL2\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0xc00 | [31:0] | ctl3\_gpio\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL3\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xc04 | [31:0] | ctl3\_gpio\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL3\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xc08 | [31:0] | ctl3\_gpio\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the CTL3\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xc0c | [31:0] | ctl3\_gpio\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the CTL3\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xc10 | [31:0] | ctl3\_gpio\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL3\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xc14 | [31:0] | ctl3\_gpio\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL3\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xc18 | [31:0] | ctl3\_gpio\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the CTL3\_GPIO\_ENABLE signal is asserted high. |
| | | | | | |
| 0xc1c | [31:0] | ctl3\_gpio\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the CTL3\_GPIO\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xc20 | [1:0] | ctl3\_gpio\_mode[1:0] | RW | 0x0 | The software control of CTL3\_GPIO\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0xd00 | [31:0] | trig0\_ext\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the TRIG0\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xd04 | [31:0] | trig0\_ext\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the TRIG0\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xd08 | [31:0] | trig0\_ext\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the TRIG0\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xd0c | [31:0] | trig0\_ext\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the TRIG0\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xd10 | [31:0] | trig0\_ext\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TRIG0\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xd14 | [31:0] | trig0\_ext\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TRIG0\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xd18 | [31:0] | trig0\_ext\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TRIG0\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xd1c | [31:0] | trig0\_ext\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TRIG0\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xd20 | [1:0] | trig0\_ext\_mode[1:0] | RW | 0x0 | The software control of TRIG0\_EXT\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
| 0xe00 | [31:0] | trig1\_ext\_primary\_assert[31:0] | RW | 0x0 | The clock count at which the TRIG1\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xe04 | [31:0] | trig1\_ext\_primary\_deassert[31:0] | RW | 0x0 | The clock count at which the TRIG1\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xe08 | [31:0] | trig1\_ext\_secondary\_assert[31:0] | RW | 0x0 | The clock count at which the TRIG1\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xe0c | [31:0] | trig1\_ext\_secondary\_deassert[31:0] | RW | 0x0 | The clock count at which the TRIG1\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xe10 | [31:0] | trig1\_ext\_primary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TRIG1\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xe14 | [31:0] | trig1\_ext\_primary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TRIG1\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xe18 | [31:0] | trig1\_ext\_secondary\_frame\_assert[31:0] | RW | 0x0 | The frame count at which the TRIG1\_EXT\_ENABLE signal is asserted high. |
| | | | | | |
| 0xe1c | [31:0] | trig1\_ext\_secondary\_frame\_deassert[31:0] | RW | 0x0 | The frame count at which the TRIG1\_EXT\_ENABLE signal is deasserted low. |
| | | | | | |
| 0xe20 | [1:0] | trig1\_ext\_mode[1:0] | RW | 0x0 | The software control of TRIG1\_EXT\_ENABLE signal. 2b00: Software mode, enable is deasserted (low). 2b01: Software mode, enable is asserted (high). 2b1x: Hardware mode, enable is controlled by counters above. |
| | | | | | |
---
