// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tdd_dma_regs #(parameter [3:0] ID = 0) (

  output  reg   [31:0]    axilite_rx0_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx0_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_rx0_dma_mode = 'd0,
  output  reg             axilite_rx0_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_rx0_dma_clk_ratio,
  output  reg   [31:0]    axilite_tx0_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx0_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_tx0_dma_mode = 'd0,
  output  reg             axilite_tx0_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_tx0_dma_clk_ratio,
  output  reg   [31:0]    axilite_rx1_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_rx1_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_rx1_dma_mode = 'd0,
  output  reg             axilite_rx1_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_rx1_dma_clk_ratio,
  output  reg   [31:0]    axilite_tx1_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_tx1_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_tx1_dma_mode = 'd0,
  output  reg             axilite_tx1_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_tx1_dma_clk_ratio,
  output  reg   [31:0]    axilite_orx0_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx0_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_orx0_dma_mode = 'd0,
  output  reg             axilite_orx0_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_orx0_dma_clk_ratio,
  output  reg   [31:0]    axilite_orx1_dma_primary_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_primary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_secondary_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_secondary_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_primary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_primary_frame_deassert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_secondary_frame_assert = 'd0,
  output  reg   [31:0]    axilite_orx1_dma_secondary_frame_deassert = 'd0,
  output  reg   [ 1:0]    axilite_orx1_dma_mode = 'd0,
  output  reg             axilite_orx1_dma_sync = 'd0,
  input   wire  [ 7:0]    axilite_orx1_dma_clk_ratio,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [15:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [15:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);


  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      if (axilite_wraddr[15:12] == ID) begin
        axilite_wrack <= axilite_wrreq;
      end else begin
        axilite_wrack <= 1'd0;
      end
      if (axilite_rdaddr[15:12] == ID) begin
        axilite_rdack <= axilite_rdreq;
      end else begin
        axilite_rdack <= 1'd0;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h100)) begin
        axilite_rx0_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h104)) begin
        axilite_rx0_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h108)) begin
        axilite_rx0_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
        axilite_rx0_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h110)) begin
        axilite_rx0_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h114)) begin
        axilite_rx0_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h118)) begin
        axilite_rx0_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h11c)) begin
        axilite_rx0_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h120)) begin
        axilite_rx0_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h124)) begin
        axilite_rx0_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h200)) begin
        axilite_tx0_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
        axilite_tx0_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h208)) begin
        axilite_tx0_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20c)) begin
        axilite_tx0_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h210)) begin
        axilite_tx0_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h214)) begin
        axilite_tx0_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h218)) begin
        axilite_tx0_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h21c)) begin
        axilite_tx0_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h220)) begin
        axilite_tx0_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h224)) begin
        axilite_tx0_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h300)) begin
        axilite_rx1_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h304)) begin
        axilite_rx1_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h308)) begin
        axilite_rx1_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h30c)) begin
        axilite_rx1_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h310)) begin
        axilite_rx1_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h314)) begin
        axilite_rx1_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h318)) begin
        axilite_rx1_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h31c)) begin
        axilite_rx1_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h320)) begin
        axilite_rx1_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h324)) begin
        axilite_rx1_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h400)) begin
        axilite_tx1_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h404)) begin
        axilite_tx1_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h408)) begin
        axilite_tx1_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h40c)) begin
        axilite_tx1_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h410)) begin
        axilite_tx1_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h414)) begin
        axilite_tx1_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h418)) begin
        axilite_tx1_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h41c)) begin
        axilite_tx1_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h420)) begin
        axilite_tx1_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h424)) begin
        axilite_tx1_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h500)) begin
        axilite_orx0_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h504)) begin
        axilite_orx0_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h508)) begin
        axilite_orx0_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h50c)) begin
        axilite_orx0_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h510)) begin
        axilite_orx0_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h514)) begin
        axilite_orx0_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h518)) begin
        axilite_orx0_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h51c)) begin
        axilite_orx0_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h520)) begin
        axilite_orx0_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx0_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h524)) begin
        axilite_orx0_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_primary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h600)) begin
        axilite_orx1_dma_primary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_primary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h604)) begin
        axilite_orx1_dma_primary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_secondary_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h608)) begin
        axilite_orx1_dma_secondary_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_secondary_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60c)) begin
        axilite_orx1_dma_secondary_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_primary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h610)) begin
        axilite_orx1_dma_primary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_primary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h614)) begin
        axilite_orx1_dma_primary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_secondary_frame_assert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h618)) begin
        axilite_orx1_dma_secondary_frame_assert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_secondary_frame_deassert <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h61c)) begin
        axilite_orx1_dma_secondary_frame_deassert <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_mode <= 'h1;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h620)) begin
        axilite_orx1_dma_mode <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx1_dma_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h624)) begin
        axilite_orx1_dma_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
        case (axilite_rdaddr[11:0])
          'h100: begin
            axilite_rddata <= axilite_rx0_dma_primary_assert;
          end
          'h104: begin
            axilite_rddata <= axilite_rx0_dma_primary_deassert;
          end
          'h108: begin
            axilite_rddata <= axilite_rx0_dma_secondary_assert;
          end
          'h10c: begin
            axilite_rddata <= axilite_rx0_dma_secondary_deassert;
          end
          'h110: begin
            axilite_rddata <= axilite_rx0_dma_primary_frame_assert;
          end
          'h114: begin
            axilite_rddata <= axilite_rx0_dma_primary_frame_deassert;
          end
          'h118: begin
            axilite_rddata <= axilite_rx0_dma_secondary_frame_assert;
          end
          'h11c: begin
            axilite_rddata <= axilite_rx0_dma_secondary_frame_deassert;
          end
          'h120: begin
            axilite_rddata[1:0] <= axilite_rx0_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h124: begin
            axilite_rddata[0] <= axilite_rx0_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h130: begin
            axilite_rddata[7:0] <= axilite_rx0_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h200: begin
            axilite_rddata <= axilite_tx0_dma_primary_assert;
          end
          'h204: begin
            axilite_rddata <= axilite_tx0_dma_primary_deassert;
          end
          'h208: begin
            axilite_rddata <= axilite_tx0_dma_secondary_assert;
          end
          'h20c: begin
            axilite_rddata <= axilite_tx0_dma_secondary_deassert;
          end
          'h210: begin
            axilite_rddata <= axilite_tx0_dma_primary_frame_assert;
          end
          'h214: begin
            axilite_rddata <= axilite_tx0_dma_primary_frame_deassert;
          end
          'h218: begin
            axilite_rddata <= axilite_tx0_dma_secondary_frame_assert;
          end
          'h21c: begin
            axilite_rddata <= axilite_tx0_dma_secondary_frame_deassert;
          end
          'h220: begin
            axilite_rddata[1:0] <= axilite_tx0_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h224: begin
            axilite_rddata[0] <= axilite_tx0_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h230: begin
            axilite_rddata[7:0] <= axilite_tx0_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h300: begin
            axilite_rddata <= axilite_rx1_dma_primary_assert;
          end
          'h304: begin
            axilite_rddata <= axilite_rx1_dma_primary_deassert;
          end
          'h308: begin
            axilite_rddata <= axilite_rx1_dma_secondary_assert;
          end
          'h30c: begin
            axilite_rddata <= axilite_rx1_dma_secondary_deassert;
          end
          'h310: begin
            axilite_rddata <= axilite_rx1_dma_primary_frame_assert;
          end
          'h314: begin
            axilite_rddata <= axilite_rx1_dma_primary_frame_deassert;
          end
          'h318: begin
            axilite_rddata <= axilite_rx1_dma_secondary_frame_assert;
          end
          'h31c: begin
            axilite_rddata <= axilite_rx1_dma_secondary_frame_deassert;
          end
          'h320: begin
            axilite_rddata[1:0] <= axilite_rx1_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h324: begin
            axilite_rddata[0] <= axilite_rx1_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h330: begin
            axilite_rddata[7:0] <= axilite_rx1_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h400: begin
            axilite_rddata <= axilite_tx1_dma_primary_assert;
          end
          'h404: begin
            axilite_rddata <= axilite_tx1_dma_primary_deassert;
          end
          'h408: begin
            axilite_rddata <= axilite_tx1_dma_secondary_assert;
          end
          'h40c: begin
            axilite_rddata <= axilite_tx1_dma_secondary_deassert;
          end
          'h410: begin
            axilite_rddata <= axilite_tx1_dma_primary_frame_assert;
          end
          'h414: begin
            axilite_rddata <= axilite_tx1_dma_primary_frame_deassert;
          end
          'h418: begin
            axilite_rddata <= axilite_tx1_dma_secondary_frame_assert;
          end
          'h41c: begin
            axilite_rddata <= axilite_tx1_dma_secondary_frame_deassert;
          end
          'h420: begin
            axilite_rddata[1:0] <= axilite_tx1_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h424: begin
            axilite_rddata[0] <= axilite_tx1_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h430: begin
            axilite_rddata[7:0] <= axilite_tx1_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h500: begin
            axilite_rddata <= axilite_orx0_dma_primary_assert;
          end
          'h504: begin
            axilite_rddata <= axilite_orx0_dma_primary_deassert;
          end
          'h508: begin
            axilite_rddata <= axilite_orx0_dma_secondary_assert;
          end
          'h50c: begin
            axilite_rddata <= axilite_orx0_dma_secondary_deassert;
          end
          'h510: begin
            axilite_rddata <= axilite_orx0_dma_primary_frame_assert;
          end
          'h514: begin
            axilite_rddata <= axilite_orx0_dma_primary_frame_deassert;
          end
          'h518: begin
            axilite_rddata <= axilite_orx0_dma_secondary_frame_assert;
          end
          'h51c: begin
            axilite_rddata <= axilite_orx0_dma_secondary_frame_deassert;
          end
          'h520: begin
            axilite_rddata[1:0] <= axilite_orx0_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h524: begin
            axilite_rddata[0] <= axilite_orx0_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h530: begin
            axilite_rddata[7:0] <= axilite_orx0_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h600: begin
            axilite_rddata <= axilite_orx1_dma_primary_assert;
          end
          'h604: begin
            axilite_rddata <= axilite_orx1_dma_primary_deassert;
          end
          'h608: begin
            axilite_rddata <= axilite_orx1_dma_secondary_assert;
          end
          'h60c: begin
            axilite_rddata <= axilite_orx1_dma_secondary_deassert;
          end
          'h610: begin
            axilite_rddata <= axilite_orx1_dma_primary_frame_assert;
          end
          'h614: begin
            axilite_rddata <= axilite_orx1_dma_primary_frame_deassert;
          end
          'h618: begin
            axilite_rddata <= axilite_orx1_dma_secondary_frame_assert;
          end
          'h61c: begin
            axilite_rddata <= axilite_orx1_dma_secondary_frame_deassert;
          end
          'h620: begin
            axilite_rddata[1:0] <= axilite_orx1_dma_mode;
            axilite_rddata[31:2] <= 'd0;
          end
          'h624: begin
            axilite_rddata[0] <= axilite_orx1_dma_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h630: begin
            axilite_rddata[7:0] <= axilite_orx1_dma_clk_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
