#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 TDD registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_tdd_dma');

$enable_list[ 0] = "RX0_DMA";
$enable_list[ 1] = "TX0_DMA";
$enable_list[ 2] = "RX1_DMA";
$enable_list[ 3] = "TX1_DMA";
$enable_list[ 4] = "ORX0_DMA";
$enable_list[ 5] = "ORX1_DMA";
$enable_cnt = 6;

for ($n = 0; $n < $enable_cnt; $n++) {

  register(((($n+1)*0x100)+0x00), "REG_$enable_list[$n]_PRIMARY_ASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_PRIMARY_ASSERT", "The clock count at which the
    $enable_list[$n]_ENABLE signal is asserted high.");

  register(((($n+1)*0x100)+0x04), "REG_$enable_list[$n]_PRIMARY_DEASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_PRIMARY_DEASSERT", "The clock count at which the
    $enable_list[$n]_ENABLE signal is deasserted low.");

  register(((($n+1)*0x100)+0x08), "REG_$enable_list[$n]_SECONDARY_ASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_SECONDARY_ASSERT", "The clock count at which the
    $enable_list[$n]_ENABLE signal is asserted high.");

  register(((($n+1)*0x100)+0x0c), "REG_$enable_list[$n]_SECONDARY_DEASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_SECONDARY_DEASSERT", "The clock count at which the
    $enable_list[$n]_ENABLE signal is deasserted low.");

  register(((($n+1)*0x100)+0x10), "REG_$enable_list[$n]_PRIMARY_FRAME_ASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_PRIMARY_FRAME_ASSERT", "The frame count at which the
    $enable_list[$n]_ENABLE signal is asserted high.");

  register(((($n+1)*0x100)+0x14), "REG_$enable_list[$n]_PRIMARY_FRAME_DEASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_PRIMARY_FRAME_DEASSERT", "The frame count at which the
    $enable_list[$n]_ENABLE signal is deasserted low.");

  register(((($n+1)*0x100)+0x18), "REG_$enable_list[$n]_SECONDARY_FRAME_ASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_SECONDARY_FRAME_ASSERT", "The frame count at which the
    $enable_list[$n]_ENABLE signal is asserted high.");

  register(((($n+1)*0x100)+0x1c), "REG_$enable_list[$n]_SECONDARY_FRAME_DEASSERT");
  field(0, 32, RW, 0x0, "$enable_list[$n]_SECONDARY_FRAME_DEASSERT", "The frame count at which the
    $enable_list[$n]_ENABLE signal is deasserted low.");

  register(((($n+1)*0x100)+0x20), "REG_$enable_list[$n]_MODE");
  field(0,  2, RW, 0x1, "$enable_list[$n]_MODE", "The software control of
    $enable_list[$n]_ENABLE signal.
      2b00: Software mode, enable is deasserted (low).
      2b01: Software mode, enable is asserted (high).
      2b1x: Hardware mode, enable is controlled by counters above.");

  register(((($n+1)*0x100)+0x24), "REG_$enable_list[$n]_SYNC");
  field(0,  1, RW, 0x0, "$enable_list[$n]_SYNC", "The synchornization control of
    $enable_list[$n]_ENABLE signal. If set to 0x1, DMA is guranteed to be
    synchronous to the respective interface clock. If set to 0x0, DMA enable
    is asynchronous, thus prone to clock jitters (the capture length may vary
    within the same sequence.");

  register(((($n+1)*0x100)+0x30), "REG_$enable_list[$n]_CLK_RATIO");
  field(0,  8, RO, 0x0, "$enable_list[$n]_CLK_RATIO", "The ratio of interface clock
    frequency to TDD clock frequency.");
}

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
