// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001, TDD
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_tdd #(

  parameter ID = 0,
  parameter DMA_ID = 0,
  parameter INSTANCE_ID = 0) (

  // tdd dma interface

  input   wire            rx0_resetn,
  input   wire            rx0_clk,
  output  wire            rx0_enable,
  output  wire            orx0_enable,

  input   wire            tx0_resetn,
  input   wire            tx0_clk,
  output  wire            tx0_enable,

  input   wire            rx1_resetn,
  input   wire            rx1_clk,
  output  wire            rx1_enable,
  output  wire            orx1_enable,

  input   wire            tx1_resetn,
  input   wire            tx1_clk,
  output  wire            tx1_enable,

  // tdd interface

  output  wire            tdd_out_resetn,
  output  wire            tdd_out_state,
  output  wire            tdd_out_frm_toggle,
  output  wire  [ 31:0]   tdd_out_clk_cnt,
  output  wire  [ 31:0]   tdd_out_frm_cnt,

  input   wire            tdd_clk,
  input   wire            tdd_resetn,
  input   wire            tdd_state,
  input   wire            tdd_frm_toggle,
  input   wire  [ 31:0]   tdd_clk_cnt,
  input   wire  [ 31:0]   tdd_frm_cnt,

  output  wire            tdd_rx0_device_enable,
  output  wire            tdd_tx0_device_enable,
  output  wire            tdd_rx1_device_enable,
  output  wire            tdd_tx1_device_enable,
  output  wire            tdd_orx0_gpio_enable,
  output  wire            tdd_orx1_gpio_enable,
  output  wire            tdd_aux0_gpio_enable,
  output  wire            tdd_aux1_gpio_enable,
  output  wire            tdd_ctl0_gpio_enable,
  output  wire            tdd_ctl1_gpio_enable,
  output  wire            tdd_ctl2_gpio_enable,
  output  wire            tdd_ctl3_gpio_enable,
  output  wire            tdd_trig0_ext_enable,
  output  wire            tdd_trig1_ext_enable,

  // asynchronous events
 
  input   wire  [  3:0]   trig,

  // axi interface

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [ 15:0]   axilite_wraddr,
  input   wire  [ 31:0]   axilite_wrdata,
  output  wire            axilite_wrack,
  input   wire            axilite_rdreq,
  input   wire  [ 15:0]   axilite_rdaddr,
  output  wire  [ 31:0]   axilite_rddata,
  output  wire            axilite_rdack);

  // internal signals
 
  wire          [  5:0]   resetn;
  wire          [  5:0]   clk;
  wire          [  5:0]   enable;
  wire          [ 13:0]   tdd_enable;
  wire          [ 31:0]   axilite_frame_period;
  wire          [ 31:0]   axilite_num_of_frames;
  wire          [ 31:0]   axilite_frame_switch_period;
  wire          [ 31:0]   axilite_frame_switch_number;
  wire          [ 11:0]   axilite_trigger_mode;
  wire                    axilite_stop;
  wire                    axilite_start;
  wire                    axilite_request_clr;
  wire                    axilite_frame_switch_enable;
  wire                    axilite_sequence_repeat;
  wire                    axilite_swreset;
  wire                    axilite_swreset_clr;
  wire          [ 31:0]   axilite_clk_mon_count;
  wire          [447:0]   axilite_pri_assert;
  wire          [447:0]   axilite_pri_deassert;
  wire          [447:0]   axilite_sec_assert;
  wire          [447:0]   axilite_sec_deassert;
  wire          [447:0]   axilite_pri_frame_assert;
  wire          [447:0]   axilite_pri_frame_deassert;
  wire          [447:0]   axilite_sec_frame_assert;
  wire          [447:0]   axilite_sec_frame_deassert;
  wire          [ 27:0]   axilite_mode;
  wire          [191:0]   axilite_dma_pri_assert;
  wire          [191:0]   axilite_dma_pri_deassert;
  wire          [191:0]   axilite_dma_sec_assert;
  wire          [191:0]   axilite_dma_sec_deassert;
  wire          [191:0]   axilite_dma_pri_frame_assert;
  wire          [191:0]   axilite_dma_pri_frame_deassert;
  wire          [191:0]   axilite_dma_sec_frame_assert;
  wire          [191:0]   axilite_dma_sec_frame_deassert;
  wire          [ 11:0]   axilite_dma_mode;
  wire          [  5:0]   axilite_dma_sync;
  wire          [ 47:0]   axilite_dma_clk_ratio;
  wire          [  1:0]   axilite_blk_wrack;
  wire          [  1:0]   axilite_blk_rdack;
  wire          [ 63:0]   axilite_blk_rddata;

  // tdd enables
 
  assign tdd_rx0_device_enable = tdd_enable[0];
  assign tdd_tx0_device_enable = tdd_enable[1];
  assign tdd_rx1_device_enable = tdd_enable[2];
  assign tdd_tx1_device_enable = tdd_enable[3];
  assign tdd_orx0_gpio_enable = tdd_enable[4];
  assign tdd_orx1_gpio_enable = tdd_enable[5];
  assign tdd_aux0_gpio_enable = tdd_enable[6];
  assign tdd_aux1_gpio_enable = tdd_enable[7];
  assign tdd_ctl0_gpio_enable = tdd_enable[8];
  assign tdd_ctl1_gpio_enable = tdd_enable[9];
  assign tdd_ctl2_gpio_enable = tdd_enable[10];
  assign tdd_ctl3_gpio_enable = tdd_enable[11];
  assign tdd_trig0_ext_enable = tdd_enable[12];
  assign tdd_trig1_ext_enable = tdd_enable[13];
 
  generate
  for (genvar n = 0; n < 14; n = n + 1) begin: g_enable
 
  tdd_enable i_enable (
    .tdd_resetn                                   (tdd_resetn),
    .tdd_clk                                      (tdd_clk),
    .tdd_state                                    (tdd_state),
    .tdd_clk_cnt                                  (tdd_clk_cnt),
    .tdd_frm_cnt                                  (tdd_frm_cnt),
    .tdd_enable                                   (tdd_enable[n]),
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_pri_assert                           (axilite_pri_assert[((n*32)+31):(n*32)]),
    .axilite_pri_deassert                         (axilite_pri_deassert[((n*32)+31):(n*32)]),
    .axilite_sec_assert                           (axilite_sec_assert[((n*32)+31):(n*32)]),
    .axilite_sec_deassert                         (axilite_sec_deassert[((n*32)+31):(n*32)]),
    .axilite_pri_frame_assert                     (axilite_pri_frame_assert[((n*32)+31):(n*32)]),
    .axilite_pri_frame_deassert                   (axilite_pri_frame_deassert[((n*32)+31):(n*32)]),
    .axilite_sec_frame_assert                     (axilite_sec_frame_assert[((n*32)+31):(n*32)]),
    .axilite_sec_frame_deassert                   (axilite_sec_frame_deassert[((n*32)+31):(n*32)]),
    .axilite_mode                                 (axilite_mode[((n*2)+1):(n*2)]));

  end
  endgenerate

  // tdd dma enables
 
  assign resetn[0] = rx0_resetn;
  assign clk[0] = rx0_clk;
  assign rx0_enable = enable[0];
  assign resetn[1] = tx0_resetn;
  assign clk[1] = tx0_clk;
  assign tx0_enable = enable[1];
  assign resetn[2] = rx1_resetn;
  assign clk[2] = rx1_clk;
  assign rx1_enable = enable[2];
  assign resetn[3] = tx1_resetn;
  assign clk[3] = tx1_clk;
  assign tx1_enable = enable[3];
  assign resetn[4] = rx0_resetn;
  assign clk[4] = rx0_clk;
  assign orx0_enable = enable[4];
  assign resetn[5] = rx1_resetn;
  assign clk[5] = rx1_clk;
  assign orx1_enable = enable[5];

  generate
  for (genvar n = 0; n < 6; n = n + 1) begin: g_dma_enable
 
  tdd_dma_enable i_dma_enable (
    .resetn                                       (resetn[n]),
    .clk                                          (clk[n]),
    .enable                                       (enable[n]),
    .tdd_resetn                                   (tdd_resetn),
    .tdd_clk                                      (tdd_clk),
    .tdd_state                                    (tdd_state),
    .tdd_clk_cnt                                  (tdd_clk_cnt),
    .tdd_frm_cnt                                  (tdd_frm_cnt),
    .tdd_frm_toggle                               (tdd_frm_toggle),
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_clk_ratio                            (axilite_dma_clk_ratio[((n*8)+7):(n*8)]),
    .axilite_num_of_frames                        (axilite_num_of_frames),
    .axilite_pri_assert                           (axilite_dma_pri_assert[((n*32)+31):(n*32)]),
    .axilite_pri_deassert                         (axilite_dma_pri_deassert[((n*32)+31):(n*32)]),
    .axilite_sec_assert                           (axilite_dma_sec_assert[((n*32)+31):(n*32)]),
    .axilite_sec_deassert                         (axilite_dma_sec_deassert[((n*32)+31):(n*32)]),
    .axilite_pri_frame_assert                     (axilite_dma_pri_frame_assert[((n*32)+31):(n*32)]),
    .axilite_pri_frame_deassert                   (axilite_dma_pri_frame_deassert[((n*32)+31):(n*32)]),
    .axilite_sec_frame_assert                     (axilite_dma_sec_frame_assert[((n*32)+31):(n*32)]),
    .axilite_sec_frame_deassert                   (axilite_dma_sec_frame_deassert[((n*32)+31):(n*32)]),
    .axilite_mode                                 (axilite_dma_mode[((n*2)+1):(n*2)]),
    .axilite_sync                                 (axilite_dma_sync[n]));

  end
  endgenerate

  generate
  if (INSTANCE_ID == 0) begin

  tdd_frame i_frame (
    .tdd_resetn                                   (tdd_resetn),
    .tdd_clk                                      (tdd_clk),
    .tdd_state                                    (tdd_out_state),
    .tdd_frm_toggle                               (tdd_out_frm_toggle),
    .tdd_clk_cnt                                  (tdd_out_clk_cnt),
    .tdd_frm_cnt                                  (tdd_out_frm_cnt),
    .trig                                         (trig),
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_frame_period                         (axilite_frame_period),
    .axilite_num_of_frames                        (axilite_num_of_frames),
    .axilite_frame_switch_period                  (axilite_frame_switch_period),
    .axilite_frame_switch_number                  (axilite_frame_switch_number),
    .axilite_trigger_mode                         (axilite_trigger_mode),
    .axilite_frame_switch_enable                  (axilite_frame_switch_enable),
    .axilite_sequence_repeat                      (axilite_sequence_repeat),
    .axilite_stop                                 (axilite_stop),
    .axilite_start                                (axilite_start),
    .axilite_request_clr                          (axilite_request_clr));

  cdc #(.DATA_WIDTH(1)) i_cdc_tdd (
    .src_data                                     (~axilite_swreset),
    .dest_resetn                                  (1'b1),
    .dest_clk                                     (tdd_clk),
    .dest_data                                    (tdd_out_resetn));

  cdc #(.DATA_WIDTH(1)) i_cdc_axilite (
    .src_data                                     (~tdd_resetn),
    .dest_resetn                                  (axilite_resetn),
    .dest_clk                                     (axilite_clk),
    .dest_data                                    (axilite_swreset_clr));

  end else begin

  assign tdd_out_state = 1'd0;
  assign tdd_out_frm_toggle = 1'd0;
  assign tdd_out_clk_cnt = 32'd0;
  assign tdd_out_frm_cnt = 32'd0;
  assign tdd_out_resetn = 1'd0;
  assign axilite_request_clr = 1'd0;

  end
  endgenerate

  clk_mon i_tdd_clk_mon (
    .clk                                          (tdd_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_clk                                  (axilite_clk),
    .axilite_clk_mon_count                        (axilite_clk_mon_count));

  axi_adrv9001_tdd_regs #(.ID(ID)) i_regs (
    .axilite_frame_period                         (axilite_frame_period),
    .axilite_num_of_frames                        (axilite_num_of_frames),
    .axilite_frame_switch_period                  (axilite_frame_switch_period),
    .axilite_frame_switch_number                  (axilite_frame_switch_number),
    .axilite_trigger_mode_0                       (axilite_trigger_mode[2:0]),
    .axilite_trigger_mode_1                       (axilite_trigger_mode[5:3]),
    .axilite_trigger_mode_2                       (axilite_trigger_mode[8:6]),
    .axilite_trigger_mode_3                       (axilite_trigger_mode[11:9]),
    .axilite_start                                (axilite_start),
    .axilite_start_clr                            (axilite_request_clr),
    .axilite_stop                                 (axilite_stop),
    .axilite_stop_clr                             (axilite_request_clr),
    .axilite_frame_switch_enable                  (axilite_frame_switch_enable),
    .axilite_sequence_repeat                      (axilite_sequence_repeat),
    .axilite_swreset                              (axilite_swreset),
    .axilite_swreset_clr                          (axilite_swreset_clr),
    .axilite_timer                                (),
    .axilite_clk_mon_count                        (axilite_clk_mon_count),
    .axilite_rx0_device_primary_assert            (axilite_pri_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_primary_deassert          (axilite_pri_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_secondary_assert          (axilite_sec_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_secondary_deassert        (axilite_sec_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_primary_frame_assert      (axilite_pri_frame_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_primary_frame_deassert    (axilite_pri_frame_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_secondary_frame_assert    (axilite_sec_frame_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_secondary_frame_deassert  (axilite_sec_frame_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_device_mode                      (axilite_mode[((0*2)+1):(0*2)]),
    .axilite_tx0_device_primary_assert            (axilite_pri_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_primary_deassert          (axilite_pri_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_secondary_assert          (axilite_sec_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_secondary_deassert        (axilite_sec_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_primary_frame_assert      (axilite_pri_frame_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_primary_frame_deassert    (axilite_pri_frame_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_secondary_frame_assert    (axilite_sec_frame_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_secondary_frame_deassert  (axilite_sec_frame_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_device_mode                      (axilite_mode[((1*2)+1):(1*2)]),
    .axilite_rx1_device_primary_assert            (axilite_pri_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_primary_deassert          (axilite_pri_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_secondary_assert          (axilite_sec_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_secondary_deassert        (axilite_sec_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_primary_frame_assert      (axilite_pri_frame_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_primary_frame_deassert    (axilite_pri_frame_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_secondary_frame_assert    (axilite_sec_frame_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_secondary_frame_deassert  (axilite_sec_frame_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_device_mode                      (axilite_mode[((2*2)+1):(2*2)]),
    .axilite_tx1_device_primary_assert            (axilite_pri_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_primary_deassert          (axilite_pri_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_secondary_assert          (axilite_sec_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_secondary_deassert        (axilite_sec_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_primary_frame_assert      (axilite_pri_frame_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_primary_frame_deassert    (axilite_pri_frame_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_secondary_frame_assert    (axilite_sec_frame_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_secondary_frame_deassert  (axilite_sec_frame_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_device_mode                      (axilite_mode[((3*2)+1):(3*2)]),
    .axilite_orx0_gpio_primary_assert             (axilite_pri_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_primary_deassert           (axilite_pri_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_secondary_assert           (axilite_sec_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_secondary_deassert         (axilite_sec_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_primary_frame_assert       (axilite_pri_frame_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_gpio_mode                       (axilite_mode[((4*2)+1):(4*2)]),
    .axilite_orx1_gpio_primary_assert             (axilite_pri_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_primary_deassert           (axilite_pri_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_secondary_assert           (axilite_sec_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_secondary_deassert         (axilite_sec_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_primary_frame_assert       (axilite_pri_frame_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_gpio_mode                       (axilite_mode[((5*2)+1):(5*2)]),
    .axilite_aux0_gpio_primary_assert             (axilite_pri_assert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_primary_deassert           (axilite_pri_deassert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_secondary_assert           (axilite_sec_assert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_secondary_deassert         (axilite_sec_deassert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_primary_frame_assert       (axilite_pri_frame_assert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((6*32)+31):(6*32)]),
    .axilite_aux0_gpio_mode                       (axilite_mode[((6*2)+1):(6*2)]),
    .axilite_aux1_gpio_primary_assert             (axilite_pri_assert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_primary_deassert           (axilite_pri_deassert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_secondary_assert           (axilite_sec_assert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_secondary_deassert         (axilite_sec_deassert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_primary_frame_assert       (axilite_pri_frame_assert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((7*32)+31):(7*32)]),
    .axilite_aux1_gpio_mode                       (axilite_mode[((7*2)+1):(7*2)]),
    .axilite_ctl0_gpio_primary_assert             (axilite_pri_assert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_primary_deassert           (axilite_pri_deassert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_secondary_assert           (axilite_sec_assert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_secondary_deassert         (axilite_sec_deassert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_primary_frame_assert       (axilite_pri_frame_assert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((8*32)+31):(8*32)]),
    .axilite_ctl0_gpio_mode                       (axilite_mode[((8*2)+1):(8*2)]),
    .axilite_ctl1_gpio_primary_assert             (axilite_pri_assert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_primary_deassert           (axilite_pri_deassert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_secondary_assert           (axilite_sec_assert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_secondary_deassert         (axilite_sec_deassert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_primary_frame_assert       (axilite_pri_frame_assert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((9*32)+31):(9*32)]),
    .axilite_ctl1_gpio_mode                       (axilite_mode[((9*2)+1):(9*2)]),
    .axilite_ctl2_gpio_primary_assert             (axilite_pri_assert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_primary_deassert           (axilite_pri_deassert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_secondary_assert           (axilite_sec_assert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_secondary_deassert         (axilite_sec_deassert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_primary_frame_assert       (axilite_pri_frame_assert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((10*32)+31):(10*32)]),
    .axilite_ctl2_gpio_mode                       (axilite_mode[((10*2)+1):(10*2)]),
    .axilite_ctl3_gpio_primary_assert             (axilite_pri_assert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_primary_deassert           (axilite_pri_deassert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_secondary_assert           (axilite_sec_assert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_secondary_deassert         (axilite_sec_deassert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_primary_frame_assert       (axilite_pri_frame_assert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_primary_frame_deassert     (axilite_pri_frame_deassert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_secondary_frame_assert     (axilite_sec_frame_assert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_secondary_frame_deassert   (axilite_sec_frame_deassert[((11*32)+31):(11*32)]),
    .axilite_ctl3_gpio_mode                       (axilite_mode[((11*2)+1):(11*2)]),
    .axilite_trig0_ext_primary_assert             (axilite_pri_assert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_primary_deassert           (axilite_pri_deassert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_secondary_assert           (axilite_sec_assert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_secondary_deassert         (axilite_sec_deassert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_primary_frame_assert       (axilite_pri_frame_assert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_primary_frame_deassert     (axilite_pri_frame_deassert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_secondary_frame_assert     (axilite_sec_frame_assert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_secondary_frame_deassert   (axilite_sec_frame_deassert[((12*32)+31):(12*32)]),
    .axilite_trig0_ext_mode                       (axilite_mode[((12*2)+1):(12*2)]),
    .axilite_trig1_ext_primary_assert             (axilite_pri_assert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_primary_deassert           (axilite_pri_deassert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_secondary_assert           (axilite_sec_assert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_secondary_deassert         (axilite_sec_deassert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_primary_frame_assert       (axilite_pri_frame_assert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_primary_frame_deassert     (axilite_pri_frame_deassert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_secondary_frame_assert     (axilite_sec_frame_assert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_secondary_frame_deassert   (axilite_sec_frame_deassert[((13*32)+31):(13*32)]),
    .axilite_trig1_ext_mode                       (axilite_mode[((13*2)+1):(13*2)]),
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_wrreq                                (axilite_wrreq),
    .axilite_wraddr                               (axilite_wraddr),
    .axilite_wrdata                               (axilite_wrdata),
    .axilite_wrack                                (axilite_blk_wrack[0]),
    .axilite_rdreq                                (axilite_rdreq),
    .axilite_rdaddr                               (axilite_rdaddr),
    .axilite_rddata                               (axilite_blk_rddata[31:0]),
    .axilite_rdack                                (axilite_blk_rdack[0]));

  axi_adrv9001_tdd_dma_regs #(.ID(DMA_ID)) i_dma_regs (
    .axilite_rx0_dma_primary_assert               (axilite_dma_pri_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_primary_deassert             (axilite_dma_pri_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_secondary_assert             (axilite_dma_sec_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_secondary_deassert           (axilite_dma_sec_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_primary_frame_assert         (axilite_dma_pri_frame_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_primary_frame_deassert       (axilite_dma_pri_frame_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_secondary_frame_assert       (axilite_dma_sec_frame_assert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_secondary_frame_deassert     (axilite_dma_sec_frame_deassert[((0*32)+31):(0*32)]),
    .axilite_rx0_dma_mode                         (axilite_dma_mode[((0*2)+1):(0*2)]),
    .axilite_rx0_dma_sync                         (axilite_dma_sync[0]),
    .axilite_rx0_dma_clk_ratio                    (axilite_dma_clk_ratio[((0*8)+7):(0*8)]),
    .axilite_tx0_dma_primary_assert               (axilite_dma_pri_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_primary_deassert             (axilite_dma_pri_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_secondary_assert             (axilite_dma_sec_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_secondary_deassert           (axilite_dma_sec_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_primary_frame_assert         (axilite_dma_pri_frame_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_primary_frame_deassert       (axilite_dma_pri_frame_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_secondary_frame_assert       (axilite_dma_sec_frame_assert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_secondary_frame_deassert     (axilite_dma_sec_frame_deassert[((1*32)+31):(1*32)]),
    .axilite_tx0_dma_mode                         (axilite_dma_mode[((1*2)+1):(1*2)]),
    .axilite_tx0_dma_sync                         (axilite_dma_sync[1]),
    .axilite_tx0_dma_clk_ratio                    (axilite_dma_clk_ratio[((1*8)+7):(1*8)]),
    .axilite_rx1_dma_primary_assert               (axilite_dma_pri_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_primary_deassert             (axilite_dma_pri_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_secondary_assert             (axilite_dma_sec_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_secondary_deassert           (axilite_dma_sec_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_primary_frame_assert         (axilite_dma_pri_frame_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_primary_frame_deassert       (axilite_dma_pri_frame_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_secondary_frame_assert       (axilite_dma_sec_frame_assert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_secondary_frame_deassert     (axilite_dma_sec_frame_deassert[((2*32)+31):(2*32)]),
    .axilite_rx1_dma_mode                         (axilite_dma_mode[((2*2)+1):(2*2)]),
    .axilite_rx1_dma_sync                         (axilite_dma_sync[2]),
    .axilite_rx1_dma_clk_ratio                    (axilite_dma_clk_ratio[((2*8)+7):(2*8)]),
    .axilite_tx1_dma_primary_assert               (axilite_dma_pri_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_primary_deassert             (axilite_dma_pri_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_secondary_assert             (axilite_dma_sec_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_secondary_deassert           (axilite_dma_sec_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_primary_frame_assert         (axilite_dma_pri_frame_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_primary_frame_deassert       (axilite_dma_pri_frame_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_secondary_frame_assert       (axilite_dma_sec_frame_assert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_secondary_frame_deassert     (axilite_dma_sec_frame_deassert[((3*32)+31):(3*32)]),
    .axilite_tx1_dma_mode                         (axilite_dma_mode[((3*2)+1):(3*2)]),
    .axilite_tx1_dma_sync                         (axilite_dma_sync[3]),
    .axilite_tx1_dma_clk_ratio                    (axilite_dma_clk_ratio[((3*8)+7):(3*8)]),
    .axilite_orx0_dma_primary_assert              (axilite_dma_pri_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_primary_deassert            (axilite_dma_pri_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_secondary_assert            (axilite_dma_sec_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_secondary_deassert          (axilite_dma_sec_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_primary_frame_assert        (axilite_dma_pri_frame_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_primary_frame_deassert      (axilite_dma_pri_frame_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_secondary_frame_assert      (axilite_dma_sec_frame_assert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_secondary_frame_deassert    (axilite_dma_sec_frame_deassert[((4*32)+31):(4*32)]),
    .axilite_orx0_dma_mode                        (axilite_dma_mode[((4*2)+1):(4*2)]),
    .axilite_orx0_dma_sync                        (axilite_dma_sync[4]),
    .axilite_orx0_dma_clk_ratio                   (axilite_dma_clk_ratio[((4*8)+7):(4*8)]),
    .axilite_orx1_dma_primary_assert              (axilite_dma_pri_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_primary_deassert            (axilite_dma_pri_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_secondary_assert            (axilite_dma_sec_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_secondary_deassert          (axilite_dma_sec_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_primary_frame_assert        (axilite_dma_pri_frame_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_primary_frame_deassert      (axilite_dma_pri_frame_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_secondary_frame_assert      (axilite_dma_sec_frame_assert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_secondary_frame_deassert    (axilite_dma_sec_frame_deassert[((5*32)+31):(5*32)]),
    .axilite_orx1_dma_mode                        (axilite_dma_mode[((5*2)+1):(5*2)]),
    .axilite_orx1_dma_sync                        (axilite_dma_sync[5]),
    .axilite_orx1_dma_clk_ratio                   (axilite_dma_clk_ratio[((5*8)+7):(5*8)]),
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_wrreq                                (axilite_wrreq),
    .axilite_wraddr                               (axilite_wraddr),
    .axilite_wrdata                               (axilite_wrdata),
    .axilite_wrack                                (axilite_blk_wrack[1]),
    .axilite_rdreq                                (axilite_rdreq),
    .axilite_rdaddr                               (axilite_rdaddr),
    .axilite_rddata                               (axilite_blk_rddata[63:32]),
    .axilite_rdack                                (axilite_blk_rdack[1]));

  axilite_block_if #(.NUM_OF_BLOCKS(2)) i_axilite_block_if (
    .axilite_clk                                  (axilite_clk),
    .axilite_resetn                               (axilite_resetn),
    .axilite_intr                                 (),
    .axilite_wrack                                (axilite_wrack),
    .axilite_rdack                                (axilite_rdack),
    .axilite_rddata                               (axilite_rddata),
    .axilite_block_intr                           (2'd0),
    .axilite_block_wrack                          (axilite_blk_wrack),
    .axilite_block_rdack                          (axilite_blk_rdack),
    .axilite_block_rddata                         (axilite_blk_rddata));

endmodule

// **********************************************************************************
// **********************************************************************************
