// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_rx_regs #(parameter [3:0] ID = 0) (

  input   wire  [31:0]    axilite_rx_cmos_lvds_id,
  output  reg   [ 1:0]    axilite_rx_clk_rate = 'd0,
  output  reg   [ 2:0]    axilite_rx_num_of_bits = 'd0,
  output  reg             axilite_rx_lstrb1_pstrb0 = 'd0,
  output  reg             axilite_rx_mlane1_slane0 = 'd0,
  output  reg             axilite_rx_sdr1_ddr0 = 'd0,
  output  reg             axilite_rx_lsb1_msb0 = 'd0,
  output  reg             axilite_rx_q1_i0 = 'd0,
  output  reg             axilite_rx_fall1_rise0 = 'd0,
  input   wire            axilite_rx_cmos1_lvds0,
  output  reg             axilite_rx_init = 'd0,
  input   wire            axilite_rx_init_clr,
  output  reg   [ 3:0]    axilite_rx_dec_ratio = 'd0,
  output  reg   [ 3:0]    axilite_orx_dec_ratio = 'd0,
  output  reg   [ 2:0]    axilite_rx_data_sel = 'd0,
  output  reg   [31:0]    axilite_rx_data_pat_0 = 'd0,
  output  reg   [31:0]    axilite_rx_data_pat_1 = 'd0,
  input   wire  [31:0]    axilite_rx_data_0,
  input   wire  [31:0]    axilite_rx_data_1,
  input   wire            axilite_rx_frm_oos,
  input   wire            axilite_rx_frm_err,
  input   wire            axilite_rx_mon_oos,
  input   wire            axilite_rx_mon_err,
  input   wire            axilite_rx_delay_unlocked,
  output  reg   [ 4:0]    axilite_rx_wrdelay_0 = 'd0,
  input   wire  [ 4:0]    axilite_rx_rddelay_0,
  output  reg   [ 4:0]    axilite_rx_wrdelay_1 = 'd0,
  input   wire  [ 4:0]    axilite_rx_rddelay_1,
  output  reg   [ 4:0]    axilite_rx_wrdelay_2 = 'd0,
  input   wire  [ 4:0]    axilite_rx_rddelay_2,
  output  reg   [ 4:0]    axilite_rx_wrdelay_3 = 'd0,
  input   wire  [ 4:0]    axilite_rx_rddelay_3,
  output  reg   [ 4:0]    axilite_rx_wrdelay_s = 'd0,
  input   wire  [ 4:0]    axilite_rx_rddelay_s,
  output  reg   [31:0]    axilite_rx_timer = 'd0,
  input   wire  [31:0]    axilite_rx_clk_mon_count,
  input   wire  [15:0]    axilite_rx_mcs_latency_count,
  output  reg             axilite_rx_mcs_sync = 'd0,
  output  reg   [ 3:0]    axilite_rx_mcs_active = 'd0,
  input   wire            axilite_rx_data_pat_state,
  input   wire  [31:0]    axilite_rx_data_pat_latency,
  output  reg             axilite_rx_sw_reset = 'd0,
  input   wire            axilite_rx_sw_reset_clr,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [15:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [15:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);

  reg                     axilite_rx_init_clr_d = 'd0;
  reg                     axilite_rx_frm_oos_w1c = 'd0;
  reg                     axilite_rx_frm_err_w1c = 'd0;
  reg                     axilite_rx_mon_oos_w1c = 'd0;
  reg                     axilite_rx_mon_err_w1c = 'd0;
  reg                     axilite_rx_sw_reset_clr_d = 'd0;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      if (axilite_wraddr[15:12] == ID) begin
        axilite_wrack <= axilite_wrreq;
      end else begin
        axilite_wrack <= 1'd0;
      end
      if (axilite_rdaddr[15:12] == ID) begin
        axilite_rdack <= axilite_rdreq;
      end else begin
        axilite_rdack <= 1'd0;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_clk_rate <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_clk_rate <= axilite_wrdata[1:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_num_of_bits <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_num_of_bits <= axilite_wrdata[6:4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_lstrb1_pstrb0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_lstrb1_pstrb0 <= axilite_wrdata[8];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_mlane1_slane0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_mlane1_slane0 <= axilite_wrdata[9];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_sdr1_ddr0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_sdr1_ddr0 <= axilite_wrdata[10];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_lsb1_msb0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_lsb1_msb0 <= axilite_wrdata[11];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_q1_i0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_q1_i0 <= axilite_wrdata[12];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_fall1_rise0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h4)) begin
        axilite_rx_fall1_rise0 <= axilite_wrdata[13];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_init_clr_d <= 'd0;
      axilite_rx_init <= 'h0;
    end else begin
      axilite_rx_init_clr_d <= axilite_rx_init_clr;
      if ((axilite_rx_init_clr_d == 1'b0) && (axilite_rx_init_clr == 1'b1)) begin
        axilite_rx_init <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'hc)) begin
        axilite_rx_init <= axilite_rx_init | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_dec_ratio <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_rx_dec_ratio <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_orx_dec_ratio <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10)) begin
        axilite_orx_dec_ratio <= axilite_wrdata[7:4];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_data_sel <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h20)) begin
        axilite_rx_data_sel <= axilite_wrdata[2:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_data_pat_0 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h30)) begin
        axilite_rx_data_pat_0 <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_data_pat_1 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h34)) begin
        axilite_rx_data_pat_1 <= axilite_wrdata;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_frm_oos_w1c <= 'h0;
    end else begin
      if (axilite_rx_frm_oos == 1'b1) begin
        axilite_rx_frm_oos_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
        axilite_rx_frm_oos_w1c <= axilite_rx_frm_oos_w1c & ~axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_frm_err_w1c <= 'h0;
    end else begin
      if (axilite_rx_frm_err == 1'b1) begin
        axilite_rx_frm_err_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
        axilite_rx_frm_err_w1c <= axilite_rx_frm_err_w1c & ~axilite_wrdata[1];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_mon_oos_w1c <= 'h0;
    end else begin
      if (axilite_rx_mon_oos == 1'b1) begin
        axilite_rx_mon_oos_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
        axilite_rx_mon_oos_w1c <= axilite_rx_mon_oos_w1c & ~axilite_wrdata[2];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_mon_err_w1c <= 'h0;
    end else begin
      if (axilite_rx_mon_err == 1'b1) begin
        axilite_rx_mon_err_w1c <= 1'b1;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h60)) begin
        axilite_rx_mon_err_w1c <= axilite_rx_mon_err_w1c & ~axilite_wrdata[3];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_wrdelay_0 <= 'h13;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h80)) begin
        axilite_rx_wrdelay_0 <= axilite_wrdata[4:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_wrdelay_1 <= 'h13;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h84)) begin
        axilite_rx_wrdelay_1 <= axilite_wrdata[4:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_wrdelay_2 <= 'h13;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h88)) begin
        axilite_rx_wrdelay_2 <= axilite_wrdata[4:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_wrdelay_3 <= 'h13;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h8c)) begin
        axilite_rx_wrdelay_3 <= axilite_wrdata[4:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_wrdelay_s <= 'h13;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h90)) begin
        axilite_rx_wrdelay_s <= axilite_wrdata[4:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_timer <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h100)) begin
        axilite_rx_timer <= axilite_wrdata;
      end else if (axilite_rx_timer > 0) begin
        axilite_rx_timer <= axilite_rx_timer - 1'b1;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_mcs_sync <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
        axilite_rx_mcs_sync <= axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_mcs_active <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h110)) begin
        axilite_rx_mcs_active <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx_sw_reset_clr_d <= 'd0;
      axilite_rx_sw_reset <= 'h0;
    end else begin
      axilite_rx_sw_reset_clr_d <= axilite_rx_sw_reset_clr;
      if ((axilite_rx_sw_reset_clr_d == 1'b0) && (axilite_rx_sw_reset_clr == 1'b1)) begin
        axilite_rx_sw_reset <= 1'b0;
      end else if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h200)) begin
        axilite_rx_sw_reset <= axilite_rx_sw_reset | axilite_wrdata[0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
        case (axilite_rdaddr[11:0])
          'h0: begin
            axilite_rddata <= axilite_rx_cmos_lvds_id;
          end
          'h4: begin
            axilite_rddata[1:0] <= axilite_rx_clk_rate;
            axilite_rddata[3:2] <= 'd0;
            axilite_rddata[6:4] <= axilite_rx_num_of_bits;
            axilite_rddata[7] <= 'd0;
            axilite_rddata[8] <= axilite_rx_lstrb1_pstrb0;
            axilite_rddata[9] <= axilite_rx_mlane1_slane0;
            axilite_rddata[10] <= axilite_rx_sdr1_ddr0;
            axilite_rddata[11] <= axilite_rx_lsb1_msb0;
            axilite_rddata[12] <= axilite_rx_q1_i0;
            axilite_rddata[13] <= axilite_rx_fall1_rise0;
            axilite_rddata[14] <= axilite_rx_cmos1_lvds0;
            axilite_rddata[31:15] <= 'd0;
          end
          'hc: begin
            axilite_rddata[0] <= axilite_rx_init;
            axilite_rddata[31:1] <= 'd0;
          end
          'h10: begin
            axilite_rddata[3:0] <= axilite_rx_dec_ratio;
            axilite_rddata[7:4] <= axilite_orx_dec_ratio;
            axilite_rddata[31:8] <= 'd0;
          end
          'h20: begin
            axilite_rddata[2:0] <= axilite_rx_data_sel;
            axilite_rddata[31:3] <= 'd0;
          end
          'h30: begin
            axilite_rddata <= axilite_rx_data_pat_0;
          end
          'h34: begin
            axilite_rddata <= axilite_rx_data_pat_1;
          end
          'h40: begin
            axilite_rddata <= axilite_rx_data_0;
          end
          'h44: begin
            axilite_rddata <= axilite_rx_data_1;
          end
          'h60: begin
            axilite_rddata[0] <= axilite_rx_frm_oos_w1c;
            axilite_rddata[1] <= axilite_rx_frm_err_w1c;
            axilite_rddata[2] <= axilite_rx_mon_oos_w1c;
            axilite_rddata[3] <= axilite_rx_mon_err_w1c;
            axilite_rddata[31:4] <= 'd0;
          end
          'h70: begin
            axilite_rddata[0] <= axilite_rx_delay_unlocked;
            axilite_rddata[31:1] <= 'd0;
          end
          'h80: begin
            axilite_rddata[4:0] <= axilite_rx_wrdelay_0;
            axilite_rddata[7:5] <= 'd0;
            axilite_rddata[12:8] <= axilite_rx_rddelay_0;
            axilite_rddata[31:13] <= 'd0;
          end
          'h84: begin
            axilite_rddata[4:0] <= axilite_rx_wrdelay_1;
            axilite_rddata[7:5] <= 'd0;
            axilite_rddata[12:8] <= axilite_rx_rddelay_1;
            axilite_rddata[31:13] <= 'd0;
          end
          'h88: begin
            axilite_rddata[4:0] <= axilite_rx_wrdelay_2;
            axilite_rddata[7:5] <= 'd0;
            axilite_rddata[12:8] <= axilite_rx_rddelay_2;
            axilite_rddata[31:13] <= 'd0;
          end
          'h8c: begin
            axilite_rddata[4:0] <= axilite_rx_wrdelay_3;
            axilite_rddata[7:5] <= 'd0;
            axilite_rddata[12:8] <= axilite_rx_rddelay_3;
            axilite_rddata[31:13] <= 'd0;
          end
          'h90: begin
            axilite_rddata[4:0] <= axilite_rx_wrdelay_s;
            axilite_rddata[7:5] <= 'd0;
            axilite_rddata[12:8] <= axilite_rx_rddelay_s;
            axilite_rddata[31:13] <= 'd0;
          end
          'h100: begin
            axilite_rddata <= axilite_rx_timer;
          end
          'h104: begin
            axilite_rddata <= axilite_rx_clk_mon_count;
          end
          'h108: begin
            axilite_rddata[15:0] <= axilite_rx_mcs_latency_count;
            axilite_rddata[31:16] <= 'd0;
          end
          'h10c: begin
            axilite_rddata[0] <= axilite_rx_mcs_sync;
            axilite_rddata[31:1] <= 'd0;
          end
          'h110: begin
            axilite_rddata[3:0] <= axilite_rx_mcs_active;
            axilite_rddata[31:4] <= 'd0;
          end
          'h120: begin
            axilite_rddata[0] <= axilite_rx_data_pat_state;
            axilite_rddata[31:1] <= 'd0;
          end
          'h124: begin
            axilite_rddata <= axilite_rx_data_pat_latency;
          end
          'h200: begin
            axilite_rddata[0] <= axilite_rx_sw_reset;
            axilite_rddata[31:1] <= 'd0;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
