#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 receive registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_rx');

register(0x000, 'REG_RX_CMOS_LVDS_ID');
field(0, 32, RO, 0x0, 'RX_CMOS_LVDS_ID', 'An unambigous identifier indicates the
  current configuration of SSI interface. If configured as CMOS, this register
  reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53.');

register(0x004, 'REG_RX_CONTROL');
field( 0, 2, RW, 0x0, 'RX_CLK_RATE', 'This field must be set to the desired interface
  clock rate. It supports the following data rates in relation to the interface clock.
    2b00: data-rate = clock-rate,
    2b01: data-rate = (clock-rate/2),
    2b10: data-rate = (clock-rate/4),
    2b11: data-rate = (clock-rate/8).');
field( 4, 3, RW, 0x0, 'RX_NUM_OF_BITS', 'This field must be set to the desired number of
  bits in a sample. It supports the following sample widths.
    3b101: 64bits, (IQ) interface.
    3b100: 32bits, (IQ) interface.
    3b011: 24bits, (IQ) interface.
    3b010: 16bits, (I) interface.
    3b001:  8bits, (I) interface.
    3b000:  2bits, (I) interface.');
field( 8, 1, RW, 0x0, 'RX_LSTRB1_PSTRB0', 'This field must be set to the desired strobe
  type, It supports the following two modes. If set to 1, a level strobe is expected. The
  strobe must stay asserted for the entire channel (I or Q) in a 2 channel interface. This
  bit is ignored in single channel mode. If this bit is set to 0, strobe is expected to be
  a pulse, asserted only during the first clock cycle of the data frame.');
field( 9, 1, RW, 0x0, 'RX_MLANE1_SLANE0', 'This field must be set to the desired number of
  lanes (or lines) at the interface. If this bit is set to 0x1, the interface is a multiple lane
  (or line) interface. In CMOS mode this is 4 lines, in LVDS it is 2 lanes. If this bit is
  set to 0x0, it is a single lane (or line) interface.');
field(10, 1, RW, 0x0, 'RX_SDR1_DDR0', 'This field must be set to the desired clock type.
  If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be
  set carefully to match the device. The FPGA core supports SDR or DDR in all modes.');
field(11, 1, RW, 0x0, 'RX_LSB1_MSB0', 'This field must be set to the desired bit order within
  the data frame. If set to 0x1, the first received bit is assumed to be the LSB, if set to 0x0,
  the first received bit is the MSB.');
field(12, 1, RW, 0x0, 'RX_Q1_I0', 'This field must be set to the desired channel order within
  the data frame. If set to 0x1, the first sample is assumed to be the Q channel. If set to 0x0,
  the first received channel is the I.');
field(13, 1, RW, 0x0, 'RX_FALL1_RISE0', 'This bit controls the data sampling edge in SDR mode,
  if set to 0x1, falling clock edges are used to capture data. If set to 0x0, data is sampled
  at the rising edges of the interface clock.');
field(14, 1, RO, 0x0, 'RX_CMOS1_LVDS0', 'This is a read-only bit indicating the current
  configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is
  in LVDS mode. The software is expected to qualify the remaining fields in this register
  based on the value read in this bit.');

register(0x00c, 'REG_RX_INIT');
field(0, 1, RW1HC, 0x0, 'RX_INIT', 'A 0 to 1 transition on this bit initiates a reset request
  at the interface. This is self-cleared, it is recommended that software set this bit after
  a profile is loaded to ensure a clean start.');

register(0x010, 'REG_RX_DEC_CONTROL');
field(0, 4, RW, 0x0, 'RX_DEC_RATIO', 'The decimation ratio at the interface. If set to 0x0
  all the samples are valid and passed down stream. If set to a value N, only one among N
  samples are considered valid and passed down stream.');
field(4, 4, RW, 0x0, 'ORX_DEC_RATIO', 'The decimation ratio at the interface for the
  observation channel. The behavior is the same as above.');

register(0x020, 'REG_RX_DATA_SEL');
field(0, 3, RW, 0x0, 'RX_DATA_SEL', 'This field selects the data types for the monitor at the
  interface (RX_MON_OOS and RX_MON_ERR above). The following are supported.
    3b011: Fixed pattern (see RX_DATA_PAT below).
    3b100: Nibble ramp (0x0000-0x1111- all the way to 0xffff).
    3b101: word ramp (0x0000 to 0xffff).
    3b110: PRBS15
    3b111: PRBS7');

register(0x030, 'REG_RX_DATA_PAT_0');
field(0, 32, RW, 0x0, 'RX_DATA_PAT_0', 'The data pattern expected at the interface. In non 32
  bit modes, only the lower bits are used as per the NUM_OF_BITS field above.');

register(0x034, 'REG_RX_DATA_PAT_1');
field(0, 32, RW, 0x0, 'RX_DATA_PAT_1', 'The data pattern expected at the interface.
  This register is used only in 64bit mode');

register(0x040, 'REG_RX_DATA_0');
field(0, 32, RO, 0x0, 'RX_DATA_0', 'This register samples periodically the lower 32 bits
  of data as received by the interface core.');

register(0x044, 'REG_RX_DATA_1');
field(0, 32, RO, 0x0, 'RX_DATA_1', 'This register samples periodically the upper 32 bits
  of data as received by the interface core.');

register(0x060, 'REG_RX_STATUS');
field(0, 1, RW1C, 0x0, 'RX_FRM_OOS', 'This bit indicates the status of the delineation of data
  frames based on the strobe signal at the interface. If this bit is read 0x1, the framer is in
  out of sync and must be considered as an error state. If this bit is read 0x0, the framer is
  in sync with the received data frames. As part of the initialization sequence, software must
  write 0x1 to clear this bit and make sure that it stays cleared.');
field(1, 1, RW1C, 0x0, 'RX_FRM_ERR', 'This bit indicates spurious errors in the framer,
  but is not sufficient to cause an OOS assertion. Software must write 0x1 to clear this
  bit. Once cleared, this bit is not set until another frame error is detected.');
field(2, 1, RW1C, 0x0, 'RX_MON_OOS', 'This bit indicates the data monitor OOS similar to the
  framer OOS, software may use this bit for the delay calibration at the interface.');
field(3, 1, RW1C, 0x0, 'RX_MON_ERR', 'This bit indicates spurious errors in the data monitor
  but is not sufficient to cause an OOS assertion. The bit is cleared by writing a 0x1.');

register(0x070, 'REG_RX_DELAY_UNLOCKED');
field(0, 1, RO, 0x0, 'RX_DELAY_UNLOCKED', 'If clear, this bit indicates the delay controller
  is locked and calibrated. A delay setting is not guaranteed if this bit is set.');

register(0x080, 'REG_RX_DELAY_CONTROL_0');
field(0, 5, RW, 0x13, 'RX_WRDELAY_0', 'This field sets the IO delay value at the
  interface for data lane 1. The resolution is ~78ps. The range is 0 to 31.');
field(8, 5, RO, 0x0, 'RX_RDDELAY_0', 'This field indicates the current delay setting
  at the interface for data lane 1. If done correctly, the value read is the same as
  the RX_WRDELAY.');

register(0x084, 'REG_RX_DELAY_CONTROL_1');
field(0, 5, RW, 0x13, 'RX_WRDELAY_1', 'This field is the same as RX_WRDELAY_0 above,
  but for the data lane 2.');
field(8, 5, RO, 0x0, 'RX_RDDELAY_1', 'This field is the same as RX_RDDELAY_0 above,
  but for the data lane 2.');

register(0x088, 'REG_RX_DELAY_CONTROL_2');
field(0, 5, RW, 0x13, 'RX_WRDELAY_2', 'This field is the same as RX_WRDELAY_0 above,
  but for the data lane 3. It is unused in LVDS mode.');
field(8, 5, RO, 0x0, 'RX_RDDELAY_2', 'This field is the same as RX_RDDELAY_0 above,
  but for the data lane 3. It is unused in LVDS mode.');

register(0x08c, 'REG_RX_DELAY_CONTROL_3');
field(0, 5, RW, 0x13, 'RX_WRDELAY_3', 'This field is the same as RX_WRDELAY_0 above,
  but for the data lane 4. It is unused in LVDS mode.');
field(8, 5, RO, 0x0, 'RX_RDDELAY_3', 'This field is the same as RX_RDDELAY_0 above,
  but for the data lane 4. It is unused in LVDS mode.');

register(0x090, 'REG_RX_DELAY_CONTROL_S');
field(0, 5, RW, 0x13, 'RX_WRDELAY_s', 'This field is the same as RX_WRDELAY_0 above,
  but for the srobe lane.');
field(8, 5, RO, 0x0, 'RX_RDDELAY_s', 'This field is the same as RX_RDDELAY_0 above,
  but for the strobe lane.');

register(0x100, 'REG_RX_TIMER');
field(0, 32, RW, 0x0, 'RX_TIMER', 'General purpose timer register, this is a count
  down timer, software may write desired interval and wait for it to reach zero.
  The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

register(0x104, 'REG_RX_CLK_MON');
field(0, 32, RO, 0x0, 'RX_CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
  indicates a loss of clock. The format is 16.16 x 100MHz');

register(0x108, 'REG_RX_MCS_LATENCY');
field(0, 16, RO, 0x0, 'RX_MCS_LATENCY_COUNT', 'MCS to first strobe latency count in
  half the interface clock period.');

register(0x10c, 'REG_RX_MCS_SYNC');
field(0, 1, RW, 0x0, 'RX_MCS_SYNC', 'If set, enable MCS synchronization of
  receive ssi interface, also note that self reset is disabled.');

register(0x110, 'REG_RX_MCS_ACTIVE');
field(0, 4, RW, 0x0, 'RX_MCS_ACTIVE', 'If MCS_SYNC is set, the SSI signals are
  ignored until the active MCS pulse is received.');

register(0x120, 'REG_RX_DATA_PAT_STATE');
field(0, 1, RO, 0x0, 'RX_DATA_PAT_STATE', 'The state of receive data pattern
  latency monitor, if set waiting for the pattern.');

register(0x124, 'REG_RX_DATA_PAT_LATENCY');
field(0, 32, RO, 0x0, 'RX_DATA_PAT_LATENCY', 'The number of SSI clock cycles
  from transmit pattern pulse insert to pattern received.');

register(0x200, 'REG_RX_SW_RESET');
field(0, 1, RW1HC, 0x0, 'RX_SW_RESET', 'This bit allows reset of the transmit interface
  logic from the processor clock domain, its use is left to the driver.');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
