# axi\_adrv9001\_rx
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | rx\_cmos\_lvds\_id[31:0] | RO | 0x0 | An unambigous identifier indicates the current configuration of SSI interface. If configured as CMOS, this register reads 0x43-0x4d-0x4f-0x53, and if LVDS, reads 0x4c-0x56-0x44-0x53. |
| | | | | | |
| 0x4 | [1:0] | rx\_clk\_rate[1:0] | RW | 0x0 | This field must be set to the desired interface clock rate. It supports the following data rates in relation to the interface clock. 2b00: data-rate = clock-rate, 2b01: data-rate = (clock-rate/2), 2b10: data-rate = (clock-rate/4), 2b11: data-rate = (clock-rate/8). |
| 0x4 | [6:4] | rx\_num\_of\_bits[2:0] | RW | 0x0 | This field must be set to the desired number of bits in a sample. It supports the following sample widths. 3b101: 64bits, (IQ) interface. 3b100: 32bits, (IQ) interface. 3b011: 24bits, (IQ) interface. 3b010: 16bits, (I) interface. 3b001: 8bits, (I) interface. 3b000: 2bits, (I) interface. |
| 0x4 | [8:8] | rx\_lstrb1\_pstrb0 | RW | 0x0 | This field must be set to the desired strobe type, It supports the following two modes. If set to 1, a level strobe is expected. The strobe must stay asserted for the entire channel (I or Q) in a 2 channel interface. This bit is ignored in single channel mode. If this bit is set to 0, strobe is expected to be a pulse, asserted only during the first clock cycle of the data frame. |
| 0x4 | [9:9] | rx\_mlane1\_slane0 | RW | 0x0 | This field must be set to the desired number of lanes (or lines) at the interface. If this bit is set to 0x1, the interface is a multiple lane (or line) interface. In CMOS mode this is 4 lines, in LVDS it is 2 lanes. If this bit is set to 0x0, it is a single lane (or line) interface. |
| 0x4 | [10:10] | rx\_sdr1\_ddr0 | RW | 0x0 | This field must be set to the desired clock type. If set to 0x1, interface is SDR. If set to 0x0, interface is in DDR mode. This bit must be set carefully to match the device. The FPGA core supports SDR or DDR in all modes. |
| 0x4 | [11:11] | rx\_lsb1\_msb0 | RW | 0x0 | This field must be set to the desired bit order within the data frame. If set to 0x1, the first received bit is assumed to be the LSB, if set to 0x0, the first received bit is the MSB. |
| 0x4 | [12:12] | rx\_q1\_i0 | RW | 0x0 | This field must be set to the desired channel order within the data frame. If set to 0x1, the first sample is assumed to be the Q channel. If set to 0x0, the first received channel is the I. |
| 0x4 | [13:13] | rx\_fall1\_rise0 | RW | 0x0 | This bit controls the data sampling edge in SDR mode, if set to 0x1, falling clock edges are used to capture data. If set to 0x0, data is sampled at the rising edges of the interface clock. |
| 0x4 | [14:14] | rx\_cmos1\_lvds0 | RO | 0x0 | This is a read-only bit indicating the current configuration of this interface. If read 0x1, interface is in CMOS mode. If read 0x0, it is in LVDS mode. The software is expected to qualify the remaining fields in this register based on the value read in this bit. |
| | | | | | |
| 0xc | [0:0] | rx\_init | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates a reset request at the interface. This is self-cleared, it is recommended that software set this bit after a profile is loaded to ensure a clean start. |
| | | | | | |
| 0x10 | [3:0] | rx\_dec\_ratio[3:0] | RW | 0x0 | The decimation ratio at the interface. If set to 0x0 all the samples are valid and passed down stream. If set to a value N, only one among N samples are considered valid and passed down stream. |
| 0x10 | [7:4] | orx\_dec\_ratio[3:0] | RW | 0x0 | The decimation ratio at the interface for the observation channel. The behavior is the same as above. |
| | | | | | |
| 0x20 | [2:0] | rx\_data\_sel[2:0] | RW | 0x0 | This field selects the data types for the monitor at the interface (RX\_MON\_OOS and RX\_MON\_ERR above). The following are supported. 3b011: Fixed pattern (see RX\_DATA\_PAT below). 3b100: Nibble ramp (0x0000-0x1111- all the way to 0xffff). 3b101: word ramp (0x0000 to 0xffff). 3b110: PRBS15 3b111: PRBS7 |
| | | | | | |
| 0x30 | [31:0] | rx\_data\_pat\_0[31:0] | RW | 0x0 | The data pattern expected at the interface. In non 32 bit modes, only the lower bits are used as per the NUM\_OF\_BITS field above. |
| | | | | | |
| 0x34 | [31:0] | rx\_data\_pat\_1[31:0] | RW | 0x0 | The data pattern expected at the interface. This register is used only in 64bit mode |
| | | | | | |
| 0x40 | [31:0] | rx\_data\_0[31:0] | RO | 0x0 | This register samples periodically the lower 32 bits of data as received by the interface core. |
| | | | | | |
| 0x44 | [31:0] | rx\_data\_1[31:0] | RO | 0x0 | This register samples periodically the upper 32 bits of data as received by the interface core. |
| | | | | | |
| 0x60 | [0:0] | rx\_frm\_oos | RW1C | 0x0 | This bit indicates the status of the delineation of data frames based on the strobe signal at the interface. If this bit is read 0x1, the framer is in out of sync and must be considered as an error state. If this bit is read 0x0, the framer is in sync with the received data frames. As part of the initialization sequence, software must write 0x1 to clear this bit and make sure that it stays cleared. |
| 0x60 | [1:1] | rx\_frm\_err | RW1C | 0x0 | This bit indicates spurious errors in the framer, but is not sufficient to cause an OOS assertion. Software must write 0x1 to clear this bit. Once cleared, this bit is not set until another frame error is detected. |
| 0x60 | [2:2] | rx\_mon\_oos | RW1C | 0x0 | This bit indicates the data monitor OOS similar to the framer OOS, software may use this bit for the delay calibration at the interface. |
| 0x60 | [3:3] | rx\_mon\_err | RW1C | 0x0 | This bit indicates spurious errors in the data monitor but is not sufficient to cause an OOS assertion. The bit is cleared by writing a 0x1. |
| | | | | | |
| 0x70 | [0:0] | rx\_delay\_unlocked | RO | 0x0 | If clear, this bit indicates the delay controller is locked and calibrated. A delay setting is not guaranteed if this bit is set. |
| | | | | | |
| 0x80 | [4:0] | rx\_wrdelay\_0[4:0] | RW | 0x13 | This field sets the IO delay value at the interface for data lane 1. The resolution is ~78ps. The range is 0 to 31. |
| 0x80 | [12:8] | rx\_rddelay\_0[4:0] | RO | 0x0 | This field indicates the current delay setting at the interface for data lane 1. If done correctly, the value read is the same as the RX\_WRDELAY. |
| | | | | | |
| 0x84 | [4:0] | rx\_wrdelay\_1[4:0] | RW | 0x13 | This field is the same as RX\_WRDELAY\_0 above, but for the data lane 2. |
| 0x84 | [12:8] | rx\_rddelay\_1[4:0] | RO | 0x0 | This field is the same as RX\_RDDELAY\_0 above, but for the data lane 2. |
| | | | | | |
| 0x88 | [4:0] | rx\_wrdelay\_2[4:0] | RW | 0x13 | This field is the same as RX\_WRDELAY\_0 above, but for the data lane 3. It is unused in LVDS mode. |
| 0x88 | [12:8] | rx\_rddelay\_2[4:0] | RO | 0x0 | This field is the same as RX\_RDDELAY\_0 above, but for the data lane 3. It is unused in LVDS mode. |
| | | | | | |
| 0x8c | [4:0] | rx\_wrdelay\_3[4:0] | RW | 0x13 | This field is the same as RX\_WRDELAY\_0 above, but for the data lane 4. It is unused in LVDS mode. |
| 0x8c | [12:8] | rx\_rddelay\_3[4:0] | RO | 0x0 | This field is the same as RX\_RDDELAY\_0 above, but for the data lane 4. It is unused in LVDS mode. |
| | | | | | |
| 0x90 | [4:0] | rx\_wrdelay\_s[4:0] | RW | 0x13 | This field is the same as RX\_WRDELAY\_0 above, but for the srobe lane. |
| 0x90 | [12:8] | rx\_rddelay\_s[4:0] | RO | 0x0 | This field is the same as RX\_RDDELAY\_0 above, but for the strobe lane. |
| | | | | | |
| 0x100 | [31:0] | rx\_timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x104 | [31:0] | rx\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x108 | [15:0] | rx\_mcs\_latency\_count[15:0] | RO | 0x0 | MCS to first strobe latency count in half the interface clock period. |
| | | | | | |
| 0x10c | [0:0] | rx\_mcs\_sync | RW | 0x0 | If set, enable MCS synchronization of receive ssi interface, also note that self reset is disabled. |
| | | | | | |
| 0x110 | [3:0] | rx\_mcs\_active[3:0] | RW | 0x0 | If MCS\_SYNC is set, the SSI signals are ignored until the active MCS pulse is received. |
| | | | | | |
| 0x120 | [0:0] | rx\_data\_pat\_state | RO | 0x0 | The state of receive data pattern latency monitor, if set waiting for the pattern. |
| | | | | | |
| 0x124 | [31:0] | rx\_data\_pat\_latency[31:0] | RO | 0x0 | The number of SSI clock cycles from transmit pattern pulse insert to pattern received. |
| | | | | | |
| 0x200 | [0:0] | rx\_sw\_reset | RW1HC | 0x0 | This bit allows reset of the transmit interface logic from the processor clock domain, its use is left to the driver. |
| | | | | | |
---
