// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001, receive interface single channel
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_rx_if #(

  parameter GPIO2_CMOS1_LVDS0 = 0,
  parameter IODELAY_GROUP = "IODELAY_GROUP") (

  // system interface

  input   wire            rx_resetn,
  input   wire            rx_hs_clk,
  input   wire            rx_clk,
  input   wire            rx_align,
  input   wire            rx_data_p,
  input   wire            rx_data_n,
  output  wire  [  7:0]   rx_pdata,
  output  wire            rx_gpio_in,

  // axilite interface

  input   wire            axilite_resetn,
  input   wire            axilite_clk,
  input   wire  [  4:0]   axilite_delay_wrdata,
  output  wire  [  4:0]   axilite_delay_rddata);

  // internal registers
 
  reg                     axilite_delay_rdwr = 'd0;
  reg           [  4:0]   axilite_delay_wrdata_d = 'd0;

  // internal signals
 
  wire                    rx_ddata;
  wire                    rx_sdata;

  // load delay value

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_delay_wrdata_d <= 5'd0;
      axilite_delay_rdwr <= 1'b0;
    end else begin
      axilite_delay_wrdata_d <= axilite_delay_wrdata;
      if (axilite_delay_wrdata_d == axilite_delay_wrdata) begin
        axilite_delay_rdwr <= 1'b0;
      end else begin
        axilite_delay_rdwr <= 1'b1;
      end
    end
  end

  // instantiations

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign rx_pdata = 8'd0;
  assign rx_gpio_in = 1'd0;

  end else begin

  ISERDESE2 #(
    .DATA_RATE              ("DDR"),
    .DATA_WIDTH             (8),
    .INTERFACE_TYPE         ("NETWORKING"),
    .DYN_CLKDIV_INV_EN      ("FALSE"),
    .DYN_CLK_INV_EN         ("FALSE"),
    .NUM_CE                 (2),
    .OFB_USED               ("FALSE"),
    .IOBDELAY               ("BOTH"),
    .SERDES_MODE            ("MASTER"))
  i_serdes (
    .CLK                    (rx_hs_clk),
    .CLKB                   (~rx_hs_clk),
    .CLKDIV                 (rx_clk),
    .RST                    (~rx_resetn),
    .BITSLIP                (rx_align),
    .DDLY                   (rx_ddata),
    .Q1                     (rx_pdata[0]),
    .Q2                     (rx_pdata[1]),
    .Q3                     (rx_pdata[2]),
    .Q4                     (rx_pdata[3]),
    .Q5                     (rx_pdata[4]),
    .Q6                     (rx_pdata[5]),
    .Q7                     (rx_pdata[6]),
    .Q8                     (rx_pdata[7]),
    .CE1                    (1'b1),
    .CE2                    (1'b1),
    .CLKDIVP                (1'b0),
    .D                      (rx_sdata),
    .SHIFTIN1               (1'b0),
    .SHIFTIN2               (1'b0),
    .DYNCLKDIVSEL           (1'b0),
    .DYNCLKSEL              (1'b0),
    .OFB                    (1'b0),
    .OCLK                   (1'b0),
    .OCLKB                  (1'b0),
    .SHIFTOUT1              (),
    .SHIFTOUT2              (),
    .O                      (rx_gpio_in));

  end
  endgenerate

  // io delay

  generate
  if (GPIO2_CMOS1_LVDS0 == 2) begin

  assign rx_ddata = 1'd0;
  assign axilite_delay_rddata = 5'd0;

  end else begin

  (* IODELAY_GROUP = IODELAY_GROUP *)
  IDELAYE2 # (
    .CINVCTRL_SEL           ("FALSE"),
    .DELAY_SRC              ("IDATAIN"),
    .HIGH_PERFORMANCE_MODE  ("FALSE"),
    .IDELAY_TYPE            ("VAR_LOAD"),
    .IDELAY_VALUE           (0),
    .REFCLK_FREQUENCY       (200.0),
    .PIPE_SEL               ("FALSE"),
    .SIGNAL_PATTERN         ("DATA"))
  i_delay (
    .CE                     (1'b0),
    .INC                    (1'b0),
    .DATAIN                 (1'b0),
    .LDPIPEEN               (1'b0),
    .CINVCTRL               (1'b0),
    .REGRST                 (1'b0),
    .C                      (axilite_clk),
    .IDATAIN                (rx_sdata),
    .DATAOUT                (rx_ddata),
    .LD                     (axilite_delay_rdwr),
    .CNTVALUEIN             (axilite_delay_wrdata),
    .CNTVALUEOUT            (axilite_delay_rddata));

  end
  endgenerate

  // io buffers
 
  generate
  if (GPIO2_CMOS1_LVDS0 == 0) begin

  IBUFDS i_ibuf (
    .I                      (rx_data_p),
    .IB                     (rx_data_n),
    .O                      (rx_sdata));

  end else if (GPIO2_CMOS1_LVDS0 == 1) begin

  IBUF i_ibuf (
    .I                      (rx_data_p),
    .O                      (rx_sdata));

  end else begin

  assign rx_sdata = 1'd0;

  end
  endgenerate

endmodule

// **********************************************************************************
// **********************************************************************************
