// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001, receive data monitor
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_rx #(

  parameter ID = 0,
  parameter GPIO2_CMOS1_LVDS0 = 0,
  parameter IODELAY_GROUP = "IODELAY_GROUP",
  parameter IODELAY_CTRL_ENABLE = 1) (

  // receive interface

  input   wire            rx_cssi_clk_lssi_clk_p,
  input   wire            rx_cssi_nc_lssi_clk_n,
  input   wire            rx_cssi_strobe_lssi_strobe_p,
  input   wire            rx_cssi_nc_lssi_strobe_n,
  input   wire            rx_cssi_data1_lssi_data0_p,
  input   wire            rx_cssi_data0_lssi_data0_n,
  input   wire            rx_cssi_data3_lssi_data1_p,
  input   wire            rx_cssi_data2_lssi_data1_n,
  input   wire  [  7:0]   rx_cssi_gpio_in,
  output  wire  [  7:0]   rx_cssi_gpio_out,
  output  wire  [  7:0]   rx_cssi_gpio_enb,

  // internal interface

  output  wire            rx_buf_clk,
  output  wire            rx_clk,
  output  reg             rx_resetn = 1'd1,
  output  wire            rx_valid,
  output  wire  [ 63:0]   rx_data,
  input   wire            rx_enable,
  output  wire            orx_valid,
  output  wire  [ 63:0]   orx_data,
  input   wire            orx_enable,
  output  wire  [  7:0]   rx_gpio_in,
  input   wire  [  7:0]   rx_gpio_out,
  input   wire  [  7:0]   rx_gpio_enb,

  // mcs & transmit interface

  input   wire            mcs_toggle,
  input   wire            tx_pattern_done,

  // delay interface

  input   wire            sys_200m_clk,
  input   wire            sys_200m_resetn,

  // axi interface

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [ 15:0]   axilite_wraddr,
  input   wire  [ 31:0]   axilite_wrdata,
  output  wire            axilite_wrack,
  input   wire            axilite_rdreq,
  input   wire  [ 15:0]   axilite_rdaddr,
  output  wire  [ 31:0]   axilite_rddata,
  output  wire            axilite_rdack);
  
  // cmos & lvds data lines

  localparam              GPIO2_CMOS1 = (GPIO2_CMOS1_LVDS0 == 1) ? 1 : 2;

  // supported interface modes

  localparam    [  7:0]   CMOS_1L_LS_64X1 = {1'b1, 1'b0, 1'b1, 3'b101, 2'b00};
  localparam    [  7:0]   CMOS_1L_LS_64X2 = {1'b1, 1'b0, 1'b1, 3'b101, 2'b01};
  localparam    [  7:0]   CMOS_1L_LS_64X4 = {1'b1, 1'b0, 1'b1, 3'b101, 2'b10};
  localparam    [  7:0]   CMOS_1L_LS_64X8 = {1'b1, 1'b0, 1'b1, 3'b101, 2'b11};
  localparam    [  7:0]   CMOS_1L_LS_32X1 = {1'b1, 1'b0, 1'b1, 3'b100, 2'b00};
  localparam    [  7:0]   CMOS_1L_LS_32X2 = {1'b1, 1'b0, 1'b1, 3'b100, 2'b01};
  localparam    [  7:0]   CMOS_1L_LS_32X4 = {1'b1, 1'b0, 1'b1, 3'b100, 2'b10};
  localparam    [  7:0]   CMOS_1L_LS_32X8 = {1'b1, 1'b0, 1'b1, 3'b100, 2'b11};
  localparam    [  7:0]   CMOS_1L_PS_16X1 = {1'b1, 1'b0, 1'b0, 3'b010, 2'b00};
  localparam    [  7:0]   CMOS_1L_PS_16X2 = {1'b1, 1'b0, 1'b0, 3'b010, 2'b01};
  localparam    [  7:0]   CMOS_1L_PS_16X4 = {1'b1, 1'b0, 1'b0, 3'b010, 2'b10};
  localparam    [  7:0]   CMOS_1L_PS_16X8 = {1'b1, 1'b0, 1'b0, 3'b010, 2'b11};
  localparam    [  7:0]   CMOS_1L_PS_08X1 = {1'b1, 1'b0, 1'b0, 3'b001, 2'b00};
  localparam    [  7:0]   CMOS_1L_PS_08X2 = {1'b1, 1'b0, 1'b0, 3'b001, 2'b01};
  localparam    [  7:0]   CMOS_1L_PS_08X4 = {1'b1, 1'b0, 1'b0, 3'b001, 2'b10};
  localparam    [  7:0]   CMOS_1L_PS_08X8 = {1'b1, 1'b0, 1'b0, 3'b001, 2'b11};
  localparam    [  7:0]   CMOS_1L_PS_02X1 = {1'b1, 1'b0, 1'b0, 3'b000, 2'b00};
  localparam    [  7:0]   CMOS_1L_PS_02X2 = {1'b1, 1'b0, 1'b0, 3'b000, 2'b01};
  localparam    [  7:0]   CMOS_1L_PS_02X4 = {1'b1, 1'b0, 1'b0, 3'b000, 2'b10};
  localparam    [  7:0]   CMOS_1L_PS_02X8 = {1'b1, 1'b0, 1'b0, 3'b000, 2'b11};
  localparam    [  7:0]   CMOS_1L_PS_64X1 = {1'b1, 1'b0, 1'b0, 3'b101, 2'b00};
  localparam    [  7:0]   CMOS_1L_PS_64X2 = {1'b1, 1'b0, 1'b0, 3'b101, 2'b01};
  localparam    [  7:0]   CMOS_1L_PS_64X4 = {1'b1, 1'b0, 1'b0, 3'b101, 2'b10};
  localparam    [  7:0]   CMOS_1L_PS_64X8 = {1'b1, 1'b0, 1'b0, 3'b101, 2'b11};
  localparam    [  7:0]   CMOS_1L_PS_32X1 = {1'b1, 1'b0, 1'b0, 3'b100, 2'b00};
  localparam    [  7:0]   CMOS_1L_PS_32X2 = {1'b1, 1'b0, 1'b0, 3'b100, 2'b01};
  localparam    [  7:0]   CMOS_1L_PS_32X4 = {1'b1, 1'b0, 1'b0, 3'b100, 2'b10};
  localparam    [  7:0]   CMOS_1L_PS_32X8 = {1'b1, 1'b0, 1'b0, 3'b100, 2'b11};
  localparam    [  7:0]   CMOS_4L_PS_64X1 = {1'b1, 1'b1, 1'b0, 3'b101, 2'b00};
  localparam    [  7:0]   CMOS_4L_PS_32X1 = {1'b1, 1'b1, 1'b0, 3'b100, 2'b00};
  localparam    [  7:0]   LVDS_1L_LS_64X1 = {1'b0, 1'b0, 1'b1, 3'b101, 2'b00};
  localparam    [  7:0]   LVDS_1L_LS_32X1 = {1'b0, 1'b0, 1'b1, 3'b100, 2'b00};
  localparam    [  7:0]   LVDS_1L_LS_24X1 = {1'b0, 1'b0, 1'b1, 3'b011, 2'b00};
  localparam    [  7:0]   LVDS_1L_PS_64X1 = {1'b0, 1'b0, 1'b0, 3'b101, 2'b00};
  localparam    [  7:0]   LVDS_1L_PS_32X1 = {1'b0, 1'b0, 1'b0, 3'b100, 2'b00};
  localparam    [  7:0]   LVDS_1L_PS_24X1 = {1'b0, 1'b0, 1'b0, 3'b011, 2'b00};
  localparam    [  7:0]   LVDS_2L_PS_64X1 = {1'b0, 1'b1, 1'b0, 3'b101, 2'b00};
  localparam    [  7:0]   LVDS_2L_PS_32X1 = {1'b0, 1'b1, 1'b0, 3'b100, 2'b00};
  localparam    [  7:0]   LVDS_2L_PS_24X1 = {1'b0, 1'b1, 1'b0, 3'b011, 2'b00};

  // internal registers
 
  reg                     rx_valid_bs = 'd0;
  reg           [ 63:0]   rx_data_bs = 'd0;
  reg                     rx_valid_iq = 'd0;
  reg           [ 63:0]   rx_data_iq = 'd0;
  reg                     rx_valid_64 = 'd0;
  reg           [ 63:0]   rx_data_64 = 'd0;
  reg                     rx_bvalid_d = 'd0;
  reg           [  7:0]   rx_bstrobe_d = 'd0;
  reg           [  7:0]   rx_bdata_0_d = 'd0;
  reg           [  7:0]   rx_bdata_1_d = 'd0;
  reg           [  7:0]   rx_bdata_2_d = 'd0;
  reg           [  7:0]   rx_bdata_3_d = 'd0;
  reg           [  6:0]   rx_bcnt = 'd0;
  reg           [  2:0]   rx_fcnt = 'd0;
  reg                     rx_err = 'd0;
  reg                     rx_bvalid = 'd0;
  reg           [  7:0]   rx_bstrobe = 'd0;
  reg           [  7:0]   rx_bdata_0 = 'd0;
  reg           [  7:0]   rx_bdata_1 = 'd0;
  reg           [  7:0]   rx_bdata_2 = 'd0;
  reg           [  7:0]   rx_bdata_3 = 'd0;
  reg           [  6:0]   rx_dstrobe_d = 'd0;
  reg           [  6:0]   rx_ddata_0_d = 'd0;
  reg           [  6:0]   rx_ddata_1_d = 'd0;
  reg           [  6:0]   rx_ddata_2_d = 'd0;
  reg           [  6:0]   rx_ddata_3_d = 'd0;
  reg                     rx_dtoggle = 'd0;
  reg                     rx_dvalid = 'd0;
  reg           [  7:0]   rx_dstrobe = 'd0;
  reg           [  7:0]   rx_ddata_0 = 'd0;
  reg           [  7:0]   rx_ddata_1 = 'd0;
  reg           [  7:0]   rx_ddata_2 = 'd0;
  reg           [  7:0]   rx_ddata_3 = 'd0;
  reg                     rx_mcs_toggle_d = 'd0;
  reg                     rx_mcs_latency_start = 'd0;
  reg                     rx_mcs_latency_stop = 'd0;
  reg           [  3:0]   rx_mcs_latency_incr = 'd0;
  reg                     rx_mcs_latency_enable = 'd0;
  reg           [ 15:0]   rx_mcs_latency_count = 'd0;
  reg                     rx_frm_err = 'd0;
  reg           [  5:0]   rx_frm_bit_cnt = 'd0;
  reg                     rx_frm_oos = 'd0;
  reg           [  1:0]   rx_frm_oos_cnt = 'd0;
  reg           [  2:0]   rx_frm_align = 'd0;
  reg           [  3:0]   rx_frm_align_cnt = 'd0;
  reg                     rx_init_req_d = 'd0;
  reg           [  3:0]   rx_init_cnt = 'd0;
  reg                     axilite_delay_unlocked = 'd1;
  reg                     axilite_cpu_resetn = 1'd0;
  reg                     axilite_cpu_reset = 1'd1;
  reg                     axilite_mcs_sync_d = 1'd0;
  reg                     axilite_mcs_toggle_d = 1'd0;
  reg                     axilite_mcs_resetn = 1'd0;
  reg           [  3:0]   axilite_mcs_count = 4'd0;
  reg                     axilite_sw_resetn = 'd0;
  reg                     axilite_sw_reset_in_d = 'd0;
  reg           [  3:0]   axilite_sw_reset_count = 'd0;

  // internal signals
 
  wire                    rx_cmos1_lvds0;
  wire          [  7:0]   rx_mode;
  wire                    rx_init_ack;
  wire                    rx_mcs_toggle;
  wire          [ 63:0]   rx_mon_data;
  wire                    rx_mon_oos;
  wire                    rx_mon_err;
  wire                    rx_pattern_state;
  wire          [ 31:0]   rx_pattern_count;
  wire          [  7:0]   rx_pstrobe;
  wire          [  7:0]   rx_pdata_0;
  wire          [  7:0]   rx_pdata_1;
  wire          [  7:0]   rx_pdata_2;
  wire          [  7:0]   rx_pdata_3;
  wire                    rx_hs_clk;
  wire          [  3:0]   rx_data_p;
  wire          [  3:0]   rx_data_n;
  wire                    rx_init_req;
  wire                    rx_mcs_sync;
  wire          [  2:0]   rx_data_sel;
  wire          [ 63:0]   rx_pattern;
  wire          [  3:0]   rx_dec_ratio;
  wire          [  3:0]   orx_dec_ratio;
  wire                    rx_fall1_rise0;
  wire                    rx_q1_i0;
  wire                    rx_lsb1_msb0;
  wire                    rx_sdr1_ddr0;
  wire                    rx_mlane1_slane0;
  wire                    rx_lstrb1_pstrb0;
  wire          [  2:0]   rx_num_of_bits;
  wire          [  1:0]   rx_clk_rate;
  wire                    rx_cpu_resetn;
  wire          [  7:0]   rx_cmos_gpio_in;
  wire                    delay_locked;
  wire          [ 31:0]   axilite_cmos_lvds_id;
  wire          [  1:0]   axilite_clk_rate;
  wire          [  2:0]   axilite_num_of_bits;
  wire                    axilite_lstrb1_pstrb0;
  wire                    axilite_mlane1_slane0;
  wire                    axilite_sdr1_ddr0;
  wire                    axilite_lsb1_msb0;
  wire                    axilite_q1_i0;
  wire                    axilite_fall1_rise0;
  wire                    axilite_cmos1_lvds0;
  wire                    axilite_frm_oos;
  wire                    axilite_frm_err;
  wire                    axilite_mon_oos;
  wire                    axilite_mon_err;
  wire                    axilite_init_req;
  wire                    axilite_init_ack;
  wire          [  2:0]   axilite_data_sel;
  wire          [ 63:0]   axilite_pattern;
  wire          [ 63:0]   axilite_mon_data;
  wire          [  3:0]   axilite_rx_dec_ratio;
  wire          [  3:0]   axilite_orx_dec_ratio;
  wire                    axilite_delay_locked;
  wire          [  4:0]   axilite_wrdelay_0;
  wire          [  4:0]   axilite_rddelay_0;
  wire          [  4:0]   axilite_wrdelay_1;
  wire          [  4:0]   axilite_rddelay_1;
  wire          [  4:0]   axilite_wrdelay_2;
  wire          [  4:0]   axilite_rddelay_2;
  wire          [  4:0]   axilite_wrdelay_3;
  wire          [  4:0]   axilite_rddelay_3;
  wire          [  4:0]   axilite_wrdelay_s;
  wire          [  4:0]   axilite_rddelay_s;
  wire          [ 31:0]   axilite_clk_mon_count;
  wire          [ 15:0]   axilite_mcs_latency_count;
  wire                    axilite_mcs_sync;
  wire          [  3:0]   axilite_mcs_active;
  wire                    axilite_mcs_toggle;
  wire                    axilite_mcs_toggle_p;
  wire                    axilite_pattern_state;
  wire          [ 31:0]   axilite_pattern_count;
  wire                    axilite_sw_reset_in;

  // configuration options

  assign axilite_cmos_lvds_id = (GPIO2_CMOS1_LVDS0 == 0) ? 32'h4c564453 :
    ((GPIO2_CMOS1_LVDS0 == 1) ? 32'h434d4f53 : 32'h4750494f);
  assign axilite_cmos1_lvds0 = (GPIO2_CMOS1_LVDS0 == 0) ? 1'b0 : 1'b1;
  assign rx_cmos1_lvds0 = (GPIO2_CMOS1_LVDS0 == 0) ? 1'b0 : 1'b1;

  assign rx_mode[7:7] = rx_cmos1_lvds0;
  assign rx_mode[6:6] = rx_mlane1_slane0;
  assign rx_mode[5:5] = rx_lstrb1_pstrb0;
  assign rx_mode[4:2] = rx_num_of_bits;
  assign rx_mode[1:0] = rx_clk_rate;

  // lsb-msb swap
 
  always @(posedge rx_clk) begin
    rx_valid_bs <= rx_valid_iq;
    case ({rx_lsb1_msb0, rx_num_of_bits})
      4'b1101: begin
        rx_data_bs[63] <= rx_data_iq[32];
        rx_data_bs[62] <= rx_data_iq[33];
        rx_data_bs[61] <= rx_data_iq[34];
        rx_data_bs[60] <= rx_data_iq[35];
        rx_data_bs[59] <= rx_data_iq[36];
        rx_data_bs[58] <= rx_data_iq[37];
        rx_data_bs[57] <= rx_data_iq[38];
        rx_data_bs[56] <= rx_data_iq[39];
        rx_data_bs[55] <= rx_data_iq[40];
        rx_data_bs[54] <= rx_data_iq[41];
        rx_data_bs[53] <= rx_data_iq[42];
        rx_data_bs[52] <= rx_data_iq[43];
        rx_data_bs[51] <= rx_data_iq[44];
        rx_data_bs[50] <= rx_data_iq[45];
        rx_data_bs[49] <= rx_data_iq[46];
        rx_data_bs[48] <= rx_data_iq[47];
        rx_data_bs[47] <= rx_data_iq[48];
        rx_data_bs[46] <= rx_data_iq[49];
        rx_data_bs[45] <= rx_data_iq[50];
        rx_data_bs[44] <= rx_data_iq[51];
        rx_data_bs[43] <= rx_data_iq[52];
        rx_data_bs[42] <= rx_data_iq[53];
        rx_data_bs[41] <= rx_data_iq[54];
        rx_data_bs[40] <= rx_data_iq[55];
        rx_data_bs[39] <= rx_data_iq[56];
        rx_data_bs[38] <= rx_data_iq[57];
        rx_data_bs[37] <= rx_data_iq[58];
        rx_data_bs[36] <= rx_data_iq[59];
        rx_data_bs[35] <= rx_data_iq[60];
        rx_data_bs[34] <= rx_data_iq[61];
        rx_data_bs[33] <= rx_data_iq[62];
        rx_data_bs[32] <= rx_data_iq[63];
        rx_data_bs[31] <= rx_data_iq[ 0];
        rx_data_bs[30] <= rx_data_iq[ 1];
        rx_data_bs[29] <= rx_data_iq[ 2];
        rx_data_bs[28] <= rx_data_iq[ 3];
        rx_data_bs[27] <= rx_data_iq[ 4];
        rx_data_bs[26] <= rx_data_iq[ 5];
        rx_data_bs[25] <= rx_data_iq[ 6];
        rx_data_bs[24] <= rx_data_iq[ 7];
        rx_data_bs[23] <= rx_data_iq[ 8];
        rx_data_bs[22] <= rx_data_iq[ 9];
        rx_data_bs[21] <= rx_data_iq[10];
        rx_data_bs[20] <= rx_data_iq[11];
        rx_data_bs[19] <= rx_data_iq[12];
        rx_data_bs[18] <= rx_data_iq[13];
        rx_data_bs[17] <= rx_data_iq[14];
        rx_data_bs[16] <= rx_data_iq[15];
        rx_data_bs[15] <= rx_data_iq[16];
        rx_data_bs[14] <= rx_data_iq[17];
        rx_data_bs[13] <= rx_data_iq[18];
        rx_data_bs[12] <= rx_data_iq[19];
        rx_data_bs[11] <= rx_data_iq[20];
        rx_data_bs[10] <= rx_data_iq[21];
        rx_data_bs[ 9] <= rx_data_iq[22];
        rx_data_bs[ 8] <= rx_data_iq[23];
        rx_data_bs[ 7] <= rx_data_iq[24];
        rx_data_bs[ 6] <= rx_data_iq[25];
        rx_data_bs[ 5] <= rx_data_iq[26];
        rx_data_bs[ 4] <= rx_data_iq[27];
        rx_data_bs[ 3] <= rx_data_iq[28];
        rx_data_bs[ 2] <= rx_data_iq[29];
        rx_data_bs[ 1] <= rx_data_iq[30];
        rx_data_bs[ 0] <= rx_data_iq[31];
      end
      4'b1100: begin
        rx_data_bs[63] <= rx_data_iq[48];
        rx_data_bs[62] <= rx_data_iq[49];
        rx_data_bs[61] <= rx_data_iq[50];
        rx_data_bs[60] <= rx_data_iq[51];
        rx_data_bs[59] <= rx_data_iq[52];
        rx_data_bs[58] <= rx_data_iq[53];
        rx_data_bs[57] <= rx_data_iq[54];
        rx_data_bs[56] <= rx_data_iq[55];
        rx_data_bs[55] <= rx_data_iq[56];
        rx_data_bs[54] <= rx_data_iq[57];
        rx_data_bs[53] <= rx_data_iq[58];
        rx_data_bs[52] <= rx_data_iq[59];
        rx_data_bs[51] <= rx_data_iq[60];
        rx_data_bs[50] <= rx_data_iq[61];
        rx_data_bs[49] <= rx_data_iq[62];
        rx_data_bs[48] <= rx_data_iq[63];
        rx_data_bs[47] <= rx_data_iq[32];
        rx_data_bs[46] <= rx_data_iq[33];
        rx_data_bs[45] <= rx_data_iq[34];
        rx_data_bs[44] <= rx_data_iq[35];
        rx_data_bs[43] <= rx_data_iq[36];
        rx_data_bs[42] <= rx_data_iq[37];
        rx_data_bs[41] <= rx_data_iq[38];
        rx_data_bs[40] <= rx_data_iq[39];
        rx_data_bs[39] <= rx_data_iq[40];
        rx_data_bs[38] <= rx_data_iq[41];
        rx_data_bs[37] <= rx_data_iq[42];
        rx_data_bs[36] <= rx_data_iq[43];
        rx_data_bs[35] <= rx_data_iq[44];
        rx_data_bs[34] <= rx_data_iq[45];
        rx_data_bs[33] <= rx_data_iq[46];
        rx_data_bs[32] <= rx_data_iq[47];
        rx_data_bs[31] <= rx_data_iq[16];
        rx_data_bs[30] <= rx_data_iq[17];
        rx_data_bs[29] <= rx_data_iq[18];
        rx_data_bs[28] <= rx_data_iq[19];
        rx_data_bs[27] <= rx_data_iq[20];
        rx_data_bs[26] <= rx_data_iq[21];
        rx_data_bs[25] <= rx_data_iq[22];
        rx_data_bs[24] <= rx_data_iq[23];
        rx_data_bs[23] <= rx_data_iq[24];
        rx_data_bs[22] <= rx_data_iq[25];
        rx_data_bs[21] <= rx_data_iq[26];
        rx_data_bs[20] <= rx_data_iq[27];
        rx_data_bs[19] <= rx_data_iq[28];
        rx_data_bs[18] <= rx_data_iq[29];
        rx_data_bs[17] <= rx_data_iq[30];
        rx_data_bs[16] <= rx_data_iq[31];
        rx_data_bs[15] <= rx_data_iq[ 0];
        rx_data_bs[14] <= rx_data_iq[ 1];
        rx_data_bs[13] <= rx_data_iq[ 2];
        rx_data_bs[12] <= rx_data_iq[ 3];
        rx_data_bs[11] <= rx_data_iq[ 4];
        rx_data_bs[10] <= rx_data_iq[ 5];
        rx_data_bs[ 9] <= rx_data_iq[ 6];
        rx_data_bs[ 8] <= rx_data_iq[ 7];
        rx_data_bs[ 7] <= rx_data_iq[ 8];
        rx_data_bs[ 6] <= rx_data_iq[ 9];
        rx_data_bs[ 5] <= rx_data_iq[10];
        rx_data_bs[ 4] <= rx_data_iq[11];
        rx_data_bs[ 3] <= rx_data_iq[12];
        rx_data_bs[ 2] <= rx_data_iq[13];
        rx_data_bs[ 1] <= rx_data_iq[14];
        rx_data_bs[ 0] <= rx_data_iq[15];
      end
      4'b1011: begin
        rx_data_bs[63] <= rx_data_iq[63];
        rx_data_bs[62] <= rx_data_iq[62];
        rx_data_bs[61] <= rx_data_iq[61];
        rx_data_bs[60] <= rx_data_iq[60];
        rx_data_bs[59] <= rx_data_iq[48];
        rx_data_bs[58] <= rx_data_iq[49];
        rx_data_bs[57] <= rx_data_iq[50];
        rx_data_bs[56] <= rx_data_iq[51];
        rx_data_bs[55] <= rx_data_iq[52];
        rx_data_bs[54] <= rx_data_iq[53];
        rx_data_bs[53] <= rx_data_iq[54];
        rx_data_bs[52] <= rx_data_iq[55];
        rx_data_bs[51] <= rx_data_iq[56];
        rx_data_bs[50] <= rx_data_iq[57];
        rx_data_bs[49] <= rx_data_iq[58];
        rx_data_bs[48] <= rx_data_iq[59];
        rx_data_bs[47] <= rx_data_iq[47];
        rx_data_bs[46] <= rx_data_iq[46];
        rx_data_bs[45] <= rx_data_iq[45];
        rx_data_bs[44] <= rx_data_iq[44];
        rx_data_bs[43] <= rx_data_iq[32];
        rx_data_bs[42] <= rx_data_iq[33];
        rx_data_bs[41] <= rx_data_iq[34];
        rx_data_bs[40] <= rx_data_iq[35];
        rx_data_bs[39] <= rx_data_iq[36];
        rx_data_bs[38] <= rx_data_iq[37];
        rx_data_bs[37] <= rx_data_iq[38];
        rx_data_bs[36] <= rx_data_iq[39];
        rx_data_bs[35] <= rx_data_iq[40];
        rx_data_bs[34] <= rx_data_iq[41];
        rx_data_bs[33] <= rx_data_iq[42];
        rx_data_bs[32] <= rx_data_iq[43];
        rx_data_bs[31] <= rx_data_iq[31];
        rx_data_bs[30] <= rx_data_iq[30];
        rx_data_bs[29] <= rx_data_iq[29];
        rx_data_bs[28] <= rx_data_iq[28];
        rx_data_bs[27] <= rx_data_iq[16];
        rx_data_bs[26] <= rx_data_iq[17];
        rx_data_bs[25] <= rx_data_iq[18];
        rx_data_bs[24] <= rx_data_iq[19];
        rx_data_bs[23] <= rx_data_iq[20];
        rx_data_bs[22] <= rx_data_iq[21];
        rx_data_bs[21] <= rx_data_iq[22];
        rx_data_bs[20] <= rx_data_iq[23];
        rx_data_bs[19] <= rx_data_iq[24];
        rx_data_bs[18] <= rx_data_iq[25];
        rx_data_bs[17] <= rx_data_iq[26];
        rx_data_bs[16] <= rx_data_iq[27];
        rx_data_bs[15] <= rx_data_iq[15];
        rx_data_bs[14] <= rx_data_iq[14];
        rx_data_bs[13] <= rx_data_iq[13];
        rx_data_bs[12] <= rx_data_iq[12];
        rx_data_bs[11] <= rx_data_iq[ 0];
        rx_data_bs[10] <= rx_data_iq[ 1];
        rx_data_bs[ 9] <= rx_data_iq[ 2];
        rx_data_bs[ 8] <= rx_data_iq[ 3];
        rx_data_bs[ 7] <= rx_data_iq[ 4];
        rx_data_bs[ 6] <= rx_data_iq[ 5];
        rx_data_bs[ 5] <= rx_data_iq[ 6];
        rx_data_bs[ 4] <= rx_data_iq[ 7];
        rx_data_bs[ 3] <= rx_data_iq[ 8];
        rx_data_bs[ 2] <= rx_data_iq[ 9];
        rx_data_bs[ 1] <= rx_data_iq[10];
        rx_data_bs[ 0] <= rx_data_iq[11];
      end
      4'b1010: begin
        rx_data_bs[63] <= rx_data_iq[48];
        rx_data_bs[62] <= rx_data_iq[49];
        rx_data_bs[61] <= rx_data_iq[50];
        rx_data_bs[60] <= rx_data_iq[51];
        rx_data_bs[59] <= rx_data_iq[52];
        rx_data_bs[58] <= rx_data_iq[53];
        rx_data_bs[57] <= rx_data_iq[54];
        rx_data_bs[56] <= rx_data_iq[55];
        rx_data_bs[55] <= rx_data_iq[56];
        rx_data_bs[54] <= rx_data_iq[57];
        rx_data_bs[53] <= rx_data_iq[58];
        rx_data_bs[52] <= rx_data_iq[59];
        rx_data_bs[51] <= rx_data_iq[60];
        rx_data_bs[50] <= rx_data_iq[61];
        rx_data_bs[49] <= rx_data_iq[62];
        rx_data_bs[48] <= rx_data_iq[63];
        rx_data_bs[47] <= rx_data_iq[32];
        rx_data_bs[46] <= rx_data_iq[33];
        rx_data_bs[45] <= rx_data_iq[34];
        rx_data_bs[44] <= rx_data_iq[35];
        rx_data_bs[43] <= rx_data_iq[36];
        rx_data_bs[42] <= rx_data_iq[37];
        rx_data_bs[41] <= rx_data_iq[38];
        rx_data_bs[40] <= rx_data_iq[39];
        rx_data_bs[39] <= rx_data_iq[40];
        rx_data_bs[38] <= rx_data_iq[41];
        rx_data_bs[37] <= rx_data_iq[42];
        rx_data_bs[36] <= rx_data_iq[43];
        rx_data_bs[35] <= rx_data_iq[44];
        rx_data_bs[34] <= rx_data_iq[45];
        rx_data_bs[33] <= rx_data_iq[46];
        rx_data_bs[32] <= rx_data_iq[47];
        rx_data_bs[31] <= rx_data_iq[16];
        rx_data_bs[30] <= rx_data_iq[17];
        rx_data_bs[29] <= rx_data_iq[18];
        rx_data_bs[28] <= rx_data_iq[19];
        rx_data_bs[27] <= rx_data_iq[20];
        rx_data_bs[26] <= rx_data_iq[21];
        rx_data_bs[25] <= rx_data_iq[22];
        rx_data_bs[24] <= rx_data_iq[23];
        rx_data_bs[23] <= rx_data_iq[24];
        rx_data_bs[22] <= rx_data_iq[25];
        rx_data_bs[21] <= rx_data_iq[26];
        rx_data_bs[20] <= rx_data_iq[27];
        rx_data_bs[19] <= rx_data_iq[28];
        rx_data_bs[18] <= rx_data_iq[29];
        rx_data_bs[17] <= rx_data_iq[30];
        rx_data_bs[16] <= rx_data_iq[31];
        rx_data_bs[15] <= rx_data_iq[ 0];
        rx_data_bs[14] <= rx_data_iq[ 1];
        rx_data_bs[13] <= rx_data_iq[ 2];
        rx_data_bs[12] <= rx_data_iq[ 3];
        rx_data_bs[11] <= rx_data_iq[ 4];
        rx_data_bs[10] <= rx_data_iq[ 5];
        rx_data_bs[ 9] <= rx_data_iq[ 6];
        rx_data_bs[ 8] <= rx_data_iq[ 7];
        rx_data_bs[ 7] <= rx_data_iq[ 8];
        rx_data_bs[ 6] <= rx_data_iq[ 9];
        rx_data_bs[ 5] <= rx_data_iq[10];
        rx_data_bs[ 4] <= rx_data_iq[11];
        rx_data_bs[ 3] <= rx_data_iq[12];
        rx_data_bs[ 2] <= rx_data_iq[13];
        rx_data_bs[ 1] <= rx_data_iq[14];
        rx_data_bs[ 0] <= rx_data_iq[15];
      end
      4'b1001: begin
        rx_data_bs[63] <= rx_data_iq[56];
        rx_data_bs[62] <= rx_data_iq[57];
        rx_data_bs[61] <= rx_data_iq[58];
        rx_data_bs[60] <= rx_data_iq[59];
        rx_data_bs[59] <= rx_data_iq[60];
        rx_data_bs[58] <= rx_data_iq[61];
        rx_data_bs[57] <= rx_data_iq[62];
        rx_data_bs[56] <= rx_data_iq[63];
        rx_data_bs[55] <= rx_data_iq[48];
        rx_data_bs[54] <= rx_data_iq[49];
        rx_data_bs[53] <= rx_data_iq[50];
        rx_data_bs[52] <= rx_data_iq[51];
        rx_data_bs[51] <= rx_data_iq[52];
        rx_data_bs[50] <= rx_data_iq[53];
        rx_data_bs[49] <= rx_data_iq[54];
        rx_data_bs[48] <= rx_data_iq[55];
        rx_data_bs[47] <= rx_data_iq[40];
        rx_data_bs[46] <= rx_data_iq[41];
        rx_data_bs[45] <= rx_data_iq[42];
        rx_data_bs[44] <= rx_data_iq[43];
        rx_data_bs[43] <= rx_data_iq[44];
        rx_data_bs[42] <= rx_data_iq[45];
        rx_data_bs[41] <= rx_data_iq[46];
        rx_data_bs[40] <= rx_data_iq[47];
        rx_data_bs[39] <= rx_data_iq[32];
        rx_data_bs[38] <= rx_data_iq[33];
        rx_data_bs[37] <= rx_data_iq[34];
        rx_data_bs[36] <= rx_data_iq[35];
        rx_data_bs[35] <= rx_data_iq[36];
        rx_data_bs[34] <= rx_data_iq[37];
        rx_data_bs[33] <= rx_data_iq[38];
        rx_data_bs[32] <= rx_data_iq[39];
        rx_data_bs[31] <= rx_data_iq[24];
        rx_data_bs[30] <= rx_data_iq[25];
        rx_data_bs[29] <= rx_data_iq[26];
        rx_data_bs[28] <= rx_data_iq[27];
        rx_data_bs[27] <= rx_data_iq[28];
        rx_data_bs[26] <= rx_data_iq[29];
        rx_data_bs[25] <= rx_data_iq[30];
        rx_data_bs[24] <= rx_data_iq[31];
        rx_data_bs[23] <= rx_data_iq[16];
        rx_data_bs[22] <= rx_data_iq[17];
        rx_data_bs[21] <= rx_data_iq[18];
        rx_data_bs[20] <= rx_data_iq[19];
        rx_data_bs[19] <= rx_data_iq[20];
        rx_data_bs[18] <= rx_data_iq[21];
        rx_data_bs[17] <= rx_data_iq[22];
        rx_data_bs[16] <= rx_data_iq[23];
        rx_data_bs[15] <= rx_data_iq[ 8];
        rx_data_bs[14] <= rx_data_iq[ 9];
        rx_data_bs[13] <= rx_data_iq[10];
        rx_data_bs[12] <= rx_data_iq[11];
        rx_data_bs[11] <= rx_data_iq[12];
        rx_data_bs[10] <= rx_data_iq[13];
        rx_data_bs[ 9] <= rx_data_iq[14];
        rx_data_bs[ 8] <= rx_data_iq[15];
        rx_data_bs[ 7] <= rx_data_iq[ 0];
        rx_data_bs[ 6] <= rx_data_iq[ 1];
        rx_data_bs[ 5] <= rx_data_iq[ 2];
        rx_data_bs[ 4] <= rx_data_iq[ 3];
        rx_data_bs[ 3] <= rx_data_iq[ 4];
        rx_data_bs[ 2] <= rx_data_iq[ 5];
        rx_data_bs[ 1] <= rx_data_iq[ 6];
        rx_data_bs[ 0] <= rx_data_iq[ 7];
      end
      4'b1000: begin
        rx_data_bs[63] <= rx_data_iq[63];
        rx_data_bs[62] <= rx_data_iq[62];
        rx_data_bs[61] <= rx_data_iq[61];
        rx_data_bs[60] <= rx_data_iq[60];
        rx_data_bs[59] <= rx_data_iq[59];
        rx_data_bs[58] <= rx_data_iq[58];
        rx_data_bs[57] <= rx_data_iq[56];
        rx_data_bs[56] <= rx_data_iq[57];
        rx_data_bs[55] <= rx_data_iq[55];
        rx_data_bs[54] <= rx_data_iq[54];
        rx_data_bs[53] <= rx_data_iq[53];
        rx_data_bs[52] <= rx_data_iq[52];
        rx_data_bs[51] <= rx_data_iq[51];
        rx_data_bs[50] <= rx_data_iq[50];
        rx_data_bs[49] <= rx_data_iq[48];
        rx_data_bs[48] <= rx_data_iq[49];
        rx_data_bs[47] <= rx_data_iq[47];
        rx_data_bs[46] <= rx_data_iq[46];
        rx_data_bs[45] <= rx_data_iq[45];
        rx_data_bs[44] <= rx_data_iq[44];
        rx_data_bs[43] <= rx_data_iq[43];
        rx_data_bs[42] <= rx_data_iq[42];
        rx_data_bs[41] <= rx_data_iq[40];
        rx_data_bs[40] <= rx_data_iq[41];
        rx_data_bs[39] <= rx_data_iq[39];
        rx_data_bs[38] <= rx_data_iq[38];
        rx_data_bs[37] <= rx_data_iq[37];
        rx_data_bs[36] <= rx_data_iq[36];
        rx_data_bs[35] <= rx_data_iq[35];
        rx_data_bs[34] <= rx_data_iq[34];
        rx_data_bs[33] <= rx_data_iq[32];
        rx_data_bs[32] <= rx_data_iq[33];
        rx_data_bs[31] <= rx_data_iq[31];
        rx_data_bs[30] <= rx_data_iq[30];
        rx_data_bs[29] <= rx_data_iq[29];
        rx_data_bs[28] <= rx_data_iq[28];
        rx_data_bs[27] <= rx_data_iq[27];
        rx_data_bs[26] <= rx_data_iq[26];
        rx_data_bs[25] <= rx_data_iq[24];
        rx_data_bs[24] <= rx_data_iq[25];
        rx_data_bs[23] <= rx_data_iq[23];
        rx_data_bs[22] <= rx_data_iq[22];
        rx_data_bs[21] <= rx_data_iq[21];
        rx_data_bs[20] <= rx_data_iq[20];
        rx_data_bs[19] <= rx_data_iq[19];
        rx_data_bs[18] <= rx_data_iq[18];
        rx_data_bs[17] <= rx_data_iq[16];
        rx_data_bs[16] <= rx_data_iq[17];
        rx_data_bs[15] <= rx_data_iq[15];
        rx_data_bs[14] <= rx_data_iq[14];
        rx_data_bs[13] <= rx_data_iq[13];
        rx_data_bs[12] <= rx_data_iq[12];
        rx_data_bs[11] <= rx_data_iq[11];
        rx_data_bs[10] <= rx_data_iq[10];
        rx_data_bs[ 9] <= rx_data_iq[ 8];
        rx_data_bs[ 8] <= rx_data_iq[ 9];
        rx_data_bs[ 7] <= rx_data_iq[ 7];
        rx_data_bs[ 6] <= rx_data_iq[ 6];
        rx_data_bs[ 5] <= rx_data_iq[ 5];
        rx_data_bs[ 4] <= rx_data_iq[ 4];
        rx_data_bs[ 3] <= rx_data_iq[ 3];
        rx_data_bs[ 2] <= rx_data_iq[ 2];
        rx_data_bs[ 1] <= rx_data_iq[ 0];
        rx_data_bs[ 0] <= rx_data_iq[ 1];
      end
      default: begin
        rx_data_bs <= rx_data_iq;
      end
    endcase
  end

  // iq swap

  always @(posedge rx_clk) begin
    rx_valid_iq <= rx_valid_64;
    case ({rx_q1_i0, rx_num_of_bits})
      4'b1100, 4'b1011: rx_data_iq <= {rx_data_64[48:32], rx_data_64[63:47],
        rx_data_64[15:0], rx_data_64[31:16]};
      4'b1101: rx_data_iq <= {rx_data_64[31:0], rx_data_64[63:32]}; 
      default: rx_data_iq <= rx_data_64;
    endcase
  end

  // de-framed data
 
  always @(posedge rx_clk) begin
    case (rx_mode)
      CMOS_1L_LS_64X1, CMOS_1L_LS_64X2, CMOS_1L_LS_64X4, CMOS_1L_LS_64X8,
      CMOS_1L_PS_64X1, CMOS_1L_PS_64X2, CMOS_1L_PS_64X4, CMOS_1L_PS_64X8,
      LVDS_1L_LS_64X1, LVDS_1L_PS_64X1: begin
        rx_valid_64 <= (rx_bcnt == 7'd7) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2)) begin
          rx_data_64[47:40] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd3)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd4)) begin
          rx_data_64[31:24] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd5)) begin
          rx_data_64[23:16] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd6)) begin
          rx_data_64[15: 8] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd7)) begin
          rx_data_64[ 7: 0] <= rx_bdata_0_d;
        end
      end
      CMOS_1L_LS_32X1, CMOS_1L_LS_32X2, CMOS_1L_LS_32X4, CMOS_1L_LS_32X8,
      CMOS_1L_PS_32X1, CMOS_1L_PS_32X2, CMOS_1L_PS_32X4, CMOS_1L_PS_32X8,
      LVDS_1L_LS_32X1, LVDS_1L_PS_32X1: begin
        rx_valid_64 <= ((rx_bcnt == 7'd3) && (rx_fcnt[0] == 1'd1)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[47:40] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd3) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[31:24] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[23:16] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[15: 8] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd3) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[ 7: 0] <= rx_bdata_0_d;
        end
      end
      CMOS_1L_PS_16X1, CMOS_1L_PS_16X2, CMOS_1L_PS_16X4,
      CMOS_1L_PS_16X8: begin
        rx_valid_64 <= ((rx_bcnt == 7'd1) && (rx_fcnt[1:0] == 2'd3)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd3)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[1:0] == 2'd3)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd2)) begin
          rx_data_64[47:40] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[1:0] == 2'd2)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd1)) begin
          rx_data_64[31:24] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[1:0] == 2'd1)) begin
          rx_data_64[23:16] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd0)) begin
          rx_data_64[15: 8] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[1:0] == 2'd0)) begin
          rx_data_64[ 7: 0] <= rx_bdata_0_d;
        end
      end
      CMOS_1L_PS_08X1, CMOS_1L_PS_08X2, CMOS_1L_PS_08X4,
      CMOS_1L_PS_08X8: begin
        rx_valid_64 <= ((rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd7)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd7)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd6)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd5)) begin
          rx_data_64[47:40] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd4)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd3)) begin
          rx_data_64[31:24] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd2)) begin
          rx_data_64[23:16] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd1)) begin
          rx_data_64[15: 8] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd0)) begin
          rx_data_64[ 7: 0] <= rx_bdata_0_d;
        end
      end
      CMOS_1L_PS_02X1: begin
        rx_valid_64 <= ((rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[63:56] <= {6'd0, rx_bdata_0_d[1:0]};
          rx_data_64[55:48] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[47:40] <= {6'd0, rx_bdata_0_d[5:4]};
          rx_data_64[39:32] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[31:24] <= {6'd0, rx_bdata_0_d[1:0]};
          rx_data_64[23:16] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[15: 8] <= {6'd0, rx_bdata_0_d[5:4]};
          rx_data_64[ 7: 0] <= {6'd0, rx_bdata_0_d[7:6]};
        end
      end
      CMOS_1L_PS_02X2: begin
        rx_valid_64 <= ((rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd3)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd3)) begin
          rx_data_64[63:56] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[55:48] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd2)) begin
          rx_data_64[47:40] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[39:32] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd1)) begin
          rx_data_64[31:24] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[23:16] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[1:0] == 2'd0)) begin
          rx_data_64[15: 8] <= {6'd0, rx_bdata_0_d[3:2]};
          rx_data_64[ 7: 0] <= {6'd0, rx_bdata_0_d[7:6]};
        end
      end
      CMOS_1L_PS_02X4, CMOS_1L_PS_02X8: begin
        rx_valid_64 <= ((rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd7)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd7)) begin
          rx_data_64[63:56] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd6)) begin
          rx_data_64[55:48] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd5)) begin
          rx_data_64[47:40] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd4)) begin
          rx_data_64[39:32] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd3)) begin
          rx_data_64[31:24] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd2)) begin
          rx_data_64[23:16] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd1)) begin
          rx_data_64[15: 8] <= {6'd0, rx_bdata_0_d[7:6]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[2:0] == 3'd0)) begin
          rx_data_64[ 7: 0] <= {6'd0, rx_bdata_0_d[7:6]};
        end
      end
      CMOS_4L_PS_32X1: begin
        rx_valid_64 <= ((rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[63:56] <= rx_bdata_1_d;
          rx_data_64[55:48] <= rx_bdata_0_d;
          rx_data_64[47:40] <= rx_bdata_3_d;
          rx_data_64[39:32] <= rx_bdata_2_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[31:24] <= rx_bdata_1_d;
          rx_data_64[23:16] <= rx_bdata_0_d;
          rx_data_64[15: 8] <= rx_bdata_3_d;
          rx_data_64[ 7: 0] <= rx_bdata_2_d;
        end
      end
      CMOS_4L_PS_64X1: begin
        rx_valid_64 <= (rx_bcnt == 7'd1) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0)) begin
          rx_data_64[63:56] <= rx_bdata_1_d;
          rx_data_64[47:40] <= rx_bdata_0_d;
          rx_data_64[31:24] <= rx_bdata_3_d;
          rx_data_64[15: 8] <= rx_bdata_2_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1)) begin
          rx_data_64[55:48] <= rx_bdata_1_d;
          rx_data_64[39:32] <= rx_bdata_0_d;
          rx_data_64[23:16] <= rx_bdata_3_d;
          rx_data_64[ 7: 0] <= rx_bdata_2_d;
        end
      end
      LVDS_1L_LS_24X1, LVDS_1L_PS_24X1: begin
        rx_valid_64 <= ((rx_bcnt == 7'd2) && (rx_fcnt[0] == 1'd1)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[63:52] <= {4'd0, rx_bdata_0_d};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[51:40] <= {rx_bdata_0_d[7:4], 4'd0, rx_bdata_0_d[3:0]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[31:20] <= {4'd0, rx_bdata_0_d};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[19: 8] <= {rx_bdata_0_d[7:4], 4'd0, rx_bdata_0_d[3:0]};
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[ 7: 0] <= rx_bdata_0_d;
        end
      end
      LVDS_2L_PS_64X1: begin
        rx_valid_64 <= (rx_bcnt == 7'd3) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
          rx_data_64[31:24] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
          rx_data_64[23:16] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2)) begin
          rx_data_64[47:40] <= rx_bdata_0_d;
          rx_data_64[15: 8] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd3)) begin
          rx_data_64[39:32] <= rx_bdata_0_d;
          rx_data_64[ 7: 0] <= rx_bdata_1_d;
        end
      end
      LVDS_2L_PS_32X1: begin
        rx_valid_64 <= ((rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd1)) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[63:56] <= rx_bdata_0_d;
          rx_data_64[47:40] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd1)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
          rx_data_64[39:32] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[31:24] <= rx_bdata_0_d;
          rx_data_64[15: 8] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1) && (rx_fcnt[0] == 1'd0)) begin
          rx_data_64[23:16] <= rx_bdata_0_d;
          rx_data_64[ 7: 0] <= rx_bdata_1_d;
        end
      end
      LVDS_2L_PS_24X1: begin
        rx_valid_64 <= (rx_bcnt == 7'd2) ? rx_bvalid_d : 1'd0;
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd2)) begin
          rx_data_64[55:48] <= rx_bdata_0_d;
          rx_data_64[39:32] <= rx_bdata_1_d;
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd1)) begin
          rx_data_64[63:56] <= {4'd0, rx_bdata_0_d[3:0]};
          rx_data_64[47:40] <= {4'd0, rx_bdata_1_d[3:0]};
          rx_data_64[19:16] <= rx_bdata_0_d[7:4];
          rx_data_64[ 3: 0] <= rx_bdata_1_d[7:4];
        end
        if ((rx_bvalid_d == 1'b1) && (rx_bcnt == 7'd0)) begin
          rx_data_64[31:20] <= {4'd0, rx_bdata_0_d};
          rx_data_64[15: 4] <= {4'd0, rx_bdata_1_d};
        end
      end
      default: begin
        rx_valid_64 <= 1'd0;
        rx_data_64 <= 32'd0;
      end
    endcase
  end

  // pipelined bytes

  always @(posedge rx_clk) begin
    rx_bvalid_d <= rx_bvalid;
    if (rx_bvalid == 1'b1) begin
      rx_bstrobe_d <= rx_bstrobe;
      rx_bdata_0_d <= rx_bdata_0;
      rx_bdata_1_d <= rx_bdata_1;
      rx_bdata_2_d <= rx_bdata_2;
      rx_bdata_3_d <= rx_bdata_3;
    end
  end

  // byte count & frame count

  always @(negedge rx_resetn or posedge rx_clk) begin
    if (rx_resetn == 1'd0) begin
      rx_bcnt <= 7'd0;
      rx_fcnt <= 2'd0;
    end else if (rx_bvalid == 1'b1) begin
      case (rx_mode)
        CMOS_1L_PS_16X1, CMOS_1L_PS_16X2, CMOS_1L_PS_16X4, CMOS_1L_PS_16X8,
        CMOS_1L_PS_08X1, CMOS_1L_PS_08X2, CMOS_1L_PS_08X4, CMOS_1L_PS_08X8,
        CMOS_1L_PS_02X4, CMOS_1L_PS_02X8, CMOS_1L_PS_32X1, CMOS_1L_PS_32X2,
        CMOS_1L_PS_32X4, CMOS_1L_PS_32X8, CMOS_4L_PS_32X1, LVDS_1L_PS_32X1,
        LVDS_1L_PS_24X1, LVDS_2L_PS_32X1, CMOS_1L_PS_64X1, CMOS_1L_PS_64X2,
        CMOS_1L_PS_64X4, CMOS_1L_PS_64X8, CMOS_4L_PS_64X1, LVDS_1L_PS_64X1,
        LVDS_2L_PS_64X1: begin
          if (rx_bstrobe == 8'h80) begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= rx_fcnt + 1'b1;
          end else if (rx_bstrobe == 8'h00) begin
            rx_bcnt <= rx_bcnt + 1'b1;
            rx_fcnt <= rx_fcnt;
          end else begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= 2'd0;
          end
        end
        CMOS_1L_PS_02X1: begin
          if (rx_bstrobe == 8'haa) begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= rx_fcnt + 1'b1;
          end else begin
            rx_bcnt <= rx_bcnt + 1'b1;
            rx_fcnt <= rx_fcnt;
          end
        end
        CMOS_1L_PS_02X2: begin
          if (rx_bstrobe == 8'h88) begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= rx_fcnt + 1'b1;
          end else begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= 2'd0;
          end
        end
        CMOS_1L_LS_32X1, CMOS_1L_LS_32X2, CMOS_1L_LS_32X4, CMOS_1L_LS_32X8,
        LVDS_1L_LS_32X1, CMOS_1L_LS_64X1, CMOS_1L_LS_64X2, CMOS_1L_LS_64X4,
        CMOS_1L_LS_64X8, LVDS_1L_LS_64X1: begin
          if (rx_bstrobe == 8'hff) begin
            if (rx_bstrobe_d == 8'h00) begin
              rx_bcnt <= 7'd0;
              rx_fcnt <= rx_fcnt + 1'b1;
            end else if (rx_bstrobe_d == 8'hff) begin
              rx_bcnt <= rx_bcnt + 1'b1;
              rx_fcnt <= rx_fcnt;
            end
          end else if (rx_bstrobe == 8'h00) begin
            rx_bcnt <= rx_bcnt + 1'b1;
            rx_fcnt <= rx_fcnt;
          end else begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= 2'd0;
          end
        end
        LVDS_1L_LS_24X1: begin
          if (rx_bstrobe == 8'hff) begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= rx_fcnt + 1'b1;
          end else if (rx_bstrobe == 8'hf0) begin
            rx_bcnt <= 7'd1;
            rx_fcnt <= rx_fcnt;
          end else if (rx_bstrobe == 8'h00) begin
            rx_bcnt <= 7'd2;
            rx_fcnt <= rx_fcnt;
          end else begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= 2'd0;
          end
        end
        LVDS_2L_PS_24X1: begin
          if (rx_bstrobe == 8'h80) begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= rx_fcnt + 1'b1;
          end else if (rx_bstrobe == 8'h08) begin
            rx_bcnt <= 7'd1;
            rx_fcnt <= rx_fcnt;
          end else if (rx_bstrobe == 8'h00) begin
            rx_bcnt <= 7'd2;
            rx_fcnt <= rx_fcnt;
          end else begin
            rx_bcnt <= 7'd0;
            rx_fcnt <= 2'd0;
          end
        end
        default: begin
          rx_bcnt <= 7'd0;
          rx_fcnt <= 2'd0;
        end
      endcase
    end
  end

  // delineation errors

  always @(posedge rx_clk) begin
    if (rx_bvalid == 1'b1) begin
      case (rx_mode)
        CMOS_1L_PS_16X1, CMOS_1L_PS_08X2, CMOS_1L_PS_02X8,
        LVDS_2L_PS_32X1, CMOS_4L_PS_64X1: begin
          if (((rx_bcnt == 7'd1) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd1) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        LVDS_1L_PS_24X1: begin
          if (((rx_bcnt == 7'd2) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd2) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_16X2, CMOS_1L_PS_08X4, CMOS_1L_PS_32X1,
        LVDS_1L_PS_32X1, LVDS_2L_PS_64X1: begin
          if (((rx_bcnt == 7'd3) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd3) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_16X4, CMOS_1L_PS_08X8, CMOS_1L_PS_32X2,
        CMOS_1L_PS_64X1, LVDS_1L_PS_64X1: begin
          if (((rx_bcnt == 7'd7) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd7) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_16X8, CMOS_1L_PS_32X4, CMOS_1L_PS_64X2: begin
          if (((rx_bcnt == 7'd15) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd15) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_32X8, CMOS_1L_PS_64X4: begin
          if (((rx_bcnt == 7'd31) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd31) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_64X8: begin
          if (((rx_bcnt == 7'd63) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt < 7'd63) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_08X1, CMOS_1L_PS_02X4, CMOS_4L_PS_32X1: begin
          if (rx_bstrobe == 8'h80) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_02X1: begin
          if (rx_bstrobe == 8'haa) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_PS_02X2: begin
          if (rx_bstrobe == 8'h88) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_32X1, LVDS_1L_LS_32X1: begin
          if (((rx_bcnt == 7'd3) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt > 7'd0) && (rx_bcnt < 7'd3) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_32X2: begin
          if (((rx_bcnt == 7'd7) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt > 7'd0) && (rx_bcnt < 7'd7) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_64X1, LVDS_1L_LS_64X1: begin
          if (((rx_bcnt == 7'd7) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt < 7'd3) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt >= 7'd3) && (rx_bcnt < 7'd7) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_32X4: begin
          if (((rx_bcnt == 7'd15) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt > 7'd0) && (rx_bcnt < 7'd15) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_64X2: begin
          if (((rx_bcnt == 7'd15) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt < 7'd3) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt >= 7'd3) && (rx_bcnt < 7'd15) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_32X8: begin
          if (((rx_bcnt == 7'd31) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt > 7'd0) && (rx_bcnt < 7'd31) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_64X4: begin
          if (((rx_bcnt == 7'd31) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt < 7'd3) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt >= 7'd3) && (rx_bcnt < 7'd31) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        CMOS_1L_LS_64X8: begin
          if (((rx_bcnt == 7'd63) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt < 7'd3) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt >= 7'd3) && (rx_bcnt < 7'd63) &&
            (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        LVDS_1L_LS_24X1: begin
          if (((rx_bcnt == 7'd2) && (rx_bstrobe == 8'hff)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'hf0)) ||
            ((rx_bcnt == 7'd1) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        LVDS_2L_PS_24X1: begin
          if (((rx_bcnt == 7'd2) && (rx_bstrobe == 8'h80)) ||
            ((rx_bcnt == 7'd0) && (rx_bstrobe == 8'h08)) ||
            ((rx_bcnt == 7'd1) && (rx_bstrobe == 8'h00))) begin
            rx_err <= 1'b0;
          end else begin
            rx_err <= 1'b1;
          end
        end
        default: begin
          rx_err <= 1'b1;
        end
      endcase
    end
  end
 
  // alignment
 
  always @(posedge rx_clk) begin
    rx_bvalid <= rx_dvalid;
    case (rx_frm_align)
      3'b111: begin
        rx_bstrobe <= {rx_dstrobe_d[6:0], rx_dstrobe[7]};
        rx_bdata_0 <= {rx_ddata_0_d[6:0], rx_ddata_0[7]};
        rx_bdata_1 <= {rx_ddata_1_d[6:0], rx_ddata_1[7]};
        rx_bdata_2 <= {rx_ddata_2_d[6:0], rx_ddata_2[7]};
        rx_bdata_3 <= {rx_ddata_3_d[6:0], rx_ddata_3[7]};
      end
      3'b110: begin
        rx_bstrobe <= {rx_dstrobe_d[5:0], rx_dstrobe[7:6]};
        rx_bdata_0 <= {rx_ddata_0_d[5:0], rx_ddata_0[7:6]};
        rx_bdata_1 <= {rx_ddata_1_d[5:0], rx_ddata_1[7:6]};
        rx_bdata_2 <= {rx_ddata_2_d[5:0], rx_ddata_2[7:6]};
        rx_bdata_3 <= {rx_ddata_3_d[5:0], rx_ddata_3[7:6]};
      end
      3'b101: begin
        rx_bstrobe <= {rx_dstrobe_d[4:0], rx_dstrobe[7:5]};
        rx_bdata_0 <= {rx_ddata_0_d[4:0], rx_ddata_0[7:5]};
        rx_bdata_1 <= {rx_ddata_1_d[4:0], rx_ddata_1[7:5]};
        rx_bdata_2 <= {rx_ddata_2_d[4:0], rx_ddata_2[7:5]};
        rx_bdata_3 <= {rx_ddata_3_d[4:0], rx_ddata_3[7:5]};
      end
      3'b100: begin
        rx_bstrobe <= {rx_dstrobe_d[3:0], rx_dstrobe[7:4]};
        rx_bdata_0 <= {rx_ddata_0_d[3:0], rx_ddata_0[7:4]};
        rx_bdata_1 <= {rx_ddata_1_d[3:0], rx_ddata_1[7:4]};
        rx_bdata_2 <= {rx_ddata_2_d[3:0], rx_ddata_2[7:4]};
        rx_bdata_3 <= {rx_ddata_3_d[3:0], rx_ddata_3[7:4]};
      end
      3'b011: begin
        rx_bstrobe <= {rx_dstrobe_d[2:0], rx_dstrobe[7:3]};
        rx_bdata_0 <= {rx_ddata_0_d[2:0], rx_ddata_0[7:3]};
        rx_bdata_1 <= {rx_ddata_1_d[2:0], rx_ddata_1[7:3]};
        rx_bdata_2 <= {rx_ddata_2_d[2:0], rx_ddata_2[7:3]};
        rx_bdata_3 <= {rx_ddata_3_d[2:0], rx_ddata_3[7:3]};
      end
      3'b010: begin
        rx_bstrobe <= {rx_dstrobe_d[1:0], rx_dstrobe[7:2]};
        rx_bdata_0 <= {rx_ddata_0_d[1:0], rx_ddata_0[7:2]};
        rx_bdata_1 <= {rx_ddata_1_d[1:0], rx_ddata_1[7:2]};
        rx_bdata_2 <= {rx_ddata_2_d[1:0], rx_ddata_2[7:2]};
        rx_bdata_3 <= {rx_ddata_3_d[1:0], rx_ddata_3[7:2]};
      end
      3'b001: begin
        rx_bstrobe <= {rx_dstrobe_d[0], rx_dstrobe[7:1]};
        rx_bdata_0 <= {rx_ddata_0_d[0], rx_ddata_0[7:1]};
        rx_bdata_1 <= {rx_ddata_1_d[0], rx_ddata_1[7:1]};
        rx_bdata_2 <= {rx_ddata_2_d[0], rx_ddata_2[7:1]};
        rx_bdata_3 <= {rx_ddata_3_d[0], rx_ddata_3[7:1]};
      end
      default: begin
        rx_bstrobe <= rx_dstrobe;
        rx_bdata_0 <= rx_ddata_0;
        rx_bdata_1 <= rx_ddata_1;
        rx_bdata_2 <= rx_ddata_2;
        rx_bdata_3 <= rx_ddata_3;
      end
    endcase
  end

  // pipelined data

  always @(posedge rx_clk) begin
    if (rx_dvalid == 1'b1) begin
      rx_dstrobe_d <= rx_dstrobe[6:0];
      rx_ddata_0_d <= rx_ddata_0[6:0];
      rx_ddata_1_d <= rx_ddata_1[6:0];
      rx_ddata_2_d <= rx_ddata_2[6:0];
      rx_ddata_3_d <= rx_ddata_3[6:0];
    end
  end

  // sdr-ddr and sdr-clock-edge-select
 
  always @(negedge rx_resetn or posedge rx_clk) begin
    if (rx_resetn == 1'b0) begin
      rx_dtoggle <= 1'd0;
      rx_dvalid <= 1'b0;
      rx_dstrobe <= 8'd0;
      rx_ddata_0 <= 8'd0;
      rx_ddata_1 <= 8'd0;
      rx_ddata_2 <= 8'd0;
      rx_ddata_3 <= 8'd0;
    end else begin
      rx_dtoggle <= ~rx_dtoggle;
      if (rx_sdr1_ddr0 == 1'b0) begin
        rx_dvalid <= 1'b1;
        rx_dstrobe <= rx_pstrobe;
        rx_ddata_0 <= rx_pdata_0;
        rx_ddata_1 <= rx_pdata_1;
        rx_ddata_2 <= rx_pdata_2;
        rx_ddata_3 <= rx_pdata_3;
      end else if (rx_dtoggle == 1'b0) begin
        rx_dvalid <= 1'b0;
        rx_dstrobe[3:0] <= 4'd0;
        rx_ddata_0[3:0] <= 4'd0;
        rx_ddata_1[3:0] <= 4'd0;
        rx_ddata_2[3:0] <= 4'd0;
        rx_ddata_3[3:0] <= 4'd0;
        if (rx_fall1_rise0 == 1'b1) begin
          rx_dstrobe[7] <= rx_pstrobe[6];
          rx_dstrobe[6] <= rx_pstrobe[4];
          rx_dstrobe[5] <= rx_pstrobe[2];
          rx_dstrobe[4] <= rx_pstrobe[0];
          rx_ddata_0[7] <= rx_pdata_0[6];
          rx_ddata_0[6] <= rx_pdata_0[4];
          rx_ddata_0[5] <= rx_pdata_0[2];
          rx_ddata_0[4] <= rx_pdata_0[0];
          rx_ddata_1[7] <= rx_pdata_1[6];
          rx_ddata_1[6] <= rx_pdata_1[4];
          rx_ddata_1[5] <= rx_pdata_1[2];
          rx_ddata_1[4] <= rx_pdata_1[0];
          rx_ddata_2[7] <= rx_pdata_2[6];
          rx_ddata_2[6] <= rx_pdata_2[4];
          rx_ddata_2[5] <= rx_pdata_2[2];
          rx_ddata_2[4] <= rx_pdata_2[0];
          rx_ddata_3[7] <= rx_pdata_3[6];
          rx_ddata_3[6] <= rx_pdata_3[4];
          rx_ddata_3[5] <= rx_pdata_3[2];
          rx_ddata_3[4] <= rx_pdata_3[0];
        end else begin
          rx_dstrobe[7] <= rx_pstrobe[7];
          rx_dstrobe[6] <= rx_pstrobe[5];
          rx_dstrobe[5] <= rx_pstrobe[3];
          rx_dstrobe[4] <= rx_pstrobe[1];
          rx_ddata_0[7] <= rx_pdata_0[7];
          rx_ddata_0[6] <= rx_pdata_0[5];
          rx_ddata_0[5] <= rx_pdata_0[3];
          rx_ddata_0[4] <= rx_pdata_0[1];
          rx_ddata_1[7] <= rx_pdata_1[7];
          rx_ddata_1[6] <= rx_pdata_1[5];
          rx_ddata_1[5] <= rx_pdata_1[3];
          rx_ddata_1[4] <= rx_pdata_1[1];
          rx_ddata_2[7] <= rx_pdata_2[7];
          rx_ddata_2[6] <= rx_pdata_2[5];
          rx_ddata_2[5] <= rx_pdata_2[3];
          rx_ddata_2[4] <= rx_pdata_2[1];
          rx_ddata_3[7] <= rx_pdata_3[7];
          rx_ddata_3[6] <= rx_pdata_3[5];
          rx_ddata_3[5] <= rx_pdata_3[3];
          rx_ddata_3[4] <= rx_pdata_3[1];
        end
      end else begin
        rx_dvalid <= 1'b1;
        rx_dstrobe[7:4] <= rx_dstrobe[7:4];
        rx_ddata_0[7:4] <= rx_ddata_0[7:4];
        rx_ddata_1[7:4] <= rx_ddata_1[7:4];
        rx_ddata_2[7:4] <= rx_ddata_2[7:4];
        rx_ddata_3[7:4] <= rx_ddata_3[7:4];
        if (rx_fall1_rise0 == 1'b1) begin
          rx_dstrobe[3] <= rx_pstrobe[6];
          rx_dstrobe[2] <= rx_pstrobe[4];
          rx_dstrobe[1] <= rx_pstrobe[2];
          rx_dstrobe[0] <= rx_pstrobe[0];
          rx_ddata_0[3] <= rx_pdata_0[6];
          rx_ddata_0[2] <= rx_pdata_0[4];
          rx_ddata_0[1] <= rx_pdata_0[2];
          rx_ddata_0[0] <= rx_pdata_0[0];
          rx_ddata_1[3] <= rx_pdata_1[6];
          rx_ddata_1[2] <= rx_pdata_1[4];
          rx_ddata_1[1] <= rx_pdata_1[2];
          rx_ddata_1[0] <= rx_pdata_1[0];
          rx_ddata_2[3] <= rx_pdata_2[6];
          rx_ddata_2[2] <= rx_pdata_2[4];
          rx_ddata_2[1] <= rx_pdata_2[2];
          rx_ddata_2[0] <= rx_pdata_2[0];
          rx_ddata_3[3] <= rx_pdata_3[6];
          rx_ddata_3[2] <= rx_pdata_3[4];
          rx_ddata_3[1] <= rx_pdata_3[2];
          rx_ddata_3[0] <= rx_pdata_3[0];
        end else begin
          rx_dstrobe[3] <= rx_pstrobe[7];
          rx_dstrobe[2] <= rx_pstrobe[5];
          rx_dstrobe[1] <= rx_pstrobe[3];
          rx_dstrobe[0] <= rx_pstrobe[1];
          rx_ddata_0[3] <= rx_pdata_0[7];
          rx_ddata_0[2] <= rx_pdata_0[5];
          rx_ddata_0[1] <= rx_pdata_0[3];
          rx_ddata_0[0] <= rx_pdata_0[1];
          rx_ddata_1[3] <= rx_pdata_1[7];
          rx_ddata_1[2] <= rx_pdata_1[5];
          rx_ddata_1[1] <= rx_pdata_1[3];
          rx_ddata_1[0] <= rx_pdata_1[1];
          rx_ddata_2[3] <= rx_pdata_2[7];
          rx_ddata_2[2] <= rx_pdata_2[5];
          rx_ddata_2[1] <= rx_pdata_2[3];
          rx_ddata_2[0] <= rx_pdata_2[1];
          rx_ddata_3[3] <= rx_pdata_3[7];
          rx_ddata_3[2] <= rx_pdata_3[5];
          rx_ddata_3[1] <= rx_pdata_3[3];
          rx_ddata_3[0] <= rx_pdata_3[1];
        end
      end
    end
  end

  // mcs to strobe delay
 
  always @(negedge rx_cpu_resetn or posedge rx_clk) begin
    if (rx_cpu_resetn == 1'b0) begin
      rx_mcs_toggle_d <= 1'd0;
      rx_mcs_latency_start <= 1'd1;
      rx_mcs_latency_stop <= 1'd0;
      rx_mcs_latency_incr <= 4'd8;
      rx_mcs_latency_enable <= 1'd0;
      rx_mcs_latency_count <= 16'd0;
    end else begin
      rx_mcs_toggle_d <= rx_mcs_toggle;
      rx_mcs_latency_start <= rx_mcs_toggle ^ rx_mcs_toggle_d;
      if (rx_pstrobe == 8'd0) begin
        rx_mcs_latency_stop <= 1'd0;
      end else begin
        rx_mcs_latency_stop <= 1'd1;
      end
      if (rx_pstrobe == 8'd0) begin
        rx_mcs_latency_incr <= 4'd8;
      end else if (rx_pstrobe[7] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd0;
      end else if (rx_pstrobe[6] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd1;
      end else if (rx_pstrobe[5] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd2;
      end else if (rx_pstrobe[4] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd3;
      end else if (rx_pstrobe[3] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd4;
      end else if (rx_pstrobe[2] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd5;
      end else if (rx_pstrobe[1] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd6;
      end else if (rx_pstrobe[0] == 1'd1) begin
        rx_mcs_latency_incr <= 4'd7;
      end
      if (rx_mcs_latency_start == 1'd1) begin
        rx_mcs_latency_enable <= ~rx_mcs_latency_stop;
        rx_mcs_latency_count <= rx_mcs_latency_incr;
      end else if (rx_mcs_latency_enable == 1'd1) begin
        rx_mcs_latency_enable <= ~rx_mcs_latency_stop;
        rx_mcs_latency_count <= rx_mcs_latency_count + rx_mcs_latency_incr;
      end
    end
  end

  // delineation error per frame and count

  always @(negedge rx_resetn or posedge rx_clk) begin
    if (rx_resetn == 1'b0) begin
      rx_frm_err <= 1'd1;
      rx_frm_bit_cnt <= 6'd0;
    end else if (rx_bvalid == 1'b1) begin
      if (rx_frm_bit_cnt == 6'd0) begin
        rx_frm_err <= rx_err;
      end else begin
        rx_frm_err <= rx_frm_err | rx_err;
      end
      case (rx_mode)
        CMOS_1L_PS_02X1, CMOS_1L_PS_02X2, CMOS_1L_PS_02X4,
        CMOS_1L_PS_08X1, CMOS_4L_PS_32X1: begin
          rx_frm_bit_cnt <= 6'd0;
        end
        LVDS_2L_PS_24X1, CMOS_1L_PS_02X8, CMOS_1L_PS_08X2,
        CMOS_1L_PS_16X1, LVDS_2L_PS_32X1,
        CMOS_4L_PS_64X1: begin
          if (rx_frm_bit_cnt >= 6'd1) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        LVDS_1L_LS_24X1, LVDS_1L_PS_24X1: begin
          if (rx_frm_bit_cnt >= 6'd2) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        CMOS_1L_PS_08X4, CMOS_1L_PS_16X2, CMOS_1L_LS_32X1,
        CMOS_1L_PS_32X1, LVDS_1L_LS_32X1, LVDS_1L_PS_32X1,
        LVDS_2L_PS_64X1: begin
          if (rx_frm_bit_cnt >= 6'd3) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        CMOS_1L_PS_08X8, CMOS_1L_PS_16X4, CMOS_1L_LS_32X2,
        CMOS_1L_PS_32X2, CMOS_1L_LS_64X1, CMOS_1L_PS_64X1,
        LVDS_1L_LS_64X1, LVDS_1L_PS_64X1: begin
          if (rx_frm_bit_cnt >= 6'd7) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        CMOS_1L_PS_16X8, CMOS_1L_LS_32X4, CMOS_1L_PS_32X4,
        CMOS_1L_LS_64X2, CMOS_1L_PS_64X2: begin
          if (rx_frm_bit_cnt >= 6'd15) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        CMOS_1L_LS_32X8, CMOS_1L_PS_32X8, CMOS_1L_LS_64X4,
        CMOS_1L_PS_64X4: begin
          if (rx_frm_bit_cnt >= 6'd31) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        CMOS_1L_LS_64X8, CMOS_1L_PS_64X8: begin
          if (rx_frm_bit_cnt >= 6'd63) begin
            rx_frm_bit_cnt <= 6'd0;
          end else begin
            rx_frm_bit_cnt <= rx_frm_bit_cnt + 1'd1;
          end
        end
        default: begin
          rx_frm_bit_cnt <= 6'd0;
        end
      endcase
    end
  end

  // delineation error counter and oos

  always @(negedge rx_resetn or posedge rx_clk) begin
    if (rx_resetn == 1'b0) begin
      rx_frm_oos <= 1'b1;
      rx_frm_oos_cnt <= 2'd0;
    end else if ((rx_bvalid == 1'b1) && (rx_frm_bit_cnt == 6'd0)) begin
      if (((rx_frm_oos == 1'd1) && (rx_frm_oos_cnt >= 2'd1)) ||
        ((rx_frm_oos == 1'd0) && (rx_frm_oos_cnt >= 2'd3))) begin
        rx_frm_oos <= rx_frm_err;
      end
      if ((rx_frm_oos ^ rx_frm_err) == 1'b1) begin
        rx_frm_oos_cnt <= rx_frm_oos_cnt + 1'b1;
      end else begin
        rx_frm_oos_cnt <= 'd0;
      end
    end
  end

  // delineation oos, alignment, processor initialization and reset

  assign rx_init_ack = ~rx_init_req_d & rx_init_req;

  always @(negedge rx_cpu_resetn or posedge rx_clk) begin
    if (rx_cpu_resetn == 1'b0) begin
      rx_resetn <= 1'b0;
      rx_frm_align <= 3'd0;
      rx_frm_align_cnt <= 4'd0;
      rx_init_req_d <= 1'd0;
      rx_init_cnt <= 4'd0;
    end else begin
      if ((rx_init_cnt[3] == 1'd1) || ((rx_bvalid == 1'b1) && (rx_frm_bit_cnt == 6'd0) &&
        (rx_frm_align_cnt >= 4'hf) && (rx_frm_oos == 1'b1) && (rx_mcs_sync == 1'd0))) begin
        rx_resetn <= 1'd0;
      end else if ((rx_mcs_sync == 1'd0) || ((rx_mcs_sync == 1'd1) &&
        (rx_mcs_latency_start == 1'd1))) begin
        rx_resetn <= 1'd1;
      end
      if ((rx_bvalid == 1'b1) && (rx_frm_bit_cnt == 6'd0) &&
        (rx_frm_align_cnt >= 4'hf) && (rx_frm_oos == 1'b1)) begin
        rx_frm_align <= rx_frm_align + 1'b1;
      end
      if (rx_resetn == 1'd0) begin
        rx_frm_align_cnt <= 4'd0;
      end else if ((rx_bvalid == 1'b1) && (rx_frm_bit_cnt == 6'd0)) begin
        if (rx_frm_oos == 1'b1) begin
          rx_frm_align_cnt <= rx_frm_align_cnt + 1'b1;
        end else begin
          rx_frm_align_cnt <= 4'd0;
        end
      end
      rx_init_req_d <= rx_init_req;
      if (rx_init_ack == 1'd1) begin
        rx_init_cnt <= 4'h8;
      end else if (rx_init_cnt[3] == 1'b1) begin
        rx_init_cnt <= rx_init_cnt + 1'b1;
      end
    end
  end

  // cpu reset (software or mcs controlled)
 
  assign axilite_mcs_toggle_p = axilite_mcs_toggle ^ axilite_mcs_toggle_d;

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_delay_unlocked <= 1'd1;
      axilite_cpu_resetn <= 1'd0;
      axilite_cpu_reset <= 1'd1;
      axilite_mcs_sync_d <= 1'd0;
      axilite_mcs_toggle_d <= 1'd0;
      axilite_mcs_resetn <= 1'd0;
      axilite_mcs_count <= 4'd0;
      axilite_sw_resetn <= 1'd0;
      axilite_sw_reset_in_d <= 1'd0;
      axilite_sw_reset_count <= 4'h0;
    end else begin
      axilite_delay_unlocked <= ~axilite_delay_locked;
      axilite_cpu_resetn <= ~axilite_cpu_reset;
      axilite_cpu_reset <= ~(axilite_sw_resetn & axilite_mcs_resetn);
      axilite_mcs_sync_d <= axilite_mcs_sync;
      axilite_mcs_toggle_d <= axilite_mcs_toggle;
      if (axilite_mcs_sync == 1'd0) begin
        axilite_mcs_resetn <= 1'd1;
        axilite_mcs_count <= 4'd0;
      end else if (axilite_mcs_sync_d == 1'd0) begin
        axilite_mcs_resetn <= 1'd0;
        axilite_mcs_count <= 4'd0;
      end else if (axilite_mcs_toggle_p == 1'd1) begin
        axilite_mcs_count <= axilite_mcs_count + 1'd1;
        if (axilite_mcs_count >= axilite_mcs_active) begin
          axilite_mcs_resetn <= 1'd1;
        end
      end
      axilite_sw_resetn <= ~axilite_sw_reset_count[3];
      axilite_sw_reset_in_d <= axilite_sw_reset_in;
      if ((axilite_sw_reset_in_d == 1'd0) && (axilite_sw_reset_in == 1'd1)) begin
        axilite_sw_reset_count <= 4'h8;
      end else if (axilite_sw_reset_count[3] == 1'd1) begin
        axilite_sw_reset_count <= axilite_sw_reset_count + 1'd1;
      end
    end
  end

  // io buffers

  assign rx_gpio_in = (GPIO2_CMOS1_LVDS0 == 1) ? rx_cmos_gpio_in : rx_cssi_gpio_in;
  assign rx_cssi_gpio_out = rx_gpio_out;
  assign rx_cssi_gpio_enb = rx_gpio_enb;

  assign rx_cmos_gpio_in[5] = (GPIO2_CMOS1_LVDS0 == 1) ? rx_cssi_nc_lssi_strobe_n : 1'd0;
  assign rx_cmos_gpio_in[6] = (GPIO2_CMOS1_LVDS0 == 1) ? rx_buf_clk : 1'd0;
  assign rx_cmos_gpio_in[7] = (GPIO2_CMOS1_LVDS0 == 1) ? rx_cssi_nc_lssi_clk_n : 1'd0;
  
  assign rx_data_p[0] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data1_lssi_data0_p : rx_cssi_data0_lssi_data0_n;
  assign rx_data_n[0] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data0_lssi_data0_n : 1'd0;
  assign rx_data_p[1] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data3_lssi_data1_p : rx_cssi_data1_lssi_data0_p;
  assign rx_data_n[1] = (GPIO2_CMOS1_LVDS0 == 0) ? rx_cssi_data2_lssi_data1_n : 1'd0;
  assign rx_data_p[2] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : rx_cssi_data2_lssi_data1_n;
  assign rx_data_n[2] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : 1'd0;
  assign rx_data_p[3] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : rx_cssi_data3_lssi_data1_p;
  assign rx_data_n[3] = (GPIO2_CMOS1_LVDS0 == 0) ? 1'd0 : 1'd0;

  // instantiations

  cdc #(.DATA_WIDTH(1)) i_rx_mcs_cdc (
    .src_data                               (mcs_toggle),
    .dest_resetn                            (rx_cpu_resetn),
    .dest_clk                               (rx_clk),
    .dest_data                              (rx_mcs_toggle));

  cdc_cntrl #(.DATA_WIDTH(16)) i_rx_mcs_cdc_cntrl (
    .src_resetn                             (rx_cpu_resetn),
    .src_clk                                (rx_clk),
    .src_data                               (rx_mcs_latency_count),
    .dest_resetn                            (axilite_resetn),
    .dest_clk                               (axilite_clk),
    .dest_data                              (axilite_mcs_latency_count));

  axi_adrv9001_rx_dec i_orx_dec (
    .rx_clk                                 (rx_clk),
    .rx_resetn                              (rx_resetn),
    .rx_enable                              (orx_enable),
    .rx_valid                               (rx_valid_bs),
    .rx_data                                (rx_data_bs),
    .rx_dec_ratio                           (orx_dec_ratio),
    .rx_num_of_bits                         (rx_num_of_bits),
    .rx_dec_valid                           (orx_valid),
    .rx_dec_data                            (orx_data));

  axi_adrv9001_rx_dec i_rx_dec (
    .rx_clk                                 (rx_clk),
    .rx_resetn                              (rx_resetn),
    .rx_enable                              (rx_enable),
    .rx_valid                               (rx_valid_bs),
    .rx_data                                (rx_data_bs),
    .rx_dec_ratio                           (rx_dec_ratio),
    .rx_num_of_bits                         (rx_num_of_bits),
    .rx_dec_valid                           (rx_valid),
    .rx_dec_data                            (rx_data));

  axi_adrv9001_rx_dmon i_rx_dmon (
    .rx_clk                                 (rx_clk),
    .rx_resetn                              (rx_resetn),
    .rx_valid                               (rx_valid_bs),
    .rx_data                                (rx_data_bs),
    .rx_pattern                             (rx_pattern),
    .rx_data_sel                            (rx_data_sel),
    .rx_num_of_bits                         (rx_num_of_bits),
    .rx_mon_data                            (rx_mon_data),
    .rx_mon_oos                             (rx_mon_oos),
    .rx_mon_err                             (rx_mon_err),
    .rx_pattern_state                       (rx_pattern_state),
    .rx_pattern_count                       (rx_pattern_count),
    .tx_pattern_done                        (tx_pattern_done));

  clk_mon i_rx_clk_mon (
    .clk                                    (rx_clk),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_clk_mon_count                  (axilite_clk_mon_count));

  axi_adrv9001_rx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_rx_pdata_0 (
    .rx_resetn                              (rx_resetn),
    .rx_hs_clk                              (rx_hs_clk),
    .rx_clk                                 (rx_clk),
    .rx_align                               (1'd0),
    .rx_data_p                              (rx_data_p[0]),
    .rx_data_n                              (rx_data_n[0]),
    .rx_pdata                               (rx_pdata_0),
    .rx_gpio_in                             (rx_cmos_gpio_in[0]),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_0),
    .axilite_delay_rddata                   (axilite_rddelay_0));

  axi_adrv9001_rx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_rx_pdata_1 (
    .rx_resetn                              (rx_resetn),
    .rx_hs_clk                              (rx_hs_clk),
    .rx_clk                                 (rx_clk),
    .rx_align                               (1'd0),
    .rx_data_p                              (rx_data_p[1]),
    .rx_data_n                              (rx_data_n[1]),
    .rx_pdata                               (rx_pdata_1),
    .rx_gpio_in                             (rx_cmos_gpio_in[1]),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_1),
    .axilite_delay_rddata                   (axilite_rddelay_1));

  axi_adrv9001_rx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_rx_pdata_2 (
    .rx_resetn                              (rx_resetn),
    .rx_hs_clk                              (rx_hs_clk),
    .rx_clk                                 (rx_clk),
    .rx_align                               (1'd0),
    .rx_data_p                              (rx_data_p[2]),
    .rx_data_n                              (rx_data_n[2]),
    .rx_pdata                               (rx_pdata_2),
    .rx_gpio_in                             (rx_cmos_gpio_in[2]),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_2),
    .axilite_delay_rddata                   (axilite_rddelay_2));

  axi_adrv9001_rx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_rx_pdata_3 (
    .rx_resetn                              (rx_resetn),
    .rx_hs_clk                              (rx_hs_clk),
    .rx_clk                                 (rx_clk),
    .rx_align                               (1'd0),
    .rx_data_p                              (rx_data_p[3]),
    .rx_data_n                              (rx_data_n[3]),
    .rx_pdata                               (rx_pdata_3),
    .rx_gpio_in                             (rx_cmos_gpio_in[3]),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_3),
    .axilite_delay_rddata                   (axilite_rddelay_3));

  axi_adrv9001_rx_if #(
    .GPIO2_CMOS1_LVDS0                      (GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                          (IODELAY_GROUP))
  i_rx_pstrobe (
    .rx_resetn                              (rx_resetn),
    .rx_hs_clk                              (rx_hs_clk),
    .rx_clk                                 (rx_clk),
    .rx_align                               (1'd0),
    .rx_data_p                              (rx_cssi_strobe_lssi_strobe_p),
    .rx_data_n                              (rx_cssi_nc_lssi_strobe_n),
    .rx_pdata                               (rx_pstrobe),
    .rx_gpio_in                             (rx_cmos_gpio_in[4]),
    .axilite_resetn                         (axilite_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_delay_wrdata                   (axilite_wrdelay_s),
    .axilite_delay_rddata                   (axilite_rddelay_s));

  BUFR #(.BUFR_DIVIDE("4")) i_rx_ls_clk (
    .CE                                     (1'b1),
    .CLR                                    (axilite_cpu_reset),
    .I                                      (rx_buf_clk),
    .O                                      (rx_clk));

  BUFIO i_rx_hs_clk (
    .I                                      (rx_buf_clk),
    .O                                      (rx_hs_clk));

  generate
  if (GPIO2_CMOS1_LVDS0 == 0) begin

  IBUFGDS i_rx_sclock (
    .I                                      (rx_cssi_clk_lssi_clk_p),
    .IB                                     (rx_cssi_nc_lssi_clk_n),
    .O                                      (rx_buf_clk));

  end else if (GPIO2_CMOS1_LVDS0 == 1) begin

  IBUFG i_rx_sclock (
    .I                                      (rx_cssi_clk_lssi_clk_p),
    .O                                      (rx_buf_clk));

  end else begin

  assign rx_buf_clk = 1'd0;

  end
  endgenerate

  cdc_cntrl #(.DATA_WIDTH(88)) i_rx_cdc_cntrl (
    .src_resetn                             (axilite_resetn),
    .src_clk                                (axilite_clk),
    .src_data                               ({axilite_init_req,
                                              axilite_mcs_sync,
                                              axilite_data_sel,
                                              axilite_pattern,
                                              axilite_rx_dec_ratio,
                                              axilite_orx_dec_ratio,
                                              axilite_fall1_rise0,
                                              axilite_q1_i0,
                                              axilite_lsb1_msb0,
                                              axilite_sdr1_ddr0,
                                              axilite_mlane1_slane0,
                                              axilite_lstrb1_pstrb0,
                                              axilite_num_of_bits,
                                              axilite_clk_rate}),
    .dest_resetn                            (rx_cpu_resetn),
    .dest_clk                               (rx_clk),
    .dest_data                              ({rx_init_req,
                                              rx_mcs_sync,
                                              rx_data_sel,
                                              rx_pattern,
                                              rx_dec_ratio,
                                              orx_dec_ratio,
                                              rx_fall1_rise0,
                                              rx_q1_i0,
                                              rx_lsb1_msb0,
                                              rx_sdr1_ddr0,
                                              rx_mlane1_slane0,
                                              rx_lstrb1_pstrb0,
                                              rx_num_of_bits,
                                              rx_clk_rate}));

  cdc #(.DATA_WIDTH(1)) i_rx_cdc (
    .src_data                               (axilite_cpu_resetn),
    .dest_resetn                            (1'b1),
    .dest_clk                               (rx_clk),
    .dest_data                              (rx_cpu_resetn));

  generate
  if (IODELAY_CTRL_ENABLE == 0) begin

  assign delay_locked = 1'b1;

  end else begin

  (* IODELAY_GROUP = IODELAY_GROUP *)
  IDELAYCTRL i_delay_ctrl (
    .RST                                    (~sys_200m_resetn),
    .REFCLK                                 (sys_200m_clk),
    .RDY                                    (delay_locked));

  end
  endgenerate

  cdc_cntrl #(.DATA_WIDTH(99)) i_axilite_cdc_cntrl (
    .src_resetn                             (rx_resetn),
    .src_clk                                (rx_clk),
    .src_data                               ({rx_frm_oos,
                                              rx_mon_oos,
                                              rx_mon_data,
                                              rx_pattern_state,
                                              rx_pattern_count}),
    .dest_resetn                            (axilite_resetn),
    .dest_clk                               (axilite_clk),
    .dest_data                              ({axilite_frm_oos,
                                              axilite_mon_oos,
                                              axilite_mon_data,
                                              axilite_pattern_state,
                                              axilite_pattern_count}));

  cdc_event #(.DATA_WIDTH(2)) i_axilite_cdc_event (
    .src_resetn                             (rx_resetn),
    .src_clk                                (rx_clk),
    .src_data                               ({rx_mon_err, rx_frm_err}),
    .dest_resetn                            (axilite_resetn),
    .dest_clk                               (axilite_clk),
    .dest_data                              ({axilite_mon_err, axilite_frm_err}));

  cdc_event #(.DATA_WIDTH(1)) i_axilite_init_cdc_event (
    .src_resetn                             (rx_cpu_resetn),
    .src_clk                                (rx_clk),
    .src_data                               (rx_init_ack),
    .dest_resetn                            (axilite_resetn),
    .dest_clk                               (axilite_clk),
    .dest_data                              (axilite_init_ack));

  cdc #(.DATA_WIDTH(2)) i_axilite_cdc (
    .src_data                               ({delay_locked,
                                              mcs_toggle}),
    .dest_resetn                            (axilite_resetn),
    .dest_clk                               (axilite_clk),
    .dest_data                              ({axilite_delay_locked,
                                              axilite_mcs_toggle}));

  axi_adrv9001_rx_regs #(.ID(ID)) i_rx_regs (
    .axilite_rx_cmos_lvds_id                (axilite_cmos_lvds_id),
    .axilite_rx_clk_rate                    (axilite_clk_rate),
    .axilite_rx_num_of_bits                 (axilite_num_of_bits),
    .axilite_rx_lstrb1_pstrb0               (axilite_lstrb1_pstrb0),
    .axilite_rx_mlane1_slane0               (axilite_mlane1_slane0),
    .axilite_rx_sdr1_ddr0                   (axilite_sdr1_ddr0),
    .axilite_rx_lsb1_msb0                   (axilite_lsb1_msb0),
    .axilite_rx_q1_i0                       (axilite_q1_i0),
    .axilite_rx_fall1_rise0                 (axilite_fall1_rise0),
    .axilite_rx_cmos1_lvds0                 (axilite_cmos1_lvds0),
    .axilite_rx_frm_oos                     (axilite_frm_oos),
    .axilite_rx_frm_err                     (axilite_frm_err),
    .axilite_rx_mon_oos                     (axilite_mon_oos),
    .axilite_rx_mon_err                     (axilite_mon_err),
    .axilite_rx_init                        (axilite_init_req),
    .axilite_rx_init_clr                    (axilite_init_ack),
    .axilite_rx_data_sel                    (axilite_data_sel),
    .axilite_rx_data_pat_0                  (axilite_pattern[31:0]),
    .axilite_rx_data_pat_1                  (axilite_pattern[63:32]),
    .axilite_rx_data_0                      (axilite_mon_data[31:0]),
    .axilite_rx_data_1                      (axilite_mon_data[63:32]),
    .axilite_rx_dec_ratio                   (axilite_rx_dec_ratio),
    .axilite_orx_dec_ratio                  (axilite_orx_dec_ratio),
    .axilite_rx_delay_unlocked              (axilite_delay_unlocked),
    .axilite_rx_wrdelay_0                   (axilite_wrdelay_0),
    .axilite_rx_rddelay_0                   (axilite_rddelay_0),
    .axilite_rx_wrdelay_1                   (axilite_wrdelay_1),
    .axilite_rx_rddelay_1                   (axilite_rddelay_1),
    .axilite_rx_wrdelay_2                   (axilite_wrdelay_2),
    .axilite_rx_rddelay_2                   (axilite_rddelay_2),
    .axilite_rx_wrdelay_3                   (axilite_wrdelay_3),
    .axilite_rx_rddelay_3                   (axilite_rddelay_3),
    .axilite_rx_wrdelay_s                   (axilite_wrdelay_s),
    .axilite_rx_rddelay_s                   (axilite_rddelay_s),
    .axilite_rx_timer                       (),
    .axilite_rx_clk_mon_count               (axilite_clk_mon_count),
    .axilite_rx_mcs_latency_count           (axilite_mcs_latency_count),
    .axilite_rx_mcs_sync                    (axilite_mcs_sync),
    .axilite_rx_mcs_active                  (axilite_mcs_active),
    .axilite_rx_data_pat_state              (axilite_pattern_state),
    .axilite_rx_data_pat_latency            (axilite_pattern_count),
    .axilite_rx_sw_reset                    (axilite_sw_reset_in),
    .axilite_rx_sw_reset_clr                (axilite_sw_resetn),
    .axilite_clk                            (axilite_clk),
    .axilite_resetn                         (axilite_resetn),
    .axilite_wrreq                          (axilite_wrreq),
    .axilite_wraddr                         (axilite_wraddr),
    .axilite_wrdata                         (axilite_wrdata),
    .axilite_wrack                          (axilite_wrack),
    .axilite_rdreq                          (axilite_rdreq),
    .axilite_rdaddr                         (axilite_rdaddr),
    .axilite_rddata                         (axilite_rddata),
    .axilite_rdack                          (axilite_rdack));

endmodule

// **********************************************************************************
// **********************************************************************************
