# axi\_adrv9001
## Properties
* Address Width: 12
## Register Map
---
| Address | Bits | Field | Type | Default | Description |
| ------- | ---- | ----- | ---- | ------- | ----------- |
| 0x0 | [31:0] | version[31:0] | RO | 0x60000 | This ip core version, default value depends on current fpga build. The format is unused[8], major[8], minor[8], and patch[8]. |
| | | | | | |
| 0x4 | [31:0] | instance\_id[31:0] | RO | 0x0 | Indicates instance identifier of this core. In a master/slave system, core with INSTANCE\_ID of 0 is the master. |
| | | | | | |
| 0x8 | [31:0] | scratch[31:0] | RW | 0x0 | General purpose scratch register, software may use this register for tempoaray variable storage. |
| | | | | | |
| 0xc | [31:0] | timer[31:0] | RW | 0x0 | General purpose timer register, this is a count down timer, software may write desired interval and wait for it to reach zero. The count can be prematurely terminated, runs at AXILite clock (usually 100MHz). |
| | | | | | |
| 0x20 | [0:0] | resetb | RW | 0x0 | This bit is directly mapped to device reset pin. After power-up, device is held in reset until software writes 0x1 to this bit. |
| | | | | | |
| 0x24 | [0:0] | mode | RW | 0x0 | This bit is directly mapped to device mode pin. Refer to device documentation for further details. |
| | | | | | |
| 0x28 | [0:0] | gpint | RW1C | 0x0 | This bit is set if an interrupt is detected (based on the GPINT\_MODE bits below) on the device GPINT pin. Software must write 0x1 to clear this bit. |
| | | | | | |
| 0x2c | [1:0] | gpint\_mode[1:0] | RW | 0x0 | These bits select the interrupt detection mode on the GPINT pin. The following are supported: 0x3: falling edge, 0x2: rising edge, 0x1: active low, 0x0: active high. |
| | | | | | |
| 0x100 | [31:0] | usr\_gpio\_in[31:0] | RO | 0x0 | These bits are directly mapped to internal FPGA signals. The use of which is left to the down stream modules. |
| | | | | | |
| 0x104 | [31:0] | usr\_gpio\_out[31:0] | RW | 0x0 | These bits are directly mapped to internal FPGA signals. The use of which is left to the down stream modules. |
| | | | | | |
| 0x200 | [0:0] | mcs\_request | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates MCS sequence generation as defined by the register fields below. This bit is cleared after the MCS sequence is completed. |
| | | | | | |
| 0x204 | [3:0] | mcs\_width[3:0] | RW | 0x1 | This field defines the width of the mcs pulse in number of DEVICE\_CLOCK cycles (must be less than MCS\_PERIOD). |
| 0x204 | [11:8] | mcs\_num[3:0] | RW | 0x0 | This field defines the number of MCS pulses to generate in a MCS sequence initiates by the MCS\_REQUEST bit. |
| 0x204 | [16:16] | mcs\_edge\_fall1\_rise0 | RW | 0x0 | This field defines the edge of DEVICE\_CLOCK to assert/deassert mcs. 0 = rising-edge; 1 = falling-edge. |
| | | | | | |
| 0x208 | [0:0] | mcs\_select | RW | 0x0 | If set to 0x1, select generated mcs as internal mcs, otherwise, select external mcs as internal mcs. This does not affect the mcs IO. The mcs IO is always the generated one. |
| | | | | | |
| 0x20c | [31:0] | mcs\_period[31:0] | RW | 0x0 | This field defines the number of DEVICE\_CLOCK cycles between consecutive MCS pulses in the MCS sequence. |
| | | | | | |
| 0x240 | [31:0] | mcs\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x300 | [0:0] | mmcm\_request | RW1HC | 0x0 | A 0 to 1 transition on this bit initiates an indirect access to the DEVICE\_CLOCK, TDD\_CLOCK, and GPIO\_CLOCK MMCM inside the core. This bit is self-cleared when the access is complete. Refer to the vendor documentation for the MMCM register details. |
| 0x300 | [1:1] | mmcm\_rd1\_wr0 | RW | 0x0 | If set, the MMCM\_REQUEST initiates a read operation, otherwise a write operation. Software may field write this bit separately from the MMCM\_REQUEST above, however this and other MMCM access fields must be programmed before an MMCM\_REQUEST. |
| | | | | | |
| 0x304 | [6:0] | mmcm\_addr[6:0] | RW | 0x0 | This field defines the MMCM indirect register address. The width of this register depends on the device family being used. |
| | | | | | |
| 0x308 | [15:0] | mmcm\_wrdata[15:0] | RW | 0x0 | This field defines the MMCM indirect register write data. The details of which depends on the device family being used. |
| | | | | | |
| 0x30c | [15:0] | mmcm\_rddata[15:0] | RO | 0x0 | This field defines the MMCM indirect register read data. The details of which depends on the device family being used. |
| | | | | | |
| 0x310 | [0:0] | mmcm\_reset | RW | 0x1 | If set causes a MMCM reset, software must write 0x0 once the device clock is running and stable as part of the initialization. |
| | | | | | |
| 0x314 | [0:0] | mmcm\_busy | RO | 0x0 | If set after a MMCM\_REQUEST, indicates that the access is in-progress. If this bit is clear, indicates the interface is idle. The software must make sure this bit is clear before initiating a MMCM\_REQUEST. |
| 0x314 | [1:1] | mmcm\_unlocked | RO | 0x0 | If clear indicates that the MMCM clocks are locked and running. If this bit is set, none of the DEVICE\_CLOCK, TDD\_CLK, and GPIO\_CLK are operational and their status unknown. |
| | | | | | |
| 0x340 | [0:0] | mmcm\_ref\_clk\_sel | RW | 0x0 | If set, selects device clock output as reference clock to the MMCM, otherwise system clock is used as mmcm reference clock. |
| | | | | | |
| 0x344 | [31:0] | mmcm\_ref\_clk\_mon\_count[31:0] | RO | 0x0 | Clock monitor frequency count. If read 0x0, indicates a loss of clock. The format is 16.16 x 100MHz |
| | | | | | |
| 0x400 | [0:0] | trig0\_ext\_oe | RW | 0x0 | This bit controls the output enable for external trigger 0 |
| 0x400 | [1:1] | trig1\_ext\_oe | RW | 0x0 | This bit controls the output enable for external trigger 1 |
| | | | | | |
---
