// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Auto generated, local modifications are discouraged.
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001_gpio_regs #(parameter [3:0] ID = 0) (

  output  reg   [31:0]    axilite_timer = 'd0,
  input   wire  [11:0]    axilite_dgpio_pio_data,
  output  reg   [11:0]    axilite_dgpio_pio_data_out = 'd0,
  output  reg   [11:0]    axilite_dgpio_pio_data_out_enb = 'd0,
  output  reg   [11:0]    axilite_dgpio_pio_data_mode = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_00 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_01 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_02 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_03 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_04 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_05 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_06 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_07 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_08 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_09 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_10 = 'd0,
  output  reg   [ 3:0]    axilite_dgpio_pio_sel_11 = 'd0,
  input   wire  [ 7:0]    axilite_rx0_pio_data,
  output  reg   [ 7:0]    axilite_rx0_pio_data_out = 'd0,
  output  reg   [ 7:0]    axilite_rx0_pio_data_out_enb = 'd0,
  input   wire  [ 7:0]    axilite_rx1_pio_data,
  output  reg   [ 7:0]    axilite_rx1_pio_data_out = 'd0,
  output  reg   [ 7:0]    axilite_rx1_pio_data_out_enb = 'd0,
  input   wire  [ 9:0]    axilite_tx0_pio_data,
  output  reg   [ 9:0]    axilite_tx0_pio_data_out = 'd0,
  output  reg   [ 9:0]    axilite_tx0_pio_data_out_enb = 'd0,
  input   wire  [ 9:0]    axilite_tx1_pio_data,
  output  reg   [ 9:0]    axilite_tx1_pio_data_out = 'd0,
  output  reg   [ 9:0]    axilite_tx1_pio_data_out_enb = 'd0,
  output  reg   [ 3:0]    axilite_trig_src_group = 'd0,
  output  reg   [ 3:0]    axilite_trig_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex_src_group = 'd0,
  output  reg   [ 3:0]    axilite_gainindex0_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex1_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex2_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex3_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex4_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex5_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex6_src_pin = 'd0,
  output  reg   [ 3:0]    axilite_gainindex7_src_pin = 'd0,
  input   wire  [31:0]    axilite_clk_mon_count,

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_wrreq,
  input   wire  [15:0]    axilite_wraddr,
  input   wire  [31:0]    axilite_wrdata,
  output  reg             axilite_wrack = 'd0,
  input   wire            axilite_rdreq,
  input   wire  [15:0]    axilite_rdaddr,
  output  reg   [31:0]    axilite_rddata = 'd0,
  output  reg             axilite_rdack = 'd0);


  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_wrack <= 'd0;
      axilite_rdack <= 'd0;
    end else begin
      if (axilite_wraddr[15:12] == ID) begin
        axilite_wrack <= axilite_wrreq;
      end else begin
        axilite_wrack <= 1'd0;
      end
      if (axilite_rdaddr[15:12] == ID) begin
        axilite_rdack <= axilite_rdreq;
      end else begin
        axilite_rdack <= 1'd0;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_timer <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h0)) begin
        axilite_timer <= axilite_wrdata;
      end else if (axilite_timer > 0) begin
        axilite_timer <= axilite_timer - 1'b1;
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_data_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h104)) begin
        axilite_dgpio_pio_data_out <= axilite_wrdata[11:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_data_out_enb <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h108)) begin
        axilite_dgpio_pio_data_out_enb <= axilite_wrdata[11:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_data_mode <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h10c)) begin
        axilite_dgpio_pio_data_mode <= axilite_wrdata[11:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_00 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h110)) begin
        axilite_dgpio_pio_sel_00 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_01 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h114)) begin
        axilite_dgpio_pio_sel_01 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_02 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h118)) begin
        axilite_dgpio_pio_sel_02 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_03 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h11c)) begin
        axilite_dgpio_pio_sel_03 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_04 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h120)) begin
        axilite_dgpio_pio_sel_04 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_05 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h124)) begin
        axilite_dgpio_pio_sel_05 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_06 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h128)) begin
        axilite_dgpio_pio_sel_06 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_07 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h12c)) begin
        axilite_dgpio_pio_sel_07 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_08 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h130)) begin
        axilite_dgpio_pio_sel_08 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_09 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h134)) begin
        axilite_dgpio_pio_sel_09 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_10 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h138)) begin
        axilite_dgpio_pio_sel_10 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_dgpio_pio_sel_11 <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h13c)) begin
        axilite_dgpio_pio_sel_11 <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_pio_data_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h204)) begin
        axilite_rx0_pio_data_out <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx0_pio_data_out_enb <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h208)) begin
        axilite_rx0_pio_data_out_enb <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_pio_data_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h304)) begin
        axilite_rx1_pio_data_out <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rx1_pio_data_out_enb <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h308)) begin
        axilite_rx1_pio_data_out_enb <= axilite_wrdata[7:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_pio_data_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h404)) begin
        axilite_tx0_pio_data_out <= axilite_wrdata[9:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx0_pio_data_out_enb <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h408)) begin
        axilite_tx0_pio_data_out_enb <= axilite_wrdata[9:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_pio_data_out <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h504)) begin
        axilite_tx1_pio_data_out <= axilite_wrdata[9:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_tx1_pio_data_out_enb <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h508)) begin
        axilite_tx1_pio_data_out_enb <= axilite_wrdata[9:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig_src_group <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h600)) begin
        axilite_trig_src_group <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_trig_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h604)) begin
        axilite_trig_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex_src_group <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h700)) begin
        axilite_gainindex_src_group <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex0_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h704)) begin
        axilite_gainindex0_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex1_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h708)) begin
        axilite_gainindex1_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex2_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h70c)) begin
        axilite_gainindex2_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex3_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h710)) begin
        axilite_gainindex3_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex4_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h714)) begin
        axilite_gainindex4_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex5_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h718)) begin
        axilite_gainindex5_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex6_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h71c)) begin
        axilite_gainindex6_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_gainindex7_src_pin <= 'h0;
    end else begin
      if ((axilite_wrreq == 1'b1) && (axilite_wraddr[15:12] == ID) && (axilite_wraddr[11:0] == 'h720)) begin
        axilite_gainindex7_src_pin <= axilite_wrdata[3:0];
      end
    end
  end

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'b0) begin
      axilite_rddata <= 'd0;
    end else begin
      if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[15:12] == ID)) begin
        case (axilite_rdaddr[11:0])
          'h0: begin
            axilite_rddata <= axilite_timer;
          end
          'h100: begin
            axilite_rddata[11:0] <= axilite_dgpio_pio_data;
            axilite_rddata[31:12] <= 'd0;
          end
          'h104: begin
            axilite_rddata[11:0] <= axilite_dgpio_pio_data_out;
            axilite_rddata[31:12] <= 'd0;
          end
          'h108: begin
            axilite_rddata[11:0] <= axilite_dgpio_pio_data_out_enb;
            axilite_rddata[31:12] <= 'd0;
          end
          'h10c: begin
            axilite_rddata[11:0] <= axilite_dgpio_pio_data_mode;
            axilite_rddata[31:12] <= 'd0;
          end
          'h110: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_00;
            axilite_rddata[31:4] <= 'd0;
          end
          'h114: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_01;
            axilite_rddata[31:4] <= 'd0;
          end
          'h118: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_02;
            axilite_rddata[31:4] <= 'd0;
          end
          'h11c: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_03;
            axilite_rddata[31:4] <= 'd0;
          end
          'h120: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_04;
            axilite_rddata[31:4] <= 'd0;
          end
          'h124: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_05;
            axilite_rddata[31:4] <= 'd0;
          end
          'h128: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_06;
            axilite_rddata[31:4] <= 'd0;
          end
          'h12c: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_07;
            axilite_rddata[31:4] <= 'd0;
          end
          'h130: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_08;
            axilite_rddata[31:4] <= 'd0;
          end
          'h134: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_09;
            axilite_rddata[31:4] <= 'd0;
          end
          'h138: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_10;
            axilite_rddata[31:4] <= 'd0;
          end
          'h13c: begin
            axilite_rddata[3:0] <= axilite_dgpio_pio_sel_11;
            axilite_rddata[31:4] <= 'd0;
          end
          'h200: begin
            axilite_rddata[7:0] <= axilite_rx0_pio_data;
            axilite_rddata[31:8] <= 'd0;
          end
          'h204: begin
            axilite_rddata[7:0] <= axilite_rx0_pio_data_out;
            axilite_rddata[31:8] <= 'd0;
          end
          'h208: begin
            axilite_rddata[7:0] <= axilite_rx0_pio_data_out_enb;
            axilite_rddata[31:8] <= 'd0;
          end
          'h300: begin
            axilite_rddata[7:0] <= axilite_rx1_pio_data;
            axilite_rddata[31:8] <= 'd0;
          end
          'h304: begin
            axilite_rddata[7:0] <= axilite_rx1_pio_data_out;
            axilite_rddata[31:8] <= 'd0;
          end
          'h308: begin
            axilite_rddata[7:0] <= axilite_rx1_pio_data_out_enb;
            axilite_rddata[31:8] <= 'd0;
          end
          'h400: begin
            axilite_rddata[9:0] <= axilite_tx0_pio_data;
            axilite_rddata[31:10] <= 'd0;
          end
          'h404: begin
            axilite_rddata[9:0] <= axilite_tx0_pio_data_out;
            axilite_rddata[31:10] <= 'd0;
          end
          'h408: begin
            axilite_rddata[9:0] <= axilite_tx0_pio_data_out_enb;
            axilite_rddata[31:10] <= 'd0;
          end
          'h500: begin
            axilite_rddata[9:0] <= axilite_tx1_pio_data;
            axilite_rddata[31:10] <= 'd0;
          end
          'h504: begin
            axilite_rddata[9:0] <= axilite_tx1_pio_data_out;
            axilite_rddata[31:10] <= 'd0;
          end
          'h508: begin
            axilite_rddata[9:0] <= axilite_tx1_pio_data_out_enb;
            axilite_rddata[31:10] <= 'd0;
          end
          'h600: begin
            axilite_rddata[3:0] <= axilite_trig_src_group;
            axilite_rddata[31:4] <= 'd0;
          end
          'h604: begin
            axilite_rddata[3:0] <= axilite_trig_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h700: begin
            axilite_rddata[3:0] <= axilite_gainindex_src_group;
            axilite_rddata[31:4] <= 'd0;
          end
          'h704: begin
            axilite_rddata[3:0] <= axilite_gainindex0_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h708: begin
            axilite_rddata[3:0] <= axilite_gainindex1_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h70c: begin
            axilite_rddata[3:0] <= axilite_gainindex2_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h710: begin
            axilite_rddata[3:0] <= axilite_gainindex3_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h714: begin
            axilite_rddata[3:0] <= axilite_gainindex4_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h718: begin
            axilite_rddata[3:0] <= axilite_gainindex5_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h71c: begin
            axilite_rddata[3:0] <= axilite_gainindex6_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h720: begin
            axilite_rddata[3:0] <= axilite_gainindex7_src_pin;
            axilite_rddata[31:4] <= 'd0;
          end
          'h800: begin
            axilite_rddata <= axilite_clk_mon_count;
          end
          default: begin
            axilite_rddata <= 32'd0;
          end
        endcase
      end else begin
        axilite_rddata <= 32'd0;
      end
    end
  end

endmodule

// **********************************************************************************
// **********************************************************************************
