#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       AXI_ADRV9001 top level registers
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;
require 'dooku.pl';

$addr_width = 16;
$addr_width_used = 12;

setdooku(@ARGV);
module(0x0, 'axi_adrv9001_gpio');

register(0x000, 'REG_TIMER');
field(0, 32, RW, 0x0, 'TIMER', 'General purpose timer register, this is a count
  down timer, software may write desired interval and wait for it to reach zero.
  The count can be prematurely terminated, runs at AXILite clock (usually 100MHz).');

register(0x100, 'REG_DGPIO_PIO_DATA');
field(0, 12, RO, 0x0, 'DGPIO_PIO_DATA', 'These bits are directly mapped to the
  device digital GPIO pins. These bits always indicate the current data on these
  pins regardless of who is driving them (FPGA or device).');

register(0x104, 'REG_DGPIO_PIO_DATA_OUT');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_OUT', 'These register bits directly drive
  the digital GPIO pins, in output mode.');

register(0x108, 'REG_DGPIO_PIO_DATA_OUT_ENB');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_OUT_ENB', 'These register bits controls the
  direction of GPIO. If set, the corresponding pin output buffer is enabled.');

register(0x10c, 'REG_DGPIO_PIO_DATA_MODE');
field(0, 12, RW, 0x0, 'DGPIO_PIO_DATA_MODE', 'These register bits controls the
  source of GPIO in output mode. If set to 0x1, the corresponding pin is in hardware
  mode controlled by the bits below. If set to 0x0, the corresponding pin is in
  software mode and is controlled by the DGPIO_DATA_OUT register.');

for ($i = 0; $i < 12; $i++) {
  $i_str = "$i";
  if ($i < 10) {
    $i_str = "0$i";
  }
  register((0x110 + ($i * 4)), "REG_DGPIO_PIO_SEL_$i_str");
  field(0, 4, RW, 0x0, "DGPIO_PIO_SEL_$i_str", 'These bits control the source of
    digital GPIO in hardware mode. The following modes are supported:
      0000: TDD, transmit-0 channel enable.
      0001: TDD, receive-0 channel enable.
      0010: TDD, observation-receive-0 channel enable.
      0011: TDD, auxiliary-0 channel enable.
      0100: TDD, transmit-1 channel enable.
      0101: TDD, receive-1 channel enable.
      0110: TDD, observation-receive-1 channel enable.
      0111: TDD, auxiliary-1 channel enable.
      1000: TDD, control-0 enable.
      1001: TDD, control-1 enable.
      1010: TDD, control-2 enable.
      1011: TDD, control-3 enable.');
}

register(0x200, 'REG_RX0_PIO_DATA');
field(0, 8, RO, 0x0, 'RX0_PIO_DATA', 'These bits are directly mapped to the
  device RXSSI0 pins. In data, strobe, and clock order (msb to lsb)');

register(0x204, 'REG_RX0_PIO_DATA_OUT');
field(0, 8, RW, 0x0, 'RX0_PIO_DATA_OUT', 'These register bits directly drive
  the RXSSI0 pins, in output mode.');

register(0x208, 'REG_RX0_PIO_DATA_OUT_ENB');
field(0, 8, RW, 0x0, 'RX0_PIO_DATA_OUT_ENB', 'These register bits controls the
  direction of RXSSI0 pins. If set, the corresponding pin output buffer is enabled.');

register(0x300, 'REG_RX1_PIO_DATA');
field(0, 8, RO, 0x0, 'RX1_PIO_DATA', 'These bits are directly mapped to the
  device RXSSI1 pins. In data, strobe, and clock order (msb to lsb)');

register(0x304, 'REG_RX1_PIO_DATA_OUT');
field(0, 8, RW, 0x0, 'RX1_PIO_DATA_OUT', 'These register bits directly drive
  the RXSSI1 pins, in output mode.');

register(0x308, 'REG_RX1_PIO_DATA_OUT_ENB');
field(0, 8, RW, 0x0, 'RX1_PIO_DATA_OUT_ENB', 'These register bits controls the
  direction of RXSSI1 pins. If set, the corresponding pin output buffer is enabled.');

register(0x400, 'REG_TX0_PIO_DATA');
field(0, 10, RO, 0x0, 'TX0_PIO_DATA', 'These bits are directly mapped to the
  device TXSSI0 pins. In data, strobe, clock, and ref-clock order (msb to lsb)');

register(0x404, 'REG_TX0_PIO_DATA_OUT');
field(0, 10, RW, 0x0, 'TX0_PIO_DATA_OUT', 'These register bits directly drive
  the TXSSI0 pins, in output mode.');

register(0x408, 'REG_TX0_PIO_DATA_OUT_ENB');
field(0, 10, RW, 0x0, 'TX0_PIO_DATA_OUT_ENB', 'These register bits controls the
  direction of TXSSI0 pins. If set, the corresponding pin output buffer is enabled.');

register(0x500, 'REG_TX1_PIO_DATA');
field(0, 10, RO, 0x0, 'TX1_PIO_DATA', 'These bits are directly mapped to the
  device TXSSI1 pins. In data, strobe, clock, and ref-clock order (msb to lsb)');

register(0x504, 'REG_TX1_PIO_DATA_OUT');
field(0, 10, RW, 0x0, 'TX1_PIO_DATA_OUT', 'These register bits directly drive
  the TXSSI1 pins, in output mode.');

register(0x508, 'REG_TX1_PIO_DATA_OUT_ENB');
field(0, 10, RW, 0x0, 'TX1_PIO_DATA_OUT_ENB', 'These register bits controls the
  direction of TXSSI1 pins. If set, the corresponding pin output buffer is enabled.');

register(0x600, 'REG_TRIG_SRC_GROUP');
field(0, 4, RW, 0x0, 'TRIG_SRC_GROUP', 'The source GPIO group, DGPIO (0x1),
  RXSSI0 (0x4), RXSSI1 (0x5), TXSSI0 (0x6) or TXSSI1 (0x7).');

register(0x604, 'REG_TRIG_SRC_PIN');
field(0, 4, RW, 0x0, 'TRIG_SRC_PIN', 'The source GPIO pin number.');

register(0x700, "REG_GAININDEX_SRC_GROUP");
field(0, 4, RW, 0x0, "GAININDEX_SRC_GROUP", 'The source GPIO group, DGPIO (0x1),
  RXSSI0 (0x4), RXSSI1 (0x5), TXSSI0 (0x6) or TXSSI1 (0x7).');

for ($i = 0; $i < 8; $i++) {
  register((0x704 + ($i * 4)), "REG_GAININDEX${i}_SRC_PIN");
  field(0, 4, RW, 0x0, "GAININDEX${i}_SRC_PIN", 'The source GPIO pin number.');
}

register(0x800, 'REG_CLK_MON');
field(0, 32, RO, 0x0, 'CLK_MON_COUNT', 'Clock monitor frequency count. If read 0x0,
  indicates a loss of clock. The format is 16.16 x 100MHz');

endregisters();
endmodule();
generate();

## ##################################################################################
## ##################################################################################
