// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI_ADRV9001
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module axi_adrv9001 #(

  parameter AXI_ADRV9001_INSTANCE_ID = 0,
  parameter AXI_ADRV9001_RX0_GPIO2_CMOS1_LVDS0 = 0,
  parameter AXI_ADRV9001_RX1_GPIO2_CMOS1_LVDS0 = 0,
  parameter AXI_ADRV9001_TX0_GPIO2_CMOS1_LVDS0 = 0,
  parameter AXI_ADRV9001_TX1_GPIO2_CMOS1_LVDS0 = 0,
  parameter AXI_ADRV9001_RX0_IODELAY_CTRL_ENABLE = 1,
  parameter AXI_ADRV9001_RX1_IODELAY_CTRL_ENABLE = 0,
  parameter AXI_ADRV9001_TX0_IODELAY_CTRL_ENABLE = 0,
  parameter AXI_ADRV9001_TX1_IODELAY_CTRL_ENABLE = 0,
  parameter AXI_ADRV9001_RX0_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
  parameter AXI_ADRV9001_RX1_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
  parameter AXI_ADRV9001_TX0_IODELAY_GROUP = "AXI_ADRV9001_IODELAY",
  parameter AXI_ADRV9001_TX1_IODELAY_GROUP = "AXI_ADRV9001_IODELAY") (

  // system interface

  input   wire            sys_200m_clk,
  input   wire            sys_ref_clk_p,
  input   wire            sys_ref_clk_n,
  input   wire            sys_mcs_in_p,
  input   wire            sys_mcs_in_n,
  output  wire            sys_mcs_out_p,
  output  wire            sys_mcs_out_n,

  // adrv9001 interface

  input   wire            dio_rx0_cssi_clk_lssi_clk_p,
  input   wire            dio_rx0_cssi_nc_lssi_clk_n,
  input   wire            dio_rx0_cssi_strobe_lssi_strobe_p,
  input   wire            dio_rx0_cssi_nc_lssi_strobe_n,
  input   wire            dio_rx0_cssi_data1_lssi_data0_p,
  input   wire            dio_rx0_cssi_data0_lssi_data0_n,
  input   wire            dio_rx0_cssi_data3_lssi_data1_p,
  input   wire            dio_rx0_cssi_data2_lssi_data1_n,
  input   wire  [  7:0]   dio_rx0_cssi_gpio_in,
  output  wire  [  7:0]   dio_rx0_cssi_gpio_out,
  output  wire  [  7:0]   dio_rx0_cssi_gpio_enb,
  input   wire            dio_rx1_cssi_clk_lssi_clk_p,
  input   wire            dio_rx1_cssi_nc_lssi_clk_n,
  input   wire            dio_rx1_cssi_strobe_lssi_strobe_p,
  input   wire            dio_rx1_cssi_nc_lssi_strobe_n,
  input   wire            dio_rx1_cssi_data1_lssi_data0_p,
  input   wire            dio_rx1_cssi_data0_lssi_data0_n,
  input   wire            dio_rx1_cssi_data3_lssi_data1_p,
  input   wire            dio_rx1_cssi_data2_lssi_data1_n,
  input   wire  [  7:0]   dio_rx1_cssi_gpio_in,
  output  wire  [  7:0]   dio_rx1_cssi_gpio_out,
  output  wire  [  7:0]   dio_rx1_cssi_gpio_enb,
  input   wire            dio_tx0_cssi_refclk_lssi_refclk_p,
  input   wire            dio_tx0_cssi_nc_lssi_refclk_n,
  output  wire            dio_tx0_cssi_clk_lssi_clk_p,
  output  wire            dio_tx0_cssi_nc_lssi_clk_n,
  output  wire            dio_tx0_cssi_strobe_lssi_strobe_p,
  output  wire            dio_tx0_cssi_nc_lssi_strobe_n,
  output  wire            dio_tx0_cssi_data1_lssi_data0_p,
  output  wire            dio_tx0_cssi_data0_lssi_data0_n,
  output  wire            dio_tx0_cssi_data3_lssi_data1_p,
  output  wire            dio_tx0_cssi_data2_lssi_data1_n,
  input   wire  [  9:0]   dio_tx0_cssi_gpio_in,
  output  wire  [  9:0]   dio_tx0_cssi_gpio_out,
  output  wire  [  9:0]   dio_tx0_cssi_gpio_enb,
  input   wire            dio_tx1_cssi_refclk_lssi_refclk_p,
  input   wire            dio_tx1_cssi_nc_lssi_refclk_n,
  output  wire            dio_tx1_cssi_clk_lssi_clk_p,
  output  wire            dio_tx1_cssi_nc_lssi_clk_n,
  output  wire            dio_tx1_cssi_strobe_lssi_strobe_p,
  output  wire            dio_tx1_cssi_nc_lssi_strobe_n,
  output  wire            dio_tx1_cssi_data1_lssi_data0_p,
  output  wire            dio_tx1_cssi_data0_lssi_data0_n,
  output  wire            dio_tx1_cssi_data3_lssi_data1_p,
  output  wire            dio_tx1_cssi_data2_lssi_data1_n,
  input   wire  [  9:0]   dio_tx1_cssi_gpio_in,
  output  wire  [  9:0]   dio_tx1_cssi_gpio_out,
  output  wire  [  9:0]   dio_tx1_cssi_gpio_enb,
  output  wire            dio_rx0_enable,
  output  wire            dio_rx1_enable,
  output  wire            dio_tx0_enable,
  output  wire            dio_tx1_enable,
  inout   wire  [ 11:0]   dio_dgpio,
  output  wire            dio_mode,
  output  wire            dio_resetb,
  input   wire            dio_gp_int,
  input   wire            dio_dev_clk,

  // multi-chip synchronization interface

  output  wire            gpio_out_clk,
  input   wire            gpio_clk,

  output  wire            dev_out_clk,
  output  wire            mcs_out_int,
  input   wire            dev_clk,
  input   wire            mcs_int,

  output  wire            tdd_out_clk,
  output  wire            tdd_out_resetn,
  output  wire            tdd_out_state,
  output  wire            tdd_out_frm_toggle,
  output  wire  [ 31:0]   tdd_out_clk_cnt,
  output  wire  [ 31:0]   tdd_out_frm_cnt,
  input   wire            tdd_clk,
  input   wire            tdd_resetn,
  input   wire            tdd_state,
  input   wire            tdd_frm_toggle,
  input   wire  [ 31:0]   tdd_clk_cnt,
  input   wire  [ 31:0]   tdd_frm_cnt,

  // internal receive & observation interface (axi-stream)

  output  wire            rx0_resetn,
  output  wire            rx0_clk,
  output  wire            rx0_tvalid,
  output  wire  [ 63:0]   rx0_tdata,
  output  wire            orx0_tvalid,
  output  wire  [ 63:0]   orx0_tdata,

  output  wire            rx1_resetn,
  output  wire            rx1_clk,
  output  wire            rx1_tvalid,
  output  wire  [ 63:0]   rx1_tdata,
  output  wire            orx1_tvalid,
  output  wire  [ 63:0]   orx1_tdata,

  // internal transmit interface (**NOT** axi-stream)
  // tvalid <= tready[t-LATENCY]; turn around tready to match source latency
  // tdata <= (IS_DATA_AVAILABLE ? data : DEFAULT_SAMPLE;
  // source must drive a sample for every tready asserted high,
  // if data is not available, must drive a default sample (0x0)

  output  wire            tx0_resetn,
  output  wire            tx0_clk,
  output  wire            tx0_tready,
  input   wire            tx0_tvalid,
  input   wire  [ 63:0]   tx0_tdata,

  output  wire            tx1_resetn,
  output  wire            tx1_clk,
  output  wire            tx1_tready,
  input   wire            tx1_tvalid,
  input   wire  [ 63:0]   tx1_tdata,

  // gain capture

  output  wire            gpio_resetn,
  output  wire            gpio_gain_tvalid,
  output  wire  [  7:0]   gpio_gain_tdata,

  // user gpio & triggers
 
  inout   wire  [  1:0]   trig,
  output  wire  [  3:0]   trig_out,
  input   wire  [ 31:0]   usr_gpio_in,
  output  wire  [ 31:0]   usr_gpio_out,

  // axi interface

  input   wire            axilite_clk,
  input   wire            axilite_resetn,
  input   wire            axilite_awvalid,
  input   wire  [ 15:0]   axilite_awaddr,
  output  wire            axilite_awready,
  input   wire            axilite_wvalid,
  input   wire  [ 31:0]   axilite_wdata,
  output  wire            axilite_wready,
  output  wire            axilite_bvalid,
  output  wire  [  1:0]   axilite_bresp,
  input   wire            axilite_bready,
  input   wire            axilite_arvalid,
  input   wire  [ 15:0]   axilite_araddr,
  output  wire            axilite_arready,
  output  wire            axilite_rvalid,
  output  wire  [  1:0]   axilite_rresp,
  output  wire  [ 31:0]   axilite_rdata,
  input   wire            axilite_rready,
  output  wire            interrupt);

  // local parameters

  localparam    [ 31:0]   AXI_ADRV9001_VERSION      = {8'd0, 8'd6, 8'd3, 8'd3};
  localparam    [  3:0]   AXI_ADRV9001_MAIN_ID      = 4'b0000;
  localparam    [  3:0]   AXI_ADRV9001_GPIO_ID      = 4'b0001;
  localparam    [  3:0]   AXI_ADRV9001_RX0_ID       = 4'b0100;
  localparam    [  3:0]   AXI_ADRV9001_RX1_ID       = 4'b0101;
  localparam    [  3:0]   AXI_ADRV9001_TX0_ID       = 4'b0110;
  localparam    [  3:0]   AXI_ADRV9001_TX1_ID       = 4'b0111;
  localparam    [  3:0]   AXI_ADRV9001_TDD_DEV_ID   = 4'b1000;
  localparam    [  3:0]   AXI_ADRV9001_TDD_DMA_ID   = 4'b1001;

  // internal registers

  reg                     axilite_gpint_in_d = 'd0;
  reg                     axilite_gpint = 'd0;
 
  // internal signals

  wire                    mcs_toggle;
  wire                    rx0_buf_clk;
  wire                    rx0_enable;
  wire          [  7:0]   rx0_gpio_in;
  wire          [  7:0]   rx0_gpio_out;
  wire          [  7:0]   rx0_gpio_enb;
  wire                    orx0_enable;
  wire                    rx1_buf_clk;
  wire                    rx1_enable;
  wire          [  7:0]   rx1_gpio_in;
  wire          [  7:0]   rx1_gpio_out;
  wire          [  7:0]   rx1_gpio_enb;
  wire                    orx1_enable;
  wire                    tx0_enable;
  wire          [  9:0]   tx0_gpio_in;
  wire          [  9:0]   tx0_gpio_out;
  wire          [  9:0]   tx0_gpio_enb;
  wire                    tx0_pattern_done;
  wire                    tx1_enable;
  wire          [  9:0]   tx1_gpio_in;
  wire          [  9:0]   tx1_gpio_out;
  wire          [  9:0]   tx1_gpio_enb;
  wire                    tx1_pattern_done;
  wire                    sys_200m_resetn;
  wire                    tdd_orx0_gpio_enable;
  wire                    tdd_orx1_gpio_enable;
  wire                    tdd_aux0_gpio_enable;
  wire                    tdd_aux1_gpio_enable;
  wire                    tdd_ctl0_gpio_enable;
  wire                    tdd_ctl1_gpio_enable;
  wire                    tdd_ctl2_gpio_enable;
  wire                    tdd_ctl3_gpio_enable;
  wire                    tdd_trig0_ext_enable;
  wire                    tdd_trig1_ext_enable;
  wire                    axilite_wrreq;
  wire          [ 15:0]   axilite_wraddr;
  wire          [ 31:0]   axilite_wrdata;
  wire                    axilite_wrack;
  wire                    axilite_rdreq;
  wire          [ 15:0]   axilite_rdaddr;
  wire          [ 31:0]   axilite_rddata;
  wire                    axilite_rdack;
  wire          [  6:0]   axilite_blk_wrack;
  wire          [  6:0]   axilite_blk_rdack;
  wire          [223:0]   axilite_blk_rddata;
  wire                    axilite_gpint_in;
  wire          [  1:0]   axilite_gpint_mode;
  wire                    axilite_mcs_request;
  wire                    axilite_mcs_done;
  wire          [  3:0]   axilite_mcs_width;
  wire          [  3:0]   axilite_mcs_num;
  wire                    axilite_mcs_edge_fall1_rise0;
  wire                    axilite_mcs_select;
  wire          [ 31:0]   axilite_mcs_period;
  wire          [ 31:0]   axilite_mcs_clk_mon_count;
  wire                    axilite_mmcm_request;
  wire                    axilite_mmcm_ack;
  wire                    axilite_mmcm_rd1_wr0;
  wire          [  6:0]   axilite_mmcm_addr;
  wire          [ 15:0]   axilite_mmcm_wrdata;
  wire          [ 15:0]   axilite_mmcm_rddata;
  wire                    axilite_mmcm_reset;
  wire                    axilite_mmcm_busy;
  wire                    axilite_mmcm_unlocked;
  wire                    axilite_mmcm_ref_clk_sel;
  wire          [ 31:0]   axilite_mmcm_ref_clk_mon_count;
  wire                    axilite_trig0_ext_oe;
  wire                    axilite_trig1_ext_oe;

  // defaults 

  assign interrupt = axilite_gpint;
  assign trig_out[1:0] = trig;
  assign trig[0] = (axilite_trig0_ext_oe == 1'b1) ? tdd_trig0_ext_enable : 1'bz;
  assign trig[1] = (axilite_trig1_ext_oe == 1'b1) ? tdd_trig1_ext_enable : 1'bz;

  // interrupt

  always @(negedge axilite_resetn or posedge axilite_clk) begin
    if (axilite_resetn == 1'd0) begin
      axilite_gpint_in_d <= 1'd0;
      axilite_gpint <= 1'd0;
    end else begin
      axilite_gpint_in_d <= axilite_gpint_in;
      case (axilite_gpint_mode)
        2'b11: axilite_gpint <= axilite_gpint_in_d & ~axilite_gpint_in;
        2'b10: axilite_gpint <= ~axilite_gpint_in_d & axilite_gpint_in;
        2'b01: axilite_gpint <= ~axilite_gpint_in;
        default: axilite_gpint <= axilite_gpint_in;
      endcase
    end
  end

  // instantiations

  generate
  if (AXI_ADRV9001_INSTANCE_ID == 0) begin

  axi_adrv9001_clkgen i_clkgen (
    .sys_ref_clk_p                    (sys_ref_clk_p),
    .sys_ref_clk_n                    (sys_ref_clk_n),
    .dev_ref_clk                      (dio_dev_clk),
    .dev_clk                          (dev_out_clk),
    .gpio_clk                         (gpio_out_clk),
    .tdd_clk                          (tdd_out_clk),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_mmcm_reset               (axilite_mmcm_reset),
    .axilite_mmcm_request             (axilite_mmcm_request),
    .axilite_mmcm_ack                 (axilite_mmcm_ack),
    .axilite_mmcm_rd1_wr0             (axilite_mmcm_rd1_wr0),
    .axilite_mmcm_addr                (axilite_mmcm_addr),
    .axilite_mmcm_wrdata              (axilite_mmcm_wrdata),
    .axilite_mmcm_rddata              (axilite_mmcm_rddata),
    .axilite_mmcm_busy                (axilite_mmcm_busy),
    .axilite_mmcm_unlocked            (axilite_mmcm_unlocked),
    .axilite_mmcm_ref_clk_sel         (axilite_mmcm_ref_clk_sel),
    .axilite_mmcm_ref_clk_mon_count   (axilite_mmcm_ref_clk_mon_count));

  end else begin

  assign dev_out_clk = 1'd0;
  assign gpio_out_clk = 1'd0;
  assign tdd_out_clk = 1'd0;
  assign axilite_mmcm_ack = 1'd0;
  assign axilite_mmcm_rddata = 16'd0;
  assign axilite_mmcm_busy = 1'd0;
  assign axilite_mmcm_unlocked = 1'd1;
  assign axilite_mmcm_ref_clk_mon_count = 32'd0;

  end
  endgenerate

  axi_adrv9001_mcs #(
    .INSTANCE_ID                      (AXI_ADRV9001_INSTANCE_ID))
  i_mcs (
    .dev_clk                          (dev_clk),
    .mcs_in_p                         (sys_mcs_in_p),
    .mcs_in_n                         (sys_mcs_in_n),
    .mcs_out_p                        (sys_mcs_out_p),
    .mcs_out_n                        (sys_mcs_out_n),
    .mcs_out_int                      (mcs_out_int),
    .mcs_toggle                       (mcs_toggle),
    .mcs_int                          (mcs_int),
    .mcs                              (trig_out[2]),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_mcs_request              (axilite_mcs_request),
    .axilite_mcs_done                 (axilite_mcs_done),
    .axilite_mcs_period               (axilite_mcs_period),
    .axilite_mcs_width                (axilite_mcs_width),
    .axilite_mcs_num                  (axilite_mcs_num),
    .axilite_mcs_edge_fall1_rise0     (axilite_mcs_edge_fall1_rise0),
    .axilite_mcs_select               (axilite_mcs_select),
    .axilite_mcs_clk_mon_count        (axilite_mcs_clk_mon_count));

  axi_adrv9001_gpio #(
    .ID                               (AXI_ADRV9001_GPIO_ID))
  i_gpio (
    .dgpio                            (dio_dgpio),
    .rx0_gpio_in                      (rx0_gpio_in),
    .rx0_gpio_out                     (rx0_gpio_out),
    .rx0_gpio_enb                     (rx0_gpio_enb),
    .rx1_gpio_in                      (rx1_gpio_in),
    .rx1_gpio_out                     (rx1_gpio_out),
    .rx1_gpio_enb                     (rx1_gpio_enb),
    .tx0_gpio_in                      (tx0_gpio_in),
    .tx0_gpio_out                     (tx0_gpio_out),
    .tx0_gpio_enb                     (tx0_gpio_enb),
    .tx1_gpio_in                      (tx1_gpio_in),
    .tx1_gpio_out                     (tx1_gpio_out),
    .tx1_gpio_enb                     (tx1_gpio_enb),
    .gpio_clk                         (gpio_clk),
    .gpio_resetn                      (gpio_resetn),
    .gpio_trig                        (trig_out[3]),
    .gpio_gainindex_valid             (gpio_gain_tvalid),
    .gpio_gainindex                   (gpio_gain_tdata),
    .tdd_clk                          (tdd_clk),
    .tdd_resetn                       (tdd_resetn),
    .tdd_tx0_dev_enable               (dio_tx0_enable),
    .tdd_rx0_dev_enable               (dio_rx0_enable),
    .tdd_tx1_dev_enable               (dio_tx1_enable),
    .tdd_rx1_dev_enable               (dio_rx1_enable),
    .tdd_orx0_gpio_enable             (tdd_orx0_gpio_enable),
    .tdd_orx1_gpio_enable             (tdd_orx1_gpio_enable),
    .tdd_aux0_gpio_enable             (tdd_aux0_gpio_enable),
    .tdd_aux1_gpio_enable             (tdd_aux1_gpio_enable),
    .tdd_ctl0_gpio_enable             (tdd_ctl0_gpio_enable),
    .tdd_ctl1_gpio_enable             (tdd_ctl1_gpio_enable),
    .tdd_ctl2_gpio_enable             (tdd_ctl2_gpio_enable),
    .tdd_ctl3_gpio_enable             (tdd_ctl3_gpio_enable),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[6]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*6)+31):(32*6)]),
    .axilite_rdack                    (axilite_blk_rdack[6]));

  axi_adrv9001_tdd #(
    .ID                               (AXI_ADRV9001_TDD_DEV_ID),
    .DMA_ID                           (AXI_ADRV9001_TDD_DMA_ID),
    .INSTANCE_ID                      (AXI_ADRV9001_INSTANCE_ID))
  i_tdd (
    .rx0_resetn                       (rx0_resetn),
    .rx0_clk                          (rx0_clk),
    .rx0_enable                       (rx0_enable),
    .orx0_enable                      (orx0_enable),
    .tx0_resetn                       (tx0_resetn),
    .tx0_clk                          (tx0_clk),
    .tx0_enable                       (tx0_enable),
    .rx1_resetn                       (rx1_resetn),
    .rx1_clk                          (rx1_clk),
    .rx1_enable                       (rx1_enable),
    .orx1_enable                      (orx1_enable),
    .tx1_resetn                       (tx1_resetn),
    .tx1_clk                          (tx1_clk),
    .tx1_enable                       (tx1_enable),
    .tdd_out_resetn                   (tdd_out_resetn),
    .tdd_out_state                    (tdd_out_state),
    .tdd_out_frm_toggle               (tdd_out_frm_toggle),
    .tdd_out_clk_cnt                  (tdd_out_clk_cnt),
    .tdd_out_frm_cnt                  (tdd_out_frm_cnt),
    .tdd_clk                          (tdd_clk),
    .tdd_resetn                       (tdd_resetn),
    .tdd_state                        (tdd_state),
    .tdd_frm_toggle                   (tdd_frm_toggle),
    .tdd_clk_cnt                      (tdd_clk_cnt),
    .tdd_frm_cnt                      (tdd_frm_cnt),
    .tdd_rx0_device_enable            (dio_rx0_enable),
    .tdd_tx0_device_enable            (dio_tx0_enable),
    .tdd_rx1_device_enable            (dio_rx1_enable),
    .tdd_tx1_device_enable            (dio_tx1_enable),
    .tdd_orx0_gpio_enable             (tdd_orx0_gpio_enable),
    .tdd_orx1_gpio_enable             (tdd_orx1_gpio_enable),
    .tdd_aux0_gpio_enable             (tdd_aux0_gpio_enable),
    .tdd_aux1_gpio_enable             (tdd_aux1_gpio_enable),
    .tdd_ctl0_gpio_enable             (tdd_ctl0_gpio_enable),
    .tdd_ctl1_gpio_enable             (tdd_ctl1_gpio_enable),
    .tdd_ctl2_gpio_enable             (tdd_ctl2_gpio_enable),
    .tdd_ctl3_gpio_enable             (tdd_ctl3_gpio_enable),
    .tdd_trig0_ext_enable             (tdd_trig0_ext_enable),
    .tdd_trig1_ext_enable             (tdd_trig1_ext_enable),
    .trig                             (trig_out),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[5]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*5)+31):(32*5)]),
    .axilite_rdack                    (axilite_blk_rdack[5]));

  axi_adrv9001_tx #(
    .ID                               (AXI_ADRV9001_TX1_ID),
    .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_TX1_GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                    (AXI_ADRV9001_TX1_IODELAY_GROUP),
    .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_TX1_IODELAY_CTRL_ENABLE))
  i_tx1 (
    .tx_cssi_refclk_lssi_refclk_p     (dio_tx1_cssi_refclk_lssi_refclk_p),
    .tx_cssi_nc_lssi_refclk_n         (dio_tx1_cssi_nc_lssi_refclk_n),
    .tx_cssi_clk_lssi_clk_p           (dio_tx1_cssi_clk_lssi_clk_p),
    .tx_cssi_nc_lssi_clk_n            (dio_tx1_cssi_nc_lssi_clk_n),
    .tx_cssi_strobe_lssi_strobe_p     (dio_tx1_cssi_strobe_lssi_strobe_p),
    .tx_cssi_nc_lssi_strobe_n         (dio_tx1_cssi_nc_lssi_strobe_n),
    .tx_cssi_data1_lssi_data0_p       (dio_tx1_cssi_data1_lssi_data0_p),
    .tx_cssi_data0_lssi_data0_n       (dio_tx1_cssi_data0_lssi_data0_n),
    .tx_cssi_data3_lssi_data1_p       (dio_tx1_cssi_data3_lssi_data1_p),
    .tx_cssi_data2_lssi_data1_n       (dio_tx1_cssi_data2_lssi_data1_n),
    .tx_cssi_gpio_in                  (dio_tx1_cssi_gpio_in),
    .tx_cssi_gpio_out                 (dio_tx1_cssi_gpio_out),
    .tx_cssi_gpio_enb                 (dio_tx1_cssi_gpio_enb),
    .rx_buf_clk                       (rx1_buf_clk),
    .rx_clk                           (rx1_clk),
    .rx_resetn                        (rx1_resetn),
    .rx_valid                         (rx1_tvalid),
    .rx_data                          (rx1_tdata),
    .tx_clk                           (tx1_clk),
    .tx_resetn                        (tx1_resetn),
    .tx_read                          (tx1_tready),
    .tx_valid                         (tx1_tvalid),
    .tx_data                          (tx1_tdata),
    .tx_enable                        (tx1_enable),
    .tx_gpio_in                       (tx1_gpio_in),
    .tx_gpio_out                      (tx1_gpio_out),
    .tx_gpio_enb                      (tx1_gpio_enb),
    .mcs_toggle                       (mcs_toggle),
    .tx_pattern_done                  (tx1_pattern_done),
    .sys_200m_clk                     (sys_200m_clk),
    .sys_200m_resetn                  (sys_200m_resetn),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[4]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*4)+31):(32*4)]),
    .axilite_rdack                    (axilite_blk_rdack[4]));

  axi_adrv9001_tx #(
    .ID                               (AXI_ADRV9001_TX0_ID),
    .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_TX0_GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                    (AXI_ADRV9001_TX0_IODELAY_GROUP),
    .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_TX0_IODELAY_CTRL_ENABLE))
  i_tx0 (
    .tx_cssi_refclk_lssi_refclk_p     (dio_tx0_cssi_refclk_lssi_refclk_p),
    .tx_cssi_nc_lssi_refclk_n         (dio_tx0_cssi_nc_lssi_refclk_n),
    .tx_cssi_clk_lssi_clk_p           (dio_tx0_cssi_clk_lssi_clk_p),
    .tx_cssi_nc_lssi_clk_n            (dio_tx0_cssi_nc_lssi_clk_n),
    .tx_cssi_strobe_lssi_strobe_p     (dio_tx0_cssi_strobe_lssi_strobe_p),
    .tx_cssi_nc_lssi_strobe_n         (dio_tx0_cssi_nc_lssi_strobe_n),
    .tx_cssi_data1_lssi_data0_p       (dio_tx0_cssi_data1_lssi_data0_p),
    .tx_cssi_data0_lssi_data0_n       (dio_tx0_cssi_data0_lssi_data0_n),
    .tx_cssi_data3_lssi_data1_p       (dio_tx0_cssi_data3_lssi_data1_p),
    .tx_cssi_data2_lssi_data1_n       (dio_tx0_cssi_data2_lssi_data1_n),
    .tx_cssi_gpio_in                  (dio_tx0_cssi_gpio_in),
    .tx_cssi_gpio_out                 (dio_tx0_cssi_gpio_out),
    .tx_cssi_gpio_enb                 (dio_tx0_cssi_gpio_enb),
    .rx_buf_clk                       (rx0_buf_clk),
    .rx_clk                           (rx0_clk),
    .rx_resetn                        (rx0_resetn),
    .rx_valid                         (rx0_tvalid),
    .rx_data                          (rx0_tdata),
    .tx_clk                           (tx0_clk),
    .tx_resetn                        (tx0_resetn),
    .tx_read                          (tx0_tready),
    .tx_valid                         (tx0_tvalid),
    .tx_data                          (tx0_tdata),
    .tx_enable                        (tx0_enable),
    .tx_gpio_in                       (tx0_gpio_in),
    .tx_gpio_out                      (tx0_gpio_out),
    .tx_gpio_enb                      (tx0_gpio_enb),
    .mcs_toggle                       (mcs_toggle),
    .tx_pattern_done                  (tx0_pattern_done),
    .sys_200m_clk                     (sys_200m_clk),
    .sys_200m_resetn                  (sys_200m_resetn),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[3]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*3)+31):(32*3)]),
    .axilite_rdack                    (axilite_blk_rdack[3]));

  axi_adrv9001_rx #(
    .ID                               (AXI_ADRV9001_RX1_ID),
    .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_RX1_GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                    (AXI_ADRV9001_RX1_IODELAY_GROUP),
    .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_RX1_IODELAY_CTRL_ENABLE))
  i_rx1 (
    .rx_cssi_clk_lssi_clk_p           (dio_rx1_cssi_clk_lssi_clk_p),
    .rx_cssi_nc_lssi_clk_n            (dio_rx1_cssi_nc_lssi_clk_n),
    .rx_cssi_strobe_lssi_strobe_p     (dio_rx1_cssi_strobe_lssi_strobe_p),
    .rx_cssi_nc_lssi_strobe_n         (dio_rx1_cssi_nc_lssi_strobe_n),
    .rx_cssi_data1_lssi_data0_p       (dio_rx1_cssi_data1_lssi_data0_p),
    .rx_cssi_data0_lssi_data0_n       (dio_rx1_cssi_data0_lssi_data0_n),
    .rx_cssi_data3_lssi_data1_p       (dio_rx1_cssi_data3_lssi_data1_p),
    .rx_cssi_data2_lssi_data1_n       (dio_rx1_cssi_data2_lssi_data1_n),
    .rx_cssi_gpio_in                  (dio_rx1_cssi_gpio_in),
    .rx_cssi_gpio_out                 (dio_rx1_cssi_gpio_out),
    .rx_cssi_gpio_enb                 (dio_rx1_cssi_gpio_enb),
    .rx_buf_clk                       (rx1_buf_clk),
    .rx_clk                           (rx1_clk),
    .rx_resetn                        (rx1_resetn),
    .rx_valid                         (rx1_tvalid),
    .rx_data                          (rx1_tdata),
    .rx_enable                        (rx1_enable),
    .orx_enable                       (orx1_enable),
    .orx_valid                        (orx1_tvalid),
    .orx_data                         (orx1_tdata),
    .rx_gpio_in                       (rx1_gpio_in),
    .rx_gpio_out                      (rx1_gpio_out),
    .rx_gpio_enb                      (rx1_gpio_enb),
    .mcs_toggle                       (mcs_toggle),
    .tx_pattern_done                  (tx1_pattern_done),
    .sys_200m_clk                     (sys_200m_clk),
    .sys_200m_resetn                  (sys_200m_resetn),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[2]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*2)+31):(32*2)]),
    .axilite_rdack                    (axilite_blk_rdack[2]));

  axi_adrv9001_rx #(
    .ID                               (AXI_ADRV9001_RX0_ID),
    .GPIO2_CMOS1_LVDS0                (AXI_ADRV9001_RX0_GPIO2_CMOS1_LVDS0),
    .IODELAY_GROUP                    (AXI_ADRV9001_RX0_IODELAY_GROUP),
    .IODELAY_CTRL_ENABLE              (AXI_ADRV9001_RX0_IODELAY_CTRL_ENABLE))
  i_rx0 (
    .rx_cssi_clk_lssi_clk_p           (dio_rx0_cssi_clk_lssi_clk_p),
    .rx_cssi_nc_lssi_clk_n            (dio_rx0_cssi_nc_lssi_clk_n),
    .rx_cssi_strobe_lssi_strobe_p     (dio_rx0_cssi_strobe_lssi_strobe_p),
    .rx_cssi_nc_lssi_strobe_n         (dio_rx0_cssi_nc_lssi_strobe_n),
    .rx_cssi_data1_lssi_data0_p       (dio_rx0_cssi_data1_lssi_data0_p),
    .rx_cssi_data0_lssi_data0_n       (dio_rx0_cssi_data0_lssi_data0_n),
    .rx_cssi_data3_lssi_data1_p       (dio_rx0_cssi_data3_lssi_data1_p),
    .rx_cssi_data2_lssi_data1_n       (dio_rx0_cssi_data2_lssi_data1_n),
    .rx_cssi_gpio_in                  (dio_rx0_cssi_gpio_in),
    .rx_cssi_gpio_out                 (dio_rx0_cssi_gpio_out),
    .rx_cssi_gpio_enb                 (dio_rx0_cssi_gpio_enb),
    .rx_buf_clk                       (rx0_buf_clk),
    .rx_clk                           (rx0_clk),
    .rx_resetn                        (rx0_resetn),
    .rx_valid                         (rx0_tvalid),
    .rx_data                          (rx0_tdata),
    .rx_enable                        (rx0_enable),
    .orx_enable                       (orx0_enable),
    .orx_valid                        (orx0_tvalid),
    .orx_data                         (orx0_tdata),
    .rx_gpio_in                       (rx0_gpio_in),
    .rx_gpio_out                      (rx0_gpio_out),
    .rx_gpio_enb                      (rx0_gpio_enb),
    .mcs_toggle                       (mcs_toggle),
    .tx_pattern_done                  (tx0_pattern_done),
    .sys_200m_clk                     (sys_200m_clk),
    .sys_200m_resetn                  (sys_200m_resetn),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[1]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*1)+31):(32*1)]),
    .axilite_rdack                    (axilite_blk_rdack[1]));

  axi_adrv9001_regs #(
    .ID                               (AXI_ADRV9001_MAIN_ID))
  i_main_regs (
    .axilite_version                  (AXI_ADRV9001_VERSION),
    .axilite_instance_id              (AXI_ADRV9001_INSTANCE_ID),
    .axilite_scratch                  (),
    .axilite_timer                    (),
    .axilite_resetb                   (dio_resetb),
    .axilite_mode                     (dio_mode),
    .axilite_gpint                    (axilite_gpint),
    .axilite_gpint_mode               (axilite_gpint_mode),
    .axilite_usr_gpio_in              (usr_gpio_in),
    .axilite_usr_gpio_out             (usr_gpio_out),
    .axilite_mcs_request              (axilite_mcs_request),
    .axilite_mcs_request_clr          (axilite_mcs_done),
    .axilite_mcs_width                (axilite_mcs_width),
    .axilite_mcs_num                  (axilite_mcs_num),
    .axilite_mcs_edge_fall1_rise0     (axilite_mcs_edge_fall1_rise0),
    .axilite_mcs_select               (axilite_mcs_select),
    .axilite_mcs_period               (axilite_mcs_period),
    .axilite_mcs_clk_mon_count        (axilite_mcs_clk_mon_count),
    .axilite_mmcm_request             (axilite_mmcm_request),
    .axilite_mmcm_request_clr         (axilite_mmcm_ack),
    .axilite_mmcm_rd1_wr0             (axilite_mmcm_rd1_wr0),
    .axilite_mmcm_addr                (axilite_mmcm_addr),
    .axilite_mmcm_wrdata              (axilite_mmcm_wrdata),
    .axilite_mmcm_rddata              (axilite_mmcm_rddata),
    .axilite_mmcm_reset               (axilite_mmcm_reset),
    .axilite_mmcm_busy                (axilite_mmcm_busy),
    .axilite_mmcm_unlocked            (axilite_mmcm_unlocked),
    .axilite_mmcm_ref_clk_sel         (axilite_mmcm_ref_clk_sel),
    .axilite_mmcm_ref_clk_mon_count   (axilite_mmcm_ref_clk_mon_count),
    .axilite_trig0_ext_oe             (axilite_trig0_ext_oe),
    .axilite_trig1_ext_oe             (axilite_trig1_ext_oe),
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_blk_wrack[0]),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_blk_rddata[((32*0)+31):(32*0)]),
    .axilite_rdack                    (axilite_blk_rdack[0]));

  axilite_slave_if #(
    .AXI_ADDRESS_WIDTH                (16))
  i_axilite_slave_if (
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_awvalid                  (axilite_awvalid),
    .axilite_awaddr                   (axilite_awaddr),
    .axilite_awready                  (axilite_awready),
    .axilite_wvalid                   (axilite_wvalid),
    .axilite_wdata                    (axilite_wdata),
    .axilite_wready                   (axilite_wready),
    .axilite_bvalid                   (axilite_bvalid),
    .axilite_bresp                    (axilite_bresp),
    .axilite_bready                   (axilite_bready),
    .axilite_arvalid                  (axilite_arvalid),
    .axilite_araddr                   (axilite_araddr),
    .axilite_arready                  (axilite_arready),
    .axilite_rvalid                   (axilite_rvalid),
    .axilite_rresp                    (axilite_rresp),
    .axilite_rdata                    (axilite_rdata),
    .axilite_rready                   (axilite_rready),
    .axilite_wrreq                    (axilite_wrreq),
    .axilite_wraddr                   (axilite_wraddr),
    .axilite_wrdata                   (axilite_wrdata),
    .axilite_wrack                    (axilite_wrack),
    .axilite_rdreq                    (axilite_rdreq),
    .axilite_rdaddr                   (axilite_rdaddr),
    .axilite_rddata                   (axilite_rddata),
    .axilite_rdack                    (axilite_rdack));

  axilite_block_if #(
    .NUM_OF_BLOCKS                    (7))
  i_axilite_block_if (
    .axilite_clk                      (axilite_clk),
    .axilite_resetn                   (axilite_resetn),
    .axilite_intr                     (),
    .axilite_wrack                    (axilite_wrack),
    .axilite_rdack                    (axilite_rdack),
    .axilite_rddata                   (axilite_rddata),
    .axilite_block_intr               (7'd0),
    .axilite_block_wrack              (axilite_blk_wrack),
    .axilite_block_rdack              (axilite_blk_rdack),
    .axilite_block_rddata             (axilite_blk_rddata));

  cdc #(.DATA_WIDTH(1)) i_cdc_delay_reset (
    .src_data                         (axilite_resetn),
    .dest_resetn                      (1'b1),
    .dest_clk                         (sys_200m_clk),
    .dest_data                        (sys_200m_resetn));

  cdc #(.DATA_WIDTH(1)) i_cdc_gpint (
    .src_data                         (dio_gp_int),
    .dest_resetn                      (axilite_resetn),
    .dest_clk                         (axilite_clk),
    .dest_data                        (axilite_gpint_in));

endmodule

// **********************************************************************************
// **********************************************************************************
