# AXI ADRV9001 Interface

## Contents

* [Introduction](#introduction)
* [Functional Description](#functional-description)
  * [IO Standard](#io-standard)
  * [Transmit SSI](#transmit-ssi)
  * [Receive SSI](#receive-ssi)
  * [Interfaces](#interfaces)
  * [Clock Monitors](#clock-monitors)
* [Parameters](#parameters)
* [Ports](#ports)
  * [External System Ports](#external-system-ports)
  * [External ADRV9001 Ports](#external-adrv9001-ports)
  * [Internal Master/Slave Ports](#internal-master-slave-ports)
  * [Internal Data Ports](#internal-data-ports)
  * [Internal Trigger/GPIO Ports](#internal-trigger-gpio-ports)
  * [Internal AXILite Ports](#internal-axilite-ports)
* [Register Map](#register-map)
* [System Integration](#system-integration)

## <a name="introduction"></a>Introduction

This IP core is complementary to the ADRV9001 device, it interfaces one-to-one physically to the ADRV9001 device. All interface standards such as LVDS or CMOS; protocols related to STROBE such as pulse or level; and conversions from external serial based on number of lines to internal parallel bus; are encapsulated inside the core. The user or internal FPGA logic is presented with a simple AXIS like interface.

## <a name="functional-description"></a>Functional Description

A functional block diagram of the IP core is shown below. In all the modes supported in both LVDS and CMOS IO standards, the FPGA SERDES modules are used. The core internally runs at a quarter of the interface clock. At 61.44 MSPS 2 lane LVDS, the interface runs at 491.52 MHz and internally at 122.88 MHz.

![AXI\_ADRV9001 Block Diagram](docs/axi_adrv9001.png)

### <a name="io-standard"></a>IO Standard

The core supports both LVDS and CMOS IO standards, but this is a configuration option. In order to change this into a run time option, partial configuration is recommended. See the [parameters](#parameters) section for more details. The internal logic of the core remains identical in both LVDS and CMOS mode, however not all configurations are meaningful as the device can support only a limited number of options.

### <a name="transmit-ssi"></a>Transmit SSI

In the transmit direction, the core asserts the ready signal to indicate a sample request. This is **NOT** a standard AXIS interface. The upstream module must turn around this ready signal as a valid signal along with the data. The latency of ready to valid turn around is irrelevant (in TDD, must be compensated), however it must remain constant for all sample requests.

Inside the core this data is sourced along with internal test signals (RAMP, PRBS) and optionally a receive data loopback. The data is then passed to the SERDES module.

The SERDES module uses a 8:1 conversion in DDR mode and is run at a quarter rate of the interface clock. The transmit clock may optionally be sourced by the receive clock.

The core uses two instances of this module for the two channels.

### <a name="receive-ssi"></a>Receive SSI

The receive SSI consists of a SERDES module, it converts the serial data to byte wide parallel data. The internal clock runs at a quarter of the interface clock. The samples are delineated using the strobe signal. The core monitors the strobe signal based on the mode of operation. If the strobe signal behavior differs from expected, the core asserts OOS (out of sync). It takes 4 correct alignment of the strobe signals to clear the OOS status.

The received samples may optionally be monitored for a ramp (16bit linear only) or PRBS.

The data is then passed to either the receive channel or the observation receive channel as directed by the TDD enable signals.

At the AXIS interface, downstream modules must be capable of accepting data when the valid signal is asserted high. The core do not support any back pressure.

The core uses two instances of this module for the two channels.

### <a name="interfaces"></a>Interfaces

#### AXILite Interface (AXILite)

This must be connected to an AXILite master (usually CPU through an interconnect). The core requires an addressable space of 64K bytes.

#### Device Interface (DIO)

This must be exported as an external interface and must be connected to the ADRV9001 device on board. There must be one instance for each of the ADRV9001 devices on board.

#### System Interface (SYS)

This must be exported as an external interface and must be connected to the resources on board. This may be shared across all instances.

#### Transmit AXIS Interfaces (TX0, TX1)

These internal interfaces provide data samples with the corresponding clock and reset signals. They may be connected to a compatible AXI stream master inside the FPGA.

#### Receive AXIS Interfaces (RX0, RX1)

These internal interfaces provide data samples with the corresponding clock and reset signals. They may be connected to a compatible AXI stream slave inside the FPGA.

#### Observation Receive AXIS Interfaces (ORX0, ORX1)

These internal interfaces provide data samples with the corresponding clock and reset signals. They may be connected to a compatible AXI stream slave inside the FPGA. The ORX AXIS interfaces share the same clock and reset signals as the receive path.

#### GPIO Interface (Digital, SSI)

The core supports true GPIO on the 12 DGPIO pins of the device. The SSI GPIO has limitted use in certain configurations. In order to support true GPIO, the SSI interface must be reconfigured to do so. The data path elements (SERDES) and clocking do NOT support GPIO.

If so configured, the following is supported:

##### Digital GPIO (12 pins)

These pins support two modes, software and hardware. In hardware mode, any of the TDD enables may be sourced as output. In software mode, the pin may be configured as either input or output.

##### SSI GPIO (10 TX0 pins, 10 TX1 pins, 8 RX0 pins and 8 RX1 pins)

These pins support only software mode.

#### GPIO Gain AXIS Interface (GPIO\_GAIN)

These internal interfaces provide gain data with the corresponding clock and reset signals. They may be connected to a compatible AXI stream slave inside the FPGA. The gain index is a collection of 7 GPIO ports. Any GPIO port may be mapped to any one of the gain index data bits. The core outputs an 8 bit gain index with the MSB set to 0x0. The gain index is a free running data stream, capture may be controlled at the DMA cores using any one of the trigger sources mentioned below.

#### Trigger Interface (TRIG)

These signals provide trigger sources for TDD, MCS and other system level synchronization of multiple instances and the ADRV9001 devices. These may be sourced externally or internally. They may also be optionally used to trigger external peripherals such as DMA. The following table summarizes the trigger sources.

---
| Port         | Trigger Source    | Description |
| ------------ | ----------------- | ----------- |
| trig\_out[0] | External-Carrier  | This is trigger input 0. |
| trig\_out[1] | External-Carrier  | This is trigger input 1. |
| trig\_out[2] | External-ADRV9001 | This is internal MCS (either sourced by ADRV9001 or this core). |
| trig\_out[3] | Internal-ADRV9001 | This can be sourced from any of the 12 digital GPIO pins from the device. |
||||
---

All trigger sources independently support the following modes.

---
| Mode | Description |
| ---- | ----------- |
| 0x1  | The trigger occurs if the signal is asserted high. |
| 0x4  | The trigger occurs at the rising edge of the signal. |
| 0x5  | The trigger occurs at the falling edge of the signal. |
| 0x6  | The trigger occurs at either edge of the signal. |
||||
---

#### User GPIO Interface (USR\_GPIO)

These signals provide general purpose control/monitor functionalities within the interface core as desired by software and downstream modules.

### <a name="clock-monitors"></a>Clock Monitors

All variable clocks of the interface core are monitored and reported to the software. The driver call returns the frequency of the respective clock in Hz. This is assuming an AXILite CPU clock frequency of 100 MHz. The following are considered variable clocks.

* The reference clock input (device clock out from ADRV9001 or on-board clock), default 19.2MHz.
* The generated device clock (this clock drives MCS and other top level signals), default 38.4MHz.
* The generated TDD clock (this clock drives all TDD enables), default 245.76MHz.
* The generated GPIO clock (this clock drives all GPIO signals), default is 245.76MHz.
* The four SSI internal clocks (these clocks run at a quarter of interface rate).

The clock monitors are capable of monitoring frequencies from a minimum of 1.526kHz to a maximum of 6.554THz. In most practical systems, the maximum is limitted by device (usually 300MHz). Since it monitors clocks down to 1.526kHz, it takes about 1.3ms to report correct frequency.

## <a name="parameters"></a>Parameters

---
| Parameter                        | Type    | Default | Description |
| -------------------------------- | ------- | ------- | ----------- |
| AXI\_ADRV9001\_INSTANCE\_ID      | Integer | 0       | The instance ID of this core. If system has more than one instances (MIMO) assign unique values to identify the cores in software. Also make sure to assign one of them as the master instance (0x0). |
| AXI\_ADRV9001\_RX0\_GPIO2\_CMOS1\_LVDS0 | Integer | 0       | The IO configuration of receive 0 instance, for GPIO set to 0x2, CMOS mode set to 0x1, LVDS set to 0x0. |
| AXI\_ADRV9001\_TX0\_GPIO2\_CMOS1\_LVDS0 | Integer | 0       | The IO configuration of transmit 0 instance, for GPIO set to 0x2, CMOS mode set to 0x1, LVDS set to 0x0. |
| AXI\_ADRV9001\_RX1\_GPIO2\_CMOS1\_LVDS0 | Integer | 0       | The IO configuration of receive 1 instance, for GPIO set to 0x2, CMOS mode set to 0x1, LVDS set to 0x0. |
| AXI\_ADRV9001\_TX1\_GPIO2\_CMOS1\_LVDS0 | Integer | 0       | The IO configuration of transmit 1 instance, for GPIO set to 0x2, CMOS mode set to 0x1, LVDS set to 0x0. |
| AXI\_ADRV9001\_RX0\_IODELAY\_CTRL\_ENABLE  | Integer  | 1 | If set, IODELAY controller for RX0 is instantiated. |
| AXI\_ADRV9001\_RX1\_IODELAY\_CTRL\_ENABLE  | Integer  | 0 | If set, IODELAY controller for RX1 is instantiated. |
| AXI\_ADRV9001\_TX0\_IODELAY\_CTRL\_ENABLE  | Integer  | 0 | If set, IODELAY controller for TX0 is instantiated. |
| AXI\_ADRV9001\_TX1\_IODELAY\_CTRL\_ENABLE  | Integer  | 0 | If set, IODELAY controller for TX1 is instantiated. |
| AXI\_ADRV9001\_RX0\_IODELAY\_GROUP  | String  | AXI\_ADRV9001\_IODELAY | The placement identifier for the RX0 IODELAY group. |
| AXI\_ADRV9001\_RX1\_IODELAY\_GROUP  | String  | AXI\_ADRV9001\_IODELAY | The placement identifier for the RX1 IODELAY group. |
| AXI\_ADRV9001\_TX0\_IODELAY\_GROUP  | String  | AXI\_ADRV9001\_IODELAY | The placement identifier for the TX0 IODELAY group. |
| AXI\_ADRV9001\_TX1\_IODELAY\_GROUP  | String  | AXI\_ADRV9001\_IODELAY | The placement identifier for the TX1 IODELAY group. |
|||||
---

## <a name="ports"></a>Ports

### <a name="external-system-ports"></a>External System Ports

These ports may optionally be connected internally if not available from the hardware.

---
| Port               | Direction/Size  | Description |
| ------------------ | --------------- | ----------- |
| sys\_200m\_clk     | Input           | The 200 MHz clock for the IODELAY elements. |
| sys\_dev\_clk      | Input           | The device clock (reference clock) or ADRV9001 device clock. |
| sys\_mcs\_in\_p    | Input           | The MCS input, LVDS true (registered on the internal device clock). |
| sys\_mcs\_in\_n    | Input           | The MCS input, LVDS complementary (registered on the internal device clock). |
| sys\_mcs\_out\_p   | Output          | The MCS output, LVDS true (registered on the internal device clock). |
| sys\_mcs\_out\_n   | Output          | The MCS output, LVDS complementary (registered on the internal device clock). |
||||
---

### <a name="external-adrv9001-ports"></a>External ADRV9001 Ports

These ports must be connected to the ADRV9001 device. The data path IO are multi purpose ports, and depend on the IO configuration (GPIO, CMOS or LVDS). In GPIO mode, use only the cssi gpio pins and discard the other pins. In CMOS or LVDS mode, discard the cssi gpio pins. Also in CMOS mode, some of the pins can be configured as GPIO with direction as dictated by the data path. That is, the receive data pins becomes general purpose inputs, but can not be set as general purpose outputs.

---
| Port                                        | Direction/Size  | Description |
| ------------------------------------------- | --------------- | ----------- |
| dio\_rx0\_cssi\_clk\_lssi\_clk\_p           | Input           | Receive 0 clock (CMOS), clock true (LVDS). |            
| dio\_rx0\_cssi\_nc\_lssi\_clk\_n            | Input           | Receive 0 no-connect (CMOS), clock complementary (LVDS). |
| dio\_rx0\_cssi\_strobe\_lssi\_strobe\_p     | Input           | Receive 0 strobe (CMOS), strobe true (LVDS). |           
| dio\_rx0\_cssi\_nc\_lssi\_strobe\_n         | Input           | Receive 0 no-connect (CMOS), strobe complementary (LVDS). |
| dio\_rx0\_cssi\_data1\_lssi\_data0\_p       | Input           | Receive 0 data line 1 (CMOS), data line 0 true (LVDS). |
| dio\_rx0\_cssi\_data0\_lssi\_data0\_n       | Input           | Receive 0 data line 0 (CMOS), data line 0 complementary (LVDS). |
| dio\_rx0\_cssi\_data3\_lssi\_data1\_p       | Input           | Receive 0 data line 3 (CMOS), data line 1 true (LVDS). |
| dio\_rx0\_cssi\_data2\_lssi\_data1\_n       | Input           | Receive 0 data line 2 (CMOS), data line 1 complementary (LVDS). |
| dio\_rx0\_cssi\_gpio\_in                    | Input[8]        | Receive 0 GPIO inputs (not applicable in data mode). |
| dio\_rx0\_cssi\_gpio\_out                   | Output[8]       | Receive 0 GPIO outputs (not applicable in data mode). |
| dio\_rx0\_cssi\_gpio\_enb                   | Output[8]       | Receive 0 GPIO output enables (not applicable in data mode). |
| dio\_rx1\_cssi\_clk\_lssi\_clk\_p           | Input           | Receive 1 clock (CMOS), clock true (LVDS). |            
| dio\_rx1\_cssi\_nc\_lssi\_clk\_n            | Input           | Receive 1 no-connect (CMOS), clock complementary (LVDS). |
| dio\_rx1\_cssi\_strobe\_lssi\_strobe\_p     | Input           | Receive 1 strobe (CMOS), strobe true (LVDS). |           
| dio\_rx1\_cssi\_nc\_lssi\_strobe\_n         | Input           | Receive 1 no-connect (CMOS), strobe complementary (LVDS). |
| dio\_rx1\_cssi\_data1\_lssi\_data0\_p       | Input           | Receive 1 data line 1 (CMOS), data line 0 true (LVDS). |
| dio\_rx1\_cssi\_data0\_lssi\_data0\_n       | Input           | Receive 1 data line 0 (CMOS), data line 0 complementary (LVDS). |
| dio\_rx1\_cssi\_data3\_lssi\_data1\_p       | Input           | Receive 1 data line 3 (CMOS), data line 1 true (LVDS). |
| dio\_rx1\_cssi\_data2\_lssi\_data1\_n       | Input           | Receive 1 data line 2 (CMOS), data line 1 complementary (LVDS). |
| dio\_rx1\_cssi\_gpio\_in                    | Input[8]        | Receive 0 GPIO inputs (not applicable in data mode). |
| dio\_rx1\_cssi\_gpio\_out                   | Output[8]       | Receive 0 GPIO outputs (not applicable in data mode). |
| dio\_rx1\_cssi\_gpio\_enb                   | Output[8]       | Receive 0 GPIO output enables (not applicable in data mode). |
| dio\_tx0\_cssi\_refclk\_lssi\_refclk\_p     | Input           | Transmit 0 reference clock (CMOS), reference clock true (LVDS). |
| dio\_tx0\_cssi\_nc\_lssi\_refclk\_n         | Input           | Transmit 0 no-connect (CMOS), reference clock complementary (LVDS). |
| dio\_tx0\_cssi\_clk\_lssi\_clk\_p           | Output          | Transmit 0 clock (CMOS), clock true (LVDS). |            
| dio\_tx0\_cssi\_nc\_lssi\_clk\_n            | Output          | Transmit 0 no-connect (CMOS), clock complementary (LVDS). |
| dio\_tx0\_cssi\_strobe\_lssi\_strobe\_p     | Output          | Transmit 0 strobe (CMOS), strobe true (LVDS). |           
| dio\_tx0\_cssi\_nc\_lssi\_strobe\_n         | Output          | Transmit 0 no-connect (CMOS), strobe complementary (LVDS). |
| dio\_tx0\_cssi\_data1\_lssi\_data0\_p       | Output          | Transmit 0 data line 1 (CMOS), data line 0 true (LVDS). |
| dio\_tx0\_cssi\_data0\_lssi\_data0\_n       | Output          | Transmit 0 data line 0 (CMOS), data line 0 complementary (LVDS). |
| dio\_tx0\_cssi\_data3\_lssi\_data1\_p       | Output          | Transmit 0 data line 3 (CMOS), data line 1 true (LVDS). |
| dio\_tx0\_cssi\_data2\_lssi\_data1\_n       | Output          | Transmit 0 data line 2 (CMOS), data line 1 complementary (LVDS). |
| dio\_tx0\_cssi\_gpio\_in                    | Input[10]       | Transmit 0 GPIO inputs (not applicable in data mode). |
| dio\_tx0\_cssi\_gpio\_out                   | Output[10]      | Transmit 0 GPIO outputs (not applicable in data mode). |
| dio\_tx0\_cssi\_gpio\_enb                   | Output[10]      | Transmit 0 GPIO output enables (not applicable in data mode). |
| dio\_tx1\_cssi\_refclk\_lssi\_refclk\_p     | Input           | Transmit 1 reference clock (CMOS), reference clock true (LVDS). |
| dio\_tx1\_cssi\_nc\_lssi\_refclk\_n         | Input           | Transmit 1 no-connect (CMOS), reference clock complementary (LVDS). |
| dio\_tx1\_cssi\_clk\_lssi\_clk\_p           | Output          | Transmit 1 clock (CMOS), clock true (LVDS). |            
| dio\_tx1\_cssi\_nc\_lssi\_clk\_n            | Output          | Transmit 1 no-connect (CMOS), clock complementary (LVDS). |
| dio\_tx1\_cssi\_strobe\_lssi\_strobe\_p     | Output          | Transmit 1 strobe (CMOS), strobe true (LVDS). |           
| dio\_tx1\_cssi\_nc\_lssi\_strobe\_n         | Output          | Transmit 1 no-connect (CMOS), strobe complementary (LVDS). |
| dio\_tx1\_cssi\_data1\_lssi\_data0\_p       | Output          | Transmit 1 data line 1 (CMOS), data line 0 true (LVDS). |
| dio\_tx1\_cssi\_data0\_lssi\_data0\_n       | Output          | Transmit 1 data line 0 (CMOS), data line 0 complementary (LVDS). |
| dio\_tx1\_cssi\_data3\_lssi\_data1\_p       | Output          | Transmit 1 data line 3 (CMOS), data line 1 true (LVDS). |
| dio\_tx1\_cssi\_data2\_lssi\_data1\_n       | Output          | Transmit 1 data line 2 (CMOS), data line 1 complementary (LVDS). |
| dio\_tx1\_cssi\_gpio\_in                    | Input[10]       | Transmit 1 GPIO inputs (not applicable in data mode). |
| dio\_tx1\_cssi\_gpio\_out                   | Output[10]      | Transmit 1 GPIO outputs (not applicable in data mode). |
| dio\_tx1\_cssi\_gpio\_enb                   | Output[10]      | Transmit 1 GPIO output enables (not applicable in data mode). |
| dio\_rx0\_enable                            | Output          | Receive 0 Enable. | 
| dio\_rx1\_enable                            | Output          | Receive 1 Enable. |
| dio\_tx0\_enable                            | Output          | Transmit 0 Enable. | 
| dio\_tx1\_enable                            | Output          | Transmit 1 Enable. |
| dio\_dgpio                                  | InOut[12]       | Digital GPIO. |
| dio\_mode                                   | Output          | Mode. |
| dio\_resetb                                 | Output          | Reset (active low). |
| dio\_gp\_int                                | Input           | Interrupt. |
||||
---

### <a name="internal-master-slave-ports"></a>Internal Master/Slave Ports

These ports must be connected as outlined below for multiple instances in a master-slave configuration.

---
| Port                  | Direction/Size  | Description |
| --------------------- | --------------- | ----------- |
| gpio\_out\_clk        | Output          | Master GPIO clock source (to self and slave cores).|
| gpio\_clk             | Input           | Master and slave GPIO clock input (must be connected to a master gpio\_out\_clk).|
| dev\_out\_clk         | Output          | Master device clock source (to self and slave cores).|
| mcs\_out\_int         | Output          | Master MCS source (to self and slave cores).|
| dev\_clk              | Input           | Master and slave device clock input (must be connected to a master dev\_out\_clk).|
| mcs\_int              | Input           | Master and slave MCS input (must be connected to a master mcs\_out\_int).|
| tdd\_out\_clk         | Output          | Master TDD clock source (to self and slave cores).|
| tdd\_out\_resetn      | Output          | Master TDD reset source (to self and slave cores).|
| tdd\_out\_state       | Output          | Master TDD state source (to self and slave cores).|
| tdd\_out\_frm\_toggle | Output          | Master TDD frame toggle source (to self and slave cores).|
| tdd\_out\_clk\_cnt    | Output[32]      | Master TDD clock count source (to self and slave cores).|
| tdd\_out\_frm\_cnt    | Output[32]      | Master TDD frame count source (to self and slave cores).|
| tdd\_clk              | Input           | Master and slave TDD clock input (must be connected to a master tdd\_out\_clk).|
| tdd\_resetn           | Input           | Master and slave TDD reset input (must be connected to a master tdd\_out\_resetn).|
| tdd\_state            | Input           | Master and slave TDD state input (must be connected to a master tdd\_out\_state).|
| tdd\_frm\_toggle      | Input           | Master and slave TDD frame toggle input (must be connected to a master tdd\_out\_frm\_toggle).|
| tdd\_clk\_cnt         | Input[32]       | Master and slave TDD clock count input (must be connected to a master tdd\_out\_clk\_cnt).|
| tdd\_frm\_cnt         | Input[32]       | Master and slave TDD frame count input (must be connected to a master tdd\_out\_frm\_cnt).|
||||
---

### <a name="internal-data-ports"></a>Internal Data Ports

These ports may be connected to the corresponding DMA modules or other DSP cores.

---
| Port                  | Direction/Size  | Description |
| --------------------- | --------------- | ----------- |
| rx0\_resetn           | Output          | Receive 0 reset (active low). |
| rx0\_clk              | Output          | Receive 0 clock. | 
| rx0\_tvalid           | Output          | Receive 0 data valid. |
| rx0\_tdata            | Output[32]      | Receive 0 data (digital samples, the most significant 16bits is I, lower word is Q). |
| orx0\_tvalid          | Output          | Observation receive 0 data valid. |
| orx0\_tdata           | Output[32]      | Observation receive 0 data (digital samples, the most significant 16bits is I, lower word is Q). |
| rx1\_resetn           | Output          | Receive 1 reset (active low). |
| rx1\_clk              | Output          | Receive 1 clock. |
| rx1\_tvalid           | Output          | Receive 1 data valid. |
| rx1\_tdata            | Output[32]      | Receive 1 data (digital samples, the most significant 16bits is I, lower word is Q). |
| orx1\_tvalid          | Output          | Observation receive 1 data valid. |
| orx1\_tdata           | Output[32]      | Observation receive 1 data (digital samples, the most significant 16bits is I, lower word is Q). |
| tx0\_resetn           | Output          | Transmit 0 reset (active low). |
| tx0\_clk              | Output          | Transmit 0 clock. |
| tx0\_tready           | Output          | Transmit 0 ready (indicates a read request for data). |
| tx0\_tvalid           | Input           | Transmit 0 data valid (turn around ready signal and match with data latency). |
| tx0\_tdata            | Input[32]       | Transmit 0 data (digital samples, the most significant 16bits is I, lower word is Q). |
| tx1\_resetn           | Output          | Transmit 1 reset (active low). |
| tx1\_clk              | Output          | Transmit 1 clock. |
| tx1\_tready           | Output          | Transmit 1 ready (indicates a read request for data). |
| tx1\_tvalid           | Input           | Transmit 1 data valid (turn around ready signal and match with data latency). |
| tx1\_tdata            | Input[32]       | Transmit 1 data (digital samples, the most significant 16bits is I, lower word is Q). |
| gpio\_resetn          | Output          | GPIO reset (active low). |
| gpio\_gain\_tvalid    | Output          | GPIO gain valid. |
| gpio\_gain\_tdata     | Output[8]       | GPIO gain data. |
||||
---

### <a name="internal-trigger-gpio-ports"></a>Internal Trigger/GPIO Ports

---
| Port                  | Direction/Size  | Description |
| --------------------- | --------------- | ----------- |
| trig                  | InOut[2]        | This input is taken as an asynchronous trigger source or destination. |
| trig\_out             | Output[4]       | This output is a collection of trigger sources for external peripherals and the internal timing references such as TDD. |
| usr\_gpio\_in         | Input[32]       | This input is passed to the software for indirect control of downstream instances. |
| usr\_gpio\_out        | Output[32]      | This output is passed down from software for indirect control of downstream instances. |
||||
---

### <a name="internal-axilite-ports"></a>Internal AXILite Ports

---
| Port                  | Direction/Size  | Description |
| --------------------- | --------------- | ----------- |
| axilite\_clk          | Input           | Processor clock. |
| axilite\_resetn       | Input           | Processor reset (active low). |
| axilite\_awvalid      | Input           | Write address channel, valid. |
| axilite\_awaddr       | Input[16]       | Write address channel, address. |
| axilite\_awready      | Output          | Write address channel, ready. |
| axilite\_wvalid       | Input           | Write channel, valid. |
| axilite\_wdata        | Input[32]       | Write channel, data. | 
| axilite\_wready       | Output          | Write channel, ready. |
| axilite\_bvalid       | Output          | Write response channel, valid. |
| axilite\_bresp        | Output[2]       | Write response channel, data (response). |
| axilite\_bready       | Input           | Write response channel, ready. |
| axilite\_arvalid      | Input           | Read address channel, valid. |
| axilite\_araddr       | Input[16]       | Read address channel, address. |
| axilite\_arready      | Output          | Read address channel, ready. |
| axilite\_rvalid       | Output          | Read data channel, valid. |
| axilite\_rresp        | Output[2]       | Read data channel, response. |
| axilite\_rdata        | Output[32]      | Read data channel, data. |
| axilite\_rready       | Input           | Read data channel, ready. |
| interrupt             | Output          | Processor interrupt (active high). |
||||
---

## <a name="register-map"></a>Register Map

---
| Address offset                             | Instance                                     | Description                                             |
| ------------------------------------------ | -------------------------------------------- | ------------------------------------------------------- |
| [0x0000](hdl/axi_adrv9001_regs.md)         | [Main](hdl/axi_adrv9001_regs.md)             | Top level, primary IO controls (reset, mode, mcs etc.). |
| [0x1000](hdl/axi_adrv9001_gpio_regs.md)    | [GPIO](hdl/axi_adrv9001_gpio_regs.md)        | GPIO control (including DGPIO and SSI).                 |
| [0x4000](hdl/axi_adrv9001_rx_regs.md)      | [RECEIVE-0](hdl/axi_adrv9001_rx_regs.md)     | Receive 0 data path only (CMOS/LVDS).                   |
| [0x5000](hdl/axi_adrv9001_rx_regs.md)      | [RECEIVE-1](hdl/axi_adrv9001_rx_regs.md)     | Receive 1 data path only (CMOS/LVDS).                   |
| [0x6000](hdl/axi_adrv9001_tx_regs.md)      | [TRANSMIT-0](hdl/axi_adrv9001_tx_regs.md)    | Transmit 0 data path only (CMOS/LVDS).                  |
| [0x7000](hdl/axi_adrv9001_tx_regs.md)      | [TRANSMIT-1](hdl/axi_adrv9001_tx_regs.md)    | Transmit 1 data path only (CMOS/LVDS).                  |
| [0x8000](hdl/axi_adrv9001_tdd_regs.md)     | [TDD](hdl/axi_adrv9001_tdd_regs.md)          | TDD frame timing and device enable timings.             |
| [0x9000](hdl/axi_adrv9001_tdd_dma_regs.md) | [TDD-DMA](hdl/axi_adrv9001_tdd_dma_regs.md)  | TDD DMA enable timings.                                 |
||||
---

## <a name="system-integration"></a>System integration

A typical system level port connections is shown below.

![AXI\_ADRV9001 System Integration](docs/axi_adrv9001_system.png)

A typical use case in Xilinx Vivado IPI board design.

![AXI\_ADRV9001 Vivado IPI](docs/axi_adrv9001_vivado.png)


