## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       Vivado TCL include
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## IP Packaging

variable m_root
set m_root .

if [info exists ::env(M_ROOT)] {
  set m_root $::env(M_ROOT)
}
proc add_ip_files {file_list file_group} {

  set m_file_group [ipx::get_file_groups -filter "name =~ *${file_group}*"]
  foreach m_file $file_list {
    ipx::add_file $m_file $m_file_group
  }
}

proc pkg_ip_core {ip_name} {

	ipx::package_project -root_dir . -vendor analog.com \
		-library user -taxonomy /Analog_Devices
	set_property name $ip_name [ipx::current_core]
	set_property vendor_display_name {Analog Devices} [ipx::current_core]
	set_property company_url {http://www.analog.com} [ipx::current_core]
	ipx::save_core
}

proc add_interface_ports {name dir width {type none}} {

  ipx::add_bus_abstraction_port $name [ipx::current_busabs]
  set if_param_list {}
  lappend if_param_list master_presence required
  lappend if_param_list slave_presence required
  if {$width > 0} {
    lappend if_param_list master_width $width
    lappend if_param_list slave_width $width
  }
  lappend if_param_list master_direction $dir
  if {$dir eq "in"} {
    lappend if_param_list slave_direction out
  } elseif {$dir eq "out"} {
    lappend if_param_list slave_direction in
  } else {
    lappend if_param_list slave_direction $dir
  }
  if {$type ne "none"} {
    lappend if_param_list is_${type} true
  }
  set_property -dict $if_param_list [ipx::get_bus_abstraction_ports $name \
    -of_objects [ipx::current_busabs]]
}

proc pkg_interface {if_name} {

  ipx::create_abstraction_definition analog.com interface ${if_name}_rtl 1.0
  ipx::create_bus_definition analog.com interface ${if_name} 1.0
  set_property xml_file_name interfaces/${if_name}_rtl.xml [ipx::current_busabs]
  set_property xml_file_name interfaces/${if_name}.xml [ipx::current_busdef]
  set_property bus_type_vlnv analog.com:interface:${if_name}:1.0 [ipx::current_busabs]
  ipx::save_abstraction_definition [ipx::current_busabs]
  ipx::save_bus_definition [ipx::current_busdef]
}

## ##################################################################################
## ##################################################################################
## Ignored warnings and such

proc msg_settings {mode} {

  if {$mode eq "none"} {
    set_msg_config -id {Vivado 12-1462} -new_severity INFO
    set_msg_config -id {IP_Flow 19-3507} -new_severity INFO
    set_msg_config -id {IP_Flow 19-3656} -new_severity INFO
    set_msg_config -id {IP_Flow 19-2999} -new_severity INFO
    set_msg_config -id {IP_Flow 19-1654} -new_severity INFO
    set_msg_config -id {IP_Flow 19-4623} -new_severity INFO
    set_msg_config -id {IP_Flow 19-3833} -new_severity INFO
    set_msg_config -id {IP_Flow 19-1971} -new_severity INFO
    set_msg_config -id {IP_Flow 19-459} -new_severity INFO
    set_msg_config -id {IP_Flow 19-731} -new_severity INFO
    set_msg_config -id {Timing 38-282} -new_severity ERROR
  }
}

proc gen_system_id {s} {

  set s [format "%-32s" $s]
  set m "0x"
  for {set x 0} {$x < 8} {incr x} {
    set w [string range $s [expr ($x*4)] [expr (($x*4)+3)]]
    for {set y 3} {$y >= 0} {incr y -1} {
      set c [string range $w $y $y]
      scan $c "%c" b
      set b [format "%02x" $b]
      set m $m$b
    }
  }
  return $m
}

proc gen_build_id {} {

  set s [clock seconds]
  set s [clock format $s -format "%Y-%m-%d-%H-%M"]
  set s [gen_system_id $s]
  return $s
}

proc gen_build_version {} {

  set s [clock seconds]
  set s [clock format $s -format "0x%m%d%Y00%H%M%S"]
  return $s
}

## ##################################################################################
## ##################################################################################
## Projects

variable axilite_base_intf
set axilite_base_intf none

proc add_axilite_peripheral {ip_base ip_intf} {

  global axilite_index
  global axilite_base_intf

  if {$axilite_index > 15} {

    set axilite_index_1 [expr $axilite_index - 15]
    set_property config.num_mi [expr $axilite_index_1 + 1] [get_bd_cells sys_axilite_xc_1]
    set intc_intf m${axilite_index_1}_axi
    if {$axilite_index_1 < 10} {
      set intc_intf m0${axilite_index_1}_axi
    }
    connect_bd_intf_net [get_bd_intf_pins sys_axilite_xc_1/${intc_intf}] [get_bd_intf_pins $ip_intf]
    set ip_segment [get_bd_addr_segs -of_objects [get_bd_intf_pins $ip_intf]]
    set ip_range [get_property range $ip_segment]
    if {$ip_range < 0x1000} {
      set ip_range 0x1000
    }
    set ip_name [lindex [split $ip_intf /] 0]
    set ip_space [get_bd_addr_spaces -of_objects [get_bd_intf_pins $axilite_base_intf]]
    create_bd_addr_seg -offset $ip_base -range $ip_range $ip_space $ip_segment seg_axilite_$ip_name

  } elseif {$axilite_index == 15} {

    set ip_param_list {}
    set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
    create_bd_cell -type ip -vlnv $ip_vlnv sys_axilite_xc_1
    lappend ip_param_list config.num_si 1
    lappend ip_param_list config.num_mi 1
    set_property -dict $ip_param_list [get_bd_cells sys_axilite_xc_1]
    connect_bd_net -net axilite_resetn [get_bd_pins sys_axilite_xc_1/aresetn]
    connect_bd_net -net axilite_clk [get_bd_pins sys_axilite_xc_1/aclk]

    set_property config.num_mi 16 [get_bd_cells sys_axilite_xc]

    connect_bd_intf_net [get_bd_intf_pins sys_axilite_xc/m15_axi] [get_bd_intf_pins sys_axilite_xc_1/s00_axi]
    connect_bd_intf_net [get_bd_intf_pins sys_axilite_xc_1/m00_axi] [get_bd_intf_pins $ip_intf]

    set ip_segment [get_bd_addr_segs -of_objects [get_bd_intf_pins $ip_intf]]
    set ip_range [get_property range $ip_segment]
    if {$ip_range < 0x1000} {
      set ip_range 0x1000
    }
    set ip_name [lindex [split $ip_intf /] 0]
    set ip_space [get_bd_addr_spaces -of_objects [get_bd_intf_pins $axilite_base_intf]]
    create_bd_addr_seg -offset $ip_base -range $ip_range $ip_space $ip_segment seg_axilite_$ip_name

  } elseif {$axilite_index < 0} {

    set ip_param_list {}
    set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
    create_bd_cell -type ip -vlnv $ip_vlnv sys_axilite_xc
    lappend ip_param_list config.num_si 1
    lappend ip_param_list config.num_mi 1
    set_property -dict $ip_param_list [get_bd_cells sys_axilite_xc]
    connect_bd_net -net axilite_resetn [get_bd_pins sys_axilite_xc/aresetn]
    connect_bd_net -net axilite_clk [get_bd_pins sys_axilite_xc/aclk]
    connect_bd_intf_net [get_bd_intf_pins $ip_intf] [get_bd_intf_pins sys_axilite_xc/s00_axi]
    set axilite_base_intf $ip_intf

  } else {

    set_property config.num_mi [expr $axilite_index + 1] [get_bd_cells sys_axilite_xc]
    set intc_intf m${axilite_index}_axi
    if {$axilite_index < 10} {
      set intc_intf m0${axilite_index}_axi
    }
    connect_bd_intf_net [get_bd_intf_pins sys_axilite_xc/${intc_intf}] [get_bd_intf_pins $ip_intf]
    set ip_segment [get_bd_addr_segs -of_objects [get_bd_intf_pins $ip_intf]]
    set ip_range [get_property range $ip_segment]
    if {$ip_range < 0x1000} {
      set ip_range 0x1000
    }
    set ip_name [lindex [split $ip_intf /] 0]
    set ip_space [get_bd_addr_spaces -of_objects [get_bd_intf_pins $axilite_base_intf]]
    create_bd_addr_seg -offset $ip_base -range $ip_range $ip_space $ip_segment seg_axilite_$ip_name
  }

  set axilite_index [expr $axilite_index + 1]
}

variable aximm_base_intf
set aximm_base_intf none

proc add_aximm_peripheral {ip_base ip_intf} {

  global aximm_index
  global aximm_range
  global aximm_base_intf

  if {$aximm_index < 0} {

    set ip_param_list {}
    set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
    create_bd_cell -type ip -vlnv $ip_vlnv sys_aximm_xc
    lappend ip_param_list config.num_si 1
    lappend ip_param_list config.num_mi 1
    set_property -dict $ip_param_list [get_bd_cells sys_aximm_xc]
    connect_bd_net -net aximm_clk [get_bd_pins sys_aximm_xc/aclk]
    connect_bd_net -net aximm_resetn [get_bd_pins sys_aximm_xc/aresetn]
    connect_bd_intf_net [get_bd_intf_pins sys_aximm_xc/m00_axi] [get_bd_intf_pins $ip_intf]
    set aximm_base_intf $ip_intf

  } else {

    set_property config.num_si [expr $aximm_index + 1] [get_bd_cells sys_aximm_xc]
    set intc_intf s${aximm_index}_axi
    if {$aximm_index < 10} {
      set intc_intf s0${aximm_index}_axi
    }
    connect_bd_intf_net [get_bd_intf_pins $ip_intf] [get_bd_intf_pins sys_aximm_xc/${intc_intf}]
    set ip_name [lindex [split $ip_intf /] 0]
    set ip_space [get_bd_addr_spaces -of_objects [get_bd_intf_pins $ip_intf]]
    set ip_segment [get_bd_addr_segs -of_objects [get_bd_intf_pins $aximm_base_intf]]
    create_bd_addr_seg -offset $ip_base -range $aximm_range $ip_space $ip_segment seg_aximm_$ip_name
  }

  set aximm_index [expr $aximm_index + 1]
}

proc add_interrupt {ip_intr} {

  global intr_index

  if {$intr_index < 0} {

    set ip_param_list {}
    set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
    create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
    set_property config.num_ports 1 [get_bd_cells sys_intrs]
    connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins $ip_intr]

  } else {

    set_property config.num_ports [expr $intr_index + 1] [get_bd_cells sys_intrs]
    connect_bd_net [get_bd_pins $ip_intr] [get_bd_pins sys_intrs/in${intr_index}]
  }

  set intr_index [expr $intr_index + 1]
}

## ##################################################################################
## ##################################################################################

