## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       Vivado Make rules
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Vivado

export M_ROOT := $(M_ROOT)

M_VIVADO := vivado -mode batch -source
M_VIVADO_TARGET := $(M_VIVADO_PROJECT).xpr
M_VIVADO_TCL := $(M_VIVADO_PROJECT)_vivado.tcl
M_VIVADO_LOG := $(M_VIVADO_PROJECT)_vivado.log

M_VIVADO_CLEAN_LIST := *.cache
M_VIVADO_CLEAN_LIST += *.rpt
M_VIVADO_CLEAN_LIST += *.sysdef
M_VIVADO_CLEAN_LIST += *.data
M_VIVADO_CLEAN_LIST += *.xpr
M_VIVADO_CLEAN_LIST += *.log
M_VIVADO_CLEAN_LIST += *.jou
M_VIVADO_CLEAN_LIST +=  xgui
M_VIVADO_CLEAN_LIST += *.runs
M_VIVADO_CLEAN_LIST += *.srcs
M_VIVADO_CLEAN_LIST += *.sdk
M_VIVADO_CLEAN_LIST += *.hw
M_VIVADO_CLEAN_LIST += *.sim
M_VIVADO_CLEAN_LIST += .Xil
M_VIVADO_CLEAN_LIST += *.xml
M_VIVADO_CLEAN_LIST += *.ip_user_files

M_VIVADO_SOURCES := $(shell $(M_ROOT)/bin/tcl2make.pl -deps $(M_VIVADO_TCL))
M_VIVADO_SOURCES += $(shell $(M_ROOT)/bin/tcl2make.pl -dep-cores $(M_VIVADO_TCL))
M_VIVADO_SOURCES += $(M_VIVADO_TCL)

M_VIVADO_DOCS := $(filter %_regs.v, $(M_VIVADO_SOURCES))
M_VIVADO_DOCS := $(subst .v,.md, $(M_VIVADO_DOCS))

M_VIVADO_CORES := $(shell $(M_ROOT)/bin/tcl2make.pl -cores $(M_VIVADO_TCL))
M_CLEAN_VIVADO_CORES := $(addsuffix .clean, $(M_VIVADO_CORES))

.PHONY: defaults
defaults: lib $(M_VIVADO_DOCS) $(M_VIVADO_TARGET)


$(M_VIVADO_TARGET): $(M_VIVADO_SOURCES)
	rm -fr $(M_VIVADO_CLEAN_LIST)
	$(M_VIVADO) $(M_VIVADO_TCL) > $(M_VIVADO_LOG) 2>&1


.PHONY: lib
lib: $(M_VIVADO_CORES)


.PHONY: $(M_VIVADO_CORES)
$(M_VIVADO_CORES):
	$(MAKE) -C $@/hdl


.PHONY: clean
clean:
	rm -fr $(M_VIVADO_CLEAN_LIST)


.PHONY: clean-all
clean-all: clean $(M_CLEAN_VIVADO_CORES)


$(M_CLEAN_VIVADO_CORES): %.clean:
	$(MAKE) -C $*/hdl clean


%_regs.v: %_regs.pl $(M_ROOT)/bin/dooku.pl
	perl -I $(M_ROOT)/bin $< $@


%_regs.md: %_regs.pl $(M_ROOT)/bin/dooku.pl
	perl -I $(M_ROOT)/bin $< $@

## ##################################################################################
## ##################################################################################
