#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       Auto generate dependencies from TCL
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;

$m_deps = "";
$m_cores = "";
$m_dep_cores = "";
if (open(IFILE, $ARGV[1])) {
  while ($fline = <IFILE>) {
    chomp($fline);
    $fline =~ s/\s+//g;
    if ($fline =~ /^lappendip_source_list/) {
      $fline =~ s/^lappendip_source_list/ /;
      $m_deps = $m_deps.$fline;
    }
    if ($fline =~ /^lappendproject_source_list/) {
      $fline =~ s/^lappendproject_source_list/ /;
      $m_deps = $m_deps.$fline;
    }
    if ($fline =~ /^source/) {
      $fline =~ s/^source/ /;
      $m_deps = $m_deps.$fline;
    }
    if ($fline =~ /^lappendip_core_list/) {
      $fline =~ s/^lappendip_core_list/ /;
      $m_cores = $m_cores.$fline;
      $fword = $fline;
      $fword =~ s/.*\///;
      $fline = $fline."/hdl/".$fword.".xpr";
      $m_dep_cores = $m_dep_cores.$fline;
    }
  }
}

if ($ARGV[0] eq "-deps") {
  print "$m_deps";
}

if ($ARGV[0] eq "-cores") {
  print "$m_cores";
}

if ($ARGV[0] eq "-dep-cores") {
  print "$m_dep_cores";
}

exit(0);

## ##################################################################################
## ##################################################################################
