#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       The simplest form of auto generated register/documentation
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use Cwd;

sub setdooku {

  local(@args) = @_;
	$outfile = $args[0];
  $incdir = $args[1];
  $vlog = 1;
  $yoda = 0;
  $mkdn = 0;
  if ($outfile =~ /\.yda$/) {
    $vlog = 0;
    $yoda = 1;
    $mkdn = 0;
  }
  if ($outfile =~ /\.md$/) {
    $vlog = 0;
    $yoda = 0;
    $mkdn = 1;
  }
}
dooku;

sub s2h_32 {

  local($s, $i) = @_;

  $s = $s.(" " x 32);
  $s = substr($s, ($i*4), 4);
  $s =~ s/(.)/sprintf("%x",ord($1))/eg;
  $s = "0x".$s;
  return($s);
}
dooku;

sub fieldtypes {

  local($type) = @_;

  if ($type eq "RO")    {return("R");}
  return("R/W");
}
dooku;

sub field {

  local($spos, $width, $type, $default, $name, $desc) = @_;

  $desc =~ tr{\n}{ };
  $desc =~ s/ +/ /g;
  $field_spos[$no_of_fields] = $spos;
  $field_width[$no_of_fields] = $width;
  $field_type[$no_of_fields] = $type;
  if ($default =~ /^0x/) {
    $default =~ s/^0x//;
    $field_default[$no_of_fields] = $default;
  } else {
    $field_default[$no_of_fields] = sprintf("%x", $default);
  }
  $field_name[$no_of_fields] = $name;
  $field_desc[$no_of_fields] = $desc;
  $field_address[$no_of_fields] = $cur_address;
  $no_of_fields = $no_of_fields + 1;
}
dooku;

sub register {

  local($address, $name) = @_;
  $address =~ s/^0x//;
  $cur_address = sprintf("%x", $address);
  $register_address[$no_of_registers] = $cur_address;
  $register_name[$no_of_registers] = $name;
  $no_of_registers = $no_of_registers + 1;
}
dooku;

sub instance {

  local($address, $core, $mname, $ifname, $ofname) = @_;
  local($n);

  $address =~ s/^0x//;
  $instance_address[$no_of_instances] = sprintf("%x", $address);
  $instance_core[$no_of_instances] = $core;
  $instance_module[$no_of_instances] = $mname;
  $instance_ifname[$no_of_instances] = $ifname;
  $instance_ofname[$no_of_instances] = $ofname;
  $no_of_instances = $no_of_instances + 1;
}
dooku;

sub module {

  local($address, $name) = @_;
  local($w);

  $address =~ s/^0x//;
  $module_name = $name;
  $no_of_fields = 0;
  $no_of_registers = 0;
  $no_of_instances = 0;
  $cur_address = 0;
  $mod_address = sprintf("%x", $address);

  if ($sw_name eq "") {
    $sw_name = $name;
  }

  if ($vlog == 1) {
    open(ofile, ">$outfile");
    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// ################\n";
    print ofile "// ##   ###########   Analog Devices Inc.\n";
    print ofile "// ##      ########\n";
    print ofile "// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.\n";
    print ofile "// ##            ##   This file is the confidential and proprietary property of ADI.\n";
    print ofile "// ##         #####   Possession or use of this file requires a written license.\n";
    print ofile "// ##      ########   The licensing information may be found at: www.analog.com\n";
    print ofile "// ##   ###########\n";
    print ofile "// ################\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// Author:            Rejeesh Kutty\n";
    print ofile "// Description:       Auto generated, local modifications are discouraged.\n";
    print ofile "// ----------------------------------------------------------------------------------\n";
    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    print ofile "\n";
    print ofile "`timescale 1ps/1ps\n";
    print ofile "\n";
    print ofile "module ${name}_regs";
    $w = ($addr_width - $addr_width_used) - 1;
    if ($w > 0) {
      print ofile " #(parameter [$w:0] ID = 0)";
    }
    print ofile " (\n";
    print ofile "\n";
  }

  if ($mkdn == 1) {
    $s = $name;
    $s =~ s/_/\\_/g;
    open(ofile, ">$outfile");
    print ofile "# ${s}\n";
    print ofile "## Properties\n";
    print ofile "* Address Width: $addr_width_used\n";
    print ofile "## Register Map\n";
    print ofile "---\n";
    print ofile "| Address | Bits | Field | Type | Default | Description |\n";
    print ofile "| ------- | ---- | ----- | ---- | ------- | ----------- |\n";
  }

  if ($yoda == 1) {
    open(ofile, ">$outfile");
    print ofile "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    print ofile "<Module DBSchema=\"Native\" DBVersion=\"2.42\">\n";
    print ofile "  <Parameters>\n";
    print ofile "  </Parameters>\n";
    print ofile "  <Properties>\n";
    print ofile "    <HardwareName>${name}</HardwareName>\n";
    print ofile "    <SoftwareName>${sw_name}</SoftwareName>\n";
    print ofile "    <Description>${name}</Description>\n";
    print ofile "    <Documentation>${name}</Documentation>\n";
    print ofile "    <Address>'h$mod_address</Address>\n";
    print ofile "    <AddressUnitBits>8</AddressUnitBits>\n";
    print ofile "    <ByteOrder>LittleEndian</ByteOrder>\n";
    print ofile "    <AddressWidth>'d32</AddressWidth>\n";
    print ofile "    <BitFieldScope>Global</BitFieldScope>\n";
    print ofile "    <RegisterScope>Global</RegisterScope>\n";
    print ofile "    <ReserveOption>AutomaticReadZero</ReserveOption>\n";
    print ofile "    <NameSpaceProtection>True</NameSpaceProtection>\n";
    print ofile "    <EnumerationScope>Global</EnumerationScope>\n";
    print ofile "    <MemoryAccessMethod>MemoryMappedRegister</MemoryAccessMethod>\n";
    print ofile "    <Notes>none</Notes>\n";
    print ofile "    <User></User>\n";
    print ofile "    <GeneratorOptions></GeneratorOptions>\n";
    print ofile "    <Dictionary></Dictionary>\n";
    print ofile "    <ModuleEditMode>Engineering</ModuleEditMode>\n";
    print ofile "    <DocSetToUse>DS1</DocSetToUse>\n";
    print ofile "  </Properties>\n";
    print ofile "  <PageMasks>\n";
    print ofile "  </PageMasks>\n";
    print ofile "  <Ports>\n";
    print ofile "  </Ports>\n";
  }
}
dooku;

sub endmodule {

  local($n);

  if ($vlog == 1) {
    print ofile "endmodule\n";
    print ofile "\n";
    print ofile "// **********************************************************************************\n";
    print ofile "// **********************************************************************************\n";
    close(ofile);
  }

  if ($mkdn == 1) {
    print ofile "---\n";
    close(ofile);
  }

  if ($yoda == 1) {
    print ofile "  <Instances>\n";
    for ($n = 0; $n < $no_of_instances; $n++) {
      print ofile "    <Instance>\n";
      print ofile "      <Name>$instance_core[$n]</Name>\n";
      print ofile "      <UID>f$instance_address[$n]cdc</UID>\n";
      print ofile "      <Address>'h$instance_address[$n]</Address>\n";
      print ofile "      <ArrayEnabled>False</ArrayEnabled>\n";
      print ofile "      <ArrayLetter>n</ArrayLetter>\n";
      print ofile "      <ArrayFrom>0</ArrayFrom>\n";
      print ofile "      <ArrayTo>2</ArrayTo>\n";
      print ofile "      <ArrayBy>1</ArrayBy>\n";
      print ofile "      <ArrayStride>1</ArrayStride>\n";
      print ofile "      <Description>${module_name}_$instance_core[$n]</Description>\n";
      print ofile "      <Documentation>${module_name}_$instance_core[$n]</Documentation>\n";
      print ofile "      <Exists>True</Exists>\n";
      print ofile "      <Module>$instance_module[$n]</Module>\n";
      print ofile "      <Notes></Notes>\n";
      print ofile "      <User></User>\n";
      print ofile "    </Instance>\n";
    }
    print ofile "  </Instances>\n";
    print ofile "  <Interrupts>\n";
    print ofile "  </Interrupts>\n";
    print ofile "  <Triggers>\n";
    print ofile "  </Triggers>\n";
    print ofile "  <DMAChannels>\n";
    print ofile "  </DMAChannels>\n";
    print ofile "  <ChipSignals>\n";
    print ofile "  </ChipSignals>\n";
    print ofile "  <Pads>\n";
    print ofile "  </Pads>\n";
    print ofile "  <Packages>\n";
    print ofile "  </Packages>\n";
    print ofile "  <FunctionalGroups>\n";
    print ofile "    <UID>100000000</UID>\n";
    print ofile "  </FunctionalGroups>\n";
    print ofile "  <Suppressions>\n";
    print ofile "  </Suppressions>\n";
    print ofile "</Module>\n";
    close(ofile);
  }
}
dooku;

sub endregisters {

  local($n, $i);
  local($m, $l, $s, $f, $spos, $type);

  if ($vlog == 1) {
    for ($i = 0; $i < $no_of_fields; $i++) {
      $s = lc($field_name[$i]);
      $w = $field_width[$i] - 1;
      if ($w < 10) {$w = " $w";}
      if ($field_type[$i] eq "RW1HC") {
        if ($field_width[$i] == 1) {
          print ofile "  output  reg             axilite_${s} = 'd0,\n";
          print ofile "  input   wire            axilite_${s}_clr,\n";
        } else {
          print ofile "  output  reg   [$w:0]    axilite_${s} = 'd0,\n";
          print ofile "  input   wire  [$w:0]    axilite_${s}_clr,\n";
        }
      } elsif ($field_type[$i] eq "RW") {
        if ($field_width[$i] == 1) {
          print ofile "  output  reg             axilite_${s} = 'd0,\n";
        } else {
          print ofile "  output  reg   [$w:0]    axilite_${s} = 'd0,\n";
        }
      } else {
        if ($field_width[$i] == 1) {
          print ofile "  input   wire            axilite_${s},\n";
        } else {
          print ofile "  input   wire  [$w:0]    axilite_${s},\n";
        }
      }
    }
    print ofile "\n";
    $w = $addr_width - 1;
    if ($w < 10) {$w = " $w";}
    print ofile "  input   wire            axilite_clk,\n";
    print ofile "  input   wire            axilite_resetn,\n";
    print ofile "  input   wire            axilite_wrreq,\n";
    print ofile "  input   wire  [$w:0]    axilite_wraddr,\n";
    print ofile "  input   wire  [31:0]    axilite_wrdata,\n";
    print ofile "  output  reg             axilite_wrack = 'd0,\n";
    print ofile "  input   wire            axilite_rdreq,\n";
    print ofile "  input   wire  [$w:0]    axilite_rdaddr,\n";
    print ofile "  output  reg   [31:0]    axilite_rddata = 'd0,\n";
    print ofile "  output  reg             axilite_rdack = 'd0);\n";
    print ofile "\n";

    for ($i = 0; $i < $no_of_fields; $i++) {
      $s = lc($field_name[$i]);
      $w = $field_width[$i] - 1;
      if ($w < 10) {$w = " $w";}
      if ($field_type[$i] eq "RW1C") {
        if ($field_width[$i] == 1) {
          print ofile "  reg                     axilite_${s}_w1c = 'd0;\n";
        } else {
          print ofile "  reg           [$w:0]    axilite_${s}_w1c = 'd0;\n";
        }
      }
      if ($field_type[$i] eq "RW1HC") {
        if ($field_width[$i] == 1) {
          print ofile "  reg                     axilite_${s}_clr_d = 'd0;\n";
        } else {
          print ofile "  reg           [$w:0]    axilite_${s}_clr_d = 'd0;\n";
        }
      }
    }
    print ofile "\n";

    $m = $addr_width - 1;
    $l = $addr_width_used;
    print ofile "  always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
    print ofile "    if (axilite_resetn == 1'b0) begin\n";
    print ofile "      axilite_wrack <= 'd0;\n";
    print ofile "      axilite_rdack <= 'd0;\n";
    print ofile "    end else begin\n";
    if ($m > $l) {
      print ofile "      if (axilite_wraddr[$m:$l] == ID) begin\n";
      print ofile "        axilite_wrack <= axilite_wrreq;\n";
      print ofile "      end else begin\n";
      print ofile "        axilite_wrack <= 1'd0;\n";
      print ofile "      end\n";
      print ofile "      if (axilite_rdaddr[$m:$l] == ID) begin\n";
      print ofile "        axilite_rdack <= axilite_rdreq;\n";
      print ofile "      end else begin\n";
      print ofile "        axilite_rdack <= 1'd0;\n";
      print ofile "      end\n";
    } else {
      print ofile "      axilite_wrack <= axilite_wrreq;\n";
      print ofile "      axilite_rdack <= axilite_rdreq;\n";
    }
    print ofile "    end\n";
    print ofile "  end\n";
    print ofile "\n";
    for ($n = 0; $n < $no_of_registers; $n++) {
      for ($i = 0; $i < $no_of_fields; $i++) {
        if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW")) {
          print ofile "  always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
          print ofile "    if (axilite_resetn == 1'b0) begin\n";
          $s = lc($field_name[$i]);
          print ofile "      axilite_${s} <= 'h$field_default[$i];\n";
          print ofile "    end else begin\n";
          print ofile "      if ((axilite_wrreq == 1'b1) &&";
          $m = $addr_width - 1;
          $l = $addr_width_used;
          if ($m > $l) {
            print ofile " (axilite_wraddr[$m:$l] == ID) &&";
          }
          $m = $addr_width_used - 1;
          print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
          if ($field_width[$i] == 32) {
            print ofile "        axilite_${s} <= axilite_wrdata;\n";
          } elsif ($field_width[$i] == 1) {
            print ofile "        axilite_${s} <= axilite_wrdata[$field_spos[$i]];\n";
          } else {
            $l = $field_spos[$i];
            $m = ($field_spos[$i] + $field_width[$i])-1;
            print ofile "        axilite_${s} <= axilite_wrdata[$m:$l];\n";
          }
          if ($s =~ /timer$/) {
            print ofile "      end else if (axilite_${s} > 0) begin\n";
            print ofile "        axilite_${s} <= axilite_${s} - 1'b1;\n";
          }
          print ofile "      end\n";
          print ofile "    end\n";
          print ofile "  end\n";
          print ofile "\n";
        }
        if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW1HC")) {
          print ofile "  always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
          print ofile "    if (axilite_resetn == 1'b0) begin\n";
          $s = lc($field_name[$i]);
          print ofile "      axilite_${s}_clr_d <= 'd0;\n";
          print ofile "      axilite_${s} <= 'h$field_default[$i];\n";
          print ofile "    end else begin\n";
          print ofile "      axilite_${s}_clr_d <= axilite_${s}_clr;\n";
          if ($field_width[$i] > 1) {
            for ($f = 0; $f < $field_width[$i]; $f++) {
              print ofile "      if ((axilite_${s}_clr_d[$f] == 1'b0) && (axilite_${s}_clr[$f] == 1'b1)) begin\n";
              print ofile "        axilite_${s}[$f] <= 1'b0;\n";
              print ofile "      end else if ((axilite_wrreq == 1'b1) &&";
              $m = $addr_width - 1;
              $l = $addr_width_used;
              if ($m > $l) {
                print ofile " (axilite_wraddr[$m:$l] == ID) &&";
              }
              $m = $addr_width_used - 1;
              print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
              $m = $field_spos[$i]+$f;
              print ofile "        axilite_${s}[$f] <= axilite_${s}[$f] | axilite_wrdata[$m];\n";
              print ofile "      end\n";
            }
          } else {
            print ofile "      if ((axilite_${s}_clr_d == 1'b0) && (axilite_${s}_clr == 1'b1)) begin\n";
            print ofile "        axilite_${s} <= 1'b0;\n";
            print ofile "      end else if ((axilite_wrreq == 1'b1) &&";
            $m = $addr_width - 1;
            $l = $addr_width_used;
            if ($m > $l) {
              print ofile " (axilite_wraddr[$m:$l] == ID) &&";
            }
            $m = $addr_width_used - 1;
            print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
            $m = $field_spos[$i];
            print ofile "        axilite_${s} <= axilite_${s} | axilite_wrdata[$m];\n";
            print ofile "      end\n";
          }
          print ofile "    end\n";
          print ofile "  end\n";
          print ofile "\n";
        }
        if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW1C")) {
          print ofile "  always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
          print ofile "    if (axilite_resetn == 1'b0) begin\n";
          $s = lc($field_name[$i]);
          print ofile "      axilite_${s}_w1c <= 'h$field_default[$i];\n";
          print ofile "    end else begin\n";
          if ($field_width[$i] > 1) {
            for ($f = 0; $f < $field_width[$i]; $f++) {
              print ofile "      if (axilite_${s}[$f] == 1'b1) begin\n";
              print ofile "        axilite_${s}_w1c[$f] <= 1'b1;\n";
              print ofile "      end else if ((axilite_wrreq == 1'b1) &&";
              $m = $addr_width - 1;
              $l = $addr_width_used;
              if ($m > $l) {
                print ofile " (axilite_wraddr[$m:$l] == ID) &&";
              }
              $m = $addr_width_used - 1;
              print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
              $m = $field_spos[$i]+$f;
              print ofile "        axilite_${s}_w1c[$f] <= axilite_${s}_w1c[$f] & ~axilite_wrdata[$m];\n";
              print ofile "      end\n";
            }
          } else {
            print ofile "      if (axilite_${s} == 1'b1) begin\n";
            print ofile "        axilite_${s}_w1c <= 1'b1;\n";
            print ofile "      end else if ((axilite_wrreq == 1'b1) &&";
            $m = $addr_width - 1;
            $l = $addr_width_used;
            if ($m > $l) {
              print ofile " (axilite_wraddr[$m:$l] == ID) &&";
            }
            $m = $addr_width_used - 1;
            print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
            $m = $field_spos[$i];
            print ofile "        axilite_${s}_w1c <= axilite_${s}_w1c & ~axilite_wrdata[$m];\n";
            print ofile "      end\n";
          }
          print ofile "    end\n";
          print ofile "  end\n";
          print ofile "\n";
        }
      }
    }
    $m = $addr_width - 1;
    $l = $addr_width_used;
    print ofile "  always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
    print ofile "    if (axilite_resetn == 1'b0) begin\n";
    print ofile "      axilite_rddata <= 'd0;\n";
    print ofile "    end else begin\n";
    if ($m > $l) {
      print ofile "      if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[$m:$l] == ID)) begin\n";
    } else {
      print ofile "      if (axilite_rdreq == 1'b1) begin\n";
    }
    $m = $addr_width_used-1;
    print ofile "        case (axilite_rdaddr[$m:0])\n";
    for ($n = 0; $n < $no_of_registers; $n++) {
      $spos = 0;
      print ofile "          'h$register_address[$n]: begin\n";
      for ($i = 0; $i < $no_of_fields; $i++) {
        if ($field_address[$i] eq $register_address[$n]) {
          $s = lc($field_name[$i]);
          if ($field_type[$i] eq "RW1C") {$s = "${s}_w1c";}
          if ($field_width[$i] == 32) {
            print ofile "            axilite_rddata <= axilite_${s};\n";
          } else {
            if ($spos != $field_spos[$i]) {
              $l = $spos;
              $m = $field_spos[$i]-1;
              if ($m == $l) {
                print ofile "            axilite_rddata[$m] <= 'd0;\n";
              } else {
                print ofile "            axilite_rddata[$m:$l] <= 'd0;\n";
              }
            }
            if ($field_width[$i] == 1) {
              print ofile "            axilite_rddata[$field_spos[$i]] <= axilite_${s};\n";
            } else {
              $m = ($field_spos[$i]+$field_width[$i])-1;
              $l = $field_spos[$i];
              print ofile "            axilite_rddata[$m:$l] <= axilite_${s};\n";
            }
          }
          $spos = $field_spos[$i] + $field_width[$i];
        }
      }
      if ($spos == 31) {
        print ofile "            axilite_rddata[$m] <= 'd0;\n";
      } elsif ($spos < 31) {
        print ofile "            axilite_rddata[31:$spos] <= 'd0;\n";
      }
      print ofile "          end\n";
    }
    print ofile "          default: begin\n";
    print ofile "            axilite_rddata <= 32'd0;\n";
    print ofile "          end\n";
    print ofile "        endcase\n";
    print ofile "      end else begin\n";
    print ofile "        axilite_rddata <= 32'd0;\n";
    print ofile "      end\n";
    print ofile "    end\n";
    print ofile "  end\n";
    print ofile "\n";
  }

  if ($mkdn == 1) {
    for ($n = 0; $n < $no_of_registers; $n++) {
      for ($i = 0; $i < $no_of_fields; $i++) {
        if ($field_address[$i] eq $register_address[$n]) {
          $s = lc($field_name[$i]);
          $s =~ s/_/\\_/g;
          if ($field_width[$i] > 1) {
            $l = $field_width[$i] - 1;
            $s = "${s}[${l}:0]";
          }
          $l = $field_spos[$i];
          $m = ($field_spos[$i] + $field_width[$i])-1;
          print ofile "| 0x$field_address[$i] | [${m}:${l}] | ${s} ";
          $s = $field_desc[$i];
          $s =~ s/_/\\_/g;
          print ofile "| $field_type[$i] | 0x$field_default[$i] | $s |\n";
        }
      }
      print ofile "| | | | | | |\n";
    }
  }

  if ($yoda == 1) {
    print ofile "  <MemoryMap>\n";
    print ofile "    <BitFields>\n";
    print ofile "      <UID>100000001</UID>\n";
    for ($n = 0; $n < $no_of_fields; $n++) {
      $type = fieldtypes($field_type[$n]);
      print ofile "      <BitField>\n";
      print ofile "        <Name>$field_name[$n]</Name>\n";
      print ofile "        <UID>a$field_address[$n]b$n</UID>\n";
      print ofile "        <Access>$type</Access>\n";
      print ofile "        <Bundle></Bundle>\n";
      print ofile "        <DefaultValue>$field_default[$n]</DefaultValue>\n";
      print ofile "        <Description>$field_desc[$n]</Description>\n";
      print ofile "        <Documentation></Documentation>\n";
      print ofile "        <Exists>True</Exists>\n";
      print ofile "        <HSType>Both</HSType>\n";
      print ofile "        <ReadSideEffect>None</ReadSideEffect>\n";
      if ($field_type[$n] eq "RW1C") {
        print ofile "        <WriteSideEffect>OneToClear</WriteSideEffect>\n";
      } elsif ($field_type[$n] eq "RW1HC") {
        print ofile "        <WriteSideEffect>OneToSet</WriteSideEffect>\n";
      } else {
        print ofile "        <WriteSideEffect>None</WriteSideEffect>\n";
      }
      print ofile "        <DefaultType>HardWired</DefaultType>\n";
      print ofile "        <ClockSignal>clk</ClockSignal>\n";
      print ofile "        <ResetType>ASync</ResetType>\n";
      print ofile "        <ResetSignal>=__AUTO__</ResetSignal>\n";
      print ofile "        <Visibility>Public</Visibility>\n";
      print ofile "        <ReadEnableSignal></ReadEnableSignal>\n";
      print ofile "        <WriteEnableSignal></WriteEnableSignal>\n";
      print ofile "        <ReadStrobe>None</ReadStrobe>\n";
      print ofile "        <WriteStrobe>None</WriteStrobe>\n";
      print ofile "        <LatchSignal></LatchSignal>\n";
      if ($field_type[$n] eq "RW1C") {
        print ofile "        <InputSideEffect>SyncSet</InputSideEffect>\n";
      } elsif ($field_type[$n] eq "RW1HC") {
        print ofile "        <InputSideEffect>SyncClear</InputSideEffect>\n";
      } else {
        print ofile "        <InputSideEffect>None</InputSideEffect>\n";
      }
      print ofile "        <OutputSideEffect>None</OutputSideEffect>\n";
      if ($field_type[$n] eq "RO") {
        print ofile "        <Volatile>True</Volatile>\n";
      } else {
        print ofile "        <Volatile>False</Volatile>\n";
      }
      print ofile "        <RequiresCustomRTL>False</RequiresCustomRTL>\n";
      print ofile "        <Testable>True</Testable>\n";
      print ofile "        <ForcedValue></ForcedValue>\n";
      print ofile "        <ForcedValueSignal></ForcedValueSignal>\n";
      print ofile "        <LinkSet></LinkSet>\n";
      print ofile "        <MSEnabled>False</MSEnabled>\n";
      print ofile "        <MSTransferSignal>transfer</MSTransferSignal>\n";
      print ofile "        <MSReadSelectSignal>read_select</MSReadSelectSignal>\n";
      print ofile "        <MSSlaveClockSignal>slave_clk</MSSlaveClockSignal>\n";
      print ofile "        <MSSlaveLogic>Included</MSSlaveLogic>\n";
      print ofile "        <Notes></Notes>\n";
      print ofile "        <PageMask></PageMask>\n";
      print ofile "        <UINotes></UINotes>\n";
      print ofile "        <UIToolTip>=__AUTO__</UIToolTip>\n";
      print ofile "        <UIUIType>=__AUTO__</UIUIType>\n";
      print ofile "        <UIWidget>=__AUTO__</UIWidget>\n";
      print ofile "        <UINumericBase>Decimal</UINumericBase>\n";
      print ofile "        <UIDataFormat>Unsigned</UIDataFormat>\n";
      print ofile "        <UIPrefix>None</UIPrefix>\n";
      print ofile "        <UIUnits>None</UIUnits>\n";
      print ofile "        <UIScale>1</UIScale>\n";
      print ofile "        <UIOffset>0</UIOffset>\n";
      print ofile "        <UIMinValue>=__AUTO__</UIMinValue>\n";
      print ofile "        <UIMaxValue>=__AUTO__</UIMaxValue>\n";
      print ofile "        <UIIncrement>1</UIIncrement>\n";
      print ofile "        <UIPolarity>ActiveHigh</UIPolarity>\n";
      print ofile "        <User></User>\n";
      print ofile "        <Width>$field_width[$n]</Width>\n";
      print ofile "      </BitField>\n";
    }
    print ofile "    </BitFields>\n";
    print ofile "    <RegisterMaps>\n";
    print ofile "      <UID>100000002</UID>\n";
    print ofile "      <RegisterMap>\n";
    print ofile "        <Name>register_map</Name>\n";
    print ofile "        <UID>100000110</UID>\n";
    print ofile "        <Address>'h0000</Address>\n";
    print ofile "        <Description></Description>\n";
    print ofile "        <Documentation></Documentation>\n";
    print ofile "        <Exists>True</Exists>\n";
    print ofile "        <Notes></Notes>\n";
    print ofile "        <User></User>\n";
    print ofile "        <Registers>\n";
    for ($n = 0; $n < $no_of_registers; $n++) {
      print ofile "          <Register>\n";
      print ofile "            <Name>$register_name[$n]</Name>\n";
      print ofile "            <UID>a$register_address[$n]</UID>\n";
      print ofile "            <Address>'h$register_address[$n]</Address>\n";
      print ofile "            <ArrayEnabled>False</ArrayEnabled>\n";
      print ofile "            <ArrayLetter>n</ArrayLetter>\n";
      print ofile "            <ArrayFrom>0</ArrayFrom>\n";
      print ofile "            <ArrayTo>2</ArrayTo>\n";
      print ofile "            <ArrayBy>1</ArrayBy>\n";
      print ofile "            <ArrayStride>1</ArrayStride>\n";
      print ofile "            <Description>The $register_name[$n] Register</Description>\n";
      print ofile "            <Documentation></Documentation>\n";
      print ofile "            <Exists>True</Exists>\n";
      print ofile "            <Indirect></Indirect>\n";
      print ofile "            <LinkSet></LinkSet>\n";
      print ofile "            <Notes></Notes>\n";
      print ofile "            <UINotes></UINotes>\n";
      print ofile "            <UIToolTip>=__AUTO__</UIToolTip>\n";
      print ofile "            <UIUIType>=__AUTO__</UIUIType>\n";
      print ofile "            <UIWidget>=__AUTO__</UIWidget>\n";
      print ofile "            <UINumericBase>Hexadecimal</UINumericBase>\n";
      print ofile "            <User></User>\n";
      print ofile "            <Width>32</Width>\n";
      print ofile "            <BitFieldRefs>\n";
      for ($i = 0; $i < $no_of_fields; $i++) {
        if ($field_address[$i] eq $register_address[$n]) {
          print ofile "              <BitFieldRef>\n";
          print ofile "                <BF-UID>a$field_address[$i]b$i</BF-UID>\n";
          print ofile "                <BitOffset>0</BitOffset>\n";
          print ofile "                <RegOffset>$field_spos[$i]</RegOffset>\n";
          print ofile "                <SliceWidth>$field_width[$i]</SliceWidth>\n";
          print ofile "                <UID>c21a$field_address[$i]b$i</UID>\n";
          print ofile "              </BitFieldRef>\n";
        }
      }
      print ofile "            </BitFieldRefs>\n";
      print ofile "          </Register>\n";
    }
    print ofile "        </Registers>\n";
    print ofile "      </RegisterMap>\n";
    print ofile "    </RegisterMaps>\n";
    print ofile "    <MemoryRegions>\n";
    print ofile "      <UID>100000003</UID>\n";
    print ofile "    </MemoryRegions>\n";
    print ofile "  </MemoryMap>\n";
  }
}
dooku;

sub generate {

  local($n, $fname, $yname);

  if ($yoda == 1) {
    for ($n = 0; $n < $no_of_instances; $n++) {
      print "perl -I$incdir $instance_ifname[$n] $instance_ofname[$n]\n";
      system("perl -I$incdir $instance_ifname[$n] $instance_ofname[$n]");
    }
  }
}
dooku;

## ##################################################################################
## ##################################################################################
