## ADRV9001 Evaluation Platform

## Contents

* [Introduction](#introduction)
* [License](#license)
* [User Guide](#user-guide)
* [Support](#support)

## <a name="introduction"></a> Introduction

This is the ADRV9001 evaluation platform repository and contains all the HDL, drivers and software necessary to build the images for all the hardware boards supported.

All documentation in this repository are written in Markdown format. If you are unable to read this in a pleasant manner, most likely your OS need some third party tools to render it properly. You may also convert these files to PDF format for offline reading.

## <a name="license"></a> License

This repository is distributed under an accompanying license agreement. The pocession and use of its contains implies acceptance of our licensing terms.

All the HDL and Software sources in this repository is distributed simply in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. Any redistribution, use of source or resulting binaries, with or without modification must adhere to the ADI license agreement. The sources may contain vendor device specific primitives or library components. Also, the build process may generate and use vendor files using their tools. It is your responsibility to obtain the required vendor tools and proper licensing to generate or use these components. This folder contains only HDL, TCL, C or other files solely developed by Analog Devices. All vendor files must be generated.

## <a name="user-guide"></a> User Guide

### [ADRV9001 Platform User Guide](projects/README.md)

## <a name="support"></a> Support

All the library cores and projects in this repository are fully supported. However, we do **NOT** support operating system, environment setup, tool installation and related issues.

### What is **NOT** supported?

If you are getting any errors or messages such as those mentioned below, it indicates an environment issue. It is advised that you fix these issues through your IT personnel or other means.

```
'make' is not recognized as an internal or external command,
operable program or batch file.
```

```
vivado: Command not found.
```

These are a few examples from a very long list.

### What is supported?

Any error messages or issues you see in any of the files in this repository must be reported to us. Here are a few examples:

```
ERROR: [Common 17-163] Missing value for option 'objects', please type 'set_property -help' for usage info
```

Please also let us know any errors, critical-warnings you come across the build process or during a run. This may include tool specific design rule checks (DRC), timing violations and related.

