## 6.7.0

#### LIBRARY-AXI-ADRV9001-HDL:
  * Ignores SSI interface based on active MCS, if set, this allows any glitches at IO to be filtered out, thus the interface divided clocks gets aligned.
  * Added pulse pattern insertion and monitoring, this allows round trip latency check (to be meaningful the loop back must be in the digital domain).
  * Modified MMCM default settings to generate maximum allowed clocks, 200MHz for all internal clocks. Thus, after power up reprogramming the MMCM is a must.
  * Added MCS latency functions, the core will measure latency from the last MCS signal to the first strobe sampled. The latency is counted in SSI half clock cycles. A value of 1 indicates strobe was sampled at the first edge (rising or falling) of the SSI clock after MCS.
  * Moved all clocking local routing constraints to the project level, this allows board level control of clock routing, in pin mappings that do support dedicated routes, users can remove this constraint.
  * Updated receive and observation receive decimation controls to support all bit configurations (8, 16, 32, and 64).
  * The clock generator now has two possible reference clocks, one from the device (device clock out from ADRV9001) another from the board (device clock from the on board clock fanout buffer).
  * Modifications on TDD DMA Enable to assertion at corners of frame and period boundaries. If set to synchronous mode, software must make sure there is sufficient gap (at least twice the clock ratio) from the frame and period boundaries.
  * Tdd dma enables, cross-wiring fix.
  * SSI cmos unused IO tri-stated (some, such as strobe has IO conflicts)
#### LIBRARY-AXI-ADRV9001-SW:
  * MCS and pulse pattern latency functions.
  * Clock generator supports fractional divide and sets TDD/GPIO clocks close to 200MHz.
  * Cleaned up SSI delays, now simply based on indices. The external and internal clock delays are now part of the same delay setup.
  * Clock generator reference clock select and moved reference clock monitor to a different address.
  * Clock configuration now ignores SSI clocks and sets the TDD and GPIO clocks as close to 200MHz as possible. It can be made an exact match enabling the fractional divides, this is planned for a future update.
#### PROJECTS-COMMON-SW:
  * Separated SSI setup into clock setup and SSI setup, thus allowing clock to be configured anytime, regardless of SSI setup and vice versa.
#### PROJECTS-ADRV9001-ZC706-HDL:
  * Clock generator reference clock changes (see above).
#### PROJECTS-ADRV9001x2-ZC706-HDL:
  * Clock generator reference clock changes (see above).
---
## 6.6.0

#### LIBRARY-AXI-ADRV9001-HDL:
  * Tdd dma enables, cross-wiring fix.
  * Released off a local branch

---
## 6.5.0

#### LIBRARY-COMMON-HDL:
  * FIFO, fixed empty flag bug, was asserting empty at 1 not 0.
#### LIBRARY-COMMON-SW:
  * In AXI-CLKGEN, prematurely exit frequency search loop if exact match is found (speed up).
  * Added clock generator drivers.
#### LIBRARY-AXI-MSPI-HDL:
  * Synthesis warnings fixed for duplicated nets.
  * Removed local IO buffer instantiation, because it will not allow port duplication (required for MCS).
#### LIBRARY-AXI-ADRV9001-HDL:
  * TDD enable bug fix, secondary parameters were overriding the enable generation.
  * Added MCS to SSI-Strobe latency monitoring.
  * Added SSI GPIO configuration for all data path interfaces, now allows GPIO (2), CMOS (1) or LVDS (0) configurations.
  * Added mcs select option, output can now be external or internal.
  * Changed delay control to be per instance (since receive and transmit are in the same bank).
  * Added master-slave synchronization of MCS, TDD signals and their corresponding clocks.
  * Removed axilite domain from tx lb fifo (since receive and transmit are in the same bank).
#### LIBRARY-AXI-ADRV9001-SW:
  * MMCM clock configuration now enforces device clock frequency to be an exact match. This is done to make sure MCS is generated and sampled at the same clock as the device.
  * TDD config bug fixes (was setting up wrong registers)
  * Safe gaurd mmcm against invalid inputs and limit divider to allowed max.
  * Added mcs select functions (see above).
#### PROJECTS-COMMON-HDL:
  * Modified board design to include master-slave IO changes.
#### PROJECTS-COMMON-SW:
  * Added reference clock generation drivers (uses fractions).
#### PROJECTS-ADRV9001-ZC706-HDL:
  * Generate device reference clock from IOB registers, this guarantees same package flight delay for both clocks (mainly for MCS).
  * FMC pin mappings corrected (comments were left over from revision A).
  * Removed all CC IO for HPC (this removes one of the push buttons).
  * constraints qualifed with full instance name    Apr 14, 2020  
  * SPI IO buffer instantiation at the top level for duplication of ports.
#### PROJECTS-ADRV9001x2-ZC706:
  * Added dual ADRV9001 on ZC706, HPC only supports RX1/TX1 in GPIO mode.
#### BIN:
  * AXI interconnect and Interrupt now supports more than 16 peripherals, also fixed the name too long warning.
#### GENERAL:
  * Added top level make to build all targets by default (options are available).
  * Documentation updates to match register addresses, block diagrams and IP instances.

---
## 6.4.0

#### LIBRARY-AXI-ADRV9001-HDL:
  * Receive SSI interface fix, frame bit count typo

---
## 6.3.0

#### LIBRARY-AXI-ADRV9001-HDL:
  * Monitors on all clocks.
  * GPIO restructured (also bug fixes) with group and pin selects.
  * GPIO has its own register space.
  * TDD DMA enables supports synchronous and asynchronous modes.
  * TDD DMA enables has its own register space.

---
## 6.1.0

#### LIBRARY-AXI-ADRV9001-HDL:
  * Added 32bit IQ mode for receive channels. The CONTROL register has changed, the multi bit fields are separated by a nibble, and the NUM\_OF\_BITS field size has been increased to 3 bits.
  * Replaced receive to transmit loopback XPM fifo with a simple generic fifo. The XPM fifo has too much mess.
  * All TDD registers are aligned to a byte address width, this allows easy address manipulation.
  * Trigger restructuring for inout, and moved reference clock to pmod header.

---

