# ADRV9001 Transceiver MATLAB

## Getting Started
### Programming the Device
1. Ensure that the ADRV9001 transceiver evaluation software (TES) has been installed
2. Run TES and ConfigureA
3. Click Sample Code > MATLAB.
4. In the Select Folder dialog create a new directory to save the auto-generated MATLAB code.  As of TES 0.9.0,
multiple task based files will be generated with predetermined file names.  Note: If you auto-generate code in a
directory that already has code all of the files will be overwritten and any changes you've made will be lost.
5. Select Folder. The code generated will fully specify the state of the device and can be used to restore said
state entirely from MATLAB at a later point in time.
6. Close TES or Disconnect.
7. Run `main.m` to capture and retransmit the data.

### Helpful Snippets
To assign local context variables and some useful enums from `main.m` into the workspace:
```
...
adrv9001 = board.DeviceGet('adrv9001', 0);
fpga9001 = board.DeviceGet('fpga9001', 0);

% New code here
ADI_RX = adi_common_Port_e.ADI_RX;
ADI_TX = adi_common_Port_e.ADI_TX;
ADI_CHANNEL_1 = adi_common_ChannelNumber_e.ADI_CHANNEL_1;
ADI_CHANNEL_2 = adi_common_ChannelNumber_e.ADI_CHANNEL_2;

assignin('base', 'adrv9001', adrv9001);
assignin('base', 'fpga9001', fpga9001);
assignin('base', 'ADI_RX', ADI_RX);
assignin('base', 'ADI_TX', ADI_TX);
assignin('base', 'ADI_CHANNEL_1', ADI_CHANNEL_1);
assignin('base', 'ADI_CHANNEL_2', ADI_CHANNEL_2);
% End new code

initialize(board, fpga9001);
...
```

To parse data received in `dataCapture.m`, consider this:
```
AUTOGENERATOR_ERROR_HANDLER(fpga9001.dataChain.Data_Get_16IQInterleaved(adi_common_Port_e.ADI_RX, adi_common_ChannelNumber_e.ADI_CHANNEL_1, iqData_1, 16384));

interleavedData_1 = double(typecast(iqData_1.uint16, 'int16'));
iData = interleavedData_1(1:2:end);
qData = interleavedData_1(2:2:end);
```

To return parsed data from `dataCapture.m`, change the function declaration to:
```
function [iData, qData] = dataCapture(fpga9001)
```

With the above suggestions you can now do something akin to this from the workspace:
```
>>> beginCapture(fgpa9001);
>>> for loop
>>>   [iData, qData] = dataCapture(fpga9001);
>>> end
>>> stopReceiving(fgpa9001);
```

To parse data transmitted in `vectorUpload.m`, consider this:
```
iqData_0 = [typecast(int16(iData), 'uint16'); typecast(int16(qData), 'uint16')];
iqData_0 = iqData_0(:)';

AUTOGENERATOR_ERROR_HANDLER(fpga9001.dataChain.Data_Set_16IQInterleaved(adi_common_Port_e.ADI_TX, adi_common_ChannelNumber_e.ADI_CHANNEL_1, iqData_0, 64));
```

### Stream Image
The ADRV9001 requires a stream image binary to be downloaded to the device which has been custom asembled based on
the device configuration.  TES automatically creates this stream image and passes it to the function that
initializes the part.  The stream image is a byte array and it will be part of the auto-generated code so there
is no need to manage it as a separate resource (as was done with previous versions of TES).

## Troubleshooting
- This code is *experimental* and may need to be tweaked to work correctly
- If MATLAB complains that a DLL cannot be found make sure that the variable
`CLIENT_INSTALL_DIRECTORY` points to the TES installation directory.  Look
carefully for a missing, trailing "\\".
